#include "mex.h"
#include "matrix.h"
#include "math.h"
#include "stdio.h"

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )

{

    /* -- Inputs -- */
	double *nin			= mxGetPr(prhs[0]);
	double *nyin		= mxGetPr(prhs[1]);
	double *nein		= mxGetPr(prhs[2]);
    double *xss 		= mxGetPr(prhs[3]);
    double *yss 		= mxGetPr(prhs[4]);
	double *parmin 		= mxGetPr(prhs[5]);
	double *nnuin 		= mxGetPr(prhs[6]);
	double *sigsin  	= mxGetPr(prhs[7]);
	double *Hs  		= mxGetPr(prhs[8]);
	double *Gs 			= mxGetPr(prhs[9]);
	double *Gsp 		= mxGetPr(prhs[10]);
	double *G2sp 		= mxGetPr(prhs[11]);
	double *Psspin  	= mxGetPr(prhs[12]);
	double *dP1sspin	= mxGetPr(prhs[13]);
	double *dP2sspin	= mxGetPr(prhs[14]);

	/* -- Specific Inputs -- */
	int n 				= nin[0];
	int ny 				= nyin[0];
	int ne 				= nein[0];
	double nnus 		= nnuin[0];
	double bbeta 		= parmin[0];
	double rrho 		= parmin[1];
	double oomega 		= parmin[2];
	double eeta 		= parmin[3];
	double aalpha 		= parmin[4];
	double ddelta 		= parmin[5];
	double pbar 		= parmin[6];
	double ebar 		= parmin[7];
	double iiota 		= parmin[8];
	double pphi 		= parmin[9];
	double rbar 		= parmin[10];
	double kkappa   	= parmin[11];
	double rrhoa 		= parmin[12];
	double rrhoz 		= parmin[13];
	double rrhop 		= parmin[14];
	double rrhor 		= parmin[15];
	double rrhoe 		= parmin[16];
	double rrhod 	 	= parmin[17];
	double varphibar 	= parmin[18];
	double bbar 		= parmin[19];
	double ppsir 		= parmin[20];
	double abar  		= parmin[21];
	double zbar 		= parmin[22];
	double ssigmaas		= sigsin[0];
	double ssigmazs		= sigsin[1];
	double ssigmaps		= sigsin[2];
	double ssigmars		= sigsin[3];
	double ssigmaes		= sigsin[4];
	double ssigmads		= sigsin[5];
	double Pssp 		= Psspin[0];
	double dP1ssp 		= dP1sspin[0];
	double dP2ssp 		= dP2sspin[0];

	/* -- Outputs -- */
	plhs[0] = mxCreateDoubleMatrix(n*ne*ne,(n+ny)*ne*ne,mxREAL);
	plhs[1] = mxCreateDoubleMatrix(n*ne*ne,1,mxREAL);
	double *Mee_sp_s = mxGetPr(plhs[0]);
	double *Nee_sp_s = mxGetPr(plhs[1]);

    /* -- Definition of Variables -- */
    double E = 2.71828182845905;


    /* -- Mathematica Output Here -- */
	Mee_sp_s[6048]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mee_sp_s[248832]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mee_sp_s[249696]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mee_sp_s[255744]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[256608]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[257472]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[1729]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[2593]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[3457]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[249697]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[250561]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[253153]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mee_sp_s[255745]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mee_sp_s[256609]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[257473]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[1730]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[2594]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[249698]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[250562]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[253154]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mee_sp_s[254882]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[255746]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mee_sp_s[256610]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[257474]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[3]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[867]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[1731]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[2595]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mee_sp_s[3459]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[4323]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[5187]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[6051]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[253155]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mee_sp_s[255747]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[256611]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mee_sp_s[257475]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mee_sp_s[4]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mee_sp_s[868]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mee_sp_s[1732]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mee_sp_s[2596]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mee_sp_s[3460]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mee_sp_s[4324]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mee_sp_s[5188]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mee_sp_s[6052]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mee_sp_s[254020]=-(kkappa*Pssp*yss[9]);
	Mee_sp_s[255748]=pow(E,yss[8])*Pssp;
	Mee_sp_s[256612]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mee_sp_s[257476]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mee_sp_s[5]=iiota*Pssp*zbar;
	Mee_sp_s[2597]=iiota*Pssp*zbar;
	Mee_sp_s[254021]=-Pssp;
	Mee_sp_s[249702]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mee_sp_s[254886]=-(pow(E,yss[7])*Pssp);
	Mee_sp_s[256614]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[257478]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[871]=-((Pssp*zbar)/(1 + yss[5]));
	Mee_sp_s[1735]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[2599]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mee_sp_s[3463]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mee_sp_s[5191]=-(pow(E,yss[11])*ebar*Pssp);
	Mee_sp_s[248839]=-(pow(E,yss[0])*Pssp);
	Mee_sp_s[249703]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mee_sp_s[250567]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mee_sp_s[251431]=-(pow(E,yss[3])*Pssp);
	Mee_sp_s[253159]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[254887]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mee_sp_s[256615]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[257479]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[8]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[2600]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[251432]=pow(E,yss[3])*Pssp;
	Mee_sp_s[256616]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[257480]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[9]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[873]=(Pssp*zbar)/(1 + yss[5]);
	Mee_sp_s[2601]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mee_sp_s[3465]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[249705]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[250569]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[253161]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[254025]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[254889]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[256617]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[257481]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[256618]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[257482]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[875]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mee_sp_s[4331]=Pssp;
	Mee_sp_s[253163]=-Pssp;
	Mee_sp_s[256619]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[257483]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[12]=pow(E,xss[0])*Pssp;
	Mee_sp_s[252300]=-(pow(E,xss[0])*Pssp);
	Mee_sp_s[1741]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[2605]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[3469]=pow(E,yss[2])*pbar*Pssp;
	Mee_sp_s[249709]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[250573]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mee_sp_s[256621]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[257485]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[258349]=pow(E,yss[11])*Pssp;
	Mee_sp_s[878]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[2606]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[256622]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[257486]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[258350]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mee_sp_s[259214]=Pssp;
	Mee_sp_s[879]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[2607]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[256623]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[257487]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[258351]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mee_sp_s[260079]=Pssp;
	Mee_sp_s[5200]=ebar*Pssp;
	Mee_sp_s[248848]=pow(E,yss[0] - yss[11])*Pssp;
	Mee_sp_s[251440]=pow(E,yss[3] - yss[11])*Pssp;
	Mee_sp_s[256624]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[257488]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[258352]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mee_sp_s[260944]=Pssp;
	Mee_sp_s[17]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[881]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[1745]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[2609]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mee_sp_s[3473]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[4337]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[5201]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[6065]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[256625]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[257489]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[261809]=Pssp;
	Mee_sp_s[1746]=-Pssp;
	Mee_sp_s[2611]=-Pssp;
	Mee_sp_s[3476]=-Pssp;
	Mee_sp_s[6069]=-Pssp;
	Mee_sp_s[5206]=-Pssp;
	Mee_sp_s[4343]=-Pssp;
	Mee_sp_s[12984]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mee_sp_s[262680]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mee_sp_s[263544]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mee_sp_s[269592]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[270456]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[271320]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[8665]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[9529]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[10393]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[263545]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[264409]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[267001]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mee_sp_s[269593]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mee_sp_s[270457]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[271321]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[8666]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[9530]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[263546]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[264410]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[267002]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mee_sp_s[268730]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[269594]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mee_sp_s[270458]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[271322]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[6939]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[7803]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[8667]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[9531]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mee_sp_s[10395]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[11259]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[12123]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[12987]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[267003]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mee_sp_s[269595]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[270459]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mee_sp_s[271323]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mee_sp_s[6940]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mee_sp_s[7804]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mee_sp_s[8668]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mee_sp_s[9532]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mee_sp_s[10396]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mee_sp_s[11260]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mee_sp_s[12124]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mee_sp_s[12988]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mee_sp_s[267868]=-(kkappa*Pssp*yss[9]);
	Mee_sp_s[269596]=pow(E,yss[8])*Pssp;
	Mee_sp_s[270460]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mee_sp_s[271324]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mee_sp_s[6941]=iiota*Pssp*zbar;
	Mee_sp_s[9533]=iiota*Pssp*zbar;
	Mee_sp_s[267869]=-Pssp;
	Mee_sp_s[263550]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mee_sp_s[268734]=-(pow(E,yss[7])*Pssp);
	Mee_sp_s[270462]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[271326]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[7807]=-((Pssp*zbar)/(1 + yss[5]));
	Mee_sp_s[8671]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[9535]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mee_sp_s[10399]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mee_sp_s[12127]=-(pow(E,yss[11])*ebar*Pssp);
	Mee_sp_s[262687]=-(pow(E,yss[0])*Pssp);
	Mee_sp_s[263551]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mee_sp_s[264415]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mee_sp_s[265279]=-(pow(E,yss[3])*Pssp);
	Mee_sp_s[267007]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[268735]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mee_sp_s[270463]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[271327]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[6944]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[9536]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[265280]=pow(E,yss[3])*Pssp;
	Mee_sp_s[270464]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[271328]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[6945]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[7809]=(Pssp*zbar)/(1 + yss[5]);
	Mee_sp_s[9537]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mee_sp_s[10401]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[263553]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[264417]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[267009]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[267873]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[268737]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[270465]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[271329]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[270466]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[271330]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[7811]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mee_sp_s[11267]=Pssp;
	Mee_sp_s[267011]=-Pssp;
	Mee_sp_s[270467]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[271331]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[6948]=pow(E,xss[0])*Pssp;
	Mee_sp_s[266148]=-(pow(E,xss[0])*Pssp);
	Mee_sp_s[8677]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[9541]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[10405]=pow(E,yss[2])*pbar*Pssp;
	Mee_sp_s[263557]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[264421]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mee_sp_s[270469]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[271333]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[272197]=pow(E,yss[11])*Pssp;
	Mee_sp_s[7814]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[9542]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[270470]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[271334]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[272198]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mee_sp_s[273062]=Pssp;
	Mee_sp_s[7815]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[9543]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[270471]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[271335]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[272199]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mee_sp_s[273927]=Pssp;
	Mee_sp_s[12136]=ebar*Pssp;
	Mee_sp_s[262696]=pow(E,yss[0] - yss[11])*Pssp;
	Mee_sp_s[265288]=pow(E,yss[3] - yss[11])*Pssp;
	Mee_sp_s[270472]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[271336]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[272200]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mee_sp_s[274792]=Pssp;
	Mee_sp_s[6953]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[7817]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[8681]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[9545]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mee_sp_s[10409]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[11273]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[12137]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[13001]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[270473]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[271337]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[275657]=Pssp;
	Mee_sp_s[8682]=-Pssp;
	Mee_sp_s[9547]=-Pssp;
	Mee_sp_s[10412]=-Pssp;
	Mee_sp_s[13005]=-Pssp;
	Mee_sp_s[12142]=-Pssp;
	Mee_sp_s[11279]=-Pssp;
	Mee_sp_s[19920]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mee_sp_s[276528]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mee_sp_s[277392]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mee_sp_s[283440]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[284304]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[285168]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[15601]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[16465]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[17329]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[277393]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[278257]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[280849]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mee_sp_s[283441]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mee_sp_s[284305]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[285169]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[15602]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[16466]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[277394]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[278258]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[280850]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mee_sp_s[282578]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[283442]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mee_sp_s[284306]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[285170]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[13875]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[14739]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[15603]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[16467]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mee_sp_s[17331]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[18195]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[19059]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[19923]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[280851]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mee_sp_s[283443]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[284307]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mee_sp_s[285171]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mee_sp_s[13876]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mee_sp_s[14740]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mee_sp_s[15604]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mee_sp_s[16468]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mee_sp_s[17332]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mee_sp_s[18196]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mee_sp_s[19060]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mee_sp_s[19924]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mee_sp_s[281716]=-(kkappa*Pssp*yss[9]);
	Mee_sp_s[283444]=pow(E,yss[8])*Pssp;
	Mee_sp_s[284308]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mee_sp_s[285172]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mee_sp_s[13877]=iiota*Pssp*zbar;
	Mee_sp_s[16469]=iiota*Pssp*zbar;
	Mee_sp_s[281717]=-Pssp;
	Mee_sp_s[277398]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mee_sp_s[282582]=-(pow(E,yss[7])*Pssp);
	Mee_sp_s[284310]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[285174]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[14743]=-((Pssp*zbar)/(1 + yss[5]));
	Mee_sp_s[15607]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[16471]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mee_sp_s[17335]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mee_sp_s[19063]=-(pow(E,yss[11])*ebar*Pssp);
	Mee_sp_s[276535]=-(pow(E,yss[0])*Pssp);
	Mee_sp_s[277399]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mee_sp_s[278263]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mee_sp_s[279127]=-(pow(E,yss[3])*Pssp);
	Mee_sp_s[280855]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[282583]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mee_sp_s[284311]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[285175]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[13880]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[16472]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[279128]=pow(E,yss[3])*Pssp;
	Mee_sp_s[284312]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[285176]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[13881]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[14745]=(Pssp*zbar)/(1 + yss[5]);
	Mee_sp_s[16473]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mee_sp_s[17337]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[277401]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[278265]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[280857]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[281721]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[282585]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[284313]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[285177]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[284314]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[285178]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[14747]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mee_sp_s[18203]=Pssp;
	Mee_sp_s[280859]=-Pssp;
	Mee_sp_s[284315]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[285179]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[13884]=pow(E,xss[0])*Pssp;
	Mee_sp_s[279996]=-(pow(E,xss[0])*Pssp);
	Mee_sp_s[15613]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[16477]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[17341]=pow(E,yss[2])*pbar*Pssp;
	Mee_sp_s[277405]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[278269]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mee_sp_s[284317]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[285181]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[286045]=pow(E,yss[11])*Pssp;
	Mee_sp_s[14750]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[16478]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[284318]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[285182]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[286046]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mee_sp_s[286910]=Pssp;
	Mee_sp_s[14751]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[16479]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[284319]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[285183]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[286047]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mee_sp_s[287775]=Pssp;
	Mee_sp_s[19072]=ebar*Pssp;
	Mee_sp_s[276544]=pow(E,yss[0] - yss[11])*Pssp;
	Mee_sp_s[279136]=pow(E,yss[3] - yss[11])*Pssp;
	Mee_sp_s[284320]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[285184]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[286048]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mee_sp_s[288640]=Pssp;
	Mee_sp_s[13889]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[14753]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[15617]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[16481]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mee_sp_s[17345]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[18209]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[19073]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[19937]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[284321]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[285185]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[289505]=Pssp;
	Mee_sp_s[15618]=-Pssp;
	Mee_sp_s[16483]=-Pssp;
	Mee_sp_s[17348]=-Pssp;
	Mee_sp_s[19941]=-Pssp;
	Mee_sp_s[19078]=-Pssp;
	Mee_sp_s[18215]=-Pssp;
	Mee_sp_s[26856]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mee_sp_s[290376]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mee_sp_s[291240]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mee_sp_s[297288]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[298152]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[299016]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[22537]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[23401]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[24265]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[291241]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[292105]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[294697]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mee_sp_s[297289]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mee_sp_s[298153]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[299017]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[22538]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[23402]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[291242]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[292106]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[294698]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mee_sp_s[296426]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[297290]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mee_sp_s[298154]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[299018]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[20811]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[21675]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[22539]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[23403]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mee_sp_s[24267]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[25131]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[25995]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[26859]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[294699]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mee_sp_s[297291]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[298155]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mee_sp_s[299019]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mee_sp_s[20812]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mee_sp_s[21676]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mee_sp_s[22540]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mee_sp_s[23404]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mee_sp_s[24268]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mee_sp_s[25132]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mee_sp_s[25996]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mee_sp_s[26860]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mee_sp_s[295564]=-(kkappa*Pssp*yss[9]);
	Mee_sp_s[297292]=pow(E,yss[8])*Pssp;
	Mee_sp_s[298156]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mee_sp_s[299020]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mee_sp_s[20813]=iiota*Pssp*zbar;
	Mee_sp_s[23405]=iiota*Pssp*zbar;
	Mee_sp_s[295565]=-Pssp;
	Mee_sp_s[291246]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mee_sp_s[296430]=-(pow(E,yss[7])*Pssp);
	Mee_sp_s[298158]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[299022]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[21679]=-((Pssp*zbar)/(1 + yss[5]));
	Mee_sp_s[22543]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[23407]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mee_sp_s[24271]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mee_sp_s[25999]=-(pow(E,yss[11])*ebar*Pssp);
	Mee_sp_s[290383]=-(pow(E,yss[0])*Pssp);
	Mee_sp_s[291247]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mee_sp_s[292111]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mee_sp_s[292975]=-(pow(E,yss[3])*Pssp);
	Mee_sp_s[294703]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[296431]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mee_sp_s[298159]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[299023]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[20816]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[23408]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[292976]=pow(E,yss[3])*Pssp;
	Mee_sp_s[298160]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[299024]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[20817]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[21681]=(Pssp*zbar)/(1 + yss[5]);
	Mee_sp_s[23409]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mee_sp_s[24273]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[291249]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[292113]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[294705]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[295569]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[296433]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[298161]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[299025]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[298162]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[299026]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[21683]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mee_sp_s[25139]=Pssp;
	Mee_sp_s[294707]=-Pssp;
	Mee_sp_s[298163]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[299027]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[20820]=pow(E,xss[0])*Pssp;
	Mee_sp_s[293844]=-(pow(E,xss[0])*Pssp);
	Mee_sp_s[22549]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[23413]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[24277]=pow(E,yss[2])*pbar*Pssp;
	Mee_sp_s[291253]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[292117]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mee_sp_s[298165]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[299029]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[299893]=pow(E,yss[11])*Pssp;
	Mee_sp_s[21686]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[23414]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[298166]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[299030]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[299894]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mee_sp_s[300758]=Pssp;
	Mee_sp_s[21687]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[23415]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[298167]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[299031]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[299895]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mee_sp_s[301623]=Pssp;
	Mee_sp_s[26008]=ebar*Pssp;
	Mee_sp_s[290392]=pow(E,yss[0] - yss[11])*Pssp;
	Mee_sp_s[292984]=pow(E,yss[3] - yss[11])*Pssp;
	Mee_sp_s[298168]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[299032]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[299896]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mee_sp_s[302488]=Pssp;
	Mee_sp_s[20825]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[21689]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[22553]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[23417]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mee_sp_s[24281]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[25145]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[26009]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[26873]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[298169]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[299033]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[303353]=Pssp;
	Mee_sp_s[22554]=-Pssp;
	Mee_sp_s[23419]=-Pssp;
	Mee_sp_s[24284]=-Pssp;
	Mee_sp_s[26877]=-Pssp;
	Mee_sp_s[26014]=-Pssp;
	Mee_sp_s[25151]=-Pssp;
	Mee_sp_s[33792]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mee_sp_s[304224]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mee_sp_s[305088]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mee_sp_s[311136]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[312000]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[312864]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[29473]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[30337]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[31201]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[305089]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[305953]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[308545]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mee_sp_s[311137]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mee_sp_s[312001]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[312865]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[29474]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[30338]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[305090]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[305954]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[308546]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mee_sp_s[310274]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[311138]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mee_sp_s[312002]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[312866]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[27747]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[28611]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[29475]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[30339]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mee_sp_s[31203]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[32067]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[32931]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[33795]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[308547]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mee_sp_s[311139]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[312003]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mee_sp_s[312867]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mee_sp_s[27748]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mee_sp_s[28612]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mee_sp_s[29476]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mee_sp_s[30340]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mee_sp_s[31204]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mee_sp_s[32068]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mee_sp_s[32932]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mee_sp_s[33796]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mee_sp_s[309412]=-(kkappa*Pssp*yss[9]);
	Mee_sp_s[311140]=pow(E,yss[8])*Pssp;
	Mee_sp_s[312004]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mee_sp_s[312868]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mee_sp_s[27749]=iiota*Pssp*zbar;
	Mee_sp_s[30341]=iiota*Pssp*zbar;
	Mee_sp_s[309413]=-Pssp;
	Mee_sp_s[305094]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mee_sp_s[310278]=-(pow(E,yss[7])*Pssp);
	Mee_sp_s[312006]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[312870]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[28615]=-((Pssp*zbar)/(1 + yss[5]));
	Mee_sp_s[29479]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[30343]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mee_sp_s[31207]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mee_sp_s[32935]=-(pow(E,yss[11])*ebar*Pssp);
	Mee_sp_s[304231]=-(pow(E,yss[0])*Pssp);
	Mee_sp_s[305095]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mee_sp_s[305959]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mee_sp_s[306823]=-(pow(E,yss[3])*Pssp);
	Mee_sp_s[308551]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[310279]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mee_sp_s[312007]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[312871]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[27752]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[30344]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[306824]=pow(E,yss[3])*Pssp;
	Mee_sp_s[312008]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[312872]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[27753]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[28617]=(Pssp*zbar)/(1 + yss[5]);
	Mee_sp_s[30345]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mee_sp_s[31209]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[305097]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[305961]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[308553]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[309417]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[310281]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[312009]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[312873]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[312010]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[312874]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[28619]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mee_sp_s[32075]=Pssp;
	Mee_sp_s[308555]=-Pssp;
	Mee_sp_s[312011]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[312875]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[27756]=pow(E,xss[0])*Pssp;
	Mee_sp_s[307692]=-(pow(E,xss[0])*Pssp);
	Mee_sp_s[29485]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[30349]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[31213]=pow(E,yss[2])*pbar*Pssp;
	Mee_sp_s[305101]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[305965]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mee_sp_s[312013]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[312877]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[313741]=pow(E,yss[11])*Pssp;
	Mee_sp_s[28622]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[30350]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[312014]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[312878]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[313742]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mee_sp_s[314606]=Pssp;
	Mee_sp_s[28623]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[30351]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[312015]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[312879]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[313743]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mee_sp_s[315471]=Pssp;
	Mee_sp_s[32944]=ebar*Pssp;
	Mee_sp_s[304240]=pow(E,yss[0] - yss[11])*Pssp;
	Mee_sp_s[306832]=pow(E,yss[3] - yss[11])*Pssp;
	Mee_sp_s[312016]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[312880]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[313744]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mee_sp_s[316336]=Pssp;
	Mee_sp_s[27761]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[28625]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[29489]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[30353]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mee_sp_s[31217]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[32081]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[32945]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[33809]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[312017]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[312881]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[317201]=Pssp;
	Mee_sp_s[29490]=-Pssp;
	Mee_sp_s[30355]=-Pssp;
	Mee_sp_s[31220]=-Pssp;
	Mee_sp_s[33813]=-Pssp;
	Mee_sp_s[32950]=-Pssp;
	Mee_sp_s[32087]=-Pssp;
	Mee_sp_s[40728]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mee_sp_s[318072]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mee_sp_s[318936]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mee_sp_s[324984]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[325848]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[326712]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[36409]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[37273]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[38137]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[318937]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[319801]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[322393]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mee_sp_s[324985]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mee_sp_s[325849]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[326713]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[36410]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[37274]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[318938]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[319802]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[322394]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mee_sp_s[324122]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[324986]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mee_sp_s[325850]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[326714]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[34683]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[35547]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[36411]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[37275]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mee_sp_s[38139]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[39003]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[39867]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[40731]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[322395]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mee_sp_s[324987]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[325851]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mee_sp_s[326715]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mee_sp_s[34684]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mee_sp_s[35548]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mee_sp_s[36412]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mee_sp_s[37276]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mee_sp_s[38140]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mee_sp_s[39004]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mee_sp_s[39868]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mee_sp_s[40732]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mee_sp_s[323260]=-(kkappa*Pssp*yss[9]);
	Mee_sp_s[324988]=pow(E,yss[8])*Pssp;
	Mee_sp_s[325852]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mee_sp_s[326716]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mee_sp_s[34685]=iiota*Pssp*zbar;
	Mee_sp_s[37277]=iiota*Pssp*zbar;
	Mee_sp_s[323261]=-Pssp;
	Mee_sp_s[318942]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mee_sp_s[324126]=-(pow(E,yss[7])*Pssp);
	Mee_sp_s[325854]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[326718]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[35551]=-((Pssp*zbar)/(1 + yss[5]));
	Mee_sp_s[36415]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[37279]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mee_sp_s[38143]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mee_sp_s[39871]=-(pow(E,yss[11])*ebar*Pssp);
	Mee_sp_s[318079]=-(pow(E,yss[0])*Pssp);
	Mee_sp_s[318943]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mee_sp_s[319807]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mee_sp_s[320671]=-(pow(E,yss[3])*Pssp);
	Mee_sp_s[322399]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[324127]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mee_sp_s[325855]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[326719]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[34688]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[37280]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[320672]=pow(E,yss[3])*Pssp;
	Mee_sp_s[325856]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[326720]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[34689]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[35553]=(Pssp*zbar)/(1 + yss[5]);
	Mee_sp_s[37281]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mee_sp_s[38145]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[318945]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[319809]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[322401]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[323265]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[324129]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[325857]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[326721]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[325858]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[326722]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[35555]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mee_sp_s[39011]=Pssp;
	Mee_sp_s[322403]=-Pssp;
	Mee_sp_s[325859]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[326723]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[34692]=pow(E,xss[0])*Pssp;
	Mee_sp_s[321540]=-(pow(E,xss[0])*Pssp);
	Mee_sp_s[36421]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[37285]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[38149]=pow(E,yss[2])*pbar*Pssp;
	Mee_sp_s[318949]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[319813]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mee_sp_s[325861]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[326725]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[327589]=pow(E,yss[11])*Pssp;
	Mee_sp_s[35558]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[37286]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[325862]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[326726]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[327590]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mee_sp_s[328454]=Pssp;
	Mee_sp_s[35559]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[37287]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[325863]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[326727]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[327591]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mee_sp_s[329319]=Pssp;
	Mee_sp_s[39880]=ebar*Pssp;
	Mee_sp_s[318088]=pow(E,yss[0] - yss[11])*Pssp;
	Mee_sp_s[320680]=pow(E,yss[3] - yss[11])*Pssp;
	Mee_sp_s[325864]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[326728]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[327592]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mee_sp_s[330184]=Pssp;
	Mee_sp_s[34697]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[35561]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[36425]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[37289]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mee_sp_s[38153]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[39017]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[39881]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[40745]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[325865]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[326729]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[331049]=Pssp;
	Mee_sp_s[36426]=-Pssp;
	Mee_sp_s[37291]=-Pssp;
	Mee_sp_s[38156]=-Pssp;
	Mee_sp_s[40749]=-Pssp;
	Mee_sp_s[39886]=-Pssp;
	Mee_sp_s[39023]=-Pssp;
	Mee_sp_s[7056]=1;
	Mee_sp_s[41616]=-1;
	Mee_sp_s[7921]=1;
	Mee_sp_s[42481]=-1;
	Mee_sp_s[8786]=1;
	Mee_sp_s[43346]=-1;
	Mee_sp_s[9651]=1;
	Mee_sp_s[44211]=-1;
	Mee_sp_s[10516]=1;
	Mee_sp_s[45076]=-1;
	Mee_sp_s[11381]=1;
	Mee_sp_s[45941]=-1;
	Mee_sp_s[12246]=1;
	Mee_sp_s[46806]=-1;
	Mee_sp_s[13111]=1;
	Mee_sp_s[47671]=-1;
	Mee_sp_s[262808]=1;
	Mee_sp_s[331928]=-1;
	Mee_sp_s[263673]=1;
	Mee_sp_s[332793]=-1;
	Mee_sp_s[264538]=1;
	Mee_sp_s[333658]=-1;
	Mee_sp_s[265403]=1;
	Mee_sp_s[334523]=-1;
	Mee_sp_s[266268]=1;
	Mee_sp_s[335388]=-1;
	Mee_sp_s[267133]=1;
	Mee_sp_s[336253]=-1;
	Mee_sp_s[267998]=1;
	Mee_sp_s[337118]=-1;
	Mee_sp_s[268863]=1;
	Mee_sp_s[337983]=-1;
	Mee_sp_s[269728]=1;
	Mee_sp_s[338848]=-1;
	Mee_sp_s[270593]=1;
	Mee_sp_s[339713]=-1;
	Mee_sp_s[271458]=1;
	Mee_sp_s[340578]=-1;
	Mee_sp_s[272323]=1;
	Mee_sp_s[341443]=-1;
	Mee_sp_s[273188]=1;
	Mee_sp_s[342308]=-1;
	Mee_sp_s[274053]=1;
	Mee_sp_s[343173]=-1;
	Mee_sp_s[274918]=1;
	Mee_sp_s[344038]=-1;
	Mee_sp_s[275783]=1;
	Mee_sp_s[344903]=-1;
	Mee_sp_s[54600]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mee_sp_s[345768]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mee_sp_s[346632]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mee_sp_s[352680]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[353544]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[354408]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[50281]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[51145]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[52009]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[346633]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[347497]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[350089]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mee_sp_s[352681]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mee_sp_s[353545]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[354409]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[50282]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[51146]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[346634]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[347498]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[350090]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mee_sp_s[351818]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[352682]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mee_sp_s[353546]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[354410]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[48555]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[49419]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[50283]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[51147]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mee_sp_s[52011]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[52875]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[53739]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[54603]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[350091]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mee_sp_s[352683]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[353547]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mee_sp_s[354411]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mee_sp_s[48556]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mee_sp_s[49420]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mee_sp_s[50284]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mee_sp_s[51148]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mee_sp_s[52012]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mee_sp_s[52876]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mee_sp_s[53740]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mee_sp_s[54604]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mee_sp_s[350956]=-(kkappa*Pssp*yss[9]);
	Mee_sp_s[352684]=pow(E,yss[8])*Pssp;
	Mee_sp_s[353548]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mee_sp_s[354412]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mee_sp_s[48557]=iiota*Pssp*zbar;
	Mee_sp_s[51149]=iiota*Pssp*zbar;
	Mee_sp_s[350957]=-Pssp;
	Mee_sp_s[346638]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mee_sp_s[351822]=-(pow(E,yss[7])*Pssp);
	Mee_sp_s[353550]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[354414]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[49423]=-((Pssp*zbar)/(1 + yss[5]));
	Mee_sp_s[50287]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[51151]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mee_sp_s[52015]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mee_sp_s[53743]=-(pow(E,yss[11])*ebar*Pssp);
	Mee_sp_s[345775]=-(pow(E,yss[0])*Pssp);
	Mee_sp_s[346639]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mee_sp_s[347503]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mee_sp_s[348367]=-(pow(E,yss[3])*Pssp);
	Mee_sp_s[350095]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[351823]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mee_sp_s[353551]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[354415]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[48560]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[51152]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[348368]=pow(E,yss[3])*Pssp;
	Mee_sp_s[353552]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[354416]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[48561]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[49425]=(Pssp*zbar)/(1 + yss[5]);
	Mee_sp_s[51153]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mee_sp_s[52017]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[346641]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[347505]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[350097]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[350961]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[351825]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[353553]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[354417]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[353554]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[354418]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[49427]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mee_sp_s[52883]=Pssp;
	Mee_sp_s[350099]=-Pssp;
	Mee_sp_s[353555]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[354419]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[48564]=pow(E,xss[0])*Pssp;
	Mee_sp_s[349236]=-(pow(E,xss[0])*Pssp);
	Mee_sp_s[50293]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[51157]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[52021]=pow(E,yss[2])*pbar*Pssp;
	Mee_sp_s[346645]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[347509]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mee_sp_s[353557]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[354421]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[355285]=pow(E,yss[11])*Pssp;
	Mee_sp_s[49430]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[51158]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[353558]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[354422]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[355286]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mee_sp_s[356150]=Pssp;
	Mee_sp_s[49431]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[51159]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[353559]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[354423]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[355287]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mee_sp_s[357015]=Pssp;
	Mee_sp_s[53752]=ebar*Pssp;
	Mee_sp_s[345784]=pow(E,yss[0] - yss[11])*Pssp;
	Mee_sp_s[348376]=pow(E,yss[3] - yss[11])*Pssp;
	Mee_sp_s[353560]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[354424]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[355288]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mee_sp_s[357880]=Pssp;
	Mee_sp_s[48569]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[49433]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[50297]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[51161]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mee_sp_s[52025]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[52889]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[53753]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[54617]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[353561]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[354425]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[358745]=Pssp;
	Mee_sp_s[50298]=-Pssp;
	Mee_sp_s[51163]=-Pssp;
	Mee_sp_s[52028]=-Pssp;
	Mee_sp_s[54621]=-Pssp;
	Mee_sp_s[53758]=-Pssp;
	Mee_sp_s[52895]=-Pssp;
	Mee_sp_s[61536]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mee_sp_s[359616]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mee_sp_s[360480]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mee_sp_s[366528]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[367392]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[368256]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[57217]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[58081]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[58945]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[360481]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[361345]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[363937]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mee_sp_s[366529]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mee_sp_s[367393]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[368257]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[57218]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[58082]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[360482]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[361346]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[363938]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mee_sp_s[365666]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[366530]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mee_sp_s[367394]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[368258]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[55491]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[56355]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[57219]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[58083]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mee_sp_s[58947]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[59811]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[60675]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[61539]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[363939]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mee_sp_s[366531]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[367395]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mee_sp_s[368259]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mee_sp_s[55492]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mee_sp_s[56356]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mee_sp_s[57220]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mee_sp_s[58084]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mee_sp_s[58948]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mee_sp_s[59812]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mee_sp_s[60676]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mee_sp_s[61540]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mee_sp_s[364804]=-(kkappa*Pssp*yss[9]);
	Mee_sp_s[366532]=pow(E,yss[8])*Pssp;
	Mee_sp_s[367396]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mee_sp_s[368260]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mee_sp_s[55493]=iiota*Pssp*zbar;
	Mee_sp_s[58085]=iiota*Pssp*zbar;
	Mee_sp_s[364805]=-Pssp;
	Mee_sp_s[360486]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mee_sp_s[365670]=-(pow(E,yss[7])*Pssp);
	Mee_sp_s[367398]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[368262]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[56359]=-((Pssp*zbar)/(1 + yss[5]));
	Mee_sp_s[57223]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[58087]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mee_sp_s[58951]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mee_sp_s[60679]=-(pow(E,yss[11])*ebar*Pssp);
	Mee_sp_s[359623]=-(pow(E,yss[0])*Pssp);
	Mee_sp_s[360487]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mee_sp_s[361351]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mee_sp_s[362215]=-(pow(E,yss[3])*Pssp);
	Mee_sp_s[363943]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[365671]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mee_sp_s[367399]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[368263]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[55496]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[58088]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[362216]=pow(E,yss[3])*Pssp;
	Mee_sp_s[367400]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[368264]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[55497]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[56361]=(Pssp*zbar)/(1 + yss[5]);
	Mee_sp_s[58089]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mee_sp_s[58953]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[360489]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[361353]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[363945]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[364809]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[365673]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[367401]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[368265]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[367402]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[368266]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[56363]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mee_sp_s[59819]=Pssp;
	Mee_sp_s[363947]=-Pssp;
	Mee_sp_s[367403]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[368267]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[55500]=pow(E,xss[0])*Pssp;
	Mee_sp_s[363084]=-(pow(E,xss[0])*Pssp);
	Mee_sp_s[57229]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[58093]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[58957]=pow(E,yss[2])*pbar*Pssp;
	Mee_sp_s[360493]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[361357]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mee_sp_s[367405]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[368269]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[369133]=pow(E,yss[11])*Pssp;
	Mee_sp_s[56366]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[58094]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[367406]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[368270]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[369134]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mee_sp_s[369998]=Pssp;
	Mee_sp_s[56367]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[58095]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[367407]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[368271]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[369135]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mee_sp_s[370863]=Pssp;
	Mee_sp_s[60688]=ebar*Pssp;
	Mee_sp_s[359632]=pow(E,yss[0] - yss[11])*Pssp;
	Mee_sp_s[362224]=pow(E,yss[3] - yss[11])*Pssp;
	Mee_sp_s[367408]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[368272]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[369136]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mee_sp_s[371728]=Pssp;
	Mee_sp_s[55505]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[56369]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[57233]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[58097]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mee_sp_s[58961]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[59825]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[60689]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[61553]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[367409]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[368273]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[372593]=Pssp;
	Mee_sp_s[57234]=-Pssp;
	Mee_sp_s[58099]=-Pssp;
	Mee_sp_s[58964]=-Pssp;
	Mee_sp_s[61557]=-Pssp;
	Mee_sp_s[60694]=-Pssp;
	Mee_sp_s[59831]=-Pssp;
	Mee_sp_s[68472]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mee_sp_s[373464]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mee_sp_s[374328]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mee_sp_s[380376]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[381240]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[382104]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[64153]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[65017]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[65881]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[374329]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[375193]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[377785]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mee_sp_s[380377]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mee_sp_s[381241]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[382105]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[64154]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[65018]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[374330]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[375194]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[377786]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mee_sp_s[379514]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[380378]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mee_sp_s[381242]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[382106]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[62427]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[63291]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[64155]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[65019]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mee_sp_s[65883]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[66747]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[67611]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[68475]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[377787]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mee_sp_s[380379]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[381243]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mee_sp_s[382107]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mee_sp_s[62428]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mee_sp_s[63292]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mee_sp_s[64156]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mee_sp_s[65020]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mee_sp_s[65884]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mee_sp_s[66748]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mee_sp_s[67612]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mee_sp_s[68476]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mee_sp_s[378652]=-(kkappa*Pssp*yss[9]);
	Mee_sp_s[380380]=pow(E,yss[8])*Pssp;
	Mee_sp_s[381244]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mee_sp_s[382108]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mee_sp_s[62429]=iiota*Pssp*zbar;
	Mee_sp_s[65021]=iiota*Pssp*zbar;
	Mee_sp_s[378653]=-Pssp;
	Mee_sp_s[374334]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mee_sp_s[379518]=-(pow(E,yss[7])*Pssp);
	Mee_sp_s[381246]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[382110]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[63295]=-((Pssp*zbar)/(1 + yss[5]));
	Mee_sp_s[64159]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[65023]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mee_sp_s[65887]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mee_sp_s[67615]=-(pow(E,yss[11])*ebar*Pssp);
	Mee_sp_s[373471]=-(pow(E,yss[0])*Pssp);
	Mee_sp_s[374335]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mee_sp_s[375199]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mee_sp_s[376063]=-(pow(E,yss[3])*Pssp);
	Mee_sp_s[377791]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[379519]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mee_sp_s[381247]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[382111]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[62432]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[65024]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[376064]=pow(E,yss[3])*Pssp;
	Mee_sp_s[381248]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[382112]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[62433]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[63297]=(Pssp*zbar)/(1 + yss[5]);
	Mee_sp_s[65025]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mee_sp_s[65889]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[374337]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[375201]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[377793]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[378657]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[379521]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[381249]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[382113]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[381250]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[382114]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[63299]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mee_sp_s[66755]=Pssp;
	Mee_sp_s[377795]=-Pssp;
	Mee_sp_s[381251]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[382115]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[62436]=pow(E,xss[0])*Pssp;
	Mee_sp_s[376932]=-(pow(E,xss[0])*Pssp);
	Mee_sp_s[64165]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[65029]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[65893]=pow(E,yss[2])*pbar*Pssp;
	Mee_sp_s[374341]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[375205]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mee_sp_s[381253]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[382117]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[382981]=pow(E,yss[11])*Pssp;
	Mee_sp_s[63302]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[65030]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[381254]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[382118]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[382982]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mee_sp_s[383846]=Pssp;
	Mee_sp_s[63303]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[65031]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[381255]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[382119]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[382983]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mee_sp_s[384711]=Pssp;
	Mee_sp_s[67624]=ebar*Pssp;
	Mee_sp_s[373480]=pow(E,yss[0] - yss[11])*Pssp;
	Mee_sp_s[376072]=pow(E,yss[3] - yss[11])*Pssp;
	Mee_sp_s[381256]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[382120]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[382984]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mee_sp_s[385576]=Pssp;
	Mee_sp_s[62441]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[63305]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[64169]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[65033]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mee_sp_s[65897]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[66761]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[67625]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[68489]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[381257]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[382121]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[386441]=Pssp;
	Mee_sp_s[64170]=-Pssp;
	Mee_sp_s[65035]=-Pssp;
	Mee_sp_s[65900]=-Pssp;
	Mee_sp_s[68493]=-Pssp;
	Mee_sp_s[67630]=-Pssp;
	Mee_sp_s[66767]=-Pssp;
	Mee_sp_s[75408]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mee_sp_s[387312]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mee_sp_s[388176]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mee_sp_s[394224]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[395088]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[395952]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[71089]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[71953]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[72817]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[388177]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[389041]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[391633]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mee_sp_s[394225]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mee_sp_s[395089]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[395953]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[71090]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[71954]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[388178]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[389042]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[391634]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mee_sp_s[393362]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[394226]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mee_sp_s[395090]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[395954]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[69363]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[70227]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[71091]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[71955]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mee_sp_s[72819]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[73683]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[74547]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[75411]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[391635]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mee_sp_s[394227]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[395091]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mee_sp_s[395955]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mee_sp_s[69364]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mee_sp_s[70228]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mee_sp_s[71092]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mee_sp_s[71956]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mee_sp_s[72820]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mee_sp_s[73684]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mee_sp_s[74548]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mee_sp_s[75412]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mee_sp_s[392500]=-(kkappa*Pssp*yss[9]);
	Mee_sp_s[394228]=pow(E,yss[8])*Pssp;
	Mee_sp_s[395092]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mee_sp_s[395956]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mee_sp_s[69365]=iiota*Pssp*zbar;
	Mee_sp_s[71957]=iiota*Pssp*zbar;
	Mee_sp_s[392501]=-Pssp;
	Mee_sp_s[388182]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mee_sp_s[393366]=-(pow(E,yss[7])*Pssp);
	Mee_sp_s[395094]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[395958]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[70231]=-((Pssp*zbar)/(1 + yss[5]));
	Mee_sp_s[71095]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[71959]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mee_sp_s[72823]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mee_sp_s[74551]=-(pow(E,yss[11])*ebar*Pssp);
	Mee_sp_s[387319]=-(pow(E,yss[0])*Pssp);
	Mee_sp_s[388183]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mee_sp_s[389047]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mee_sp_s[389911]=-(pow(E,yss[3])*Pssp);
	Mee_sp_s[391639]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[393367]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mee_sp_s[395095]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[395959]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[69368]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[71960]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[389912]=pow(E,yss[3])*Pssp;
	Mee_sp_s[395096]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[395960]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[69369]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[70233]=(Pssp*zbar)/(1 + yss[5]);
	Mee_sp_s[71961]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mee_sp_s[72825]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[388185]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[389049]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[391641]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[392505]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[393369]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[395097]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[395961]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[395098]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[395962]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[70235]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mee_sp_s[73691]=Pssp;
	Mee_sp_s[391643]=-Pssp;
	Mee_sp_s[395099]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[395963]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[69372]=pow(E,xss[0])*Pssp;
	Mee_sp_s[390780]=-(pow(E,xss[0])*Pssp);
	Mee_sp_s[71101]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[71965]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[72829]=pow(E,yss[2])*pbar*Pssp;
	Mee_sp_s[388189]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[389053]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mee_sp_s[395101]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[395965]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[396829]=pow(E,yss[11])*Pssp;
	Mee_sp_s[70238]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[71966]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[395102]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[395966]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[396830]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mee_sp_s[397694]=Pssp;
	Mee_sp_s[70239]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[71967]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[395103]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[395967]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[396831]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mee_sp_s[398559]=Pssp;
	Mee_sp_s[74560]=ebar*Pssp;
	Mee_sp_s[387328]=pow(E,yss[0] - yss[11])*Pssp;
	Mee_sp_s[389920]=pow(E,yss[3] - yss[11])*Pssp;
	Mee_sp_s[395104]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[395968]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[396832]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mee_sp_s[399424]=Pssp;
	Mee_sp_s[69377]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[70241]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[71105]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[71969]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mee_sp_s[72833]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[73697]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[74561]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[75425]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[395105]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[395969]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[400289]=Pssp;
	Mee_sp_s[71106]=-Pssp;
	Mee_sp_s[71971]=-Pssp;
	Mee_sp_s[72836]=-Pssp;
	Mee_sp_s[75429]=-Pssp;
	Mee_sp_s[74566]=-Pssp;
	Mee_sp_s[73703]=-Pssp;
	Mee_sp_s[82344]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mee_sp_s[401160]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mee_sp_s[402024]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mee_sp_s[408072]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[408936]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[409800]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[78025]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[78889]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[79753]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[402025]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[402889]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[405481]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mee_sp_s[408073]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mee_sp_s[408937]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[409801]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[78026]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[78890]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[402026]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[402890]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[405482]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mee_sp_s[407210]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[408074]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mee_sp_s[408938]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[409802]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[76299]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[77163]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[78027]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[78891]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mee_sp_s[79755]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[80619]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[81483]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[82347]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[405483]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mee_sp_s[408075]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[408939]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mee_sp_s[409803]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mee_sp_s[76300]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mee_sp_s[77164]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mee_sp_s[78028]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mee_sp_s[78892]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mee_sp_s[79756]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mee_sp_s[80620]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mee_sp_s[81484]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mee_sp_s[82348]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mee_sp_s[406348]=-(kkappa*Pssp*yss[9]);
	Mee_sp_s[408076]=pow(E,yss[8])*Pssp;
	Mee_sp_s[408940]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mee_sp_s[409804]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mee_sp_s[76301]=iiota*Pssp*zbar;
	Mee_sp_s[78893]=iiota*Pssp*zbar;
	Mee_sp_s[406349]=-Pssp;
	Mee_sp_s[402030]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mee_sp_s[407214]=-(pow(E,yss[7])*Pssp);
	Mee_sp_s[408942]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[409806]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[77167]=-((Pssp*zbar)/(1 + yss[5]));
	Mee_sp_s[78031]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[78895]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mee_sp_s[79759]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mee_sp_s[81487]=-(pow(E,yss[11])*ebar*Pssp);
	Mee_sp_s[401167]=-(pow(E,yss[0])*Pssp);
	Mee_sp_s[402031]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mee_sp_s[402895]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mee_sp_s[403759]=-(pow(E,yss[3])*Pssp);
	Mee_sp_s[405487]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[407215]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mee_sp_s[408943]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[409807]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[76304]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[78896]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[403760]=pow(E,yss[3])*Pssp;
	Mee_sp_s[408944]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[409808]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[76305]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[77169]=(Pssp*zbar)/(1 + yss[5]);
	Mee_sp_s[78897]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mee_sp_s[79761]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[402033]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[402897]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[405489]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[406353]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[407217]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[408945]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[409809]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[408946]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[409810]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[77171]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mee_sp_s[80627]=Pssp;
	Mee_sp_s[405491]=-Pssp;
	Mee_sp_s[408947]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[409811]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[76308]=pow(E,xss[0])*Pssp;
	Mee_sp_s[404628]=-(pow(E,xss[0])*Pssp);
	Mee_sp_s[78037]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[78901]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[79765]=pow(E,yss[2])*pbar*Pssp;
	Mee_sp_s[402037]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[402901]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mee_sp_s[408949]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[409813]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[410677]=pow(E,yss[11])*Pssp;
	Mee_sp_s[77174]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[78902]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[408950]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[409814]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[410678]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mee_sp_s[411542]=Pssp;
	Mee_sp_s[77175]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[78903]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[408951]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[409815]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[410679]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mee_sp_s[412407]=Pssp;
	Mee_sp_s[81496]=ebar*Pssp;
	Mee_sp_s[401176]=pow(E,yss[0] - yss[11])*Pssp;
	Mee_sp_s[403768]=pow(E,yss[3] - yss[11])*Pssp;
	Mee_sp_s[408952]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[409816]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[410680]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mee_sp_s[413272]=Pssp;
	Mee_sp_s[76313]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[77177]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[78041]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[78905]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mee_sp_s[79769]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[80633]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[81497]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[82361]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[408953]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[409817]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[414137]=Pssp;
	Mee_sp_s[78042]=-Pssp;
	Mee_sp_s[78907]=-Pssp;
	Mee_sp_s[79772]=-Pssp;
	Mee_sp_s[82365]=-Pssp;
	Mee_sp_s[81502]=-Pssp;
	Mee_sp_s[80639]=-Pssp;
	Mee_sp_s[14112]=1;
	Mee_sp_s[83232]=-1;
	Mee_sp_s[14977]=1;
	Mee_sp_s[84097]=-1;
	Mee_sp_s[15842]=1;
	Mee_sp_s[84962]=-1;
	Mee_sp_s[16707]=1;
	Mee_sp_s[85827]=-1;
	Mee_sp_s[17572]=1;
	Mee_sp_s[86692]=-1;
	Mee_sp_s[18437]=1;
	Mee_sp_s[87557]=-1;
	Mee_sp_s[19302]=1;
	Mee_sp_s[88422]=-1;
	Mee_sp_s[20167]=1;
	Mee_sp_s[89287]=-1;
	Mee_sp_s[276776]=1;
	Mee_sp_s[415016]=-1;
	Mee_sp_s[277641]=1;
	Mee_sp_s[415881]=-1;
	Mee_sp_s[278506]=1;
	Mee_sp_s[416746]=-1;
	Mee_sp_s[279371]=1;
	Mee_sp_s[417611]=-1;
	Mee_sp_s[280236]=1;
	Mee_sp_s[418476]=-1;
	Mee_sp_s[281101]=1;
	Mee_sp_s[419341]=-1;
	Mee_sp_s[281966]=1;
	Mee_sp_s[420206]=-1;
	Mee_sp_s[282831]=1;
	Mee_sp_s[421071]=-1;
	Mee_sp_s[283696]=1;
	Mee_sp_s[421936]=-1;
	Mee_sp_s[284561]=1;
	Mee_sp_s[422801]=-1;
	Mee_sp_s[285426]=1;
	Mee_sp_s[423666]=-1;
	Mee_sp_s[286291]=1;
	Mee_sp_s[424531]=-1;
	Mee_sp_s[287156]=1;
	Mee_sp_s[425396]=-1;
	Mee_sp_s[288021]=1;
	Mee_sp_s[426261]=-1;
	Mee_sp_s[288886]=1;
	Mee_sp_s[427126]=-1;
	Mee_sp_s[289751]=1;
	Mee_sp_s[427991]=-1;
	Mee_sp_s[55608]=1;
	Mee_sp_s[90168]=-1;
	Mee_sp_s[56473]=1;
	Mee_sp_s[91033]=-1;
	Mee_sp_s[57338]=1;
	Mee_sp_s[91898]=-1;
	Mee_sp_s[58203]=1;
	Mee_sp_s[92763]=-1;
	Mee_sp_s[59068]=1;
	Mee_sp_s[93628]=-1;
	Mee_sp_s[59933]=1;
	Mee_sp_s[94493]=-1;
	Mee_sp_s[60798]=1;
	Mee_sp_s[95358]=-1;
	Mee_sp_s[61663]=1;
	Mee_sp_s[96223]=-1;
	Mee_sp_s[359744]=1;
	Mee_sp_s[428864]=-1;
	Mee_sp_s[360609]=1;
	Mee_sp_s[429729]=-1;
	Mee_sp_s[361474]=1;
	Mee_sp_s[430594]=-1;
	Mee_sp_s[362339]=1;
	Mee_sp_s[431459]=-1;
	Mee_sp_s[363204]=1;
	Mee_sp_s[432324]=-1;
	Mee_sp_s[364069]=1;
	Mee_sp_s[433189]=-1;
	Mee_sp_s[364934]=1;
	Mee_sp_s[434054]=-1;
	Mee_sp_s[365799]=1;
	Mee_sp_s[434919]=-1;
	Mee_sp_s[366664]=1;
	Mee_sp_s[435784]=-1;
	Mee_sp_s[367529]=1;
	Mee_sp_s[436649]=-1;
	Mee_sp_s[368394]=1;
	Mee_sp_s[437514]=-1;
	Mee_sp_s[369259]=1;
	Mee_sp_s[438379]=-1;
	Mee_sp_s[370124]=1;
	Mee_sp_s[439244]=-1;
	Mee_sp_s[370989]=1;
	Mee_sp_s[440109]=-1;
	Mee_sp_s[371854]=1;
	Mee_sp_s[440974]=-1;
	Mee_sp_s[372719]=1;
	Mee_sp_s[441839]=-1;
	Mee_sp_s[103152]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mee_sp_s[442704]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mee_sp_s[443568]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mee_sp_s[449616]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[450480]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[451344]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[98833]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[99697]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[100561]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[443569]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[444433]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[447025]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mee_sp_s[449617]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mee_sp_s[450481]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[451345]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[98834]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[99698]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[443570]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[444434]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[447026]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mee_sp_s[448754]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[449618]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mee_sp_s[450482]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[451346]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[97107]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[97971]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[98835]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[99699]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mee_sp_s[100563]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[101427]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[102291]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[103155]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[447027]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mee_sp_s[449619]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[450483]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mee_sp_s[451347]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mee_sp_s[97108]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mee_sp_s[97972]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mee_sp_s[98836]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mee_sp_s[99700]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mee_sp_s[100564]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mee_sp_s[101428]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mee_sp_s[102292]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mee_sp_s[103156]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mee_sp_s[447892]=-(kkappa*Pssp*yss[9]);
	Mee_sp_s[449620]=pow(E,yss[8])*Pssp;
	Mee_sp_s[450484]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mee_sp_s[451348]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mee_sp_s[97109]=iiota*Pssp*zbar;
	Mee_sp_s[99701]=iiota*Pssp*zbar;
	Mee_sp_s[447893]=-Pssp;
	Mee_sp_s[443574]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mee_sp_s[448758]=-(pow(E,yss[7])*Pssp);
	Mee_sp_s[450486]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[451350]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[97975]=-((Pssp*zbar)/(1 + yss[5]));
	Mee_sp_s[98839]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[99703]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mee_sp_s[100567]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mee_sp_s[102295]=-(pow(E,yss[11])*ebar*Pssp);
	Mee_sp_s[442711]=-(pow(E,yss[0])*Pssp);
	Mee_sp_s[443575]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mee_sp_s[444439]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mee_sp_s[445303]=-(pow(E,yss[3])*Pssp);
	Mee_sp_s[447031]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[448759]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mee_sp_s[450487]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[451351]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[97112]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[99704]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[445304]=pow(E,yss[3])*Pssp;
	Mee_sp_s[450488]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[451352]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[97113]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[97977]=(Pssp*zbar)/(1 + yss[5]);
	Mee_sp_s[99705]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mee_sp_s[100569]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[443577]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[444441]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[447033]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[447897]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[448761]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[450489]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[451353]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[450490]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[451354]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[97979]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mee_sp_s[101435]=Pssp;
	Mee_sp_s[447035]=-Pssp;
	Mee_sp_s[450491]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[451355]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[97116]=pow(E,xss[0])*Pssp;
	Mee_sp_s[446172]=-(pow(E,xss[0])*Pssp);
	Mee_sp_s[98845]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[99709]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[100573]=pow(E,yss[2])*pbar*Pssp;
	Mee_sp_s[443581]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[444445]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mee_sp_s[450493]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[451357]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[452221]=pow(E,yss[11])*Pssp;
	Mee_sp_s[97982]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[99710]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[450494]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[451358]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[452222]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mee_sp_s[453086]=Pssp;
	Mee_sp_s[97983]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[99711]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[450495]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[451359]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[452223]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mee_sp_s[453951]=Pssp;
	Mee_sp_s[102304]=ebar*Pssp;
	Mee_sp_s[442720]=pow(E,yss[0] - yss[11])*Pssp;
	Mee_sp_s[445312]=pow(E,yss[3] - yss[11])*Pssp;
	Mee_sp_s[450496]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[451360]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[452224]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mee_sp_s[454816]=Pssp;
	Mee_sp_s[97121]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[97985]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[98849]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[99713]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mee_sp_s[100577]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[101441]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[102305]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[103169]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[450497]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[451361]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[455681]=Pssp;
	Mee_sp_s[98850]=-Pssp;
	Mee_sp_s[99715]=-Pssp;
	Mee_sp_s[100580]=-Pssp;
	Mee_sp_s[103173]=-Pssp;
	Mee_sp_s[102310]=-Pssp;
	Mee_sp_s[101447]=-Pssp;
	Mee_sp_s[110088]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mee_sp_s[456552]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mee_sp_s[457416]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mee_sp_s[463464]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[464328]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[465192]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[105769]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[106633]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[107497]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[457417]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[458281]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[460873]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mee_sp_s[463465]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mee_sp_s[464329]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[465193]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[105770]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[106634]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[457418]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[458282]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[460874]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mee_sp_s[462602]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[463466]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mee_sp_s[464330]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[465194]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[104043]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[104907]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[105771]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[106635]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mee_sp_s[107499]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[108363]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[109227]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[110091]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[460875]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mee_sp_s[463467]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[464331]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mee_sp_s[465195]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mee_sp_s[104044]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mee_sp_s[104908]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mee_sp_s[105772]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mee_sp_s[106636]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mee_sp_s[107500]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mee_sp_s[108364]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mee_sp_s[109228]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mee_sp_s[110092]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mee_sp_s[461740]=-(kkappa*Pssp*yss[9]);
	Mee_sp_s[463468]=pow(E,yss[8])*Pssp;
	Mee_sp_s[464332]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mee_sp_s[465196]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mee_sp_s[104045]=iiota*Pssp*zbar;
	Mee_sp_s[106637]=iiota*Pssp*zbar;
	Mee_sp_s[461741]=-Pssp;
	Mee_sp_s[457422]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mee_sp_s[462606]=-(pow(E,yss[7])*Pssp);
	Mee_sp_s[464334]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[465198]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[104911]=-((Pssp*zbar)/(1 + yss[5]));
	Mee_sp_s[105775]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[106639]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mee_sp_s[107503]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mee_sp_s[109231]=-(pow(E,yss[11])*ebar*Pssp);
	Mee_sp_s[456559]=-(pow(E,yss[0])*Pssp);
	Mee_sp_s[457423]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mee_sp_s[458287]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mee_sp_s[459151]=-(pow(E,yss[3])*Pssp);
	Mee_sp_s[460879]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[462607]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mee_sp_s[464335]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[465199]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[104048]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[106640]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[459152]=pow(E,yss[3])*Pssp;
	Mee_sp_s[464336]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[465200]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[104049]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[104913]=(Pssp*zbar)/(1 + yss[5]);
	Mee_sp_s[106641]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mee_sp_s[107505]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[457425]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[458289]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[460881]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[461745]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[462609]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[464337]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[465201]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[464338]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[465202]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[104915]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mee_sp_s[108371]=Pssp;
	Mee_sp_s[460883]=-Pssp;
	Mee_sp_s[464339]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[465203]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[104052]=pow(E,xss[0])*Pssp;
	Mee_sp_s[460020]=-(pow(E,xss[0])*Pssp);
	Mee_sp_s[105781]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[106645]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[107509]=pow(E,yss[2])*pbar*Pssp;
	Mee_sp_s[457429]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[458293]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mee_sp_s[464341]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[465205]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[466069]=pow(E,yss[11])*Pssp;
	Mee_sp_s[104918]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[106646]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[464342]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[465206]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[466070]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mee_sp_s[466934]=Pssp;
	Mee_sp_s[104919]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[106647]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[464343]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[465207]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[466071]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mee_sp_s[467799]=Pssp;
	Mee_sp_s[109240]=ebar*Pssp;
	Mee_sp_s[456568]=pow(E,yss[0] - yss[11])*Pssp;
	Mee_sp_s[459160]=pow(E,yss[3] - yss[11])*Pssp;
	Mee_sp_s[464344]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[465208]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[466072]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mee_sp_s[468664]=Pssp;
	Mee_sp_s[104057]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[104921]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[105785]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[106649]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mee_sp_s[107513]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[108377]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[109241]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[110105]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[464345]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[465209]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[469529]=Pssp;
	Mee_sp_s[105786]=-Pssp;
	Mee_sp_s[106651]=-Pssp;
	Mee_sp_s[107516]=-Pssp;
	Mee_sp_s[110109]=-Pssp;
	Mee_sp_s[109246]=-Pssp;
	Mee_sp_s[108383]=-Pssp;
	Mee_sp_s[117024]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mee_sp_s[470400]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mee_sp_s[471264]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mee_sp_s[477312]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[478176]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[479040]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[112705]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[113569]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[114433]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[471265]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[472129]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[474721]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mee_sp_s[477313]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mee_sp_s[478177]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[479041]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[112706]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[113570]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[471266]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[472130]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[474722]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mee_sp_s[476450]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[477314]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mee_sp_s[478178]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[479042]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[110979]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[111843]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[112707]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[113571]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mee_sp_s[114435]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[115299]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[116163]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[117027]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[474723]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mee_sp_s[477315]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[478179]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mee_sp_s[479043]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mee_sp_s[110980]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mee_sp_s[111844]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mee_sp_s[112708]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mee_sp_s[113572]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mee_sp_s[114436]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mee_sp_s[115300]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mee_sp_s[116164]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mee_sp_s[117028]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mee_sp_s[475588]=-(kkappa*Pssp*yss[9]);
	Mee_sp_s[477316]=pow(E,yss[8])*Pssp;
	Mee_sp_s[478180]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mee_sp_s[479044]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mee_sp_s[110981]=iiota*Pssp*zbar;
	Mee_sp_s[113573]=iiota*Pssp*zbar;
	Mee_sp_s[475589]=-Pssp;
	Mee_sp_s[471270]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mee_sp_s[476454]=-(pow(E,yss[7])*Pssp);
	Mee_sp_s[478182]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[479046]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[111847]=-((Pssp*zbar)/(1 + yss[5]));
	Mee_sp_s[112711]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[113575]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mee_sp_s[114439]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mee_sp_s[116167]=-(pow(E,yss[11])*ebar*Pssp);
	Mee_sp_s[470407]=-(pow(E,yss[0])*Pssp);
	Mee_sp_s[471271]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mee_sp_s[472135]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mee_sp_s[472999]=-(pow(E,yss[3])*Pssp);
	Mee_sp_s[474727]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[476455]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mee_sp_s[478183]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[479047]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[110984]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[113576]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[473000]=pow(E,yss[3])*Pssp;
	Mee_sp_s[478184]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[479048]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[110985]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[111849]=(Pssp*zbar)/(1 + yss[5]);
	Mee_sp_s[113577]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mee_sp_s[114441]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[471273]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[472137]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[474729]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[475593]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[476457]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[478185]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[479049]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[478186]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[479050]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[111851]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mee_sp_s[115307]=Pssp;
	Mee_sp_s[474731]=-Pssp;
	Mee_sp_s[478187]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[479051]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[110988]=pow(E,xss[0])*Pssp;
	Mee_sp_s[473868]=-(pow(E,xss[0])*Pssp);
	Mee_sp_s[112717]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[113581]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[114445]=pow(E,yss[2])*pbar*Pssp;
	Mee_sp_s[471277]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[472141]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mee_sp_s[478189]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[479053]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[479917]=pow(E,yss[11])*Pssp;
	Mee_sp_s[111854]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[113582]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[478190]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[479054]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[479918]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mee_sp_s[480782]=Pssp;
	Mee_sp_s[111855]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[113583]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[478191]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[479055]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[479919]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mee_sp_s[481647]=Pssp;
	Mee_sp_s[116176]=ebar*Pssp;
	Mee_sp_s[470416]=pow(E,yss[0] - yss[11])*Pssp;
	Mee_sp_s[473008]=pow(E,yss[3] - yss[11])*Pssp;
	Mee_sp_s[478192]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[479056]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[479920]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mee_sp_s[482512]=Pssp;
	Mee_sp_s[110993]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[111857]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[112721]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[113585]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mee_sp_s[114449]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[115313]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[116177]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[117041]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[478193]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[479057]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[483377]=Pssp;
	Mee_sp_s[112722]=-Pssp;
	Mee_sp_s[113587]=-Pssp;
	Mee_sp_s[114452]=-Pssp;
	Mee_sp_s[117045]=-Pssp;
	Mee_sp_s[116182]=-Pssp;
	Mee_sp_s[115319]=-Pssp;
	Mee_sp_s[123960]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mee_sp_s[484248]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mee_sp_s[485112]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mee_sp_s[491160]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[492024]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[492888]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[119641]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[120505]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[121369]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[485113]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[485977]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[488569]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mee_sp_s[491161]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mee_sp_s[492025]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[492889]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[119642]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[120506]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[485114]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[485978]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[488570]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mee_sp_s[490298]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[491162]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mee_sp_s[492026]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[492890]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[117915]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[118779]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[119643]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[120507]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mee_sp_s[121371]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[122235]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[123099]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[123963]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[488571]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mee_sp_s[491163]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[492027]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mee_sp_s[492891]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mee_sp_s[117916]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mee_sp_s[118780]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mee_sp_s[119644]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mee_sp_s[120508]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mee_sp_s[121372]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mee_sp_s[122236]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mee_sp_s[123100]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mee_sp_s[123964]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mee_sp_s[489436]=-(kkappa*Pssp*yss[9]);
	Mee_sp_s[491164]=pow(E,yss[8])*Pssp;
	Mee_sp_s[492028]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mee_sp_s[492892]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mee_sp_s[117917]=iiota*Pssp*zbar;
	Mee_sp_s[120509]=iiota*Pssp*zbar;
	Mee_sp_s[489437]=-Pssp;
	Mee_sp_s[485118]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mee_sp_s[490302]=-(pow(E,yss[7])*Pssp);
	Mee_sp_s[492030]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[492894]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[118783]=-((Pssp*zbar)/(1 + yss[5]));
	Mee_sp_s[119647]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[120511]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mee_sp_s[121375]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mee_sp_s[123103]=-(pow(E,yss[11])*ebar*Pssp);
	Mee_sp_s[484255]=-(pow(E,yss[0])*Pssp);
	Mee_sp_s[485119]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mee_sp_s[485983]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mee_sp_s[486847]=-(pow(E,yss[3])*Pssp);
	Mee_sp_s[488575]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[490303]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mee_sp_s[492031]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[492895]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[117920]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[120512]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[486848]=pow(E,yss[3])*Pssp;
	Mee_sp_s[492032]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[492896]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[117921]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[118785]=(Pssp*zbar)/(1 + yss[5]);
	Mee_sp_s[120513]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mee_sp_s[121377]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[485121]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[485985]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[488577]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[489441]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[490305]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[492033]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[492897]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[492034]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[492898]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[118787]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mee_sp_s[122243]=Pssp;
	Mee_sp_s[488579]=-Pssp;
	Mee_sp_s[492035]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[492899]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[117924]=pow(E,xss[0])*Pssp;
	Mee_sp_s[487716]=-(pow(E,xss[0])*Pssp);
	Mee_sp_s[119653]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[120517]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[121381]=pow(E,yss[2])*pbar*Pssp;
	Mee_sp_s[485125]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[485989]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mee_sp_s[492037]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[492901]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[493765]=pow(E,yss[11])*Pssp;
	Mee_sp_s[118790]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[120518]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[492038]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[492902]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[493766]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mee_sp_s[494630]=Pssp;
	Mee_sp_s[118791]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[120519]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[492039]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[492903]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[493767]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mee_sp_s[495495]=Pssp;
	Mee_sp_s[123112]=ebar*Pssp;
	Mee_sp_s[484264]=pow(E,yss[0] - yss[11])*Pssp;
	Mee_sp_s[486856]=pow(E,yss[3] - yss[11])*Pssp;
	Mee_sp_s[492040]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[492904]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[493768]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mee_sp_s[496360]=Pssp;
	Mee_sp_s[117929]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[118793]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[119657]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[120521]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mee_sp_s[121385]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[122249]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[123113]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[123977]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[492041]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[492905]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[497225]=Pssp;
	Mee_sp_s[119658]=-Pssp;
	Mee_sp_s[120523]=-Pssp;
	Mee_sp_s[121388]=-Pssp;
	Mee_sp_s[123981]=-Pssp;
	Mee_sp_s[123118]=-Pssp;
	Mee_sp_s[122255]=-Pssp;
	Mee_sp_s[21168]=1;
	Mee_sp_s[124848]=-1;
	Mee_sp_s[22033]=1;
	Mee_sp_s[125713]=-1;
	Mee_sp_s[22898]=1;
	Mee_sp_s[126578]=-1;
	Mee_sp_s[23763]=1;
	Mee_sp_s[127443]=-1;
	Mee_sp_s[24628]=1;
	Mee_sp_s[128308]=-1;
	Mee_sp_s[25493]=1;
	Mee_sp_s[129173]=-1;
	Mee_sp_s[26358]=1;
	Mee_sp_s[130038]=-1;
	Mee_sp_s[27223]=1;
	Mee_sp_s[130903]=-1;
	Mee_sp_s[290744]=1;
	Mee_sp_s[498104]=-1;
	Mee_sp_s[291609]=1;
	Mee_sp_s[498969]=-1;
	Mee_sp_s[292474]=1;
	Mee_sp_s[499834]=-1;
	Mee_sp_s[293339]=1;
	Mee_sp_s[500699]=-1;
	Mee_sp_s[294204]=1;
	Mee_sp_s[501564]=-1;
	Mee_sp_s[295069]=1;
	Mee_sp_s[502429]=-1;
	Mee_sp_s[295934]=1;
	Mee_sp_s[503294]=-1;
	Mee_sp_s[296799]=1;
	Mee_sp_s[504159]=-1;
	Mee_sp_s[297664]=1;
	Mee_sp_s[505024]=-1;
	Mee_sp_s[298529]=1;
	Mee_sp_s[505889]=-1;
	Mee_sp_s[299394]=1;
	Mee_sp_s[506754]=-1;
	Mee_sp_s[300259]=1;
	Mee_sp_s[507619]=-1;
	Mee_sp_s[301124]=1;
	Mee_sp_s[508484]=-1;
	Mee_sp_s[301989]=1;
	Mee_sp_s[509349]=-1;
	Mee_sp_s[302854]=1;
	Mee_sp_s[510214]=-1;
	Mee_sp_s[303719]=1;
	Mee_sp_s[511079]=-1;
	Mee_sp_s[62664]=1;
	Mee_sp_s[131784]=-1;
	Mee_sp_s[63529]=1;
	Mee_sp_s[132649]=-1;
	Mee_sp_s[64394]=1;
	Mee_sp_s[133514]=-1;
	Mee_sp_s[65259]=1;
	Mee_sp_s[134379]=-1;
	Mee_sp_s[66124]=1;
	Mee_sp_s[135244]=-1;
	Mee_sp_s[66989]=1;
	Mee_sp_s[136109]=-1;
	Mee_sp_s[67854]=1;
	Mee_sp_s[136974]=-1;
	Mee_sp_s[68719]=1;
	Mee_sp_s[137839]=-1;
	Mee_sp_s[373712]=1;
	Mee_sp_s[511952]=-1;
	Mee_sp_s[374577]=1;
	Mee_sp_s[512817]=-1;
	Mee_sp_s[375442]=1;
	Mee_sp_s[513682]=-1;
	Mee_sp_s[376307]=1;
	Mee_sp_s[514547]=-1;
	Mee_sp_s[377172]=1;
	Mee_sp_s[515412]=-1;
	Mee_sp_s[378037]=1;
	Mee_sp_s[516277]=-1;
	Mee_sp_s[378902]=1;
	Mee_sp_s[517142]=-1;
	Mee_sp_s[379767]=1;
	Mee_sp_s[518007]=-1;
	Mee_sp_s[380632]=1;
	Mee_sp_s[518872]=-1;
	Mee_sp_s[381497]=1;
	Mee_sp_s[519737]=-1;
	Mee_sp_s[382362]=1;
	Mee_sp_s[520602]=-1;
	Mee_sp_s[383227]=1;
	Mee_sp_s[521467]=-1;
	Mee_sp_s[384092]=1;
	Mee_sp_s[522332]=-1;
	Mee_sp_s[384957]=1;
	Mee_sp_s[523197]=-1;
	Mee_sp_s[385822]=1;
	Mee_sp_s[524062]=-1;
	Mee_sp_s[386687]=1;
	Mee_sp_s[524927]=-1;
	Mee_sp_s[104160]=1;
	Mee_sp_s[138720]=-1;
	Mee_sp_s[105025]=1;
	Mee_sp_s[139585]=-1;
	Mee_sp_s[105890]=1;
	Mee_sp_s[140450]=-1;
	Mee_sp_s[106755]=1;
	Mee_sp_s[141315]=-1;
	Mee_sp_s[107620]=1;
	Mee_sp_s[142180]=-1;
	Mee_sp_s[108485]=1;
	Mee_sp_s[143045]=-1;
	Mee_sp_s[109350]=1;
	Mee_sp_s[143910]=-1;
	Mee_sp_s[110215]=1;
	Mee_sp_s[144775]=-1;
	Mee_sp_s[456680]=1;
	Mee_sp_s[525800]=-1;
	Mee_sp_s[457545]=1;
	Mee_sp_s[526665]=-1;
	Mee_sp_s[458410]=1;
	Mee_sp_s[527530]=-1;
	Mee_sp_s[459275]=1;
	Mee_sp_s[528395]=-1;
	Mee_sp_s[460140]=1;
	Mee_sp_s[529260]=-1;
	Mee_sp_s[461005]=1;
	Mee_sp_s[530125]=-1;
	Mee_sp_s[461870]=1;
	Mee_sp_s[530990]=-1;
	Mee_sp_s[462735]=1;
	Mee_sp_s[531855]=-1;
	Mee_sp_s[463600]=1;
	Mee_sp_s[532720]=-1;
	Mee_sp_s[464465]=1;
	Mee_sp_s[533585]=-1;
	Mee_sp_s[465330]=1;
	Mee_sp_s[534450]=-1;
	Mee_sp_s[466195]=1;
	Mee_sp_s[535315]=-1;
	Mee_sp_s[467060]=1;
	Mee_sp_s[536180]=-1;
	Mee_sp_s[467925]=1;
	Mee_sp_s[537045]=-1;
	Mee_sp_s[468790]=1;
	Mee_sp_s[537910]=-1;
	Mee_sp_s[469655]=1;
	Mee_sp_s[538775]=-1;
	Mee_sp_s[151704]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mee_sp_s[539640]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mee_sp_s[540504]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mee_sp_s[546552]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[547416]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[548280]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[147385]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[148249]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[149113]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[540505]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[541369]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[543961]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mee_sp_s[546553]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mee_sp_s[547417]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[548281]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[147386]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[148250]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[540506]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[541370]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[543962]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mee_sp_s[545690]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[546554]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mee_sp_s[547418]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[548282]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[145659]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[146523]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[147387]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[148251]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mee_sp_s[149115]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[149979]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[150843]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[151707]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[543963]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mee_sp_s[546555]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[547419]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mee_sp_s[548283]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mee_sp_s[145660]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mee_sp_s[146524]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mee_sp_s[147388]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mee_sp_s[148252]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mee_sp_s[149116]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mee_sp_s[149980]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mee_sp_s[150844]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mee_sp_s[151708]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mee_sp_s[544828]=-(kkappa*Pssp*yss[9]);
	Mee_sp_s[546556]=pow(E,yss[8])*Pssp;
	Mee_sp_s[547420]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mee_sp_s[548284]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mee_sp_s[145661]=iiota*Pssp*zbar;
	Mee_sp_s[148253]=iiota*Pssp*zbar;
	Mee_sp_s[544829]=-Pssp;
	Mee_sp_s[540510]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mee_sp_s[545694]=-(pow(E,yss[7])*Pssp);
	Mee_sp_s[547422]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[548286]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[146527]=-((Pssp*zbar)/(1 + yss[5]));
	Mee_sp_s[147391]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[148255]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mee_sp_s[149119]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mee_sp_s[150847]=-(pow(E,yss[11])*ebar*Pssp);
	Mee_sp_s[539647]=-(pow(E,yss[0])*Pssp);
	Mee_sp_s[540511]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mee_sp_s[541375]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mee_sp_s[542239]=-(pow(E,yss[3])*Pssp);
	Mee_sp_s[543967]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[545695]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mee_sp_s[547423]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[548287]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[145664]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[148256]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[542240]=pow(E,yss[3])*Pssp;
	Mee_sp_s[547424]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[548288]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[145665]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[146529]=(Pssp*zbar)/(1 + yss[5]);
	Mee_sp_s[148257]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mee_sp_s[149121]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[540513]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[541377]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[543969]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[544833]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[545697]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[547425]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[548289]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[547426]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[548290]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[146531]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mee_sp_s[149987]=Pssp;
	Mee_sp_s[543971]=-Pssp;
	Mee_sp_s[547427]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[548291]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[145668]=pow(E,xss[0])*Pssp;
	Mee_sp_s[543108]=-(pow(E,xss[0])*Pssp);
	Mee_sp_s[147397]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[148261]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[149125]=pow(E,yss[2])*pbar*Pssp;
	Mee_sp_s[540517]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[541381]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mee_sp_s[547429]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[548293]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[549157]=pow(E,yss[11])*Pssp;
	Mee_sp_s[146534]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[148262]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[547430]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[548294]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[549158]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mee_sp_s[550022]=Pssp;
	Mee_sp_s[146535]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[148263]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[547431]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[548295]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[549159]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mee_sp_s[550887]=Pssp;
	Mee_sp_s[150856]=ebar*Pssp;
	Mee_sp_s[539656]=pow(E,yss[0] - yss[11])*Pssp;
	Mee_sp_s[542248]=pow(E,yss[3] - yss[11])*Pssp;
	Mee_sp_s[547432]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[548296]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[549160]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mee_sp_s[551752]=Pssp;
	Mee_sp_s[145673]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[146537]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[147401]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[148265]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mee_sp_s[149129]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[149993]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[150857]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[151721]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[547433]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[548297]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[552617]=Pssp;
	Mee_sp_s[147402]=-Pssp;
	Mee_sp_s[148267]=-Pssp;
	Mee_sp_s[149132]=-Pssp;
	Mee_sp_s[151725]=-Pssp;
	Mee_sp_s[150862]=-Pssp;
	Mee_sp_s[149999]=-Pssp;
	Mee_sp_s[158640]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mee_sp_s[553488]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mee_sp_s[554352]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mee_sp_s[560400]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[561264]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[562128]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[154321]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[155185]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[156049]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[554353]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[555217]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[557809]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mee_sp_s[560401]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mee_sp_s[561265]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[562129]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[154322]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[155186]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[554354]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[555218]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[557810]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mee_sp_s[559538]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[560402]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mee_sp_s[561266]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[562130]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[152595]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[153459]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[154323]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[155187]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mee_sp_s[156051]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[156915]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[157779]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[158643]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[557811]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mee_sp_s[560403]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[561267]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mee_sp_s[562131]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mee_sp_s[152596]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mee_sp_s[153460]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mee_sp_s[154324]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mee_sp_s[155188]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mee_sp_s[156052]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mee_sp_s[156916]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mee_sp_s[157780]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mee_sp_s[158644]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mee_sp_s[558676]=-(kkappa*Pssp*yss[9]);
	Mee_sp_s[560404]=pow(E,yss[8])*Pssp;
	Mee_sp_s[561268]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mee_sp_s[562132]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mee_sp_s[152597]=iiota*Pssp*zbar;
	Mee_sp_s[155189]=iiota*Pssp*zbar;
	Mee_sp_s[558677]=-Pssp;
	Mee_sp_s[554358]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mee_sp_s[559542]=-(pow(E,yss[7])*Pssp);
	Mee_sp_s[561270]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[562134]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[153463]=-((Pssp*zbar)/(1 + yss[5]));
	Mee_sp_s[154327]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[155191]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mee_sp_s[156055]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mee_sp_s[157783]=-(pow(E,yss[11])*ebar*Pssp);
	Mee_sp_s[553495]=-(pow(E,yss[0])*Pssp);
	Mee_sp_s[554359]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mee_sp_s[555223]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mee_sp_s[556087]=-(pow(E,yss[3])*Pssp);
	Mee_sp_s[557815]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[559543]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mee_sp_s[561271]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[562135]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[152600]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[155192]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[556088]=pow(E,yss[3])*Pssp;
	Mee_sp_s[561272]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[562136]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[152601]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[153465]=(Pssp*zbar)/(1 + yss[5]);
	Mee_sp_s[155193]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mee_sp_s[156057]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[554361]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[555225]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[557817]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[558681]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[559545]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[561273]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[562137]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[561274]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[562138]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[153467]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mee_sp_s[156923]=Pssp;
	Mee_sp_s[557819]=-Pssp;
	Mee_sp_s[561275]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[562139]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[152604]=pow(E,xss[0])*Pssp;
	Mee_sp_s[556956]=-(pow(E,xss[0])*Pssp);
	Mee_sp_s[154333]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[155197]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[156061]=pow(E,yss[2])*pbar*Pssp;
	Mee_sp_s[554365]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[555229]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mee_sp_s[561277]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[562141]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[563005]=pow(E,yss[11])*Pssp;
	Mee_sp_s[153470]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[155198]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[561278]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[562142]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[563006]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mee_sp_s[563870]=Pssp;
	Mee_sp_s[153471]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[155199]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[561279]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[562143]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[563007]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mee_sp_s[564735]=Pssp;
	Mee_sp_s[157792]=ebar*Pssp;
	Mee_sp_s[553504]=pow(E,yss[0] - yss[11])*Pssp;
	Mee_sp_s[556096]=pow(E,yss[3] - yss[11])*Pssp;
	Mee_sp_s[561280]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[562144]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[563008]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mee_sp_s[565600]=Pssp;
	Mee_sp_s[152609]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[153473]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[154337]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[155201]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mee_sp_s[156065]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[156929]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[157793]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[158657]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[561281]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[562145]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[566465]=Pssp;
	Mee_sp_s[154338]=-Pssp;
	Mee_sp_s[155203]=-Pssp;
	Mee_sp_s[156068]=-Pssp;
	Mee_sp_s[158661]=-Pssp;
	Mee_sp_s[157798]=-Pssp;
	Mee_sp_s[156935]=-Pssp;
	Mee_sp_s[165576]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mee_sp_s[567336]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mee_sp_s[568200]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mee_sp_s[574248]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[575112]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[575976]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[161257]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[162121]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[162985]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[568201]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[569065]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[571657]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mee_sp_s[574249]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mee_sp_s[575113]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[575977]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[161258]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[162122]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[568202]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[569066]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[571658]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mee_sp_s[573386]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[574250]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mee_sp_s[575114]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[575978]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[159531]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[160395]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[161259]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[162123]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mee_sp_s[162987]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[163851]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[164715]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[165579]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[571659]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mee_sp_s[574251]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[575115]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mee_sp_s[575979]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mee_sp_s[159532]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mee_sp_s[160396]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mee_sp_s[161260]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mee_sp_s[162124]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mee_sp_s[162988]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mee_sp_s[163852]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mee_sp_s[164716]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mee_sp_s[165580]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mee_sp_s[572524]=-(kkappa*Pssp*yss[9]);
	Mee_sp_s[574252]=pow(E,yss[8])*Pssp;
	Mee_sp_s[575116]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mee_sp_s[575980]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mee_sp_s[159533]=iiota*Pssp*zbar;
	Mee_sp_s[162125]=iiota*Pssp*zbar;
	Mee_sp_s[572525]=-Pssp;
	Mee_sp_s[568206]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mee_sp_s[573390]=-(pow(E,yss[7])*Pssp);
	Mee_sp_s[575118]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[575982]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[160399]=-((Pssp*zbar)/(1 + yss[5]));
	Mee_sp_s[161263]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[162127]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mee_sp_s[162991]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mee_sp_s[164719]=-(pow(E,yss[11])*ebar*Pssp);
	Mee_sp_s[567343]=-(pow(E,yss[0])*Pssp);
	Mee_sp_s[568207]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mee_sp_s[569071]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mee_sp_s[569935]=-(pow(E,yss[3])*Pssp);
	Mee_sp_s[571663]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[573391]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mee_sp_s[575119]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[575983]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[159536]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[162128]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[569936]=pow(E,yss[3])*Pssp;
	Mee_sp_s[575120]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[575984]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[159537]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[160401]=(Pssp*zbar)/(1 + yss[5]);
	Mee_sp_s[162129]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mee_sp_s[162993]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[568209]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[569073]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[571665]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[572529]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[573393]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[575121]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[575985]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[575122]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[575986]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[160403]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mee_sp_s[163859]=Pssp;
	Mee_sp_s[571667]=-Pssp;
	Mee_sp_s[575123]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[575987]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[159540]=pow(E,xss[0])*Pssp;
	Mee_sp_s[570804]=-(pow(E,xss[0])*Pssp);
	Mee_sp_s[161269]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[162133]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[162997]=pow(E,yss[2])*pbar*Pssp;
	Mee_sp_s[568213]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[569077]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mee_sp_s[575125]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[575989]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[576853]=pow(E,yss[11])*Pssp;
	Mee_sp_s[160406]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[162134]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[575126]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[575990]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[576854]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mee_sp_s[577718]=Pssp;
	Mee_sp_s[160407]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[162135]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[575127]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[575991]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[576855]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mee_sp_s[578583]=Pssp;
	Mee_sp_s[164728]=ebar*Pssp;
	Mee_sp_s[567352]=pow(E,yss[0] - yss[11])*Pssp;
	Mee_sp_s[569944]=pow(E,yss[3] - yss[11])*Pssp;
	Mee_sp_s[575128]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[575992]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[576856]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mee_sp_s[579448]=Pssp;
	Mee_sp_s[159545]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[160409]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[161273]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[162137]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mee_sp_s[163001]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[163865]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[164729]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[165593]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[575129]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[575993]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[580313]=Pssp;
	Mee_sp_s[161274]=-Pssp;
	Mee_sp_s[162139]=-Pssp;
	Mee_sp_s[163004]=-Pssp;
	Mee_sp_s[165597]=-Pssp;
	Mee_sp_s[164734]=-Pssp;
	Mee_sp_s[163871]=-Pssp;
	Mee_sp_s[28224]=1;
	Mee_sp_s[166464]=-1;
	Mee_sp_s[29089]=1;
	Mee_sp_s[167329]=-1;
	Mee_sp_s[29954]=1;
	Mee_sp_s[168194]=-1;
	Mee_sp_s[30819]=1;
	Mee_sp_s[169059]=-1;
	Mee_sp_s[31684]=1;
	Mee_sp_s[169924]=-1;
	Mee_sp_s[32549]=1;
	Mee_sp_s[170789]=-1;
	Mee_sp_s[33414]=1;
	Mee_sp_s[171654]=-1;
	Mee_sp_s[34279]=1;
	Mee_sp_s[172519]=-1;
	Mee_sp_s[304712]=1;
	Mee_sp_s[581192]=-1;
	Mee_sp_s[305577]=1;
	Mee_sp_s[582057]=-1;
	Mee_sp_s[306442]=1;
	Mee_sp_s[582922]=-1;
	Mee_sp_s[307307]=1;
	Mee_sp_s[583787]=-1;
	Mee_sp_s[308172]=1;
	Mee_sp_s[584652]=-1;
	Mee_sp_s[309037]=1;
	Mee_sp_s[585517]=-1;
	Mee_sp_s[309902]=1;
	Mee_sp_s[586382]=-1;
	Mee_sp_s[310767]=1;
	Mee_sp_s[587247]=-1;
	Mee_sp_s[311632]=1;
	Mee_sp_s[588112]=-1;
	Mee_sp_s[312497]=1;
	Mee_sp_s[588977]=-1;
	Mee_sp_s[313362]=1;
	Mee_sp_s[589842]=-1;
	Mee_sp_s[314227]=1;
	Mee_sp_s[590707]=-1;
	Mee_sp_s[315092]=1;
	Mee_sp_s[591572]=-1;
	Mee_sp_s[315957]=1;
	Mee_sp_s[592437]=-1;
	Mee_sp_s[316822]=1;
	Mee_sp_s[593302]=-1;
	Mee_sp_s[317687]=1;
	Mee_sp_s[594167]=-1;
	Mee_sp_s[69720]=1;
	Mee_sp_s[173400]=-1;
	Mee_sp_s[70585]=1;
	Mee_sp_s[174265]=-1;
	Mee_sp_s[71450]=1;
	Mee_sp_s[175130]=-1;
	Mee_sp_s[72315]=1;
	Mee_sp_s[175995]=-1;
	Mee_sp_s[73180]=1;
	Mee_sp_s[176860]=-1;
	Mee_sp_s[74045]=1;
	Mee_sp_s[177725]=-1;
	Mee_sp_s[74910]=1;
	Mee_sp_s[178590]=-1;
	Mee_sp_s[75775]=1;
	Mee_sp_s[179455]=-1;
	Mee_sp_s[387680]=1;
	Mee_sp_s[595040]=-1;
	Mee_sp_s[388545]=1;
	Mee_sp_s[595905]=-1;
	Mee_sp_s[389410]=1;
	Mee_sp_s[596770]=-1;
	Mee_sp_s[390275]=1;
	Mee_sp_s[597635]=-1;
	Mee_sp_s[391140]=1;
	Mee_sp_s[598500]=-1;
	Mee_sp_s[392005]=1;
	Mee_sp_s[599365]=-1;
	Mee_sp_s[392870]=1;
	Mee_sp_s[600230]=-1;
	Mee_sp_s[393735]=1;
	Mee_sp_s[601095]=-1;
	Mee_sp_s[394600]=1;
	Mee_sp_s[601960]=-1;
	Mee_sp_s[395465]=1;
	Mee_sp_s[602825]=-1;
	Mee_sp_s[396330]=1;
	Mee_sp_s[603690]=-1;
	Mee_sp_s[397195]=1;
	Mee_sp_s[604555]=-1;
	Mee_sp_s[398060]=1;
	Mee_sp_s[605420]=-1;
	Mee_sp_s[398925]=1;
	Mee_sp_s[606285]=-1;
	Mee_sp_s[399790]=1;
	Mee_sp_s[607150]=-1;
	Mee_sp_s[400655]=1;
	Mee_sp_s[608015]=-1;
	Mee_sp_s[111216]=1;
	Mee_sp_s[180336]=-1;
	Mee_sp_s[112081]=1;
	Mee_sp_s[181201]=-1;
	Mee_sp_s[112946]=1;
	Mee_sp_s[182066]=-1;
	Mee_sp_s[113811]=1;
	Mee_sp_s[182931]=-1;
	Mee_sp_s[114676]=1;
	Mee_sp_s[183796]=-1;
	Mee_sp_s[115541]=1;
	Mee_sp_s[184661]=-1;
	Mee_sp_s[116406]=1;
	Mee_sp_s[185526]=-1;
	Mee_sp_s[117271]=1;
	Mee_sp_s[186391]=-1;
	Mee_sp_s[470648]=1;
	Mee_sp_s[608888]=-1;
	Mee_sp_s[471513]=1;
	Mee_sp_s[609753]=-1;
	Mee_sp_s[472378]=1;
	Mee_sp_s[610618]=-1;
	Mee_sp_s[473243]=1;
	Mee_sp_s[611483]=-1;
	Mee_sp_s[474108]=1;
	Mee_sp_s[612348]=-1;
	Mee_sp_s[474973]=1;
	Mee_sp_s[613213]=-1;
	Mee_sp_s[475838]=1;
	Mee_sp_s[614078]=-1;
	Mee_sp_s[476703]=1;
	Mee_sp_s[614943]=-1;
	Mee_sp_s[477568]=1;
	Mee_sp_s[615808]=-1;
	Mee_sp_s[478433]=1;
	Mee_sp_s[616673]=-1;
	Mee_sp_s[479298]=1;
	Mee_sp_s[617538]=-1;
	Mee_sp_s[480163]=1;
	Mee_sp_s[618403]=-1;
	Mee_sp_s[481028]=1;
	Mee_sp_s[619268]=-1;
	Mee_sp_s[481893]=1;
	Mee_sp_s[620133]=-1;
	Mee_sp_s[482758]=1;
	Mee_sp_s[620998]=-1;
	Mee_sp_s[483623]=1;
	Mee_sp_s[621863]=-1;
	Mee_sp_s[152712]=1;
	Mee_sp_s[187272]=-1;
	Mee_sp_s[153577]=1;
	Mee_sp_s[188137]=-1;
	Mee_sp_s[154442]=1;
	Mee_sp_s[189002]=-1;
	Mee_sp_s[155307]=1;
	Mee_sp_s[189867]=-1;
	Mee_sp_s[156172]=1;
	Mee_sp_s[190732]=-1;
	Mee_sp_s[157037]=1;
	Mee_sp_s[191597]=-1;
	Mee_sp_s[157902]=1;
	Mee_sp_s[192462]=-1;
	Mee_sp_s[158767]=1;
	Mee_sp_s[193327]=-1;
	Mee_sp_s[553616]=1;
	Mee_sp_s[622736]=-1;
	Mee_sp_s[554481]=1;
	Mee_sp_s[623601]=-1;
	Mee_sp_s[555346]=1;
	Mee_sp_s[624466]=-1;
	Mee_sp_s[556211]=1;
	Mee_sp_s[625331]=-1;
	Mee_sp_s[557076]=1;
	Mee_sp_s[626196]=-1;
	Mee_sp_s[557941]=1;
	Mee_sp_s[627061]=-1;
	Mee_sp_s[558806]=1;
	Mee_sp_s[627926]=-1;
	Mee_sp_s[559671]=1;
	Mee_sp_s[628791]=-1;
	Mee_sp_s[560536]=1;
	Mee_sp_s[629656]=-1;
	Mee_sp_s[561401]=1;
	Mee_sp_s[630521]=-1;
	Mee_sp_s[562266]=1;
	Mee_sp_s[631386]=-1;
	Mee_sp_s[563131]=1;
	Mee_sp_s[632251]=-1;
	Mee_sp_s[563996]=1;
	Mee_sp_s[633116]=-1;
	Mee_sp_s[564861]=1;
	Mee_sp_s[633981]=-1;
	Mee_sp_s[565726]=1;
	Mee_sp_s[634846]=-1;
	Mee_sp_s[566591]=1;
	Mee_sp_s[635711]=-1;
	Mee_sp_s[200256]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mee_sp_s[636576]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mee_sp_s[637440]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mee_sp_s[643488]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[644352]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[645216]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[195937]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[196801]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[197665]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[637441]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[638305]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[640897]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mee_sp_s[643489]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mee_sp_s[644353]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[645217]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[195938]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[196802]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[637442]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[638306]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[640898]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mee_sp_s[642626]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[643490]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mee_sp_s[644354]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[645218]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[194211]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[195075]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[195939]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[196803]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mee_sp_s[197667]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[198531]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[199395]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[200259]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[640899]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mee_sp_s[643491]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[644355]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mee_sp_s[645219]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mee_sp_s[194212]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mee_sp_s[195076]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mee_sp_s[195940]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mee_sp_s[196804]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mee_sp_s[197668]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mee_sp_s[198532]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mee_sp_s[199396]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mee_sp_s[200260]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mee_sp_s[641764]=-(kkappa*Pssp*yss[9]);
	Mee_sp_s[643492]=pow(E,yss[8])*Pssp;
	Mee_sp_s[644356]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mee_sp_s[645220]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mee_sp_s[194213]=iiota*Pssp*zbar;
	Mee_sp_s[196805]=iiota*Pssp*zbar;
	Mee_sp_s[641765]=-Pssp;
	Mee_sp_s[637446]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mee_sp_s[642630]=-(pow(E,yss[7])*Pssp);
	Mee_sp_s[644358]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[645222]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[195079]=-((Pssp*zbar)/(1 + yss[5]));
	Mee_sp_s[195943]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[196807]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mee_sp_s[197671]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mee_sp_s[199399]=-(pow(E,yss[11])*ebar*Pssp);
	Mee_sp_s[636583]=-(pow(E,yss[0])*Pssp);
	Mee_sp_s[637447]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mee_sp_s[638311]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mee_sp_s[639175]=-(pow(E,yss[3])*Pssp);
	Mee_sp_s[640903]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[642631]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mee_sp_s[644359]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[645223]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[194216]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[196808]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[639176]=pow(E,yss[3])*Pssp;
	Mee_sp_s[644360]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[645224]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[194217]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[195081]=(Pssp*zbar)/(1 + yss[5]);
	Mee_sp_s[196809]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mee_sp_s[197673]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[637449]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[638313]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[640905]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[641769]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[642633]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[644361]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[645225]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[644362]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[645226]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[195083]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mee_sp_s[198539]=Pssp;
	Mee_sp_s[640907]=-Pssp;
	Mee_sp_s[644363]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[645227]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[194220]=pow(E,xss[0])*Pssp;
	Mee_sp_s[640044]=-(pow(E,xss[0])*Pssp);
	Mee_sp_s[195949]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[196813]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[197677]=pow(E,yss[2])*pbar*Pssp;
	Mee_sp_s[637453]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[638317]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mee_sp_s[644365]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[645229]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[646093]=pow(E,yss[11])*Pssp;
	Mee_sp_s[195086]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[196814]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[644366]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[645230]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[646094]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mee_sp_s[646958]=Pssp;
	Mee_sp_s[195087]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[196815]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[644367]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[645231]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[646095]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mee_sp_s[647823]=Pssp;
	Mee_sp_s[199408]=ebar*Pssp;
	Mee_sp_s[636592]=pow(E,yss[0] - yss[11])*Pssp;
	Mee_sp_s[639184]=pow(E,yss[3] - yss[11])*Pssp;
	Mee_sp_s[644368]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[645232]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[646096]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mee_sp_s[648688]=Pssp;
	Mee_sp_s[194225]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[195089]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[195953]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[196817]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mee_sp_s[197681]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[198545]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[199409]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[200273]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[644369]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[645233]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[649553]=Pssp;
	Mee_sp_s[195954]=-Pssp;
	Mee_sp_s[196819]=-Pssp;
	Mee_sp_s[197684]=-Pssp;
	Mee_sp_s[200277]=-Pssp;
	Mee_sp_s[199414]=-Pssp;
	Mee_sp_s[198551]=-Pssp;
	Mee_sp_s[207192]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mee_sp_s[650424]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mee_sp_s[651288]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mee_sp_s[657336]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[658200]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[659064]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[202873]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[203737]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[204601]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[651289]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[652153]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[654745]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mee_sp_s[657337]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mee_sp_s[658201]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[659065]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[202874]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[203738]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[651290]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[652154]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[654746]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mee_sp_s[656474]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[657338]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mee_sp_s[658202]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[659066]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[201147]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[202011]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[202875]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[203739]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mee_sp_s[204603]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[205467]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[206331]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[207195]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[654747]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mee_sp_s[657339]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[658203]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mee_sp_s[659067]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mee_sp_s[201148]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mee_sp_s[202012]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mee_sp_s[202876]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mee_sp_s[203740]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mee_sp_s[204604]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mee_sp_s[205468]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mee_sp_s[206332]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mee_sp_s[207196]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mee_sp_s[655612]=-(kkappa*Pssp*yss[9]);
	Mee_sp_s[657340]=pow(E,yss[8])*Pssp;
	Mee_sp_s[658204]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mee_sp_s[659068]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mee_sp_s[201149]=iiota*Pssp*zbar;
	Mee_sp_s[203741]=iiota*Pssp*zbar;
	Mee_sp_s[655613]=-Pssp;
	Mee_sp_s[651294]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mee_sp_s[656478]=-(pow(E,yss[7])*Pssp);
	Mee_sp_s[658206]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[659070]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[202015]=-((Pssp*zbar)/(1 + yss[5]));
	Mee_sp_s[202879]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[203743]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mee_sp_s[204607]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mee_sp_s[206335]=-(pow(E,yss[11])*ebar*Pssp);
	Mee_sp_s[650431]=-(pow(E,yss[0])*Pssp);
	Mee_sp_s[651295]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mee_sp_s[652159]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mee_sp_s[653023]=-(pow(E,yss[3])*Pssp);
	Mee_sp_s[654751]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[656479]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mee_sp_s[658207]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[659071]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[201152]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[203744]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[653024]=pow(E,yss[3])*Pssp;
	Mee_sp_s[658208]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[659072]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[201153]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[202017]=(Pssp*zbar)/(1 + yss[5]);
	Mee_sp_s[203745]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mee_sp_s[204609]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[651297]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[652161]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[654753]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[655617]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[656481]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[658209]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[659073]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[658210]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[659074]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[202019]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mee_sp_s[205475]=Pssp;
	Mee_sp_s[654755]=-Pssp;
	Mee_sp_s[658211]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[659075]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[201156]=pow(E,xss[0])*Pssp;
	Mee_sp_s[653892]=-(pow(E,xss[0])*Pssp);
	Mee_sp_s[202885]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[203749]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[204613]=pow(E,yss[2])*pbar*Pssp;
	Mee_sp_s[651301]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[652165]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mee_sp_s[658213]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[659077]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[659941]=pow(E,yss[11])*Pssp;
	Mee_sp_s[202022]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[203750]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[658214]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[659078]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[659942]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mee_sp_s[660806]=Pssp;
	Mee_sp_s[202023]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[203751]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[658215]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[659079]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[659943]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mee_sp_s[661671]=Pssp;
	Mee_sp_s[206344]=ebar*Pssp;
	Mee_sp_s[650440]=pow(E,yss[0] - yss[11])*Pssp;
	Mee_sp_s[653032]=pow(E,yss[3] - yss[11])*Pssp;
	Mee_sp_s[658216]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[659080]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[659944]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mee_sp_s[662536]=Pssp;
	Mee_sp_s[201161]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[202025]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[202889]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[203753]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mee_sp_s[204617]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[205481]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[206345]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[207209]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[658217]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[659081]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[663401]=Pssp;
	Mee_sp_s[202890]=-Pssp;
	Mee_sp_s[203755]=-Pssp;
	Mee_sp_s[204620]=-Pssp;
	Mee_sp_s[207213]=-Pssp;
	Mee_sp_s[206350]=-Pssp;
	Mee_sp_s[205487]=-Pssp;
	Mee_sp_s[35280]=1;
	Mee_sp_s[208080]=-1;
	Mee_sp_s[36145]=1;
	Mee_sp_s[208945]=-1;
	Mee_sp_s[37010]=1;
	Mee_sp_s[209810]=-1;
	Mee_sp_s[37875]=1;
	Mee_sp_s[210675]=-1;
	Mee_sp_s[38740]=1;
	Mee_sp_s[211540]=-1;
	Mee_sp_s[39605]=1;
	Mee_sp_s[212405]=-1;
	Mee_sp_s[40470]=1;
	Mee_sp_s[213270]=-1;
	Mee_sp_s[41335]=1;
	Mee_sp_s[214135]=-1;
	Mee_sp_s[318680]=1;
	Mee_sp_s[664280]=-1;
	Mee_sp_s[319545]=1;
	Mee_sp_s[665145]=-1;
	Mee_sp_s[320410]=1;
	Mee_sp_s[666010]=-1;
	Mee_sp_s[321275]=1;
	Mee_sp_s[666875]=-1;
	Mee_sp_s[322140]=1;
	Mee_sp_s[667740]=-1;
	Mee_sp_s[323005]=1;
	Mee_sp_s[668605]=-1;
	Mee_sp_s[323870]=1;
	Mee_sp_s[669470]=-1;
	Mee_sp_s[324735]=1;
	Mee_sp_s[670335]=-1;
	Mee_sp_s[325600]=1;
	Mee_sp_s[671200]=-1;
	Mee_sp_s[326465]=1;
	Mee_sp_s[672065]=-1;
	Mee_sp_s[327330]=1;
	Mee_sp_s[672930]=-1;
	Mee_sp_s[328195]=1;
	Mee_sp_s[673795]=-1;
	Mee_sp_s[329060]=1;
	Mee_sp_s[674660]=-1;
	Mee_sp_s[329925]=1;
	Mee_sp_s[675525]=-1;
	Mee_sp_s[330790]=1;
	Mee_sp_s[676390]=-1;
	Mee_sp_s[331655]=1;
	Mee_sp_s[677255]=-1;
	Mee_sp_s[76776]=1;
	Mee_sp_s[215016]=-1;
	Mee_sp_s[77641]=1;
	Mee_sp_s[215881]=-1;
	Mee_sp_s[78506]=1;
	Mee_sp_s[216746]=-1;
	Mee_sp_s[79371]=1;
	Mee_sp_s[217611]=-1;
	Mee_sp_s[80236]=1;
	Mee_sp_s[218476]=-1;
	Mee_sp_s[81101]=1;
	Mee_sp_s[219341]=-1;
	Mee_sp_s[81966]=1;
	Mee_sp_s[220206]=-1;
	Mee_sp_s[82831]=1;
	Mee_sp_s[221071]=-1;
	Mee_sp_s[401648]=1;
	Mee_sp_s[678128]=-1;
	Mee_sp_s[402513]=1;
	Mee_sp_s[678993]=-1;
	Mee_sp_s[403378]=1;
	Mee_sp_s[679858]=-1;
	Mee_sp_s[404243]=1;
	Mee_sp_s[680723]=-1;
	Mee_sp_s[405108]=1;
	Mee_sp_s[681588]=-1;
	Mee_sp_s[405973]=1;
	Mee_sp_s[682453]=-1;
	Mee_sp_s[406838]=1;
	Mee_sp_s[683318]=-1;
	Mee_sp_s[407703]=1;
	Mee_sp_s[684183]=-1;
	Mee_sp_s[408568]=1;
	Mee_sp_s[685048]=-1;
	Mee_sp_s[409433]=1;
	Mee_sp_s[685913]=-1;
	Mee_sp_s[410298]=1;
	Mee_sp_s[686778]=-1;
	Mee_sp_s[411163]=1;
	Mee_sp_s[687643]=-1;
	Mee_sp_s[412028]=1;
	Mee_sp_s[688508]=-1;
	Mee_sp_s[412893]=1;
	Mee_sp_s[689373]=-1;
	Mee_sp_s[413758]=1;
	Mee_sp_s[690238]=-1;
	Mee_sp_s[414623]=1;
	Mee_sp_s[691103]=-1;
	Mee_sp_s[118272]=1;
	Mee_sp_s[221952]=-1;
	Mee_sp_s[119137]=1;
	Mee_sp_s[222817]=-1;
	Mee_sp_s[120002]=1;
	Mee_sp_s[223682]=-1;
	Mee_sp_s[120867]=1;
	Mee_sp_s[224547]=-1;
	Mee_sp_s[121732]=1;
	Mee_sp_s[225412]=-1;
	Mee_sp_s[122597]=1;
	Mee_sp_s[226277]=-1;
	Mee_sp_s[123462]=1;
	Mee_sp_s[227142]=-1;
	Mee_sp_s[124327]=1;
	Mee_sp_s[228007]=-1;
	Mee_sp_s[484616]=1;
	Mee_sp_s[691976]=-1;
	Mee_sp_s[485481]=1;
	Mee_sp_s[692841]=-1;
	Mee_sp_s[486346]=1;
	Mee_sp_s[693706]=-1;
	Mee_sp_s[487211]=1;
	Mee_sp_s[694571]=-1;
	Mee_sp_s[488076]=1;
	Mee_sp_s[695436]=-1;
	Mee_sp_s[488941]=1;
	Mee_sp_s[696301]=-1;
	Mee_sp_s[489806]=1;
	Mee_sp_s[697166]=-1;
	Mee_sp_s[490671]=1;
	Mee_sp_s[698031]=-1;
	Mee_sp_s[491536]=1;
	Mee_sp_s[698896]=-1;
	Mee_sp_s[492401]=1;
	Mee_sp_s[699761]=-1;
	Mee_sp_s[493266]=1;
	Mee_sp_s[700626]=-1;
	Mee_sp_s[494131]=1;
	Mee_sp_s[701491]=-1;
	Mee_sp_s[494996]=1;
	Mee_sp_s[702356]=-1;
	Mee_sp_s[495861]=1;
	Mee_sp_s[703221]=-1;
	Mee_sp_s[496726]=1;
	Mee_sp_s[704086]=-1;
	Mee_sp_s[497591]=1;
	Mee_sp_s[704951]=-1;
	Mee_sp_s[159768]=1;
	Mee_sp_s[228888]=-1;
	Mee_sp_s[160633]=1;
	Mee_sp_s[229753]=-1;
	Mee_sp_s[161498]=1;
	Mee_sp_s[230618]=-1;
	Mee_sp_s[162363]=1;
	Mee_sp_s[231483]=-1;
	Mee_sp_s[163228]=1;
	Mee_sp_s[232348]=-1;
	Mee_sp_s[164093]=1;
	Mee_sp_s[233213]=-1;
	Mee_sp_s[164958]=1;
	Mee_sp_s[234078]=-1;
	Mee_sp_s[165823]=1;
	Mee_sp_s[234943]=-1;
	Mee_sp_s[567584]=1;
	Mee_sp_s[705824]=-1;
	Mee_sp_s[568449]=1;
	Mee_sp_s[706689]=-1;
	Mee_sp_s[569314]=1;
	Mee_sp_s[707554]=-1;
	Mee_sp_s[570179]=1;
	Mee_sp_s[708419]=-1;
	Mee_sp_s[571044]=1;
	Mee_sp_s[709284]=-1;
	Mee_sp_s[571909]=1;
	Mee_sp_s[710149]=-1;
	Mee_sp_s[572774]=1;
	Mee_sp_s[711014]=-1;
	Mee_sp_s[573639]=1;
	Mee_sp_s[711879]=-1;
	Mee_sp_s[574504]=1;
	Mee_sp_s[712744]=-1;
	Mee_sp_s[575369]=1;
	Mee_sp_s[713609]=-1;
	Mee_sp_s[576234]=1;
	Mee_sp_s[714474]=-1;
	Mee_sp_s[577099]=1;
	Mee_sp_s[715339]=-1;
	Mee_sp_s[577964]=1;
	Mee_sp_s[716204]=-1;
	Mee_sp_s[578829]=1;
	Mee_sp_s[717069]=-1;
	Mee_sp_s[579694]=1;
	Mee_sp_s[717934]=-1;
	Mee_sp_s[580559]=1;
	Mee_sp_s[718799]=-1;
	Mee_sp_s[201264]=1;
	Mee_sp_s[235824]=-1;
	Mee_sp_s[202129]=1;
	Mee_sp_s[236689]=-1;
	Mee_sp_s[202994]=1;
	Mee_sp_s[237554]=-1;
	Mee_sp_s[203859]=1;
	Mee_sp_s[238419]=-1;
	Mee_sp_s[204724]=1;
	Mee_sp_s[239284]=-1;
	Mee_sp_s[205589]=1;
	Mee_sp_s[240149]=-1;
	Mee_sp_s[206454]=1;
	Mee_sp_s[241014]=-1;
	Mee_sp_s[207319]=1;
	Mee_sp_s[241879]=-1;
	Mee_sp_s[650552]=1;
	Mee_sp_s[719672]=-1;
	Mee_sp_s[651417]=1;
	Mee_sp_s[720537]=-1;
	Mee_sp_s[652282]=1;
	Mee_sp_s[721402]=-1;
	Mee_sp_s[653147]=1;
	Mee_sp_s[722267]=-1;
	Mee_sp_s[654012]=1;
	Mee_sp_s[723132]=-1;
	Mee_sp_s[654877]=1;
	Mee_sp_s[723997]=-1;
	Mee_sp_s[655742]=1;
	Mee_sp_s[724862]=-1;
	Mee_sp_s[656607]=1;
	Mee_sp_s[725727]=-1;
	Mee_sp_s[657472]=1;
	Mee_sp_s[726592]=-1;
	Mee_sp_s[658337]=1;
	Mee_sp_s[727457]=-1;
	Mee_sp_s[659202]=1;
	Mee_sp_s[728322]=-1;
	Mee_sp_s[660067]=1;
	Mee_sp_s[729187]=-1;
	Mee_sp_s[660932]=1;
	Mee_sp_s[730052]=-1;
	Mee_sp_s[661797]=1;
	Mee_sp_s[730917]=-1;
	Mee_sp_s[662662]=1;
	Mee_sp_s[731782]=-1;
	Mee_sp_s[663527]=1;
	Mee_sp_s[732647]=-1;
	Mee_sp_s[248808]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mee_sp_s[733512]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mee_sp_s[734376]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mee_sp_s[740424]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[741288]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[742152]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mee_sp_s[244489]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[245353]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[246217]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[734377]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[735241]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[737833]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mee_sp_s[740425]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mee_sp_s[741289]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[742153]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[244490]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[245354]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[734378]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[735242]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[737834]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mee_sp_s[739562]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[740426]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mee_sp_s[741290]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[742154]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mee_sp_s[242763]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[243627]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[244491]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[245355]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mee_sp_s[246219]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[247083]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[247947]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[248811]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mee_sp_s[737835]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mee_sp_s[740427]=-(pow(E,yss[8])*Pssp);
	Mee_sp_s[741291]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mee_sp_s[742155]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mee_sp_s[242764]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mee_sp_s[243628]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mee_sp_s[244492]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mee_sp_s[245356]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mee_sp_s[246220]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mee_sp_s[247084]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mee_sp_s[247948]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mee_sp_s[248812]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mee_sp_s[738700]=-(kkappa*Pssp*yss[9]);
	Mee_sp_s[740428]=pow(E,yss[8])*Pssp;
	Mee_sp_s[741292]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mee_sp_s[742156]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mee_sp_s[242765]=iiota*Pssp*zbar;
	Mee_sp_s[245357]=iiota*Pssp*zbar;
	Mee_sp_s[738701]=-Pssp;
	Mee_sp_s[734382]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mee_sp_s[739566]=-(pow(E,yss[7])*Pssp);
	Mee_sp_s[741294]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[742158]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mee_sp_s[243631]=-((Pssp*zbar)/(1 + yss[5]));
	Mee_sp_s[244495]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mee_sp_s[245359]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mee_sp_s[246223]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mee_sp_s[247951]=-(pow(E,yss[11])*ebar*Pssp);
	Mee_sp_s[733519]=-(pow(E,yss[0])*Pssp);
	Mee_sp_s[734383]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mee_sp_s[735247]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mee_sp_s[736111]=-(pow(E,yss[3])*Pssp);
	Mee_sp_s[737839]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[739567]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mee_sp_s[741295]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[742159]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mee_sp_s[242768]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[245360]=-(pow(E,xss[0])*Pssp*zbar);
	Mee_sp_s[736112]=pow(E,yss[3])*Pssp;
	Mee_sp_s[741296]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[742160]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mee_sp_s[242769]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[243633]=(Pssp*zbar)/(1 + yss[5]);
	Mee_sp_s[245361]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mee_sp_s[246225]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[734385]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[735249]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[737841]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mee_sp_s[738705]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mee_sp_s[739569]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mee_sp_s[741297]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[742161]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mee_sp_s[741298]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[742162]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mee_sp_s[243635]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mee_sp_s[247091]=Pssp;
	Mee_sp_s[737843]=-Pssp;
	Mee_sp_s[741299]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[742163]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mee_sp_s[242772]=pow(E,xss[0])*Pssp;
	Mee_sp_s[736980]=-(pow(E,xss[0])*Pssp);
	Mee_sp_s[244501]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[245365]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[246229]=pow(E,yss[2])*pbar*Pssp;
	Mee_sp_s[734389]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mee_sp_s[735253]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mee_sp_s[741301]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[742165]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mee_sp_s[743029]=pow(E,yss[11])*Pssp;
	Mee_sp_s[243638]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[245366]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[741302]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[742166]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mee_sp_s[743030]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mee_sp_s[743894]=Pssp;
	Mee_sp_s[243639]=-((Pssp*zbar)/pow(E,yss[11]));
	Mee_sp_s[245367]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mee_sp_s[741303]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[742167]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mee_sp_s[743031]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mee_sp_s[744759]=Pssp;
	Mee_sp_s[247960]=ebar*Pssp;
	Mee_sp_s[733528]=pow(E,yss[0] - yss[11])*Pssp;
	Mee_sp_s[736120]=pow(E,yss[3] - yss[11])*Pssp;
	Mee_sp_s[741304]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[742168]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mee_sp_s[743032]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mee_sp_s[745624]=Pssp;
	Mee_sp_s[242777]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[243641]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[244505]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[245369]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mee_sp_s[246233]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[247097]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[247961]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[248825]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mee_sp_s[741305]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[742169]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mee_sp_s[746489]=Pssp;
	Mee_sp_s[244506]=-Pssp;
	Mee_sp_s[245371]=-Pssp;
	Mee_sp_s[246236]=-Pssp;
	Mee_sp_s[248829]=-Pssp;
	Mee_sp_s[247966]=-Pssp;
	Mee_sp_s[247103]=-Pssp;
	Nee_sp_s[0]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*pow(Gs[128],2)) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*pow(Gs[129],2) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*pow(pow(E,yss[0])*Gs[128] - pow(pow(E,yss[1]),oomega)*Gs[129],2) - pow(E,yss[8])*Pssp*pow(Gs[136],2) - 2*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[128] - pow(pow(E,yss[1]),oomega)*Gs[129])*Hs[71] + (Pssp*pow(Hs[71],2))/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + 2*(dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[128] - pow(pow(E,yss[1]),oomega)*Gs[129])) - pow(E,yss[8])*Gs[136] + Hs[71]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nee_sp_s[1]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*pow(Gs[129],2)) + 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[130] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*pow(Gs[130],2) - (2*pbar*pphi*Pssp*Gs[133]*Gs[137])/pow(E,yss[8]) - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[66] + 2*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[66] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[66],2) - 2*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[67] + 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[67] - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[67] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[67],2) + (2*pbar*pphi*Pssp*Gs[136]*Gs[137]*(1 + yss[5]))/pow(E,yss[8]) + (2*pbar*pphi*Pssp*Gs[133]*Gs[136]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*pow(Gs[136],2)*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*pow(Hs[68],2)*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (2*pbar*pphi*Pssp*Hs[68]*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9])))/pow(E,yss[8]) + 2*(dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[129]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[130] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[66] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[67] - pbar*Hs[68]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9])))/pow(E,yss[8]));
	Nee_sp_s[2]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*pow(Gs[129],2)) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Gs[129],2) - 2*(-1 + aalpha)*aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[130] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*pow(Gs[130],2) - 2*pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[133]*Gs[137] + 2*(-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[66] - 2*aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[66],2) + 2*(-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[67] - 2*pow(aalpha,2)*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[67] + 2*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[67] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[67],2) + 2*pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[136]*Gs[137]*(1 + yss[5]) + 2*pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[133]*Gs[136]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*pow(Gs[136],2)*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*pow(Gs[135],2)*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - 2*pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[135]*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9])) + 2*(dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[129]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[129] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[130] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[66] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[67] - pow(E,yss[7])*pphi*Gs[135]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9])));
	Nee_sp_s[3]=-(pow(E,yss[8])*Pssp*pow(Gs[136],2)) - (2*bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[133]*Hs[67])/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gs[133]*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(Hs[67],2)*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[64]*(G2sp[8]*Hs[64] + G2sp[24]*Hs[65] + G2sp[40]*Hs[66] + G2sp[56]*Hs[67] + G2sp[72]*Hs[68] + G2sp[88]*Hs[69] + G2sp[104]*Hs[70] + G2sp[120]*Hs[71])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[65]*(G2sp[24]*Hs[64] + G2sp[264]*Hs[65] + G2sp[280]*Hs[66] + G2sp[296]*Hs[67] + G2sp[312]*Hs[68] + G2sp[328]*Hs[69] + G2sp[344]*Hs[70] + G2sp[360]*Hs[71])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[66]*(G2sp[40]*Hs[64] + G2sp[280]*Hs[65] + G2sp[520]*Hs[66] + G2sp[536]*Hs[67] + G2sp[552]*Hs[68] + G2sp[568]*Hs[69] + G2sp[584]*Hs[70] + G2sp[600]*Hs[71])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[67]*(G2sp[56]*Hs[64] + G2sp[296]*Hs[65] + G2sp[536]*Hs[66] + G2sp[776]*Hs[67] + G2sp[792]*Hs[68] + G2sp[808]*Hs[69] + G2sp[824]*Hs[70] + G2sp[840]*Hs[71])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[68]*(G2sp[72]*Hs[64] + G2sp[312]*Hs[65] + G2sp[552]*Hs[66] + G2sp[792]*Hs[67] + G2sp[1032]*Hs[68] + G2sp[1048]*Hs[69] + G2sp[1064]*Hs[70] + G2sp[1080]*Hs[71])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[69]*(G2sp[88]*Hs[64] + G2sp[328]*Hs[65] + G2sp[568]*Hs[66] + G2sp[808]*Hs[67] + G2sp[1048]*Hs[68] + G2sp[1288]*Hs[69] + G2sp[1304]*Hs[70] + G2sp[1320]*Hs[71])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[70]*(G2sp[104]*Hs[64] + G2sp[344]*Hs[65] + G2sp[584]*Hs[66] + G2sp[824]*Hs[67] + G2sp[1064]*Hs[68] + G2sp[1304]*Hs[69] + G2sp[1544]*Hs[70] + G2sp[1560]*Hs[71])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[71]*(G2sp[120]*Hs[64] + G2sp[360]*Hs[65] + G2sp[600]*Hs[66] + G2sp[840]*Hs[67] + G2sp[1080]*Hs[68] + G2sp[1320]*Hs[69] + G2sp[1560]*Hs[70] + G2sp[1800]*Hs[71])*(1 + yss[5]))/pow(zbar,rrho) - (2*bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[67]*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71],2)*(1 + yss[5]))/pow(zbar,rrho) + 2*(dP2ssp*Gs[137] + dP1ssp*Gs[138])*((bbeta*pow(E,yss[8])*Gs[133])/pow(zbar,rrho) - pow(E,yss[8])*Gs[136] + Gs[137] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[67]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(1 + yss[5]))/pow(zbar,rrho));
	Nee_sp_s[4]=pow(E,yss[8])*Pssp*pow(Gs[136],2) - 2*kkappa*Pssp*Gs[134]*Gs[137] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Hs[64],2) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[64],2) - 2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[64]*Hs[66] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*pow(Hs[66],2) - 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[64]*Hs[67] - 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[66]*Hs[67] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*pow(Hs[67],2) - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*pow(Hs[67],2))/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[136]*(Hs[64] + Hs[67]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[64] + Hs[67])*(Gs[136] + Hs[64] + Hs[67]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*(G2sp[1]*Hs[64] + G2sp[17]*Hs[65] + G2sp[33]*Hs[66] + G2sp[49]*Hs[67] + G2sp[65]*Hs[68] + G2sp[81]*Hs[69] + G2sp[97]*Hs[70] + G2sp[113]*Hs[71]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*(G2sp[2]*Hs[64] + G2sp[18]*Hs[65] + G2sp[34]*Hs[66] + G2sp[50]*Hs[67] + G2sp[66]*Hs[68] + G2sp[82]*Hs[69] + G2sp[98]*Hs[70] + G2sp[114]*Hs[71]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[64]*(G2sp[4]*Hs[64] + G2sp[20]*Hs[65] + G2sp[36]*Hs[66] + G2sp[52]*Hs[67] + G2sp[68]*Hs[68] + G2sp[84]*Hs[69] + G2sp[100]*Hs[70] + G2sp[116]*Hs[71]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[64]*(G2sp[8]*Hs[64] + G2sp[24]*Hs[65] + G2sp[40]*Hs[66] + G2sp[56]*Hs[67] + G2sp[72]*Hs[68] + G2sp[88]*Hs[69] + G2sp[104]*Hs[70] + G2sp[120]*Hs[71]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[65]*(G2sp[17]*Hs[64] + G2sp[257]*Hs[65] + G2sp[273]*Hs[66] + G2sp[289]*Hs[67] + G2sp[305]*Hs[68] + G2sp[321]*Hs[69] + G2sp[337]*Hs[70] + G2sp[353]*Hs[71]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[65]*(G2sp[18]*Hs[64] + G2sp[258]*Hs[65] + G2sp[274]*Hs[66] + G2sp[290]*Hs[67] + G2sp[306]*Hs[68] + G2sp[322]*Hs[69] + G2sp[338]*Hs[70] + G2sp[354]*Hs[71]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[65]*(G2sp[20]*Hs[64] + G2sp[260]*Hs[65] + G2sp[276]*Hs[66] + G2sp[292]*Hs[67] + G2sp[308]*Hs[68] + G2sp[324]*Hs[69] + G2sp[340]*Hs[70] + G2sp[356]*Hs[71]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[65]*(G2sp[24]*Hs[64] + G2sp[264]*Hs[65] + G2sp[280]*Hs[66] + G2sp[296]*Hs[67] + G2sp[312]*Hs[68] + G2sp[328]*Hs[69] + G2sp[344]*Hs[70] + G2sp[360]*Hs[71]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[66]*(G2sp[33]*Hs[64] + G2sp[273]*Hs[65] + G2sp[513]*Hs[66] + G2sp[529]*Hs[67] + G2sp[545]*Hs[68] + G2sp[561]*Hs[69] + G2sp[577]*Hs[70] + G2sp[593]*Hs[71]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[66]*(G2sp[34]*Hs[64] + G2sp[274]*Hs[65] + G2sp[514]*Hs[66] + G2sp[530]*Hs[67] + G2sp[546]*Hs[68] + G2sp[562]*Hs[69] + G2sp[578]*Hs[70] + G2sp[594]*Hs[71]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[66]*(G2sp[36]*Hs[64] + G2sp[276]*Hs[65] + G2sp[516]*Hs[66] + G2sp[532]*Hs[67] + G2sp[548]*Hs[68] + G2sp[564]*Hs[69] + G2sp[580]*Hs[70] + G2sp[596]*Hs[71]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[66]*(G2sp[40]*Hs[64] + G2sp[280]*Hs[65] + G2sp[520]*Hs[66] + G2sp[536]*Hs[67] + G2sp[552]*Hs[68] + G2sp[568]*Hs[69] + G2sp[584]*Hs[70] + G2sp[600]*Hs[71]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[67]*(G2sp[49]*Hs[64] + G2sp[289]*Hs[65] + G2sp[529]*Hs[66] + G2sp[769]*Hs[67] + G2sp[785]*Hs[68] + G2sp[801]*Hs[69] + G2sp[817]*Hs[70] + G2sp[833]*Hs[71]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[67]*(G2sp[50]*Hs[64] + G2sp[290]*Hs[65] + G2sp[530]*Hs[66] + G2sp[770]*Hs[67] + G2sp[786]*Hs[68] + G2sp[802]*Hs[69] + G2sp[818]*Hs[70] + G2sp[834]*Hs[71]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[67]*(G2sp[52]*Hs[64] + G2sp[292]*Hs[65] + G2sp[532]*Hs[66] + G2sp[772]*Hs[67] + G2sp[788]*Hs[68] + G2sp[804]*Hs[69] + G2sp[820]*Hs[70] + G2sp[836]*Hs[71]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[67]*(G2sp[56]*Hs[64] + G2sp[296]*Hs[65] + G2sp[536]*Hs[66] + G2sp[776]*Hs[67] + G2sp[792]*Hs[68] + G2sp[808]*Hs[69] + G2sp[824]*Hs[70] + G2sp[840]*Hs[71]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[68]*(G2sp[65]*Hs[64] + G2sp[305]*Hs[65] + G2sp[545]*Hs[66] + G2sp[785]*Hs[67] + G2sp[1025]*Hs[68] + G2sp[1041]*Hs[69] + G2sp[1057]*Hs[70] + G2sp[1073]*Hs[71]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[68]*(G2sp[66]*Hs[64] + G2sp[306]*Hs[65] + G2sp[546]*Hs[66] + G2sp[786]*Hs[67] + G2sp[1026]*Hs[68] + G2sp[1042]*Hs[69] + G2sp[1058]*Hs[70] + G2sp[1074]*Hs[71]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[68]*(G2sp[68]*Hs[64] + G2sp[308]*Hs[65] + G2sp[548]*Hs[66] + G2sp[788]*Hs[67] + G2sp[1028]*Hs[68] + G2sp[1044]*Hs[69] + G2sp[1060]*Hs[70] + G2sp[1076]*Hs[71]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[68]*(G2sp[72]*Hs[64] + G2sp[312]*Hs[65] + G2sp[552]*Hs[66] + G2sp[792]*Hs[67] + G2sp[1032]*Hs[68] + G2sp[1048]*Hs[69] + G2sp[1064]*Hs[70] + G2sp[1080]*Hs[71]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[69]*(G2sp[81]*Hs[64] + G2sp[321]*Hs[65] + G2sp[561]*Hs[66] + G2sp[801]*Hs[67] + G2sp[1041]*Hs[68] + G2sp[1281]*Hs[69] + G2sp[1297]*Hs[70] + G2sp[1313]*Hs[71]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[69]*(G2sp[82]*Hs[64] + G2sp[322]*Hs[65] + G2sp[562]*Hs[66] + G2sp[802]*Hs[67] + G2sp[1042]*Hs[68] + G2sp[1282]*Hs[69] + G2sp[1298]*Hs[70] + G2sp[1314]*Hs[71]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[69]*(G2sp[84]*Hs[64] + G2sp[324]*Hs[65] + G2sp[564]*Hs[66] + G2sp[804]*Hs[67] + G2sp[1044]*Hs[68] + G2sp[1284]*Hs[69] + G2sp[1300]*Hs[70] + G2sp[1316]*Hs[71]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[69]*(G2sp[88]*Hs[64] + G2sp[328]*Hs[65] + G2sp[568]*Hs[66] + G2sp[808]*Hs[67] + G2sp[1048]*Hs[68] + G2sp[1288]*Hs[69] + G2sp[1304]*Hs[70] + G2sp[1320]*Hs[71]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[70]*(G2sp[97]*Hs[64] + G2sp[337]*Hs[65] + G2sp[577]*Hs[66] + G2sp[817]*Hs[67] + G2sp[1057]*Hs[68] + G2sp[1297]*Hs[69] + G2sp[1537]*Hs[70] + G2sp[1553]*Hs[71]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[70]*(G2sp[98]*Hs[64] + G2sp[338]*Hs[65] + G2sp[578]*Hs[66] + G2sp[818]*Hs[67] + G2sp[1058]*Hs[68] + G2sp[1298]*Hs[69] + G2sp[1538]*Hs[70] + G2sp[1554]*Hs[71]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[70]*(G2sp[100]*Hs[64] + G2sp[340]*Hs[65] + G2sp[580]*Hs[66] + G2sp[820]*Hs[67] + G2sp[1060]*Hs[68] + G2sp[1300]*Hs[69] + G2sp[1540]*Hs[70] + G2sp[1556]*Hs[71]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[70]*(G2sp[104]*Hs[64] + G2sp[344]*Hs[65] + G2sp[584]*Hs[66] + G2sp[824]*Hs[67] + G2sp[1064]*Hs[68] + G2sp[1304]*Hs[69] + G2sp[1544]*Hs[70] + G2sp[1560]*Hs[71]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[71]*(G2sp[113]*Hs[64] + G2sp[353]*Hs[65] + G2sp[593]*Hs[66] + G2sp[833]*Hs[67] + G2sp[1073]*Hs[68] + G2sp[1313]*Hs[69] + G2sp[1553]*Hs[70] + G2sp[1793]*Hs[71]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[71]*(G2sp[114]*Hs[64] + G2sp[354]*Hs[65] + G2sp[594]*Hs[66] + G2sp[834]*Hs[67] + G2sp[1074]*Hs[68] + G2sp[1314]*Hs[69] + G2sp[1554]*Hs[70] + G2sp[1794]*Hs[71]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[71]*(G2sp[116]*Hs[64] + G2sp[356]*Hs[65] + G2sp[596]*Hs[66] + G2sp[836]*Hs[67] + G2sp[1076]*Hs[68] + G2sp[1316]*Hs[69] + G2sp[1556]*Hs[70] + G2sp[1796]*Hs[71]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[71]*(G2sp[120]*Hs[64] + G2sp[360]*Hs[65] + G2sp[600]*Hs[66] + G2sp[840]*Hs[67] + G2sp[1080]*Hs[68] + G2sp[1320]*Hs[69] + G2sp[1560]*Hs[70] + G2sp[1800]*Hs[71]))/pow(zbar,rrho) - 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[66]*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - 2*pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[67]*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71],2) + 2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + 2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[66]*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[67]*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*pow(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71],2) + 2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[64]*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71],2) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Gsp[4]*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71],2) + (2*bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[67]*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*pow(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71],2))/pow(zbar,rrho) + (2*bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[67]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[64] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])))/pow(zbar,rrho) - (2*bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[64] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])))/pow(zbar,rrho) - kkappa*Pssp*pow(Gs[134],2)*yss[9] + 2*(dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(E,yss[8])*Gs[136] - kkappa*Gs[137] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[67])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[64] + Hs[67]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[64] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])))/pow(zbar,rrho) - kkappa*Gs[134]*yss[9]);
	Nee_sp_s[5]=-(Pssp*pow(Gs[134],2)) + iiota*Pssp*zbar*pow(Hs[64] + Hs[67],2) + 2*(dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-Gs[134] + iiota*zbar*(Hs[64] + Hs[67]));
	Nee_sp_s[6]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*pow(Gs[129],2) - pow(E,yss[7])*Pssp*pow(Gs[135],2) + 2*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[129] - pow(E,yss[7])*Gs[135])*(dP2ssp*Gs[137] + dP1ssp*Gs[138]);
	Nee_sp_s[7]=-(pow(E,yss[0])*Pssp*pow(Gs[128],2)) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Gs[129],2) - 2*aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[130] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*pow(Gs[130],2) - pow(E,yss[3])*Pssp*pow(Gs[131],2) + 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[66] - 2*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[66] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[66],2) + 2*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[67] - 2*aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[67] + 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[67] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[67],2) - pow(E,yss[2])*pbar*Pssp*pow(Gs[130] + Hs[68],2) - 2*pphi*Pssp*Gs[133]*(pow(E,yss[1] + yss[7])*(Gs[129] + Gs[135]) + pow(E,yss[2])*pbar*(Gs[130] + Hs[68])) - pow(E,yss[11])*ebar*Pssp*pow(Hs[70],2) - pow(E,yss[1] + yss[7])*pphi*Pssp*pow(Gs[129] + Gs[135],2)*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*pow(Gs[130] + Hs[68],2)*yss[5] - (2*Pssp*zbar*pow(Gs[133],2)*xss[1])/pow(1 + yss[5],3) + (2*Pssp*zbar*Gs[133]*Hs[65])/pow(1 + yss[5],2) + (2*Pssp*zbar*Gs[133]*Hs[67]*xss[1])/pow(1 + yss[5],2) - (2*Pssp*zbar*Hs[65]*Hs[67])/(1 + yss[5]) - (Pssp*zbar*pow(Hs[67],2)*xss[1])/(1 + yss[5]) + 2*(dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(pow(E,yss[0])*Gs[128]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[129] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[130] - pow(E,yss[3])*Gs[131] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[133] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[67] - pow(E,yss[2])*pbar*(Gs[130] + Hs[68]) - pow(E,yss[11])*ebar*Hs[70] - pphi*(pow(E,yss[1] + yss[7])*(Gs[129] + Gs[135]) + pow(E,yss[2])*pbar*(Gs[130] + Hs[68]))*yss[5] + (zbar*Gs[133]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[65])/(1 + yss[5]) - (zbar*Hs[67]*xss[1])/(1 + yss[5]));
	Nee_sp_s[8]=pow(E,yss[3])*Pssp*pow(Gs[131],2) - pow(E,xss[0])*Pssp*zbar*pow(Hs[64] + Hs[67],2) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*pow(Hs[64] + Hs[67],2) + 2*(dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(E,yss[3])*Gs[131] - pow(E,xss[0])*zbar*(Hs[64] + Hs[67]));
	Nee_sp_s[9]=pow(E,xss[0])*kkappa*Pssp*zbar*pow(Gs[134] + Hs[64] + Hs[67],2) - 2*pphi*Pssp*Gs[133]*(pow(E,yss[1] + yss[7])*(Gs[129] + Gs[135]) + pow(E,yss[2])*pbar*(Gs[130] + Hs[68])) + (2*Pssp*zbar*pow(Gs[133],2)*xss[1])/pow(1 + yss[5],3) - (2*Pssp*zbar*Gs[133]*Hs[65])/pow(1 + yss[5],2) - (2*Pssp*zbar*Gs[133]*Hs[67]*xss[1])/pow(1 + yss[5],2) + (2*Pssp*zbar*Hs[65]*Hs[67])/(1 + yss[5]) + (Pssp*zbar*pow(Hs[67],2)*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*pow(Gs[129] + Gs[135],2)*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*pow(Gs[130] + Hs[68],2)*(1 + yss[5]) + 2*(dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[133]) - Gs[138] + pow(E,xss[0])*kkappa*zbar*(Gs[134] + Hs[64] + Hs[67]) - (zbar*Gs[133]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[65])/(1 + yss[5]) + (zbar*Hs[67]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[129] + Gs[135]) + pow(E,yss[2])*pbar*(Gs[130] + Hs[68]))*(1 + yss[5]));
	Nee_sp_s[10]=2*(dP2ssp*Gs[137] + dP1ssp*Gs[138])*((-1 + nnus)*Gs[137] + nnus*Gs[138]);
	Nee_sp_s[11]=pow(E,bbar - xss[1])*ppsir*Pssp*pow(Hs[65],2) + 2*(dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-Gs[133] - pow(E,bbar - xss[1])*ppsir*Hs[65] + Hs[69]);
	Nee_sp_s[12]=-(pow(E,xss[0])*(Gs[132] - Hs[64])*(2*dP2ssp*Gs[137] + 2*dP1ssp*Gs[138] + Pssp*(Gs[132] + Hs[64])));
	Nee_sp_s[13]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Gs[129],2)) + 2*aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[130] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*pow(Gs[130],2) + pow(E,yss[11])*Pssp*pow(Gs[139],2) - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[66] + 2*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[66] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[66],2) - 2*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[67] + 2*aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[67] - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[67] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[67],2) + pow(E,yss[2])*pbar*Pssp*pow(Gs[130] + Hs[68],2) + 2*(dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[129]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[130] + pow(E,yss[11])*Gs[139] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[66] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[67] + pow(E,yss[2])*pbar*(Gs[130] + Hs[68]));
	Nee_sp_s[14]=(2*Pssp*zbar*Hs[65]*(Gs[139] - Hs[67]) - Pssp*zbar*pow(Gs[139] - Hs[67],2)*xss[1] + 2*(dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(E,yss[11])*Gs[140] - zbar*Hs[65] + zbar*(Gs[139] - Hs[67])*xss[1]))/pow(E,yss[11]);
	Nee_sp_s[15]=(-2*Pssp*zbar*Hs[65]*Hs[67] - Pssp*(-1 + zbar)*pow(Gs[139],2)*xss[1] - Pssp*zbar*pow(Hs[67],2)*xss[1] + 2*Pssp*zbar*Gs[139]*(Hs[65] + Hs[67]*xss[1]) - 2*(dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(pow(E,yss[11])*Gs[141]) + zbar*Hs[65] - (-1 + zbar)*Gs[139]*xss[1] + zbar*Hs[67]*xss[1]))/pow(E,yss[11]);
	Nee_sp_s[16]=pow(E,yss[0] - yss[11])*Pssp*pow(Gs[128],2) + pow(E,yss[3] - yss[11])*Pssp*pow(Gs[131],2) - Pssp*pow(Gs[139],2) + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*pow(Gs[139],2))/pow(E,yss[11]) + ebar*Pssp*pow(Hs[70],2) + (2*Pssp*Gs[139]*(-(pow(E,yss[0])*Gs[128]) - pow(E,yss[3])*Gs[131] + pow(E,yss[11])*Gs[139] - pow(E,yss[11])*ebar*Hs[70]))/pow(E,yss[11]) + (2*(dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(E,yss[0])*Gs[128] + pow(E,yss[3])*Gs[131] - pow(E,yss[0])*Gs[139] - pow(E,yss[3])*Gs[139] - pow(E,yss[11])*ebar*Gs[139] + pow(E,yss[11])*Gs[142] + pow(E,yss[11])*ebar*Hs[70]))/pow(E,yss[11]);
	Nee_sp_s[17]=(-2*Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[137]*Hs[67] + 2*Pssp*pow(zbar,rrho)*Gs[137]*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71]) - Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*pow(Hs[67],2)*yss[9] + Pssp*pow(zbar,rrho)*Hs[64]*(G2sp[8]*Hs[64] + G2sp[24]*Hs[65] + G2sp[40]*Hs[66] + G2sp[56]*Hs[67] + G2sp[72]*Hs[68] + G2sp[88]*Hs[69] + G2sp[104]*Hs[70] + G2sp[120]*Hs[71])*yss[9] + Pssp*pow(zbar,rrho)*Hs[65]*(G2sp[24]*Hs[64] + G2sp[264]*Hs[65] + G2sp[280]*Hs[66] + G2sp[296]*Hs[67] + G2sp[312]*Hs[68] + G2sp[328]*Hs[69] + G2sp[344]*Hs[70] + G2sp[360]*Hs[71])*yss[9] + Pssp*pow(zbar,rrho)*Hs[66]*(G2sp[40]*Hs[64] + G2sp[280]*Hs[65] + G2sp[520]*Hs[66] + G2sp[536]*Hs[67] + G2sp[552]*Hs[68] + G2sp[568]*Hs[69] + G2sp[584]*Hs[70] + G2sp[600]*Hs[71])*yss[9] + Pssp*pow(zbar,rrho)*Hs[67]*(G2sp[56]*Hs[64] + G2sp[296]*Hs[65] + G2sp[536]*Hs[66] + G2sp[776]*Hs[67] + G2sp[792]*Hs[68] + G2sp[808]*Hs[69] + G2sp[824]*Hs[70] + G2sp[840]*Hs[71])*yss[9] + Pssp*pow(zbar,rrho)*Hs[68]*(G2sp[72]*Hs[64] + G2sp[312]*Hs[65] + G2sp[552]*Hs[66] + G2sp[792]*Hs[67] + G2sp[1032]*Hs[68] + G2sp[1048]*Hs[69] + G2sp[1064]*Hs[70] + G2sp[1080]*Hs[71])*yss[9] + Pssp*pow(zbar,rrho)*Hs[69]*(G2sp[88]*Hs[64] + G2sp[328]*Hs[65] + G2sp[568]*Hs[66] + G2sp[808]*Hs[67] + G2sp[1048]*Hs[68] + G2sp[1288]*Hs[69] + G2sp[1304]*Hs[70] + G2sp[1320]*Hs[71])*yss[9] + Pssp*pow(zbar,rrho)*Hs[70]*(G2sp[104]*Hs[64] + G2sp[344]*Hs[65] + G2sp[584]*Hs[66] + G2sp[824]*Hs[67] + G2sp[1064]*Hs[68] + G2sp[1304]*Hs[69] + G2sp[1544]*Hs[70] + G2sp[1560]*Hs[71])*yss[9] + Pssp*pow(zbar,rrho)*Hs[71]*(G2sp[120]*Hs[64] + G2sp[360]*Hs[65] + G2sp[600]*Hs[66] + G2sp[840]*Hs[67] + G2sp[1080]*Hs[68] + G2sp[1320]*Hs[69] + G2sp[1560]*Hs[70] + G2sp[1800]*Hs[71])*yss[9] + 2*Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[67]*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*yss[9] - Pssp*pow(zbar,rrho)*pow(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71],2)*yss[9] + 2*(dP2ssp*Gs[137] + dP1ssp*Gs[138])*(bbeta*pow(E,yss[8])*Gs[143] + pow(zbar,rrho)*(-Gs[137] + (-(rrho*rrhoz) + Gsp[56])*Hs[67]*yss[9] + (Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*yss[9])))/(bbeta*pow(E,yss[8]));
	Nee_sp_s[18]=2*(dP2ssp*Gs[137] + dP1ssp*Gs[138])*(ssigmaas - Hs[66]);
	Nee_sp_s[19]=-2*(dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[67];
	Nee_sp_s[20]=-2*(dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[68];
	Nee_sp_s[21]=-2*(dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[71];
	Nee_sp_s[22]=-2*(dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[70];
	Nee_sp_s[23]=-2*(dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[69];
	Nee_sp_s[24]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[128]*Gs[144]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[129]*Gs[145] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[128] - pow(pow(E,yss[1]),oomega)*Gs[129])*(pow(E,yss[0])*Gs[144] - pow(pow(E,yss[1]),oomega)*Gs[145]) - pow(E,yss[8])*Pssp*Gs[136]*Gs[152] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[144] - pow(pow(E,yss[1]),oomega)*Gs[145])*Hs[71] + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[128] - pow(pow(E,yss[1]),oomega)*Gs[129])) - pow(E,yss[8])*Gs[136] + Hs[71]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[128] - pow(pow(E,yss[1]),oomega)*Gs[129])*Hs[79] + (Pssp*Hs[71]*Hs[79])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[144] - pow(pow(E,yss[1]),oomega)*Gs[145])) - pow(E,yss[8])*Gs[152] + Hs[79]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nee_sp_s[25]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[145]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[145] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[146] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[146] - (pbar*pphi*Pssp*Gs[137]*Gs[149])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[133]*Gs[153])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[66] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[66] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[67] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[67] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[74] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[74] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[74] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[74] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[75] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[75] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[75] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[75] + (pbar*pphi*Pssp*Gs[137]*Gs[152]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[136]*Gs[153]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[136]*Gs[149]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[133]*Gs[152]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[136]*Gs[152]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[68]*Hs[76]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[76]*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[68]*(Gs[149]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[153] - Gs[152]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[129]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[130] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[66] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[67] - pbar*Hs[68]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[145]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[146] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[74] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[75] - pbar*Hs[76]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[149]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[153] - Gs[152]*yss[9])))/pow(E,yss[8]));
	Nee_sp_s[26]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[129]*Gs[145]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[145] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[145] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[146] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[146] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[137]*Gs[149] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[133]*Gs[153] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[66] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[67] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[67] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[74] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[74] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[75] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[75] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[75] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[75] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[137]*Gs[152]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[136]*Gs[153]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[136]*Gs[149]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[133]*Gs[152]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[136]*Gs[152]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[135]*Gs[151]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[151]*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[135]*(Gs[149]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[153] - Gs[152]*yss[9])) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[129]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[129] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[130] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[66] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[67] - pow(E,yss[7])*pphi*Gs[135]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9]))) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[145]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[145] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[146] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[74] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[75] - pow(E,yss[7])*pphi*Gs[151]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[149]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[153] - Gs[152]*yss[9])));
	Nee_sp_s[27]=-(pow(E,yss[8])*Pssp*Gs[136]*Gs[152]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[149]*Hs[67])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[149]*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[133]*Hs[75])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[133]*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[67]*Hs[75]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*Hs[75]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[64]*(G2sp[8]*Hs[72] + G2sp[24]*Hs[73] + G2sp[40]*Hs[74] + G2sp[56]*Hs[75] + G2sp[72]*Hs[76] + G2sp[88]*Hs[77] + G2sp[104]*Hs[78] + G2sp[120]*Hs[79])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[65]*(G2sp[24]*Hs[72] + G2sp[264]*Hs[73] + G2sp[280]*Hs[74] + G2sp[296]*Hs[75] + G2sp[312]*Hs[76] + G2sp[328]*Hs[77] + G2sp[344]*Hs[78] + G2sp[360]*Hs[79])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[66]*(G2sp[40]*Hs[72] + G2sp[280]*Hs[73] + G2sp[520]*Hs[74] + G2sp[536]*Hs[75] + G2sp[552]*Hs[76] + G2sp[568]*Hs[77] + G2sp[584]*Hs[78] + G2sp[600]*Hs[79])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[67]*(G2sp[56]*Hs[72] + G2sp[296]*Hs[73] + G2sp[536]*Hs[74] + G2sp[776]*Hs[75] + G2sp[792]*Hs[76] + G2sp[808]*Hs[77] + G2sp[824]*Hs[78] + G2sp[840]*Hs[79])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[68]*(G2sp[72]*Hs[72] + G2sp[312]*Hs[73] + G2sp[552]*Hs[74] + G2sp[792]*Hs[75] + G2sp[1032]*Hs[76] + G2sp[1048]*Hs[77] + G2sp[1064]*Hs[78] + G2sp[1080]*Hs[79])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[69]*(G2sp[88]*Hs[72] + G2sp[328]*Hs[73] + G2sp[568]*Hs[74] + G2sp[808]*Hs[75] + G2sp[1048]*Hs[76] + G2sp[1288]*Hs[77] + G2sp[1304]*Hs[78] + G2sp[1320]*Hs[79])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[70]*(G2sp[104]*Hs[72] + G2sp[344]*Hs[73] + G2sp[584]*Hs[74] + G2sp[824]*Hs[75] + G2sp[1064]*Hs[76] + G2sp[1304]*Hs[77] + G2sp[1544]*Hs[78] + G2sp[1560]*Hs[79])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[71]*(G2sp[120]*Hs[72] + G2sp[360]*Hs[73] + G2sp[600]*Hs[74] + G2sp[840]*Hs[75] + G2sp[1080]*Hs[76] + G2sp[1320]*Hs[77] + G2sp[1560]*Hs[78] + G2sp[1800]*Hs[79])*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[67]*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*((bbeta*pow(E,yss[8])*Gs[133])/pow(zbar,rrho) - pow(E,yss[8])*Gs[136] + Gs[137] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[67]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*((bbeta*pow(E,yss[8])*Gs[149])/pow(zbar,rrho) - pow(E,yss[8])*Gs[152] + Gs[153] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[75]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*(1 + yss[5]))/pow(zbar,rrho));
	Nee_sp_s[28]=-(kkappa*Pssp*Gs[137]*Gs[150]) + pow(E,yss[8])*Pssp*Gs[136]*Gs[152] - kkappa*Pssp*Gs[134]*Gs[153] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[64]*Hs[72] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*Hs[72] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[66]*Hs[72] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[67]*Hs[72] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*Hs[72] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*Hs[72] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])*Hs[72] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[64]*Hs[74] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[66]*Hs[74] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[67]*Hs[74] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*Hs[74] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*Hs[74] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[64]*Hs[75] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[66]*Hs[75] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[67]*Hs[75] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[67]*Hs[75])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*Hs[75] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*Hs[75] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*Hs[75])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[64] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71]))*Hs[75])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[136]*(Hs[72] + Hs[75]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[64] + Hs[67])*(Gs[152] + Hs[72] + Hs[75]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*(G2sp[1]*Hs[72] + G2sp[17]*Hs[73] + G2sp[33]*Hs[74] + G2sp[49]*Hs[75] + G2sp[65]*Hs[76] + G2sp[81]*Hs[77] + G2sp[97]*Hs[78] + G2sp[113]*Hs[79]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*(G2sp[2]*Hs[72] + G2sp[18]*Hs[73] + G2sp[34]*Hs[74] + G2sp[50]*Hs[75] + G2sp[66]*Hs[76] + G2sp[82]*Hs[77] + G2sp[98]*Hs[78] + G2sp[114]*Hs[79]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[64]*(G2sp[4]*Hs[72] + G2sp[20]*Hs[73] + G2sp[36]*Hs[74] + G2sp[52]*Hs[75] + G2sp[68]*Hs[76] + G2sp[84]*Hs[77] + G2sp[100]*Hs[78] + G2sp[116]*Hs[79]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[64]*(G2sp[8]*Hs[72] + G2sp[24]*Hs[73] + G2sp[40]*Hs[74] + G2sp[56]*Hs[75] + G2sp[72]*Hs[76] + G2sp[88]*Hs[77] + G2sp[104]*Hs[78] + G2sp[120]*Hs[79]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[65]*(G2sp[17]*Hs[72] + G2sp[257]*Hs[73] + G2sp[273]*Hs[74] + G2sp[289]*Hs[75] + G2sp[305]*Hs[76] + G2sp[321]*Hs[77] + G2sp[337]*Hs[78] + G2sp[353]*Hs[79]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[65]*(G2sp[18]*Hs[72] + G2sp[258]*Hs[73] + G2sp[274]*Hs[74] + G2sp[290]*Hs[75] + G2sp[306]*Hs[76] + G2sp[322]*Hs[77] + G2sp[338]*Hs[78] + G2sp[354]*Hs[79]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[65]*(G2sp[20]*Hs[72] + G2sp[260]*Hs[73] + G2sp[276]*Hs[74] + G2sp[292]*Hs[75] + G2sp[308]*Hs[76] + G2sp[324]*Hs[77] + G2sp[340]*Hs[78] + G2sp[356]*Hs[79]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[65]*(G2sp[24]*Hs[72] + G2sp[264]*Hs[73] + G2sp[280]*Hs[74] + G2sp[296]*Hs[75] + G2sp[312]*Hs[76] + G2sp[328]*Hs[77] + G2sp[344]*Hs[78] + G2sp[360]*Hs[79]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[66]*(G2sp[33]*Hs[72] + G2sp[273]*Hs[73] + G2sp[513]*Hs[74] + G2sp[529]*Hs[75] + G2sp[545]*Hs[76] + G2sp[561]*Hs[77] + G2sp[577]*Hs[78] + G2sp[593]*Hs[79]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[66]*(G2sp[34]*Hs[72] + G2sp[274]*Hs[73] + G2sp[514]*Hs[74] + G2sp[530]*Hs[75] + G2sp[546]*Hs[76] + G2sp[562]*Hs[77] + G2sp[578]*Hs[78] + G2sp[594]*Hs[79]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[66]*(G2sp[36]*Hs[72] + G2sp[276]*Hs[73] + G2sp[516]*Hs[74] + G2sp[532]*Hs[75] + G2sp[548]*Hs[76] + G2sp[564]*Hs[77] + G2sp[580]*Hs[78] + G2sp[596]*Hs[79]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[66]*(G2sp[40]*Hs[72] + G2sp[280]*Hs[73] + G2sp[520]*Hs[74] + G2sp[536]*Hs[75] + G2sp[552]*Hs[76] + G2sp[568]*Hs[77] + G2sp[584]*Hs[78] + G2sp[600]*Hs[79]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[67]*(G2sp[49]*Hs[72] + G2sp[289]*Hs[73] + G2sp[529]*Hs[74] + G2sp[769]*Hs[75] + G2sp[785]*Hs[76] + G2sp[801]*Hs[77] + G2sp[817]*Hs[78] + G2sp[833]*Hs[79]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[67]*(G2sp[50]*Hs[72] + G2sp[290]*Hs[73] + G2sp[530]*Hs[74] + G2sp[770]*Hs[75] + G2sp[786]*Hs[76] + G2sp[802]*Hs[77] + G2sp[818]*Hs[78] + G2sp[834]*Hs[79]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[67]*(G2sp[52]*Hs[72] + G2sp[292]*Hs[73] + G2sp[532]*Hs[74] + G2sp[772]*Hs[75] + G2sp[788]*Hs[76] + G2sp[804]*Hs[77] + G2sp[820]*Hs[78] + G2sp[836]*Hs[79]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[67]*(G2sp[56]*Hs[72] + G2sp[296]*Hs[73] + G2sp[536]*Hs[74] + G2sp[776]*Hs[75] + G2sp[792]*Hs[76] + G2sp[808]*Hs[77] + G2sp[824]*Hs[78] + G2sp[840]*Hs[79]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[68]*(G2sp[65]*Hs[72] + G2sp[305]*Hs[73] + G2sp[545]*Hs[74] + G2sp[785]*Hs[75] + G2sp[1025]*Hs[76] + G2sp[1041]*Hs[77] + G2sp[1057]*Hs[78] + G2sp[1073]*Hs[79]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[68]*(G2sp[66]*Hs[72] + G2sp[306]*Hs[73] + G2sp[546]*Hs[74] + G2sp[786]*Hs[75] + G2sp[1026]*Hs[76] + G2sp[1042]*Hs[77] + G2sp[1058]*Hs[78] + G2sp[1074]*Hs[79]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[68]*(G2sp[68]*Hs[72] + G2sp[308]*Hs[73] + G2sp[548]*Hs[74] + G2sp[788]*Hs[75] + G2sp[1028]*Hs[76] + G2sp[1044]*Hs[77] + G2sp[1060]*Hs[78] + G2sp[1076]*Hs[79]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[68]*(G2sp[72]*Hs[72] + G2sp[312]*Hs[73] + G2sp[552]*Hs[74] + G2sp[792]*Hs[75] + G2sp[1032]*Hs[76] + G2sp[1048]*Hs[77] + G2sp[1064]*Hs[78] + G2sp[1080]*Hs[79]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[69]*(G2sp[81]*Hs[72] + G2sp[321]*Hs[73] + G2sp[561]*Hs[74] + G2sp[801]*Hs[75] + G2sp[1041]*Hs[76] + G2sp[1281]*Hs[77] + G2sp[1297]*Hs[78] + G2sp[1313]*Hs[79]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[69]*(G2sp[82]*Hs[72] + G2sp[322]*Hs[73] + G2sp[562]*Hs[74] + G2sp[802]*Hs[75] + G2sp[1042]*Hs[76] + G2sp[1282]*Hs[77] + G2sp[1298]*Hs[78] + G2sp[1314]*Hs[79]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[69]*(G2sp[84]*Hs[72] + G2sp[324]*Hs[73] + G2sp[564]*Hs[74] + G2sp[804]*Hs[75] + G2sp[1044]*Hs[76] + G2sp[1284]*Hs[77] + G2sp[1300]*Hs[78] + G2sp[1316]*Hs[79]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[69]*(G2sp[88]*Hs[72] + G2sp[328]*Hs[73] + G2sp[568]*Hs[74] + G2sp[808]*Hs[75] + G2sp[1048]*Hs[76] + G2sp[1288]*Hs[77] + G2sp[1304]*Hs[78] + G2sp[1320]*Hs[79]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[70]*(G2sp[97]*Hs[72] + G2sp[337]*Hs[73] + G2sp[577]*Hs[74] + G2sp[817]*Hs[75] + G2sp[1057]*Hs[76] + G2sp[1297]*Hs[77] + G2sp[1537]*Hs[78] + G2sp[1553]*Hs[79]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[70]*(G2sp[98]*Hs[72] + G2sp[338]*Hs[73] + G2sp[578]*Hs[74] + G2sp[818]*Hs[75] + G2sp[1058]*Hs[76] + G2sp[1298]*Hs[77] + G2sp[1538]*Hs[78] + G2sp[1554]*Hs[79]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[70]*(G2sp[100]*Hs[72] + G2sp[340]*Hs[73] + G2sp[580]*Hs[74] + G2sp[820]*Hs[75] + G2sp[1060]*Hs[76] + G2sp[1300]*Hs[77] + G2sp[1540]*Hs[78] + G2sp[1556]*Hs[79]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[70]*(G2sp[104]*Hs[72] + G2sp[344]*Hs[73] + G2sp[584]*Hs[74] + G2sp[824]*Hs[75] + G2sp[1064]*Hs[76] + G2sp[1304]*Hs[77] + G2sp[1544]*Hs[78] + G2sp[1560]*Hs[79]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[71]*(G2sp[113]*Hs[72] + G2sp[353]*Hs[73] + G2sp[593]*Hs[74] + G2sp[833]*Hs[75] + G2sp[1073]*Hs[76] + G2sp[1313]*Hs[77] + G2sp[1553]*Hs[78] + G2sp[1793]*Hs[79]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[71]*(G2sp[114]*Hs[72] + G2sp[354]*Hs[73] + G2sp[594]*Hs[74] + G2sp[834]*Hs[75] + G2sp[1074]*Hs[76] + G2sp[1314]*Hs[77] + G2sp[1554]*Hs[78] + G2sp[1794]*Hs[79]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[71]*(G2sp[116]*Hs[72] + G2sp[356]*Hs[73] + G2sp[596]*Hs[74] + G2sp[836]*Hs[75] + G2sp[1076]*Hs[76] + G2sp[1316]*Hs[77] + G2sp[1556]*Hs[78] + G2sp[1796]*Hs[79]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[71]*(G2sp[120]*Hs[72] + G2sp[360]*Hs[73] + G2sp[600]*Hs[74] + G2sp[840]*Hs[75] + G2sp[1080]*Hs[76] + G2sp[1320]*Hs[77] + G2sp[1560]*Hs[78] + G2sp[1800]*Hs[79]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[66]*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[67]*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[66]*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[67]*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[64]*((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])*((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])*(Gsp[4]*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[67]*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[64] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71]))*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[67]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[72] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[75] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[72] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[75] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79])))/pow(zbar,rrho) - kkappa*Pssp*Gs[134]*Gs[150]*yss[9] + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(pow(E,yss[8])*Gs[136] - kkappa*Gs[137] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[67])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[64] + Hs[67]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[64] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])))/pow(zbar,rrho) - kkappa*Gs[134]*yss[9]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(E,yss[8])*Gs[152] - kkappa*Gs[153] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[75])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[72] + Hs[75]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[72] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[75] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79])))/pow(zbar,rrho) - kkappa*Gs[150]*yss[9]);
	Nee_sp_s[29]=-(Pssp*Gs[134]*Gs[150]) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-Gs[134] + iiota*zbar*(Hs[64] + Hs[67])) + iiota*Pssp*zbar*(Hs[64] + Hs[67])*(Hs[72] + Hs[75]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-Gs[150] + iiota*zbar*(Hs[72] + Hs[75]));
	Nee_sp_s[30]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[129]*Gs[145] - pow(E,yss[7])*Pssp*Gs[135]*Gs[151] + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[145] - pow(E,yss[7])*Gs[151]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[129] - pow(E,yss[7])*Gs[135])*(dP2ssp*Gs[153] + dP1ssp*Gs[154]);
	Nee_sp_s[31]=-(pow(E,yss[0])*Pssp*Gs[128]*Gs[144]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[145] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[145] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[146] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[146] - pow(E,yss[3])*Pssp*Gs[131]*Gs[147] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[66] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[67] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[67] - pphi*Pssp*Gs[149]*(pow(E,yss[1] + yss[7])*(Gs[129] + Gs[135]) + pow(E,yss[2])*pbar*(Gs[130] + Hs[68])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[74] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[74] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[74] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[75] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[75] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[75] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[75] - pow(E,yss[2])*pbar*Pssp*(Gs[130] + Hs[68])*(Gs[146] + Hs[76]) - pphi*Pssp*Gs[133]*(pow(E,yss[1] + yss[7])*(Gs[145] + Gs[151]) + pow(E,yss[2])*pbar*(Gs[146] + Hs[76])) - pow(E,yss[11])*ebar*Pssp*Hs[70]*Hs[78] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[129] + Gs[135])*(Gs[145] + Gs[151])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[130] + Hs[68])*(Gs[146] + Hs[76])*yss[5] - (2*Pssp*zbar*Gs[133]*Gs[149]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[149]*Hs[65])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[133]*Hs[73])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[149]*Hs[67]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[133]*Hs[75]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[67]*Hs[73])/(1 + yss[5]) - (Pssp*zbar*Hs[65]*Hs[75])/(1 + yss[5]) - (Pssp*zbar*Hs[67]*Hs[75]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(pow(E,yss[0])*Gs[128]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[129] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[130] - pow(E,yss[3])*Gs[131] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[133] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[67] - pow(E,yss[2])*pbar*(Gs[130] + Hs[68]) - pow(E,yss[11])*ebar*Hs[70] - pphi*(pow(E,yss[1] + yss[7])*(Gs[129] + Gs[135]) + pow(E,yss[2])*pbar*(Gs[130] + Hs[68]))*yss[5] + (zbar*Gs[133]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[65])/(1 + yss[5]) - (zbar*Hs[67]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(pow(E,yss[0])*Gs[144]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[145] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[146] - pow(E,yss[3])*Gs[147] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[149] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[75] - pow(E,yss[2])*pbar*(Gs[146] + Hs[76]) - pow(E,yss[11])*ebar*Hs[78] - pphi*(pow(E,yss[1] + yss[7])*(Gs[145] + Gs[151]) + pow(E,yss[2])*pbar*(Gs[146] + Hs[76]))*yss[5] + (zbar*Gs[149]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[73])/(1 + yss[5]) - (zbar*Hs[75]*xss[1])/(1 + yss[5]));
	Nee_sp_s[32]=pow(E,yss[3])*Pssp*Gs[131]*Gs[147] + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(pow(E,yss[3])*Gs[131] - pow(E,xss[0])*zbar*(Hs[64] + Hs[67])) - pow(E,xss[0])*Pssp*zbar*(Hs[64] + Hs[67])*(Hs[72] + Hs[75]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[64] + Hs[67])*(Hs[72] + Hs[75]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(E,yss[3])*Gs[147] - pow(E,xss[0])*zbar*(Hs[72] + Hs[75]));
	Nee_sp_s[33]=-(pphi*Pssp*Gs[149]*(pow(E,yss[1] + yss[7])*(Gs[129] + Gs[135]) + pow(E,yss[2])*pbar*(Gs[130] + Hs[68]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[134] + Hs[64] + Hs[67])*(Gs[150] + Hs[72] + Hs[75]) - pphi*Pssp*Gs[133]*(pow(E,yss[1] + yss[7])*(Gs[145] + Gs[151]) + pow(E,yss[2])*pbar*(Gs[146] + Hs[76])) + (2*Pssp*zbar*Gs[133]*Gs[149]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[149]*Hs[65])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[133]*Hs[73])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[149]*Hs[67]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[133]*Hs[75]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[67]*Hs[73])/(1 + yss[5]) + (Pssp*zbar*Hs[65]*Hs[75])/(1 + yss[5]) + (Pssp*zbar*Hs[67]*Hs[75]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[129] + Gs[135])*(Gs[145] + Gs[151])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[130] + Hs[68])*(Gs[146] + Hs[76])*(1 + yss[5]) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[133]) - Gs[138] + pow(E,xss[0])*kkappa*zbar*(Gs[134] + Hs[64] + Hs[67]) - (zbar*Gs[133]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[65])/(1 + yss[5]) + (zbar*Hs[67]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[129] + Gs[135]) + pow(E,yss[2])*pbar*(Gs[130] + Hs[68]))*(1 + yss[5])) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[149]) - Gs[154] + pow(E,xss[0])*kkappa*zbar*(Gs[150] + Hs[72] + Hs[75]) - (zbar*Gs[149]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[73])/(1 + yss[5]) + (zbar*Hs[75]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[145] + Gs[151]) + pow(E,yss[2])*pbar*(Gs[146] + Hs[76]))*(1 + yss[5]));
	Nee_sp_s[34]=((-1 + nnus)*Gs[137] + nnus*Gs[138])*(dP2ssp*Gs[153] + dP1ssp*Gs[154]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*((-1 + nnus)*Gs[153] + nnus*Gs[154]);
	Nee_sp_s[35]=(dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-Gs[133] - pow(E,bbar - xss[1])*ppsir*Hs[65] + Hs[69]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[65]*Hs[73] + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-Gs[149] - pow(E,bbar - xss[1])*ppsir*Hs[73] + Hs[77]);
	Nee_sp_s[36]=pow(E,xss[0])*(-(Pssp*Gs[132]*Gs[148]) - (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(Gs[132] - Hs[64]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(Gs[148] - Hs[72]) + Pssp*Hs[64]*Hs[72]);
	Nee_sp_s[37]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[145]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[145] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[146] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[146] + pow(E,yss[11])*Pssp*Gs[139]*Gs[155] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[66] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[66] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[67] + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[129]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[130] + pow(E,yss[11])*Gs[139] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[66] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[67] + pow(E,yss[2])*pbar*(Gs[130] + Hs[68])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[74] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[74] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[74] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[74] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[75] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[75] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[75] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[75] + pow(E,yss[2])*pbar*Pssp*(Gs[130] + Hs[68])*(Gs[146] + Hs[76]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[145]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[146] + pow(E,yss[11])*Gs[155] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[74] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[75] + pow(E,yss[2])*pbar*(Gs[146] + Hs[76]));
	Nee_sp_s[38]=(Pssp*zbar*(Gs[139] - Hs[67])*Hs[73] + Pssp*zbar*Hs[65]*(Gs[155] - Hs[75]) - Pssp*zbar*(Gs[139] - Hs[67])*(Gs[155] - Hs[75])*xss[1] + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(pow(E,yss[11])*Gs[140] - zbar*Hs[65] + zbar*(Gs[139] - Hs[67])*xss[1]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(E,yss[11])*Gs[156] - zbar*Hs[73] + zbar*(Gs[155] - Hs[75])*xss[1]))/pow(E,yss[11]);
	Nee_sp_s[39]=(-(Pssp*zbar*Hs[67]*Hs[73]) - Pssp*zbar*Hs[65]*Hs[75] - Pssp*(-1 + zbar)*Gs[139]*Gs[155]*xss[1] - Pssp*zbar*Hs[67]*Hs[75]*xss[1] + Pssp*zbar*Gs[155]*(Hs[65] + Hs[67]*xss[1]) - (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(pow(E,yss[11])*Gs[141]) + zbar*Hs[65] - (-1 + zbar)*Gs[139]*xss[1] + zbar*Hs[67]*xss[1]) + Pssp*zbar*Gs[139]*(Hs[73] + Hs[75]*xss[1]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(pow(E,yss[11])*Gs[157]) + zbar*Hs[73] - (-1 + zbar)*Gs[155]*xss[1] + zbar*Hs[75]*xss[1]))/pow(E,yss[11]);
	Nee_sp_s[40]=pow(E,yss[0] - yss[11])*Pssp*Gs[128]*Gs[144] + pow(E,yss[3] - yss[11])*Pssp*Gs[131]*Gs[147] - Pssp*Gs[139]*Gs[155] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[139]*Gs[155])/pow(E,yss[11]) - (Pssp*Gs[155]*(pow(E,yss[0])*Gs[128] + pow(E,yss[3])*Gs[131] - pow(E,yss[11])*Gs[139] + pow(E,yss[11])*ebar*Hs[70]))/pow(E,yss[11]) + ((dP2ssp*Gs[153] + dP1ssp*Gs[154])*(pow(E,yss[0])*Gs[128] + pow(E,yss[3])*Gs[131] - pow(E,yss[0])*Gs[139] - pow(E,yss[3])*Gs[139] - pow(E,yss[11])*ebar*Gs[139] + pow(E,yss[11])*Gs[142] + pow(E,yss[11])*ebar*Hs[70]))/pow(E,yss[11]) + ebar*Pssp*Hs[70]*Hs[78] - (Pssp*Gs[139]*(pow(E,yss[0])*Gs[144] + pow(E,yss[3])*Gs[147] - pow(E,yss[11])*Gs[155] + pow(E,yss[11])*ebar*Hs[78]))/pow(E,yss[11]) + ((dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(E,yss[0])*Gs[144] + pow(E,yss[3])*Gs[147] - pow(E,yss[0])*Gs[155] - pow(E,yss[3])*Gs[155] - pow(E,yss[11])*ebar*Gs[155] + pow(E,yss[11])*Gs[158] + pow(E,yss[11])*ebar*Hs[78]))/pow(E,yss[11]);
	Nee_sp_s[41]=(-(Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[153]*Hs[67]) + Pssp*pow(zbar,rrho)*Gs[153]*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71]) - Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[137]*Hs[75] + Pssp*pow(zbar,rrho)*Gs[137]*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79]) - Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[67]*Hs[75]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*Hs[75]*yss[9] + Pssp*pow(zbar,rrho)*Hs[64]*(G2sp[8]*Hs[72] + G2sp[24]*Hs[73] + G2sp[40]*Hs[74] + G2sp[56]*Hs[75] + G2sp[72]*Hs[76] + G2sp[88]*Hs[77] + G2sp[104]*Hs[78] + G2sp[120]*Hs[79])*yss[9] + Pssp*pow(zbar,rrho)*Hs[65]*(G2sp[24]*Hs[72] + G2sp[264]*Hs[73] + G2sp[280]*Hs[74] + G2sp[296]*Hs[75] + G2sp[312]*Hs[76] + G2sp[328]*Hs[77] + G2sp[344]*Hs[78] + G2sp[360]*Hs[79])*yss[9] + Pssp*pow(zbar,rrho)*Hs[66]*(G2sp[40]*Hs[72] + G2sp[280]*Hs[73] + G2sp[520]*Hs[74] + G2sp[536]*Hs[75] + G2sp[552]*Hs[76] + G2sp[568]*Hs[77] + G2sp[584]*Hs[78] + G2sp[600]*Hs[79])*yss[9] + Pssp*pow(zbar,rrho)*Hs[67]*(G2sp[56]*Hs[72] + G2sp[296]*Hs[73] + G2sp[536]*Hs[74] + G2sp[776]*Hs[75] + G2sp[792]*Hs[76] + G2sp[808]*Hs[77] + G2sp[824]*Hs[78] + G2sp[840]*Hs[79])*yss[9] + Pssp*pow(zbar,rrho)*Hs[68]*(G2sp[72]*Hs[72] + G2sp[312]*Hs[73] + G2sp[552]*Hs[74] + G2sp[792]*Hs[75] + G2sp[1032]*Hs[76] + G2sp[1048]*Hs[77] + G2sp[1064]*Hs[78] + G2sp[1080]*Hs[79])*yss[9] + Pssp*pow(zbar,rrho)*Hs[69]*(G2sp[88]*Hs[72] + G2sp[328]*Hs[73] + G2sp[568]*Hs[74] + G2sp[808]*Hs[75] + G2sp[1048]*Hs[76] + G2sp[1288]*Hs[77] + G2sp[1304]*Hs[78] + G2sp[1320]*Hs[79])*yss[9] + Pssp*pow(zbar,rrho)*Hs[70]*(G2sp[104]*Hs[72] + G2sp[344]*Hs[73] + G2sp[584]*Hs[74] + G2sp[824]*Hs[75] + G2sp[1064]*Hs[76] + G2sp[1304]*Hs[77] + G2sp[1544]*Hs[78] + G2sp[1560]*Hs[79])*yss[9] + Pssp*pow(zbar,rrho)*Hs[71]*(G2sp[120]*Hs[72] + G2sp[360]*Hs[73] + G2sp[600]*Hs[74] + G2sp[840]*Hs[75] + G2sp[1080]*Hs[76] + G2sp[1320]*Hs[77] + G2sp[1560]*Hs[78] + G2sp[1800]*Hs[79])*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[67]*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*yss[9] - Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*yss[9] + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(bbeta*pow(E,yss[8])*Gs[143] + pow(zbar,rrho)*(-Gs[137] + (-(rrho*rrhoz) + Gsp[56])*Hs[67]*yss[9] + (Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*yss[9])) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(bbeta*pow(E,yss[8])*Gs[159] + pow(zbar,rrho)*(-Gs[153] + (-(rrho*rrhoz) + Gsp[56])*Hs[75]*yss[9] + (Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*yss[9])))/(bbeta*pow(E,yss[8]));
	Nee_sp_s[42]=(dP2ssp*Gs[153] + dP1ssp*Gs[154])*(ssigmaas - Hs[66]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[74];
	Nee_sp_s[43]=-((dP2ssp*Gs[153] + dP1ssp*Gs[154])*Hs[67]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(ssigmazs - Hs[75]);
	Nee_sp_s[44]=-((dP2ssp*Gs[153] + dP1ssp*Gs[154])*Hs[68]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[76];
	Nee_sp_s[45]=-((dP2ssp*Gs[153] + dP1ssp*Gs[154])*Hs[71]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[79];
	Nee_sp_s[46]=-((dP2ssp*Gs[153] + dP1ssp*Gs[154])*Hs[70]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[78];
	Nee_sp_s[47]=-((dP2ssp*Gs[153] + dP1ssp*Gs[154])*Hs[69]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[77];
	Nee_sp_s[48]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[128]*Gs[160]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[129]*Gs[161] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[128] - pow(pow(E,yss[1]),oomega)*Gs[129])*(pow(E,yss[0])*Gs[160] - pow(pow(E,yss[1]),oomega)*Gs[161]) - pow(E,yss[8])*Pssp*Gs[136]*Gs[168] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[160] - pow(pow(E,yss[1]),oomega)*Gs[161])*Hs[71] + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[128] - pow(pow(E,yss[1]),oomega)*Gs[129])) - pow(E,yss[8])*Gs[136] + Hs[71]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[128] - pow(pow(E,yss[1]),oomega)*Gs[129])*Hs[87] + (Pssp*Hs[71]*Hs[87])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[160] - pow(pow(E,yss[1]),oomega)*Gs[161])) - pow(E,yss[8])*Gs[168] + Hs[87]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nee_sp_s[49]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[161]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[161] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[162] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[162] - (pbar*pphi*Pssp*Gs[137]*Gs[165])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[133]*Gs[169])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Hs[66] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[162]*Hs[66] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Hs[67] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[162]*Hs[67] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[82] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[82] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[82] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[82] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[83] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[83] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[83] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[83] + (pbar*pphi*Pssp*Gs[137]*Gs[168]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[136]*Gs[169]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[136]*Gs[165]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[133]*Gs[168]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[136]*Gs[168]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[68]*Hs[84]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[84]*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[68]*(Gs[165]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[169] - Gs[168]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[129]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[130] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[66] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[67] - pbar*Hs[68]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[161]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[162] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[82] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[83] - pbar*Hs[84]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[165]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[169] - Gs[168]*yss[9])))/pow(E,yss[8]));
	Nee_sp_s[50]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[129]*Gs[161]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[161] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[161] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[162] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[162] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[137]*Gs[165] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[133]*Gs[169] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[162]*Hs[66] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Hs[67] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[162]*Hs[67] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[82] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[82] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[82] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[82] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[83] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[83] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[83] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[83] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[137]*Gs[168]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[136]*Gs[169]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[136]*Gs[165]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[133]*Gs[168]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[136]*Gs[168]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[135]*Gs[167]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[167]*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[135]*(Gs[165]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[169] - Gs[168]*yss[9])) + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[129]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[129] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[130] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[66] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[67] - pow(E,yss[7])*pphi*Gs[135]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9]))) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[161]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[161] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[162] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[82] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[83] - pow(E,yss[7])*pphi*Gs[167]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[165]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[169] - Gs[168]*yss[9])));
	Nee_sp_s[51]=-(pow(E,yss[8])*Pssp*Gs[136]*Gs[168]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[165]*Hs[67])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[165]*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[133]*Hs[83])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[133]*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[67]*Hs[83]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*Hs[83]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[64]*(G2sp[8]*Hs[80] + G2sp[24]*Hs[81] + G2sp[40]*Hs[82] + G2sp[56]*Hs[83] + G2sp[72]*Hs[84] + G2sp[88]*Hs[85] + G2sp[104]*Hs[86] + G2sp[120]*Hs[87])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[65]*(G2sp[24]*Hs[80] + G2sp[264]*Hs[81] + G2sp[280]*Hs[82] + G2sp[296]*Hs[83] + G2sp[312]*Hs[84] + G2sp[328]*Hs[85] + G2sp[344]*Hs[86] + G2sp[360]*Hs[87])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[66]*(G2sp[40]*Hs[80] + G2sp[280]*Hs[81] + G2sp[520]*Hs[82] + G2sp[536]*Hs[83] + G2sp[552]*Hs[84] + G2sp[568]*Hs[85] + G2sp[584]*Hs[86] + G2sp[600]*Hs[87])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[67]*(G2sp[56]*Hs[80] + G2sp[296]*Hs[81] + G2sp[536]*Hs[82] + G2sp[776]*Hs[83] + G2sp[792]*Hs[84] + G2sp[808]*Hs[85] + G2sp[824]*Hs[86] + G2sp[840]*Hs[87])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[68]*(G2sp[72]*Hs[80] + G2sp[312]*Hs[81] + G2sp[552]*Hs[82] + G2sp[792]*Hs[83] + G2sp[1032]*Hs[84] + G2sp[1048]*Hs[85] + G2sp[1064]*Hs[86] + G2sp[1080]*Hs[87])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[69]*(G2sp[88]*Hs[80] + G2sp[328]*Hs[81] + G2sp[568]*Hs[82] + G2sp[808]*Hs[83] + G2sp[1048]*Hs[84] + G2sp[1288]*Hs[85] + G2sp[1304]*Hs[86] + G2sp[1320]*Hs[87])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[70]*(G2sp[104]*Hs[80] + G2sp[344]*Hs[81] + G2sp[584]*Hs[82] + G2sp[824]*Hs[83] + G2sp[1064]*Hs[84] + G2sp[1304]*Hs[85] + G2sp[1544]*Hs[86] + G2sp[1560]*Hs[87])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[71]*(G2sp[120]*Hs[80] + G2sp[360]*Hs[81] + G2sp[600]*Hs[82] + G2sp[840]*Hs[83] + G2sp[1080]*Hs[84] + G2sp[1320]*Hs[85] + G2sp[1560]*Hs[86] + G2sp[1800]*Hs[87])*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[67]*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*((bbeta*pow(E,yss[8])*Gs[133])/pow(zbar,rrho) - pow(E,yss[8])*Gs[136] + Gs[137] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[67]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*((bbeta*pow(E,yss[8])*Gs[165])/pow(zbar,rrho) - pow(E,yss[8])*Gs[168] + Gs[169] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[83]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87])*(1 + yss[5]))/pow(zbar,rrho));
	Nee_sp_s[52]=-(kkappa*Pssp*Gs[137]*Gs[166]) + pow(E,yss[8])*Pssp*Gs[136]*Gs[168] - kkappa*Pssp*Gs[134]*Gs[169] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[64]*Hs[80] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*Hs[80] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[66]*Hs[80] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[67]*Hs[80] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*Hs[80] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*Hs[80] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])*Hs[80] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[64]*Hs[82] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[66]*Hs[82] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[67]*Hs[82] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*Hs[82] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*Hs[82] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[64]*Hs[83] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[66]*Hs[83] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[67]*Hs[83] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[67]*Hs[83])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*Hs[83] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*Hs[83] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*Hs[83])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[64] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71]))*Hs[83])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[136]*(Hs[80] + Hs[83]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[64] + Hs[67])*(Gs[168] + Hs[80] + Hs[83]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*(G2sp[1]*Hs[80] + G2sp[17]*Hs[81] + G2sp[33]*Hs[82] + G2sp[49]*Hs[83] + G2sp[65]*Hs[84] + G2sp[81]*Hs[85] + G2sp[97]*Hs[86] + G2sp[113]*Hs[87]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*(G2sp[2]*Hs[80] + G2sp[18]*Hs[81] + G2sp[34]*Hs[82] + G2sp[50]*Hs[83] + G2sp[66]*Hs[84] + G2sp[82]*Hs[85] + G2sp[98]*Hs[86] + G2sp[114]*Hs[87]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[64]*(G2sp[4]*Hs[80] + G2sp[20]*Hs[81] + G2sp[36]*Hs[82] + G2sp[52]*Hs[83] + G2sp[68]*Hs[84] + G2sp[84]*Hs[85] + G2sp[100]*Hs[86] + G2sp[116]*Hs[87]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[64]*(G2sp[8]*Hs[80] + G2sp[24]*Hs[81] + G2sp[40]*Hs[82] + G2sp[56]*Hs[83] + G2sp[72]*Hs[84] + G2sp[88]*Hs[85] + G2sp[104]*Hs[86] + G2sp[120]*Hs[87]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[65]*(G2sp[17]*Hs[80] + G2sp[257]*Hs[81] + G2sp[273]*Hs[82] + G2sp[289]*Hs[83] + G2sp[305]*Hs[84] + G2sp[321]*Hs[85] + G2sp[337]*Hs[86] + G2sp[353]*Hs[87]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[65]*(G2sp[18]*Hs[80] + G2sp[258]*Hs[81] + G2sp[274]*Hs[82] + G2sp[290]*Hs[83] + G2sp[306]*Hs[84] + G2sp[322]*Hs[85] + G2sp[338]*Hs[86] + G2sp[354]*Hs[87]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[65]*(G2sp[20]*Hs[80] + G2sp[260]*Hs[81] + G2sp[276]*Hs[82] + G2sp[292]*Hs[83] + G2sp[308]*Hs[84] + G2sp[324]*Hs[85] + G2sp[340]*Hs[86] + G2sp[356]*Hs[87]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[65]*(G2sp[24]*Hs[80] + G2sp[264]*Hs[81] + G2sp[280]*Hs[82] + G2sp[296]*Hs[83] + G2sp[312]*Hs[84] + G2sp[328]*Hs[85] + G2sp[344]*Hs[86] + G2sp[360]*Hs[87]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[66]*(G2sp[33]*Hs[80] + G2sp[273]*Hs[81] + G2sp[513]*Hs[82] + G2sp[529]*Hs[83] + G2sp[545]*Hs[84] + G2sp[561]*Hs[85] + G2sp[577]*Hs[86] + G2sp[593]*Hs[87]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[66]*(G2sp[34]*Hs[80] + G2sp[274]*Hs[81] + G2sp[514]*Hs[82] + G2sp[530]*Hs[83] + G2sp[546]*Hs[84] + G2sp[562]*Hs[85] + G2sp[578]*Hs[86] + G2sp[594]*Hs[87]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[66]*(G2sp[36]*Hs[80] + G2sp[276]*Hs[81] + G2sp[516]*Hs[82] + G2sp[532]*Hs[83] + G2sp[548]*Hs[84] + G2sp[564]*Hs[85] + G2sp[580]*Hs[86] + G2sp[596]*Hs[87]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[66]*(G2sp[40]*Hs[80] + G2sp[280]*Hs[81] + G2sp[520]*Hs[82] + G2sp[536]*Hs[83] + G2sp[552]*Hs[84] + G2sp[568]*Hs[85] + G2sp[584]*Hs[86] + G2sp[600]*Hs[87]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[67]*(G2sp[49]*Hs[80] + G2sp[289]*Hs[81] + G2sp[529]*Hs[82] + G2sp[769]*Hs[83] + G2sp[785]*Hs[84] + G2sp[801]*Hs[85] + G2sp[817]*Hs[86] + G2sp[833]*Hs[87]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[67]*(G2sp[50]*Hs[80] + G2sp[290]*Hs[81] + G2sp[530]*Hs[82] + G2sp[770]*Hs[83] + G2sp[786]*Hs[84] + G2sp[802]*Hs[85] + G2sp[818]*Hs[86] + G2sp[834]*Hs[87]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[67]*(G2sp[52]*Hs[80] + G2sp[292]*Hs[81] + G2sp[532]*Hs[82] + G2sp[772]*Hs[83] + G2sp[788]*Hs[84] + G2sp[804]*Hs[85] + G2sp[820]*Hs[86] + G2sp[836]*Hs[87]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[67]*(G2sp[56]*Hs[80] + G2sp[296]*Hs[81] + G2sp[536]*Hs[82] + G2sp[776]*Hs[83] + G2sp[792]*Hs[84] + G2sp[808]*Hs[85] + G2sp[824]*Hs[86] + G2sp[840]*Hs[87]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[68]*(G2sp[65]*Hs[80] + G2sp[305]*Hs[81] + G2sp[545]*Hs[82] + G2sp[785]*Hs[83] + G2sp[1025]*Hs[84] + G2sp[1041]*Hs[85] + G2sp[1057]*Hs[86] + G2sp[1073]*Hs[87]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[68]*(G2sp[66]*Hs[80] + G2sp[306]*Hs[81] + G2sp[546]*Hs[82] + G2sp[786]*Hs[83] + G2sp[1026]*Hs[84] + G2sp[1042]*Hs[85] + G2sp[1058]*Hs[86] + G2sp[1074]*Hs[87]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[68]*(G2sp[68]*Hs[80] + G2sp[308]*Hs[81] + G2sp[548]*Hs[82] + G2sp[788]*Hs[83] + G2sp[1028]*Hs[84] + G2sp[1044]*Hs[85] + G2sp[1060]*Hs[86] + G2sp[1076]*Hs[87]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[68]*(G2sp[72]*Hs[80] + G2sp[312]*Hs[81] + G2sp[552]*Hs[82] + G2sp[792]*Hs[83] + G2sp[1032]*Hs[84] + G2sp[1048]*Hs[85] + G2sp[1064]*Hs[86] + G2sp[1080]*Hs[87]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[69]*(G2sp[81]*Hs[80] + G2sp[321]*Hs[81] + G2sp[561]*Hs[82] + G2sp[801]*Hs[83] + G2sp[1041]*Hs[84] + G2sp[1281]*Hs[85] + G2sp[1297]*Hs[86] + G2sp[1313]*Hs[87]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[69]*(G2sp[82]*Hs[80] + G2sp[322]*Hs[81] + G2sp[562]*Hs[82] + G2sp[802]*Hs[83] + G2sp[1042]*Hs[84] + G2sp[1282]*Hs[85] + G2sp[1298]*Hs[86] + G2sp[1314]*Hs[87]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[69]*(G2sp[84]*Hs[80] + G2sp[324]*Hs[81] + G2sp[564]*Hs[82] + G2sp[804]*Hs[83] + G2sp[1044]*Hs[84] + G2sp[1284]*Hs[85] + G2sp[1300]*Hs[86] + G2sp[1316]*Hs[87]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[69]*(G2sp[88]*Hs[80] + G2sp[328]*Hs[81] + G2sp[568]*Hs[82] + G2sp[808]*Hs[83] + G2sp[1048]*Hs[84] + G2sp[1288]*Hs[85] + G2sp[1304]*Hs[86] + G2sp[1320]*Hs[87]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[70]*(G2sp[97]*Hs[80] + G2sp[337]*Hs[81] + G2sp[577]*Hs[82] + G2sp[817]*Hs[83] + G2sp[1057]*Hs[84] + G2sp[1297]*Hs[85] + G2sp[1537]*Hs[86] + G2sp[1553]*Hs[87]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[70]*(G2sp[98]*Hs[80] + G2sp[338]*Hs[81] + G2sp[578]*Hs[82] + G2sp[818]*Hs[83] + G2sp[1058]*Hs[84] + G2sp[1298]*Hs[85] + G2sp[1538]*Hs[86] + G2sp[1554]*Hs[87]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[70]*(G2sp[100]*Hs[80] + G2sp[340]*Hs[81] + G2sp[580]*Hs[82] + G2sp[820]*Hs[83] + G2sp[1060]*Hs[84] + G2sp[1300]*Hs[85] + G2sp[1540]*Hs[86] + G2sp[1556]*Hs[87]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[70]*(G2sp[104]*Hs[80] + G2sp[344]*Hs[81] + G2sp[584]*Hs[82] + G2sp[824]*Hs[83] + G2sp[1064]*Hs[84] + G2sp[1304]*Hs[85] + G2sp[1544]*Hs[86] + G2sp[1560]*Hs[87]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[71]*(G2sp[113]*Hs[80] + G2sp[353]*Hs[81] + G2sp[593]*Hs[82] + G2sp[833]*Hs[83] + G2sp[1073]*Hs[84] + G2sp[1313]*Hs[85] + G2sp[1553]*Hs[86] + G2sp[1793]*Hs[87]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[71]*(G2sp[114]*Hs[80] + G2sp[354]*Hs[81] + G2sp[594]*Hs[82] + G2sp[834]*Hs[83] + G2sp[1074]*Hs[84] + G2sp[1314]*Hs[85] + G2sp[1554]*Hs[86] + G2sp[1794]*Hs[87]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[71]*(G2sp[116]*Hs[80] + G2sp[356]*Hs[81] + G2sp[596]*Hs[82] + G2sp[836]*Hs[83] + G2sp[1076]*Hs[84] + G2sp[1316]*Hs[85] + G2sp[1556]*Hs[86] + G2sp[1796]*Hs[87]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[71]*(G2sp[120]*Hs[80] + G2sp[360]*Hs[81] + G2sp[600]*Hs[82] + G2sp[840]*Hs[83] + G2sp[1080]*Hs[84] + G2sp[1320]*Hs[85] + G2sp[1560]*Hs[86] + G2sp[1800]*Hs[87]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*(Gsp[1]*Hs[80] + Gsp[17]*Hs[81] + Gsp[33]*Hs[82] + Gsp[49]*Hs[83] + Gsp[65]*Hs[84] + Gsp[81]*Hs[85] + Gsp[97]*Hs[86] + Gsp[113]*Hs[87]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[66]*(Gsp[1]*Hs[80] + Gsp[17]*Hs[81] + Gsp[33]*Hs[82] + Gsp[49]*Hs[83] + Gsp[65]*Hs[84] + Gsp[81]*Hs[85] + Gsp[97]*Hs[86] + Gsp[113]*Hs[87]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[67]*(Gsp[1]*Hs[80] + Gsp[17]*Hs[81] + Gsp[33]*Hs[82] + Gsp[49]*Hs[83] + Gsp[65]*Hs[84] + Gsp[81]*Hs[85] + Gsp[97]*Hs[86] + Gsp[113]*Hs[87]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*(Gsp[1]*Hs[80] + Gsp[17]*Hs[81] + Gsp[33]*Hs[82] + Gsp[49]*Hs[83] + Gsp[65]*Hs[84] + Gsp[81]*Hs[85] + Gsp[97]*Hs[86] + Gsp[113]*Hs[87]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*(Gsp[1]*Hs[80] + Gsp[17]*Hs[81] + Gsp[33]*Hs[82] + Gsp[49]*Hs[83] + Gsp[65]*Hs[84] + Gsp[81]*Hs[85] + Gsp[97]*Hs[86] + Gsp[113]*Hs[87]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*(Gsp[2]*Hs[80] + Gsp[18]*Hs[81] + Gsp[34]*Hs[82] + Gsp[50]*Hs[83] + Gsp[66]*Hs[84] + Gsp[82]*Hs[85] + Gsp[98]*Hs[86] + Gsp[114]*Hs[87]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[66]*(Gsp[2]*Hs[80] + Gsp[18]*Hs[81] + Gsp[34]*Hs[82] + Gsp[50]*Hs[83] + Gsp[66]*Hs[84] + Gsp[82]*Hs[85] + Gsp[98]*Hs[86] + Gsp[114]*Hs[87]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[67]*(Gsp[2]*Hs[80] + Gsp[18]*Hs[81] + Gsp[34]*Hs[82] + Gsp[50]*Hs[83] + Gsp[66]*Hs[84] + Gsp[82]*Hs[85] + Gsp[98]*Hs[86] + Gsp[114]*Hs[87]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*(Gsp[2]*Hs[80] + Gsp[18]*Hs[81] + Gsp[34]*Hs[82] + Gsp[50]*Hs[83] + Gsp[66]*Hs[84] + Gsp[82]*Hs[85] + Gsp[98]*Hs[86] + Gsp[114]*Hs[87]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*(Gsp[2]*Hs[80] + Gsp[18]*Hs[81] + Gsp[34]*Hs[82] + Gsp[50]*Hs[83] + Gsp[66]*Hs[84] + Gsp[82]*Hs[85] + Gsp[98]*Hs[86] + Gsp[114]*Hs[87]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[64]*((-1 + Gsp[4])*Hs[80] + Gsp[20]*Hs[81] + Gsp[36]*Hs[82] + (rrhoz + Gsp[52])*Hs[83] + Gsp[68]*Hs[84] + Gsp[84]*Hs[85] + Gsp[100]*Hs[86] + Gsp[116]*Hs[87]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])*((-1 + Gsp[4])*Hs[80] + Gsp[20]*Hs[81] + Gsp[36]*Hs[82] + (rrhoz + Gsp[52])*Hs[83] + Gsp[68]*Hs[84] + Gsp[84]*Hs[85] + Gsp[100]*Hs[86] + Gsp[116]*Hs[87]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])*(Gsp[4]*Hs[80] + Gsp[20]*Hs[81] + Gsp[36]*Hs[82] + (rrhoz + Gsp[52])*Hs[83] + Gsp[68]*Hs[84] + Gsp[84]*Hs[85] + Gsp[100]*Hs[86] + Gsp[116]*Hs[87]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[67]*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[64] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71]))*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[67]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[80] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[82] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[83] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[80] + Gsp[17]*Hs[81] + Gsp[33]*Hs[82] + Gsp[49]*Hs[83] + Gsp[65]*Hs[84] + Gsp[81]*Hs[85] + Gsp[97]*Hs[86] + Gsp[113]*Hs[87]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[80] + Gsp[18]*Hs[81] + Gsp[34]*Hs[82] + Gsp[50]*Hs[83] + Gsp[66]*Hs[84] + Gsp[82]*Hs[85] + Gsp[98]*Hs[86] + Gsp[114]*Hs[87]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[80] + Gsp[20]*Hs[81] + Gsp[36]*Hs[82] + (rrhoz + Gsp[52])*Hs[83] + Gsp[68]*Hs[84] + Gsp[84]*Hs[85] + Gsp[100]*Hs[86] + Gsp[116]*Hs[87])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[80] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[82] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[83] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[80] + Gsp[17]*Hs[81] + Gsp[33]*Hs[82] + Gsp[49]*Hs[83] + Gsp[65]*Hs[84] + Gsp[81]*Hs[85] + Gsp[97]*Hs[86] + Gsp[113]*Hs[87]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[80] + Gsp[18]*Hs[81] + Gsp[34]*Hs[82] + Gsp[50]*Hs[83] + Gsp[66]*Hs[84] + Gsp[82]*Hs[85] + Gsp[98]*Hs[86] + Gsp[114]*Hs[87]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[80] + Gsp[20]*Hs[81] + Gsp[36]*Hs[82] + (rrhoz + Gsp[52])*Hs[83] + Gsp[68]*Hs[84] + Gsp[84]*Hs[85] + Gsp[100]*Hs[86] + Gsp[116]*Hs[87])))/pow(zbar,rrho) - kkappa*Pssp*Gs[134]*Gs[166]*yss[9] + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(pow(E,yss[8])*Gs[136] - kkappa*Gs[137] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[67])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[64] + Hs[67]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[64] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])))/pow(zbar,rrho) - kkappa*Gs[134]*yss[9]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(E,yss[8])*Gs[168] - kkappa*Gs[169] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[83])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[80] + Hs[83]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[80] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[82] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[83] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[80] + Gsp[17]*Hs[81] + Gsp[33]*Hs[82] + Gsp[49]*Hs[83] + Gsp[65]*Hs[84] + Gsp[81]*Hs[85] + Gsp[97]*Hs[86] + Gsp[113]*Hs[87]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[80] + Gsp[18]*Hs[81] + Gsp[34]*Hs[82] + Gsp[50]*Hs[83] + Gsp[66]*Hs[84] + Gsp[82]*Hs[85] + Gsp[98]*Hs[86] + Gsp[114]*Hs[87]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[80] + Gsp[20]*Hs[81] + Gsp[36]*Hs[82] + (rrhoz + Gsp[52])*Hs[83] + Gsp[68]*Hs[84] + Gsp[84]*Hs[85] + Gsp[100]*Hs[86] + Gsp[116]*Hs[87])))/pow(zbar,rrho) - kkappa*Gs[166]*yss[9]);
	Nee_sp_s[53]=-(Pssp*Gs[134]*Gs[166]) + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(-Gs[134] + iiota*zbar*(Hs[64] + Hs[67])) + iiota*Pssp*zbar*(Hs[64] + Hs[67])*(Hs[80] + Hs[83]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-Gs[166] + iiota*zbar*(Hs[80] + Hs[83]));
	Nee_sp_s[54]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[129]*Gs[161] - pow(E,yss[7])*Pssp*Gs[135]*Gs[167] + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[161] - pow(E,yss[7])*Gs[167]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[129] - pow(E,yss[7])*Gs[135])*(dP2ssp*Gs[169] + dP1ssp*Gs[170]);
	Nee_sp_s[55]=-(pow(E,yss[0])*Pssp*Gs[128]*Gs[160]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[161] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[161] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[162] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[162] - pow(E,yss[3])*Pssp*Gs[131]*Gs[163] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Hs[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[162]*Hs[66] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Hs[67] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[162]*Hs[67] - pphi*Pssp*Gs[165]*(pow(E,yss[1] + yss[7])*(Gs[129] + Gs[135]) + pow(E,yss[2])*pbar*(Gs[130] + Hs[68])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[82] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[82] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[82] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[83] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[83] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[83] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[83] - pow(E,yss[2])*pbar*Pssp*(Gs[130] + Hs[68])*(Gs[162] + Hs[84]) - pphi*Pssp*Gs[133]*(pow(E,yss[1] + yss[7])*(Gs[161] + Gs[167]) + pow(E,yss[2])*pbar*(Gs[162] + Hs[84])) - pow(E,yss[11])*ebar*Pssp*Hs[70]*Hs[86] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[129] + Gs[135])*(Gs[161] + Gs[167])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[130] + Hs[68])*(Gs[162] + Hs[84])*yss[5] - (2*Pssp*zbar*Gs[133]*Gs[165]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[165]*Hs[65])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[133]*Hs[81])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[165]*Hs[67]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[133]*Hs[83]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[67]*Hs[81])/(1 + yss[5]) - (Pssp*zbar*Hs[65]*Hs[83])/(1 + yss[5]) - (Pssp*zbar*Hs[67]*Hs[83]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(-(pow(E,yss[0])*Gs[128]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[129] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[130] - pow(E,yss[3])*Gs[131] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[133] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[67] - pow(E,yss[2])*pbar*(Gs[130] + Hs[68]) - pow(E,yss[11])*ebar*Hs[70] - pphi*(pow(E,yss[1] + yss[7])*(Gs[129] + Gs[135]) + pow(E,yss[2])*pbar*(Gs[130] + Hs[68]))*yss[5] + (zbar*Gs[133]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[65])/(1 + yss[5]) - (zbar*Hs[67]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(pow(E,yss[0])*Gs[160]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[161] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[162] - pow(E,yss[3])*Gs[163] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[165] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[82] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[83] - pow(E,yss[2])*pbar*(Gs[162] + Hs[84]) - pow(E,yss[11])*ebar*Hs[86] - pphi*(pow(E,yss[1] + yss[7])*(Gs[161] + Gs[167]) + pow(E,yss[2])*pbar*(Gs[162] + Hs[84]))*yss[5] + (zbar*Gs[165]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[81])/(1 + yss[5]) - (zbar*Hs[83]*xss[1])/(1 + yss[5]));
	Nee_sp_s[56]=pow(E,yss[3])*Pssp*Gs[131]*Gs[163] + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(pow(E,yss[3])*Gs[131] - pow(E,xss[0])*zbar*(Hs[64] + Hs[67])) - pow(E,xss[0])*Pssp*zbar*(Hs[64] + Hs[67])*(Hs[80] + Hs[83]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[64] + Hs[67])*(Hs[80] + Hs[83]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(E,yss[3])*Gs[163] - pow(E,xss[0])*zbar*(Hs[80] + Hs[83]));
	Nee_sp_s[57]=-(pphi*Pssp*Gs[165]*(pow(E,yss[1] + yss[7])*(Gs[129] + Gs[135]) + pow(E,yss[2])*pbar*(Gs[130] + Hs[68]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[134] + Hs[64] + Hs[67])*(Gs[166] + Hs[80] + Hs[83]) - pphi*Pssp*Gs[133]*(pow(E,yss[1] + yss[7])*(Gs[161] + Gs[167]) + pow(E,yss[2])*pbar*(Gs[162] + Hs[84])) + (2*Pssp*zbar*Gs[133]*Gs[165]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[165]*Hs[65])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[133]*Hs[81])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[165]*Hs[67]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[133]*Hs[83]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[67]*Hs[81])/(1 + yss[5]) + (Pssp*zbar*Hs[65]*Hs[83])/(1 + yss[5]) + (Pssp*zbar*Hs[67]*Hs[83]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[129] + Gs[135])*(Gs[161] + Gs[167])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[130] + Hs[68])*(Gs[162] + Hs[84])*(1 + yss[5]) + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[133]) - Gs[138] + pow(E,xss[0])*kkappa*zbar*(Gs[134] + Hs[64] + Hs[67]) - (zbar*Gs[133]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[65])/(1 + yss[5]) + (zbar*Hs[67]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[129] + Gs[135]) + pow(E,yss[2])*pbar*(Gs[130] + Hs[68]))*(1 + yss[5])) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[165]) - Gs[170] + pow(E,xss[0])*kkappa*zbar*(Gs[166] + Hs[80] + Hs[83]) - (zbar*Gs[165]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[81])/(1 + yss[5]) + (zbar*Hs[83]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[161] + Gs[167]) + pow(E,yss[2])*pbar*(Gs[162] + Hs[84]))*(1 + yss[5]));
	Nee_sp_s[58]=((-1 + nnus)*Gs[137] + nnus*Gs[138])*(dP2ssp*Gs[169] + dP1ssp*Gs[170]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*((-1 + nnus)*Gs[169] + nnus*Gs[170]);
	Nee_sp_s[59]=(dP2ssp*Gs[169] + dP1ssp*Gs[170])*(-Gs[133] - pow(E,bbar - xss[1])*ppsir*Hs[65] + Hs[69]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[65]*Hs[81] + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-Gs[165] - pow(E,bbar - xss[1])*ppsir*Hs[81] + Hs[85]);
	Nee_sp_s[60]=pow(E,xss[0])*(-(Pssp*Gs[132]*Gs[164]) - (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(Gs[132] - Hs[64]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(Gs[164] - Hs[80]) + Pssp*Hs[64]*Hs[80]);
	Nee_sp_s[61]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[161]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[161] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[162] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[162] + pow(E,yss[11])*Pssp*Gs[139]*Gs[171] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Hs[66] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[162]*Hs[66] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[162]*Hs[67] + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[129]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[130] + pow(E,yss[11])*Gs[139] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[66] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[67] + pow(E,yss[2])*pbar*(Gs[130] + Hs[68])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[82] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[82] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[82] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[82] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[83] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[83] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[83] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[83] + pow(E,yss[2])*pbar*Pssp*(Gs[130] + Hs[68])*(Gs[162] + Hs[84]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[161]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[162] + pow(E,yss[11])*Gs[171] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[82] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[83] + pow(E,yss[2])*pbar*(Gs[162] + Hs[84]));
	Nee_sp_s[62]=(Pssp*zbar*(Gs[139] - Hs[67])*Hs[81] + Pssp*zbar*Hs[65]*(Gs[171] - Hs[83]) - Pssp*zbar*(Gs[139] - Hs[67])*(Gs[171] - Hs[83])*xss[1] + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(pow(E,yss[11])*Gs[140] - zbar*Hs[65] + zbar*(Gs[139] - Hs[67])*xss[1]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(E,yss[11])*Gs[172] - zbar*Hs[81] + zbar*(Gs[171] - Hs[83])*xss[1]))/pow(E,yss[11]);
	Nee_sp_s[63]=(-(Pssp*zbar*Hs[67]*Hs[81]) - Pssp*zbar*Hs[65]*Hs[83] - Pssp*(-1 + zbar)*Gs[139]*Gs[171]*xss[1] - Pssp*zbar*Hs[67]*Hs[83]*xss[1] + Pssp*zbar*Gs[171]*(Hs[65] + Hs[67]*xss[1]) - (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(-(pow(E,yss[11])*Gs[141]) + zbar*Hs[65] - (-1 + zbar)*Gs[139]*xss[1] + zbar*Hs[67]*xss[1]) + Pssp*zbar*Gs[139]*(Hs[81] + Hs[83]*xss[1]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(pow(E,yss[11])*Gs[173]) + zbar*Hs[81] - (-1 + zbar)*Gs[171]*xss[1] + zbar*Hs[83]*xss[1]))/pow(E,yss[11]);
	Nee_sp_s[64]=pow(E,yss[0] - yss[11])*Pssp*Gs[128]*Gs[160] + pow(E,yss[3] - yss[11])*Pssp*Gs[131]*Gs[163] - Pssp*Gs[139]*Gs[171] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[139]*Gs[171])/pow(E,yss[11]) - (Pssp*Gs[171]*(pow(E,yss[0])*Gs[128] + pow(E,yss[3])*Gs[131] - pow(E,yss[11])*Gs[139] + pow(E,yss[11])*ebar*Hs[70]))/pow(E,yss[11]) + ((dP2ssp*Gs[169] + dP1ssp*Gs[170])*(pow(E,yss[0])*Gs[128] + pow(E,yss[3])*Gs[131] - pow(E,yss[0])*Gs[139] - pow(E,yss[3])*Gs[139] - pow(E,yss[11])*ebar*Gs[139] + pow(E,yss[11])*Gs[142] + pow(E,yss[11])*ebar*Hs[70]))/pow(E,yss[11]) + ebar*Pssp*Hs[70]*Hs[86] - (Pssp*Gs[139]*(pow(E,yss[0])*Gs[160] + pow(E,yss[3])*Gs[163] - pow(E,yss[11])*Gs[171] + pow(E,yss[11])*ebar*Hs[86]))/pow(E,yss[11]) + ((dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(E,yss[0])*Gs[160] + pow(E,yss[3])*Gs[163] - pow(E,yss[0])*Gs[171] - pow(E,yss[3])*Gs[171] - pow(E,yss[11])*ebar*Gs[171] + pow(E,yss[11])*Gs[174] + pow(E,yss[11])*ebar*Hs[86]))/pow(E,yss[11]);
	Nee_sp_s[65]=(-(Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[169]*Hs[67]) + Pssp*pow(zbar,rrho)*Gs[169]*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71]) - Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[137]*Hs[83] + Pssp*pow(zbar,rrho)*Gs[137]*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87]) - Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[67]*Hs[83]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*Hs[83]*yss[9] + Pssp*pow(zbar,rrho)*Hs[64]*(G2sp[8]*Hs[80] + G2sp[24]*Hs[81] + G2sp[40]*Hs[82] + G2sp[56]*Hs[83] + G2sp[72]*Hs[84] + G2sp[88]*Hs[85] + G2sp[104]*Hs[86] + G2sp[120]*Hs[87])*yss[9] + Pssp*pow(zbar,rrho)*Hs[65]*(G2sp[24]*Hs[80] + G2sp[264]*Hs[81] + G2sp[280]*Hs[82] + G2sp[296]*Hs[83] + G2sp[312]*Hs[84] + G2sp[328]*Hs[85] + G2sp[344]*Hs[86] + G2sp[360]*Hs[87])*yss[9] + Pssp*pow(zbar,rrho)*Hs[66]*(G2sp[40]*Hs[80] + G2sp[280]*Hs[81] + G2sp[520]*Hs[82] + G2sp[536]*Hs[83] + G2sp[552]*Hs[84] + G2sp[568]*Hs[85] + G2sp[584]*Hs[86] + G2sp[600]*Hs[87])*yss[9] + Pssp*pow(zbar,rrho)*Hs[67]*(G2sp[56]*Hs[80] + G2sp[296]*Hs[81] + G2sp[536]*Hs[82] + G2sp[776]*Hs[83] + G2sp[792]*Hs[84] + G2sp[808]*Hs[85] + G2sp[824]*Hs[86] + G2sp[840]*Hs[87])*yss[9] + Pssp*pow(zbar,rrho)*Hs[68]*(G2sp[72]*Hs[80] + G2sp[312]*Hs[81] + G2sp[552]*Hs[82] + G2sp[792]*Hs[83] + G2sp[1032]*Hs[84] + G2sp[1048]*Hs[85] + G2sp[1064]*Hs[86] + G2sp[1080]*Hs[87])*yss[9] + Pssp*pow(zbar,rrho)*Hs[69]*(G2sp[88]*Hs[80] + G2sp[328]*Hs[81] + G2sp[568]*Hs[82] + G2sp[808]*Hs[83] + G2sp[1048]*Hs[84] + G2sp[1288]*Hs[85] + G2sp[1304]*Hs[86] + G2sp[1320]*Hs[87])*yss[9] + Pssp*pow(zbar,rrho)*Hs[70]*(G2sp[104]*Hs[80] + G2sp[344]*Hs[81] + G2sp[584]*Hs[82] + G2sp[824]*Hs[83] + G2sp[1064]*Hs[84] + G2sp[1304]*Hs[85] + G2sp[1544]*Hs[86] + G2sp[1560]*Hs[87])*yss[9] + Pssp*pow(zbar,rrho)*Hs[71]*(G2sp[120]*Hs[80] + G2sp[360]*Hs[81] + G2sp[600]*Hs[82] + G2sp[840]*Hs[83] + G2sp[1080]*Hs[84] + G2sp[1320]*Hs[85] + G2sp[1560]*Hs[86] + G2sp[1800]*Hs[87])*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[67]*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87])*yss[9] - Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87])*yss[9] + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(bbeta*pow(E,yss[8])*Gs[143] + pow(zbar,rrho)*(-Gs[137] + (-(rrho*rrhoz) + Gsp[56])*Hs[67]*yss[9] + (Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*yss[9])) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(bbeta*pow(E,yss[8])*Gs[175] + pow(zbar,rrho)*(-Gs[169] + (-(rrho*rrhoz) + Gsp[56])*Hs[83]*yss[9] + (Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87])*yss[9])))/(bbeta*pow(E,yss[8]));
	Nee_sp_s[66]=(dP2ssp*Gs[169] + dP1ssp*Gs[170])*(ssigmaas - Hs[66]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[82];
	Nee_sp_s[67]=-((dP2ssp*Gs[169] + dP1ssp*Gs[170])*Hs[67]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[83];
	Nee_sp_s[68]=-((dP2ssp*Gs[169] + dP1ssp*Gs[170])*Hs[68]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(ssigmaps - Hs[84]);
	Nee_sp_s[69]=-((dP2ssp*Gs[169] + dP1ssp*Gs[170])*Hs[71]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[87];
	Nee_sp_s[70]=-((dP2ssp*Gs[169] + dP1ssp*Gs[170])*Hs[70]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[86];
	Nee_sp_s[71]=-((dP2ssp*Gs[169] + dP1ssp*Gs[170])*Hs[69]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[85];
	Nee_sp_s[72]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[128]*Gs[176]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[129]*Gs[177] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[128] - pow(pow(E,yss[1]),oomega)*Gs[129])*(pow(E,yss[0])*Gs[176] - pow(pow(E,yss[1]),oomega)*Gs[177]) - pow(E,yss[8])*Pssp*Gs[136]*Gs[184] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[176] - pow(pow(E,yss[1]),oomega)*Gs[177])*Hs[71] + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[128] - pow(pow(E,yss[1]),oomega)*Gs[129])) - pow(E,yss[8])*Gs[136] + Hs[71]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[128] - pow(pow(E,yss[1]),oomega)*Gs[129])*Hs[95] + (Pssp*Hs[71]*Hs[95])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[176] - pow(pow(E,yss[1]),oomega)*Gs[177])) - pow(E,yss[8])*Gs[184] + Hs[95]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nee_sp_s[73]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[177]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[177] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[178] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[178] - (pbar*pphi*Pssp*Gs[137]*Gs[181])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[133]*Gs[185])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Hs[66] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[178]*Hs[66] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Hs[67] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[178]*Hs[67] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[90] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[90] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[90] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[90] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[91] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[91] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[91] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[91] + (pbar*pphi*Pssp*Gs[137]*Gs[184]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[136]*Gs[185]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[136]*Gs[181]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[133]*Gs[184]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[136]*Gs[184]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[68]*Hs[92]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[92]*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[68]*(Gs[181]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[185] - Gs[184]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[129]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[130] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[66] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[67] - pbar*Hs[68]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[177]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[178] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[90] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[91] - pbar*Hs[92]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[181]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[185] - Gs[184]*yss[9])))/pow(E,yss[8]));
	Nee_sp_s[74]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[129]*Gs[177]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[177] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[177] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[178] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[178] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[137]*Gs[181] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[133]*Gs[185] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[178]*Hs[66] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Hs[67] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[178]*Hs[67] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[90] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[90] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[90] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[90] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[91] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[91] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[91] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[91] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[137]*Gs[184]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[136]*Gs[185]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[136]*Gs[181]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[133]*Gs[184]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[136]*Gs[184]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[135]*Gs[183]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[183]*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[135]*(Gs[181]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[185] - Gs[184]*yss[9])) + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[129]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[129] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[130] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[66] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[67] - pow(E,yss[7])*pphi*Gs[135]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9]))) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[177]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[177] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[178] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[90] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[91] - pow(E,yss[7])*pphi*Gs[183]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[181]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[185] - Gs[184]*yss[9])));
	Nee_sp_s[75]=-(pow(E,yss[8])*Pssp*Gs[136]*Gs[184]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[181]*Hs[67])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[181]*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[133]*Hs[91])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[133]*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[67]*Hs[91]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*Hs[91]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[64]*(G2sp[8]*Hs[88] + G2sp[24]*Hs[89] + G2sp[40]*Hs[90] + G2sp[56]*Hs[91] + G2sp[72]*Hs[92] + G2sp[88]*Hs[93] + G2sp[104]*Hs[94] + G2sp[120]*Hs[95])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[65]*(G2sp[24]*Hs[88] + G2sp[264]*Hs[89] + G2sp[280]*Hs[90] + G2sp[296]*Hs[91] + G2sp[312]*Hs[92] + G2sp[328]*Hs[93] + G2sp[344]*Hs[94] + G2sp[360]*Hs[95])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[66]*(G2sp[40]*Hs[88] + G2sp[280]*Hs[89] + G2sp[520]*Hs[90] + G2sp[536]*Hs[91] + G2sp[552]*Hs[92] + G2sp[568]*Hs[93] + G2sp[584]*Hs[94] + G2sp[600]*Hs[95])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[67]*(G2sp[56]*Hs[88] + G2sp[296]*Hs[89] + G2sp[536]*Hs[90] + G2sp[776]*Hs[91] + G2sp[792]*Hs[92] + G2sp[808]*Hs[93] + G2sp[824]*Hs[94] + G2sp[840]*Hs[95])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[68]*(G2sp[72]*Hs[88] + G2sp[312]*Hs[89] + G2sp[552]*Hs[90] + G2sp[792]*Hs[91] + G2sp[1032]*Hs[92] + G2sp[1048]*Hs[93] + G2sp[1064]*Hs[94] + G2sp[1080]*Hs[95])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[69]*(G2sp[88]*Hs[88] + G2sp[328]*Hs[89] + G2sp[568]*Hs[90] + G2sp[808]*Hs[91] + G2sp[1048]*Hs[92] + G2sp[1288]*Hs[93] + G2sp[1304]*Hs[94] + G2sp[1320]*Hs[95])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[70]*(G2sp[104]*Hs[88] + G2sp[344]*Hs[89] + G2sp[584]*Hs[90] + G2sp[824]*Hs[91] + G2sp[1064]*Hs[92] + G2sp[1304]*Hs[93] + G2sp[1544]*Hs[94] + G2sp[1560]*Hs[95])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[71]*(G2sp[120]*Hs[88] + G2sp[360]*Hs[89] + G2sp[600]*Hs[90] + G2sp[840]*Hs[91] + G2sp[1080]*Hs[92] + G2sp[1320]*Hs[93] + G2sp[1560]*Hs[94] + G2sp[1800]*Hs[95])*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[67]*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*((bbeta*pow(E,yss[8])*Gs[133])/pow(zbar,rrho) - pow(E,yss[8])*Gs[136] + Gs[137] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[67]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*((bbeta*pow(E,yss[8])*Gs[181])/pow(zbar,rrho) - pow(E,yss[8])*Gs[184] + Gs[185] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[91]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95])*(1 + yss[5]))/pow(zbar,rrho));
	Nee_sp_s[76]=-(kkappa*Pssp*Gs[137]*Gs[182]) + pow(E,yss[8])*Pssp*Gs[136]*Gs[184] - kkappa*Pssp*Gs[134]*Gs[185] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[64]*Hs[88] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*Hs[88] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[66]*Hs[88] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[67]*Hs[88] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*Hs[88] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*Hs[88] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])*Hs[88] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[64]*Hs[90] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[66]*Hs[90] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[67]*Hs[90] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*Hs[90] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*Hs[90] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[64]*Hs[91] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[66]*Hs[91] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[67]*Hs[91] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[67]*Hs[91])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*Hs[91] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*Hs[91] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*Hs[91])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[64] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71]))*Hs[91])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[136]*(Hs[88] + Hs[91]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[64] + Hs[67])*(Gs[184] + Hs[88] + Hs[91]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*(G2sp[1]*Hs[88] + G2sp[17]*Hs[89] + G2sp[33]*Hs[90] + G2sp[49]*Hs[91] + G2sp[65]*Hs[92] + G2sp[81]*Hs[93] + G2sp[97]*Hs[94] + G2sp[113]*Hs[95]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*(G2sp[2]*Hs[88] + G2sp[18]*Hs[89] + G2sp[34]*Hs[90] + G2sp[50]*Hs[91] + G2sp[66]*Hs[92] + G2sp[82]*Hs[93] + G2sp[98]*Hs[94] + G2sp[114]*Hs[95]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[64]*(G2sp[4]*Hs[88] + G2sp[20]*Hs[89] + G2sp[36]*Hs[90] + G2sp[52]*Hs[91] + G2sp[68]*Hs[92] + G2sp[84]*Hs[93] + G2sp[100]*Hs[94] + G2sp[116]*Hs[95]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[64]*(G2sp[8]*Hs[88] + G2sp[24]*Hs[89] + G2sp[40]*Hs[90] + G2sp[56]*Hs[91] + G2sp[72]*Hs[92] + G2sp[88]*Hs[93] + G2sp[104]*Hs[94] + G2sp[120]*Hs[95]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[65]*(G2sp[17]*Hs[88] + G2sp[257]*Hs[89] + G2sp[273]*Hs[90] + G2sp[289]*Hs[91] + G2sp[305]*Hs[92] + G2sp[321]*Hs[93] + G2sp[337]*Hs[94] + G2sp[353]*Hs[95]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[65]*(G2sp[18]*Hs[88] + G2sp[258]*Hs[89] + G2sp[274]*Hs[90] + G2sp[290]*Hs[91] + G2sp[306]*Hs[92] + G2sp[322]*Hs[93] + G2sp[338]*Hs[94] + G2sp[354]*Hs[95]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[65]*(G2sp[20]*Hs[88] + G2sp[260]*Hs[89] + G2sp[276]*Hs[90] + G2sp[292]*Hs[91] + G2sp[308]*Hs[92] + G2sp[324]*Hs[93] + G2sp[340]*Hs[94] + G2sp[356]*Hs[95]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[65]*(G2sp[24]*Hs[88] + G2sp[264]*Hs[89] + G2sp[280]*Hs[90] + G2sp[296]*Hs[91] + G2sp[312]*Hs[92] + G2sp[328]*Hs[93] + G2sp[344]*Hs[94] + G2sp[360]*Hs[95]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[66]*(G2sp[33]*Hs[88] + G2sp[273]*Hs[89] + G2sp[513]*Hs[90] + G2sp[529]*Hs[91] + G2sp[545]*Hs[92] + G2sp[561]*Hs[93] + G2sp[577]*Hs[94] + G2sp[593]*Hs[95]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[66]*(G2sp[34]*Hs[88] + G2sp[274]*Hs[89] + G2sp[514]*Hs[90] + G2sp[530]*Hs[91] + G2sp[546]*Hs[92] + G2sp[562]*Hs[93] + G2sp[578]*Hs[94] + G2sp[594]*Hs[95]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[66]*(G2sp[36]*Hs[88] + G2sp[276]*Hs[89] + G2sp[516]*Hs[90] + G2sp[532]*Hs[91] + G2sp[548]*Hs[92] + G2sp[564]*Hs[93] + G2sp[580]*Hs[94] + G2sp[596]*Hs[95]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[66]*(G2sp[40]*Hs[88] + G2sp[280]*Hs[89] + G2sp[520]*Hs[90] + G2sp[536]*Hs[91] + G2sp[552]*Hs[92] + G2sp[568]*Hs[93] + G2sp[584]*Hs[94] + G2sp[600]*Hs[95]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[67]*(G2sp[49]*Hs[88] + G2sp[289]*Hs[89] + G2sp[529]*Hs[90] + G2sp[769]*Hs[91] + G2sp[785]*Hs[92] + G2sp[801]*Hs[93] + G2sp[817]*Hs[94] + G2sp[833]*Hs[95]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[67]*(G2sp[50]*Hs[88] + G2sp[290]*Hs[89] + G2sp[530]*Hs[90] + G2sp[770]*Hs[91] + G2sp[786]*Hs[92] + G2sp[802]*Hs[93] + G2sp[818]*Hs[94] + G2sp[834]*Hs[95]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[67]*(G2sp[52]*Hs[88] + G2sp[292]*Hs[89] + G2sp[532]*Hs[90] + G2sp[772]*Hs[91] + G2sp[788]*Hs[92] + G2sp[804]*Hs[93] + G2sp[820]*Hs[94] + G2sp[836]*Hs[95]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[67]*(G2sp[56]*Hs[88] + G2sp[296]*Hs[89] + G2sp[536]*Hs[90] + G2sp[776]*Hs[91] + G2sp[792]*Hs[92] + G2sp[808]*Hs[93] + G2sp[824]*Hs[94] + G2sp[840]*Hs[95]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[68]*(G2sp[65]*Hs[88] + G2sp[305]*Hs[89] + G2sp[545]*Hs[90] + G2sp[785]*Hs[91] + G2sp[1025]*Hs[92] + G2sp[1041]*Hs[93] + G2sp[1057]*Hs[94] + G2sp[1073]*Hs[95]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[68]*(G2sp[66]*Hs[88] + G2sp[306]*Hs[89] + G2sp[546]*Hs[90] + G2sp[786]*Hs[91] + G2sp[1026]*Hs[92] + G2sp[1042]*Hs[93] + G2sp[1058]*Hs[94] + G2sp[1074]*Hs[95]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[68]*(G2sp[68]*Hs[88] + G2sp[308]*Hs[89] + G2sp[548]*Hs[90] + G2sp[788]*Hs[91] + G2sp[1028]*Hs[92] + G2sp[1044]*Hs[93] + G2sp[1060]*Hs[94] + G2sp[1076]*Hs[95]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[68]*(G2sp[72]*Hs[88] + G2sp[312]*Hs[89] + G2sp[552]*Hs[90] + G2sp[792]*Hs[91] + G2sp[1032]*Hs[92] + G2sp[1048]*Hs[93] + G2sp[1064]*Hs[94] + G2sp[1080]*Hs[95]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[69]*(G2sp[81]*Hs[88] + G2sp[321]*Hs[89] + G2sp[561]*Hs[90] + G2sp[801]*Hs[91] + G2sp[1041]*Hs[92] + G2sp[1281]*Hs[93] + G2sp[1297]*Hs[94] + G2sp[1313]*Hs[95]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[69]*(G2sp[82]*Hs[88] + G2sp[322]*Hs[89] + G2sp[562]*Hs[90] + G2sp[802]*Hs[91] + G2sp[1042]*Hs[92] + G2sp[1282]*Hs[93] + G2sp[1298]*Hs[94] + G2sp[1314]*Hs[95]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[69]*(G2sp[84]*Hs[88] + G2sp[324]*Hs[89] + G2sp[564]*Hs[90] + G2sp[804]*Hs[91] + G2sp[1044]*Hs[92] + G2sp[1284]*Hs[93] + G2sp[1300]*Hs[94] + G2sp[1316]*Hs[95]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[69]*(G2sp[88]*Hs[88] + G2sp[328]*Hs[89] + G2sp[568]*Hs[90] + G2sp[808]*Hs[91] + G2sp[1048]*Hs[92] + G2sp[1288]*Hs[93] + G2sp[1304]*Hs[94] + G2sp[1320]*Hs[95]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[70]*(G2sp[97]*Hs[88] + G2sp[337]*Hs[89] + G2sp[577]*Hs[90] + G2sp[817]*Hs[91] + G2sp[1057]*Hs[92] + G2sp[1297]*Hs[93] + G2sp[1537]*Hs[94] + G2sp[1553]*Hs[95]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[70]*(G2sp[98]*Hs[88] + G2sp[338]*Hs[89] + G2sp[578]*Hs[90] + G2sp[818]*Hs[91] + G2sp[1058]*Hs[92] + G2sp[1298]*Hs[93] + G2sp[1538]*Hs[94] + G2sp[1554]*Hs[95]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[70]*(G2sp[100]*Hs[88] + G2sp[340]*Hs[89] + G2sp[580]*Hs[90] + G2sp[820]*Hs[91] + G2sp[1060]*Hs[92] + G2sp[1300]*Hs[93] + G2sp[1540]*Hs[94] + G2sp[1556]*Hs[95]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[70]*(G2sp[104]*Hs[88] + G2sp[344]*Hs[89] + G2sp[584]*Hs[90] + G2sp[824]*Hs[91] + G2sp[1064]*Hs[92] + G2sp[1304]*Hs[93] + G2sp[1544]*Hs[94] + G2sp[1560]*Hs[95]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[71]*(G2sp[113]*Hs[88] + G2sp[353]*Hs[89] + G2sp[593]*Hs[90] + G2sp[833]*Hs[91] + G2sp[1073]*Hs[92] + G2sp[1313]*Hs[93] + G2sp[1553]*Hs[94] + G2sp[1793]*Hs[95]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[71]*(G2sp[114]*Hs[88] + G2sp[354]*Hs[89] + G2sp[594]*Hs[90] + G2sp[834]*Hs[91] + G2sp[1074]*Hs[92] + G2sp[1314]*Hs[93] + G2sp[1554]*Hs[94] + G2sp[1794]*Hs[95]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[71]*(G2sp[116]*Hs[88] + G2sp[356]*Hs[89] + G2sp[596]*Hs[90] + G2sp[836]*Hs[91] + G2sp[1076]*Hs[92] + G2sp[1316]*Hs[93] + G2sp[1556]*Hs[94] + G2sp[1796]*Hs[95]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[71]*(G2sp[120]*Hs[88] + G2sp[360]*Hs[89] + G2sp[600]*Hs[90] + G2sp[840]*Hs[91] + G2sp[1080]*Hs[92] + G2sp[1320]*Hs[93] + G2sp[1560]*Hs[94] + G2sp[1800]*Hs[95]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*(Gsp[1]*Hs[88] + Gsp[17]*Hs[89] + Gsp[33]*Hs[90] + Gsp[49]*Hs[91] + Gsp[65]*Hs[92] + Gsp[81]*Hs[93] + Gsp[97]*Hs[94] + Gsp[113]*Hs[95]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[66]*(Gsp[1]*Hs[88] + Gsp[17]*Hs[89] + Gsp[33]*Hs[90] + Gsp[49]*Hs[91] + Gsp[65]*Hs[92] + Gsp[81]*Hs[93] + Gsp[97]*Hs[94] + Gsp[113]*Hs[95]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[67]*(Gsp[1]*Hs[88] + Gsp[17]*Hs[89] + Gsp[33]*Hs[90] + Gsp[49]*Hs[91] + Gsp[65]*Hs[92] + Gsp[81]*Hs[93] + Gsp[97]*Hs[94] + Gsp[113]*Hs[95]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*(Gsp[1]*Hs[88] + Gsp[17]*Hs[89] + Gsp[33]*Hs[90] + Gsp[49]*Hs[91] + Gsp[65]*Hs[92] + Gsp[81]*Hs[93] + Gsp[97]*Hs[94] + Gsp[113]*Hs[95]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*(Gsp[1]*Hs[88] + Gsp[17]*Hs[89] + Gsp[33]*Hs[90] + Gsp[49]*Hs[91] + Gsp[65]*Hs[92] + Gsp[81]*Hs[93] + Gsp[97]*Hs[94] + Gsp[113]*Hs[95]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*(Gsp[2]*Hs[88] + Gsp[18]*Hs[89] + Gsp[34]*Hs[90] + Gsp[50]*Hs[91] + Gsp[66]*Hs[92] + Gsp[82]*Hs[93] + Gsp[98]*Hs[94] + Gsp[114]*Hs[95]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[66]*(Gsp[2]*Hs[88] + Gsp[18]*Hs[89] + Gsp[34]*Hs[90] + Gsp[50]*Hs[91] + Gsp[66]*Hs[92] + Gsp[82]*Hs[93] + Gsp[98]*Hs[94] + Gsp[114]*Hs[95]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[67]*(Gsp[2]*Hs[88] + Gsp[18]*Hs[89] + Gsp[34]*Hs[90] + Gsp[50]*Hs[91] + Gsp[66]*Hs[92] + Gsp[82]*Hs[93] + Gsp[98]*Hs[94] + Gsp[114]*Hs[95]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*(Gsp[2]*Hs[88] + Gsp[18]*Hs[89] + Gsp[34]*Hs[90] + Gsp[50]*Hs[91] + Gsp[66]*Hs[92] + Gsp[82]*Hs[93] + Gsp[98]*Hs[94] + Gsp[114]*Hs[95]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*(Gsp[2]*Hs[88] + Gsp[18]*Hs[89] + Gsp[34]*Hs[90] + Gsp[50]*Hs[91] + Gsp[66]*Hs[92] + Gsp[82]*Hs[93] + Gsp[98]*Hs[94] + Gsp[114]*Hs[95]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[64]*((-1 + Gsp[4])*Hs[88] + Gsp[20]*Hs[89] + Gsp[36]*Hs[90] + (rrhoz + Gsp[52])*Hs[91] + Gsp[68]*Hs[92] + Gsp[84]*Hs[93] + Gsp[100]*Hs[94] + Gsp[116]*Hs[95]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])*((-1 + Gsp[4])*Hs[88] + Gsp[20]*Hs[89] + Gsp[36]*Hs[90] + (rrhoz + Gsp[52])*Hs[91] + Gsp[68]*Hs[92] + Gsp[84]*Hs[93] + Gsp[100]*Hs[94] + Gsp[116]*Hs[95]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])*(Gsp[4]*Hs[88] + Gsp[20]*Hs[89] + Gsp[36]*Hs[90] + (rrhoz + Gsp[52])*Hs[91] + Gsp[68]*Hs[92] + Gsp[84]*Hs[93] + Gsp[100]*Hs[94] + Gsp[116]*Hs[95]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[67]*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[64] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71]))*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[67]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[88] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[90] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[91] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[88] + Gsp[17]*Hs[89] + Gsp[33]*Hs[90] + Gsp[49]*Hs[91] + Gsp[65]*Hs[92] + Gsp[81]*Hs[93] + Gsp[97]*Hs[94] + Gsp[113]*Hs[95]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[88] + Gsp[18]*Hs[89] + Gsp[34]*Hs[90] + Gsp[50]*Hs[91] + Gsp[66]*Hs[92] + Gsp[82]*Hs[93] + Gsp[98]*Hs[94] + Gsp[114]*Hs[95]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[88] + Gsp[20]*Hs[89] + Gsp[36]*Hs[90] + (rrhoz + Gsp[52])*Hs[91] + Gsp[68]*Hs[92] + Gsp[84]*Hs[93] + Gsp[100]*Hs[94] + Gsp[116]*Hs[95])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[88] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[90] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[91] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[88] + Gsp[17]*Hs[89] + Gsp[33]*Hs[90] + Gsp[49]*Hs[91] + Gsp[65]*Hs[92] + Gsp[81]*Hs[93] + Gsp[97]*Hs[94] + Gsp[113]*Hs[95]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[88] + Gsp[18]*Hs[89] + Gsp[34]*Hs[90] + Gsp[50]*Hs[91] + Gsp[66]*Hs[92] + Gsp[82]*Hs[93] + Gsp[98]*Hs[94] + Gsp[114]*Hs[95]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[88] + Gsp[20]*Hs[89] + Gsp[36]*Hs[90] + (rrhoz + Gsp[52])*Hs[91] + Gsp[68]*Hs[92] + Gsp[84]*Hs[93] + Gsp[100]*Hs[94] + Gsp[116]*Hs[95])))/pow(zbar,rrho) - kkappa*Pssp*Gs[134]*Gs[182]*yss[9] + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(pow(E,yss[8])*Gs[136] - kkappa*Gs[137] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[67])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[64] + Hs[67]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[64] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])))/pow(zbar,rrho) - kkappa*Gs[134]*yss[9]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(E,yss[8])*Gs[184] - kkappa*Gs[185] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[91])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[88] + Hs[91]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[88] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[90] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[91] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[88] + Gsp[17]*Hs[89] + Gsp[33]*Hs[90] + Gsp[49]*Hs[91] + Gsp[65]*Hs[92] + Gsp[81]*Hs[93] + Gsp[97]*Hs[94] + Gsp[113]*Hs[95]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[88] + Gsp[18]*Hs[89] + Gsp[34]*Hs[90] + Gsp[50]*Hs[91] + Gsp[66]*Hs[92] + Gsp[82]*Hs[93] + Gsp[98]*Hs[94] + Gsp[114]*Hs[95]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[88] + Gsp[20]*Hs[89] + Gsp[36]*Hs[90] + (rrhoz + Gsp[52])*Hs[91] + Gsp[68]*Hs[92] + Gsp[84]*Hs[93] + Gsp[100]*Hs[94] + Gsp[116]*Hs[95])))/pow(zbar,rrho) - kkappa*Gs[182]*yss[9]);
	Nee_sp_s[77]=-(Pssp*Gs[134]*Gs[182]) + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(-Gs[134] + iiota*zbar*(Hs[64] + Hs[67])) + iiota*Pssp*zbar*(Hs[64] + Hs[67])*(Hs[88] + Hs[91]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-Gs[182] + iiota*zbar*(Hs[88] + Hs[91]));
	Nee_sp_s[78]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[129]*Gs[177] - pow(E,yss[7])*Pssp*Gs[135]*Gs[183] + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[177] - pow(E,yss[7])*Gs[183]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[129] - pow(E,yss[7])*Gs[135])*(dP2ssp*Gs[185] + dP1ssp*Gs[186]);
	Nee_sp_s[79]=-(pow(E,yss[0])*Pssp*Gs[128]*Gs[176]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[177] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[177] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[178] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[178] - pow(E,yss[3])*Pssp*Gs[131]*Gs[179] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Hs[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[178]*Hs[66] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Hs[67] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[178]*Hs[67] - pphi*Pssp*Gs[181]*(pow(E,yss[1] + yss[7])*(Gs[129] + Gs[135]) + pow(E,yss[2])*pbar*(Gs[130] + Hs[68])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[90] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[90] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[90] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[90] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[91] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[91] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[91] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[91] - pow(E,yss[2])*pbar*Pssp*(Gs[130] + Hs[68])*(Gs[178] + Hs[92]) - pphi*Pssp*Gs[133]*(pow(E,yss[1] + yss[7])*(Gs[177] + Gs[183]) + pow(E,yss[2])*pbar*(Gs[178] + Hs[92])) - pow(E,yss[11])*ebar*Pssp*Hs[70]*Hs[94] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[129] + Gs[135])*(Gs[177] + Gs[183])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[130] + Hs[68])*(Gs[178] + Hs[92])*yss[5] - (2*Pssp*zbar*Gs[133]*Gs[181]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[181]*Hs[65])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[133]*Hs[89])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[181]*Hs[67]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[133]*Hs[91]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[67]*Hs[89])/(1 + yss[5]) - (Pssp*zbar*Hs[65]*Hs[91])/(1 + yss[5]) - (Pssp*zbar*Hs[67]*Hs[91]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(-(pow(E,yss[0])*Gs[128]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[129] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[130] - pow(E,yss[3])*Gs[131] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[133] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[67] - pow(E,yss[2])*pbar*(Gs[130] + Hs[68]) - pow(E,yss[11])*ebar*Hs[70] - pphi*(pow(E,yss[1] + yss[7])*(Gs[129] + Gs[135]) + pow(E,yss[2])*pbar*(Gs[130] + Hs[68]))*yss[5] + (zbar*Gs[133]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[65])/(1 + yss[5]) - (zbar*Hs[67]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(pow(E,yss[0])*Gs[176]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[177] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[178] - pow(E,yss[3])*Gs[179] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[181] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[90] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[91] - pow(E,yss[2])*pbar*(Gs[178] + Hs[92]) - pow(E,yss[11])*ebar*Hs[94] - pphi*(pow(E,yss[1] + yss[7])*(Gs[177] + Gs[183]) + pow(E,yss[2])*pbar*(Gs[178] + Hs[92]))*yss[5] + (zbar*Gs[181]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[89])/(1 + yss[5]) - (zbar*Hs[91]*xss[1])/(1 + yss[5]));
	Nee_sp_s[80]=pow(E,yss[3])*Pssp*Gs[131]*Gs[179] + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(pow(E,yss[3])*Gs[131] - pow(E,xss[0])*zbar*(Hs[64] + Hs[67])) - pow(E,xss[0])*Pssp*zbar*(Hs[64] + Hs[67])*(Hs[88] + Hs[91]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[64] + Hs[67])*(Hs[88] + Hs[91]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(E,yss[3])*Gs[179] - pow(E,xss[0])*zbar*(Hs[88] + Hs[91]));
	Nee_sp_s[81]=-(pphi*Pssp*Gs[181]*(pow(E,yss[1] + yss[7])*(Gs[129] + Gs[135]) + pow(E,yss[2])*pbar*(Gs[130] + Hs[68]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[134] + Hs[64] + Hs[67])*(Gs[182] + Hs[88] + Hs[91]) - pphi*Pssp*Gs[133]*(pow(E,yss[1] + yss[7])*(Gs[177] + Gs[183]) + pow(E,yss[2])*pbar*(Gs[178] + Hs[92])) + (2*Pssp*zbar*Gs[133]*Gs[181]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[181]*Hs[65])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[133]*Hs[89])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[181]*Hs[67]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[133]*Hs[91]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[67]*Hs[89])/(1 + yss[5]) + (Pssp*zbar*Hs[65]*Hs[91])/(1 + yss[5]) + (Pssp*zbar*Hs[67]*Hs[91]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[129] + Gs[135])*(Gs[177] + Gs[183])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[130] + Hs[68])*(Gs[178] + Hs[92])*(1 + yss[5]) + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[133]) - Gs[138] + pow(E,xss[0])*kkappa*zbar*(Gs[134] + Hs[64] + Hs[67]) - (zbar*Gs[133]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[65])/(1 + yss[5]) + (zbar*Hs[67]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[129] + Gs[135]) + pow(E,yss[2])*pbar*(Gs[130] + Hs[68]))*(1 + yss[5])) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[181]) - Gs[186] + pow(E,xss[0])*kkappa*zbar*(Gs[182] + Hs[88] + Hs[91]) - (zbar*Gs[181]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[89])/(1 + yss[5]) + (zbar*Hs[91]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[177] + Gs[183]) + pow(E,yss[2])*pbar*(Gs[178] + Hs[92]))*(1 + yss[5]));
	Nee_sp_s[82]=((-1 + nnus)*Gs[137] + nnus*Gs[138])*(dP2ssp*Gs[185] + dP1ssp*Gs[186]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*((-1 + nnus)*Gs[185] + nnus*Gs[186]);
	Nee_sp_s[83]=(dP2ssp*Gs[185] + dP1ssp*Gs[186])*(-Gs[133] - pow(E,bbar - xss[1])*ppsir*Hs[65] + Hs[69]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[65]*Hs[89] + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-Gs[181] - pow(E,bbar - xss[1])*ppsir*Hs[89] + Hs[93]);
	Nee_sp_s[84]=pow(E,xss[0])*(-(Pssp*Gs[132]*Gs[180]) - (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(Gs[132] - Hs[64]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(Gs[180] - Hs[88]) + Pssp*Hs[64]*Hs[88]);
	Nee_sp_s[85]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[177]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[177] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[178] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[178] + pow(E,yss[11])*Pssp*Gs[139]*Gs[187] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Hs[66] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[178]*Hs[66] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[178]*Hs[67] + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[129]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[130] + pow(E,yss[11])*Gs[139] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[66] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[67] + pow(E,yss[2])*pbar*(Gs[130] + Hs[68])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[90] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[90] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[90] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[90] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[91] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[91] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[91] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[91] + pow(E,yss[2])*pbar*Pssp*(Gs[130] + Hs[68])*(Gs[178] + Hs[92]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[177]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[178] + pow(E,yss[11])*Gs[187] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[90] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[91] + pow(E,yss[2])*pbar*(Gs[178] + Hs[92]));
	Nee_sp_s[86]=(Pssp*zbar*(Gs[139] - Hs[67])*Hs[89] + Pssp*zbar*Hs[65]*(Gs[187] - Hs[91]) - Pssp*zbar*(Gs[139] - Hs[67])*(Gs[187] - Hs[91])*xss[1] + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(pow(E,yss[11])*Gs[140] - zbar*Hs[65] + zbar*(Gs[139] - Hs[67])*xss[1]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(E,yss[11])*Gs[188] - zbar*Hs[89] + zbar*(Gs[187] - Hs[91])*xss[1]))/pow(E,yss[11]);
	Nee_sp_s[87]=(-(Pssp*zbar*Hs[67]*Hs[89]) - Pssp*zbar*Hs[65]*Hs[91] - Pssp*(-1 + zbar)*Gs[139]*Gs[187]*xss[1] - Pssp*zbar*Hs[67]*Hs[91]*xss[1] + Pssp*zbar*Gs[187]*(Hs[65] + Hs[67]*xss[1]) - (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(-(pow(E,yss[11])*Gs[141]) + zbar*Hs[65] - (-1 + zbar)*Gs[139]*xss[1] + zbar*Hs[67]*xss[1]) + Pssp*zbar*Gs[139]*(Hs[89] + Hs[91]*xss[1]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(pow(E,yss[11])*Gs[189]) + zbar*Hs[89] - (-1 + zbar)*Gs[187]*xss[1] + zbar*Hs[91]*xss[1]))/pow(E,yss[11]);
	Nee_sp_s[88]=pow(E,yss[0] - yss[11])*Pssp*Gs[128]*Gs[176] + pow(E,yss[3] - yss[11])*Pssp*Gs[131]*Gs[179] - Pssp*Gs[139]*Gs[187] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[139]*Gs[187])/pow(E,yss[11]) - (Pssp*Gs[187]*(pow(E,yss[0])*Gs[128] + pow(E,yss[3])*Gs[131] - pow(E,yss[11])*Gs[139] + pow(E,yss[11])*ebar*Hs[70]))/pow(E,yss[11]) + ((dP2ssp*Gs[185] + dP1ssp*Gs[186])*(pow(E,yss[0])*Gs[128] + pow(E,yss[3])*Gs[131] - pow(E,yss[0])*Gs[139] - pow(E,yss[3])*Gs[139] - pow(E,yss[11])*ebar*Gs[139] + pow(E,yss[11])*Gs[142] + pow(E,yss[11])*ebar*Hs[70]))/pow(E,yss[11]) + ebar*Pssp*Hs[70]*Hs[94] - (Pssp*Gs[139]*(pow(E,yss[0])*Gs[176] + pow(E,yss[3])*Gs[179] - pow(E,yss[11])*Gs[187] + pow(E,yss[11])*ebar*Hs[94]))/pow(E,yss[11]) + ((dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(E,yss[0])*Gs[176] + pow(E,yss[3])*Gs[179] - pow(E,yss[0])*Gs[187] - pow(E,yss[3])*Gs[187] - pow(E,yss[11])*ebar*Gs[187] + pow(E,yss[11])*Gs[190] + pow(E,yss[11])*ebar*Hs[94]))/pow(E,yss[11]);
	Nee_sp_s[89]=(-(Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[185]*Hs[67]) + Pssp*pow(zbar,rrho)*Gs[185]*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71]) - Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[137]*Hs[91] + Pssp*pow(zbar,rrho)*Gs[137]*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95]) - Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[67]*Hs[91]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*Hs[91]*yss[9] + Pssp*pow(zbar,rrho)*Hs[64]*(G2sp[8]*Hs[88] + G2sp[24]*Hs[89] + G2sp[40]*Hs[90] + G2sp[56]*Hs[91] + G2sp[72]*Hs[92] + G2sp[88]*Hs[93] + G2sp[104]*Hs[94] + G2sp[120]*Hs[95])*yss[9] + Pssp*pow(zbar,rrho)*Hs[65]*(G2sp[24]*Hs[88] + G2sp[264]*Hs[89] + G2sp[280]*Hs[90] + G2sp[296]*Hs[91] + G2sp[312]*Hs[92] + G2sp[328]*Hs[93] + G2sp[344]*Hs[94] + G2sp[360]*Hs[95])*yss[9] + Pssp*pow(zbar,rrho)*Hs[66]*(G2sp[40]*Hs[88] + G2sp[280]*Hs[89] + G2sp[520]*Hs[90] + G2sp[536]*Hs[91] + G2sp[552]*Hs[92] + G2sp[568]*Hs[93] + G2sp[584]*Hs[94] + G2sp[600]*Hs[95])*yss[9] + Pssp*pow(zbar,rrho)*Hs[67]*(G2sp[56]*Hs[88] + G2sp[296]*Hs[89] + G2sp[536]*Hs[90] + G2sp[776]*Hs[91] + G2sp[792]*Hs[92] + G2sp[808]*Hs[93] + G2sp[824]*Hs[94] + G2sp[840]*Hs[95])*yss[9] + Pssp*pow(zbar,rrho)*Hs[68]*(G2sp[72]*Hs[88] + G2sp[312]*Hs[89] + G2sp[552]*Hs[90] + G2sp[792]*Hs[91] + G2sp[1032]*Hs[92] + G2sp[1048]*Hs[93] + G2sp[1064]*Hs[94] + G2sp[1080]*Hs[95])*yss[9] + Pssp*pow(zbar,rrho)*Hs[69]*(G2sp[88]*Hs[88] + G2sp[328]*Hs[89] + G2sp[568]*Hs[90] + G2sp[808]*Hs[91] + G2sp[1048]*Hs[92] + G2sp[1288]*Hs[93] + G2sp[1304]*Hs[94] + G2sp[1320]*Hs[95])*yss[9] + Pssp*pow(zbar,rrho)*Hs[70]*(G2sp[104]*Hs[88] + G2sp[344]*Hs[89] + G2sp[584]*Hs[90] + G2sp[824]*Hs[91] + G2sp[1064]*Hs[92] + G2sp[1304]*Hs[93] + G2sp[1544]*Hs[94] + G2sp[1560]*Hs[95])*yss[9] + Pssp*pow(zbar,rrho)*Hs[71]*(G2sp[120]*Hs[88] + G2sp[360]*Hs[89] + G2sp[600]*Hs[90] + G2sp[840]*Hs[91] + G2sp[1080]*Hs[92] + G2sp[1320]*Hs[93] + G2sp[1560]*Hs[94] + G2sp[1800]*Hs[95])*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[67]*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95])*yss[9] - Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95])*yss[9] + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(bbeta*pow(E,yss[8])*Gs[143] + pow(zbar,rrho)*(-Gs[137] + (-(rrho*rrhoz) + Gsp[56])*Hs[67]*yss[9] + (Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*yss[9])) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(bbeta*pow(E,yss[8])*Gs[191] + pow(zbar,rrho)*(-Gs[185] + (-(rrho*rrhoz) + Gsp[56])*Hs[91]*yss[9] + (Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95])*yss[9])))/(bbeta*pow(E,yss[8]));
	Nee_sp_s[90]=(dP2ssp*Gs[185] + dP1ssp*Gs[186])*(ssigmaas - Hs[66]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[90];
	Nee_sp_s[91]=-((dP2ssp*Gs[185] + dP1ssp*Gs[186])*Hs[67]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[91];
	Nee_sp_s[92]=-((dP2ssp*Gs[185] + dP1ssp*Gs[186])*Hs[68]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[92];
	Nee_sp_s[93]=-((dP2ssp*Gs[185] + dP1ssp*Gs[186])*Hs[71]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[95];
	Nee_sp_s[94]=-((dP2ssp*Gs[185] + dP1ssp*Gs[186])*Hs[70]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[94];
	Nee_sp_s[95]=-((dP2ssp*Gs[185] + dP1ssp*Gs[186])*Hs[69]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(ssigmars - Hs[93]);
	Nee_sp_s[96]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[128]*Gs[192]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[129]*Gs[193] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[128] - pow(pow(E,yss[1]),oomega)*Gs[129])*(pow(E,yss[0])*Gs[192] - pow(pow(E,yss[1]),oomega)*Gs[193]) - pow(E,yss[8])*Pssp*Gs[136]*Gs[200] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[192] - pow(pow(E,yss[1]),oomega)*Gs[193])*Hs[71] + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[128] - pow(pow(E,yss[1]),oomega)*Gs[129])) - pow(E,yss[8])*Gs[136] + Hs[71]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[128] - pow(pow(E,yss[1]),oomega)*Gs[129])*Hs[103] + (Pssp*Hs[71]*Hs[103])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[192] - pow(pow(E,yss[1]),oomega)*Gs[193])) - pow(E,yss[8])*Gs[200] + Hs[103]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nee_sp_s[97]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[193]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[193] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[194] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[194] - (pbar*pphi*Pssp*Gs[137]*Gs[197])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[133]*Gs[201])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[193]*Hs[66] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[194]*Hs[66] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[193]*Hs[67] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[194]*Hs[67] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[98] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[98] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[98] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[98] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[99] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[99] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[99] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[99] + (pbar*pphi*Pssp*Gs[137]*Gs[200]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[136]*Gs[201]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[136]*Gs[197]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[133]*Gs[200]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[136]*Gs[200]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[68]*Hs[100]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[100]*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[68]*(Gs[197]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[201] - Gs[200]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[129]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[130] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[66] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[67] - pbar*Hs[68]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[193]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[194] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[98] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[99] - pbar*Hs[100]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[197]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[201] - Gs[200]*yss[9])))/pow(E,yss[8]));
	Nee_sp_s[98]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[129]*Gs[193]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[193] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[193] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[194] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[194] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[137]*Gs[197] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[133]*Gs[201] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[193]*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[194]*Hs[66] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[193]*Hs[67] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[194]*Hs[67] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[98] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[98] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[98] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[98] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[99] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[99] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[99] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[99] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[137]*Gs[200]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[136]*Gs[201]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[136]*Gs[197]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[133]*Gs[200]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[136]*Gs[200]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[135]*Gs[199]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[199]*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[135]*(Gs[197]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[201] - Gs[200]*yss[9])) + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[129]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[129] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[130] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[66] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[67] - pow(E,yss[7])*pphi*Gs[135]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9]))) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[193]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[193] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[194] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[98] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[99] - pow(E,yss[7])*pphi*Gs[199]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[197]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[201] - Gs[200]*yss[9])));
	Nee_sp_s[99]=-(pow(E,yss[8])*Pssp*Gs[136]*Gs[200]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[197]*Hs[67])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[197]*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[133]*Hs[99])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[133]*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[67]*Hs[99]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*Hs[99]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[64]*(G2sp[8]*Hs[96] + G2sp[24]*Hs[97] + G2sp[40]*Hs[98] + G2sp[56]*Hs[99] + G2sp[72]*Hs[100] + G2sp[88]*Hs[101] + G2sp[104]*Hs[102] + G2sp[120]*Hs[103])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[65]*(G2sp[24]*Hs[96] + G2sp[264]*Hs[97] + G2sp[280]*Hs[98] + G2sp[296]*Hs[99] + G2sp[312]*Hs[100] + G2sp[328]*Hs[101] + G2sp[344]*Hs[102] + G2sp[360]*Hs[103])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[66]*(G2sp[40]*Hs[96] + G2sp[280]*Hs[97] + G2sp[520]*Hs[98] + G2sp[536]*Hs[99] + G2sp[552]*Hs[100] + G2sp[568]*Hs[101] + G2sp[584]*Hs[102] + G2sp[600]*Hs[103])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[67]*(G2sp[56]*Hs[96] + G2sp[296]*Hs[97] + G2sp[536]*Hs[98] + G2sp[776]*Hs[99] + G2sp[792]*Hs[100] + G2sp[808]*Hs[101] + G2sp[824]*Hs[102] + G2sp[840]*Hs[103])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[68]*(G2sp[72]*Hs[96] + G2sp[312]*Hs[97] + G2sp[552]*Hs[98] + G2sp[792]*Hs[99] + G2sp[1032]*Hs[100] + G2sp[1048]*Hs[101] + G2sp[1064]*Hs[102] + G2sp[1080]*Hs[103])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[69]*(G2sp[88]*Hs[96] + G2sp[328]*Hs[97] + G2sp[568]*Hs[98] + G2sp[808]*Hs[99] + G2sp[1048]*Hs[100] + G2sp[1288]*Hs[101] + G2sp[1304]*Hs[102] + G2sp[1320]*Hs[103])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[70]*(G2sp[104]*Hs[96] + G2sp[344]*Hs[97] + G2sp[584]*Hs[98] + G2sp[824]*Hs[99] + G2sp[1064]*Hs[100] + G2sp[1304]*Hs[101] + G2sp[1544]*Hs[102] + G2sp[1560]*Hs[103])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[71]*(G2sp[120]*Hs[96] + G2sp[360]*Hs[97] + G2sp[600]*Hs[98] + G2sp[840]*Hs[99] + G2sp[1080]*Hs[100] + G2sp[1320]*Hs[101] + G2sp[1560]*Hs[102] + G2sp[1800]*Hs[103])*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[67]*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*((bbeta*pow(E,yss[8])*Gs[133])/pow(zbar,rrho) - pow(E,yss[8])*Gs[136] + Gs[137] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[67]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*((bbeta*pow(E,yss[8])*Gs[197])/pow(zbar,rrho) - pow(E,yss[8])*Gs[200] + Gs[201] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[99]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103])*(1 + yss[5]))/pow(zbar,rrho));
	Nee_sp_s[100]=-(kkappa*Pssp*Gs[137]*Gs[198]) + pow(E,yss[8])*Pssp*Gs[136]*Gs[200] - kkappa*Pssp*Gs[134]*Gs[201] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[64]*Hs[96] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*Hs[96] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[66]*Hs[96] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[67]*Hs[96] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*Hs[96] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*Hs[96] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])*Hs[96] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[64]*Hs[98] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[66]*Hs[98] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[67]*Hs[98] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*Hs[98] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*Hs[98] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[64]*Hs[99] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[66]*Hs[99] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[67]*Hs[99] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[67]*Hs[99])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*Hs[99] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*Hs[99] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*Hs[99])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[64] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71]))*Hs[99])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[136]*(Hs[96] + Hs[99]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[64] + Hs[67])*(Gs[200] + Hs[96] + Hs[99]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*(G2sp[1]*Hs[96] + G2sp[17]*Hs[97] + G2sp[33]*Hs[98] + G2sp[49]*Hs[99] + G2sp[65]*Hs[100] + G2sp[81]*Hs[101] + G2sp[97]*Hs[102] + G2sp[113]*Hs[103]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*(G2sp[2]*Hs[96] + G2sp[18]*Hs[97] + G2sp[34]*Hs[98] + G2sp[50]*Hs[99] + G2sp[66]*Hs[100] + G2sp[82]*Hs[101] + G2sp[98]*Hs[102] + G2sp[114]*Hs[103]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[64]*(G2sp[4]*Hs[96] + G2sp[20]*Hs[97] + G2sp[36]*Hs[98] + G2sp[52]*Hs[99] + G2sp[68]*Hs[100] + G2sp[84]*Hs[101] + G2sp[100]*Hs[102] + G2sp[116]*Hs[103]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[64]*(G2sp[8]*Hs[96] + G2sp[24]*Hs[97] + G2sp[40]*Hs[98] + G2sp[56]*Hs[99] + G2sp[72]*Hs[100] + G2sp[88]*Hs[101] + G2sp[104]*Hs[102] + G2sp[120]*Hs[103]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[65]*(G2sp[17]*Hs[96] + G2sp[257]*Hs[97] + G2sp[273]*Hs[98] + G2sp[289]*Hs[99] + G2sp[305]*Hs[100] + G2sp[321]*Hs[101] + G2sp[337]*Hs[102] + G2sp[353]*Hs[103]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[65]*(G2sp[18]*Hs[96] + G2sp[258]*Hs[97] + G2sp[274]*Hs[98] + G2sp[290]*Hs[99] + G2sp[306]*Hs[100] + G2sp[322]*Hs[101] + G2sp[338]*Hs[102] + G2sp[354]*Hs[103]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[65]*(G2sp[20]*Hs[96] + G2sp[260]*Hs[97] + G2sp[276]*Hs[98] + G2sp[292]*Hs[99] + G2sp[308]*Hs[100] + G2sp[324]*Hs[101] + G2sp[340]*Hs[102] + G2sp[356]*Hs[103]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[65]*(G2sp[24]*Hs[96] + G2sp[264]*Hs[97] + G2sp[280]*Hs[98] + G2sp[296]*Hs[99] + G2sp[312]*Hs[100] + G2sp[328]*Hs[101] + G2sp[344]*Hs[102] + G2sp[360]*Hs[103]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[66]*(G2sp[33]*Hs[96] + G2sp[273]*Hs[97] + G2sp[513]*Hs[98] + G2sp[529]*Hs[99] + G2sp[545]*Hs[100] + G2sp[561]*Hs[101] + G2sp[577]*Hs[102] + G2sp[593]*Hs[103]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[66]*(G2sp[34]*Hs[96] + G2sp[274]*Hs[97] + G2sp[514]*Hs[98] + G2sp[530]*Hs[99] + G2sp[546]*Hs[100] + G2sp[562]*Hs[101] + G2sp[578]*Hs[102] + G2sp[594]*Hs[103]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[66]*(G2sp[36]*Hs[96] + G2sp[276]*Hs[97] + G2sp[516]*Hs[98] + G2sp[532]*Hs[99] + G2sp[548]*Hs[100] + G2sp[564]*Hs[101] + G2sp[580]*Hs[102] + G2sp[596]*Hs[103]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[66]*(G2sp[40]*Hs[96] + G2sp[280]*Hs[97] + G2sp[520]*Hs[98] + G2sp[536]*Hs[99] + G2sp[552]*Hs[100] + G2sp[568]*Hs[101] + G2sp[584]*Hs[102] + G2sp[600]*Hs[103]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[67]*(G2sp[49]*Hs[96] + G2sp[289]*Hs[97] + G2sp[529]*Hs[98] + G2sp[769]*Hs[99] + G2sp[785]*Hs[100] + G2sp[801]*Hs[101] + G2sp[817]*Hs[102] + G2sp[833]*Hs[103]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[67]*(G2sp[50]*Hs[96] + G2sp[290]*Hs[97] + G2sp[530]*Hs[98] + G2sp[770]*Hs[99] + G2sp[786]*Hs[100] + G2sp[802]*Hs[101] + G2sp[818]*Hs[102] + G2sp[834]*Hs[103]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[67]*(G2sp[52]*Hs[96] + G2sp[292]*Hs[97] + G2sp[532]*Hs[98] + G2sp[772]*Hs[99] + G2sp[788]*Hs[100] + G2sp[804]*Hs[101] + G2sp[820]*Hs[102] + G2sp[836]*Hs[103]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[67]*(G2sp[56]*Hs[96] + G2sp[296]*Hs[97] + G2sp[536]*Hs[98] + G2sp[776]*Hs[99] + G2sp[792]*Hs[100] + G2sp[808]*Hs[101] + G2sp[824]*Hs[102] + G2sp[840]*Hs[103]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[68]*(G2sp[65]*Hs[96] + G2sp[305]*Hs[97] + G2sp[545]*Hs[98] + G2sp[785]*Hs[99] + G2sp[1025]*Hs[100] + G2sp[1041]*Hs[101] + G2sp[1057]*Hs[102] + G2sp[1073]*Hs[103]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[68]*(G2sp[66]*Hs[96] + G2sp[306]*Hs[97] + G2sp[546]*Hs[98] + G2sp[786]*Hs[99] + G2sp[1026]*Hs[100] + G2sp[1042]*Hs[101] + G2sp[1058]*Hs[102] + G2sp[1074]*Hs[103]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[68]*(G2sp[68]*Hs[96] + G2sp[308]*Hs[97] + G2sp[548]*Hs[98] + G2sp[788]*Hs[99] + G2sp[1028]*Hs[100] + G2sp[1044]*Hs[101] + G2sp[1060]*Hs[102] + G2sp[1076]*Hs[103]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[68]*(G2sp[72]*Hs[96] + G2sp[312]*Hs[97] + G2sp[552]*Hs[98] + G2sp[792]*Hs[99] + G2sp[1032]*Hs[100] + G2sp[1048]*Hs[101] + G2sp[1064]*Hs[102] + G2sp[1080]*Hs[103]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[69]*(G2sp[81]*Hs[96] + G2sp[321]*Hs[97] + G2sp[561]*Hs[98] + G2sp[801]*Hs[99] + G2sp[1041]*Hs[100] + G2sp[1281]*Hs[101] + G2sp[1297]*Hs[102] + G2sp[1313]*Hs[103]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[69]*(G2sp[82]*Hs[96] + G2sp[322]*Hs[97] + G2sp[562]*Hs[98] + G2sp[802]*Hs[99] + G2sp[1042]*Hs[100] + G2sp[1282]*Hs[101] + G2sp[1298]*Hs[102] + G2sp[1314]*Hs[103]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[69]*(G2sp[84]*Hs[96] + G2sp[324]*Hs[97] + G2sp[564]*Hs[98] + G2sp[804]*Hs[99] + G2sp[1044]*Hs[100] + G2sp[1284]*Hs[101] + G2sp[1300]*Hs[102] + G2sp[1316]*Hs[103]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[69]*(G2sp[88]*Hs[96] + G2sp[328]*Hs[97] + G2sp[568]*Hs[98] + G2sp[808]*Hs[99] + G2sp[1048]*Hs[100] + G2sp[1288]*Hs[101] + G2sp[1304]*Hs[102] + G2sp[1320]*Hs[103]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[70]*(G2sp[97]*Hs[96] + G2sp[337]*Hs[97] + G2sp[577]*Hs[98] + G2sp[817]*Hs[99] + G2sp[1057]*Hs[100] + G2sp[1297]*Hs[101] + G2sp[1537]*Hs[102] + G2sp[1553]*Hs[103]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[70]*(G2sp[98]*Hs[96] + G2sp[338]*Hs[97] + G2sp[578]*Hs[98] + G2sp[818]*Hs[99] + G2sp[1058]*Hs[100] + G2sp[1298]*Hs[101] + G2sp[1538]*Hs[102] + G2sp[1554]*Hs[103]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[70]*(G2sp[100]*Hs[96] + G2sp[340]*Hs[97] + G2sp[580]*Hs[98] + G2sp[820]*Hs[99] + G2sp[1060]*Hs[100] + G2sp[1300]*Hs[101] + G2sp[1540]*Hs[102] + G2sp[1556]*Hs[103]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[70]*(G2sp[104]*Hs[96] + G2sp[344]*Hs[97] + G2sp[584]*Hs[98] + G2sp[824]*Hs[99] + G2sp[1064]*Hs[100] + G2sp[1304]*Hs[101] + G2sp[1544]*Hs[102] + G2sp[1560]*Hs[103]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[71]*(G2sp[113]*Hs[96] + G2sp[353]*Hs[97] + G2sp[593]*Hs[98] + G2sp[833]*Hs[99] + G2sp[1073]*Hs[100] + G2sp[1313]*Hs[101] + G2sp[1553]*Hs[102] + G2sp[1793]*Hs[103]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[71]*(G2sp[114]*Hs[96] + G2sp[354]*Hs[97] + G2sp[594]*Hs[98] + G2sp[834]*Hs[99] + G2sp[1074]*Hs[100] + G2sp[1314]*Hs[101] + G2sp[1554]*Hs[102] + G2sp[1794]*Hs[103]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[71]*(G2sp[116]*Hs[96] + G2sp[356]*Hs[97] + G2sp[596]*Hs[98] + G2sp[836]*Hs[99] + G2sp[1076]*Hs[100] + G2sp[1316]*Hs[101] + G2sp[1556]*Hs[102] + G2sp[1796]*Hs[103]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[71]*(G2sp[120]*Hs[96] + G2sp[360]*Hs[97] + G2sp[600]*Hs[98] + G2sp[840]*Hs[99] + G2sp[1080]*Hs[100] + G2sp[1320]*Hs[101] + G2sp[1560]*Hs[102] + G2sp[1800]*Hs[103]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*(Gsp[1]*Hs[96] + Gsp[17]*Hs[97] + Gsp[33]*Hs[98] + Gsp[49]*Hs[99] + Gsp[65]*Hs[100] + Gsp[81]*Hs[101] + Gsp[97]*Hs[102] + Gsp[113]*Hs[103]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[66]*(Gsp[1]*Hs[96] + Gsp[17]*Hs[97] + Gsp[33]*Hs[98] + Gsp[49]*Hs[99] + Gsp[65]*Hs[100] + Gsp[81]*Hs[101] + Gsp[97]*Hs[102] + Gsp[113]*Hs[103]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[67]*(Gsp[1]*Hs[96] + Gsp[17]*Hs[97] + Gsp[33]*Hs[98] + Gsp[49]*Hs[99] + Gsp[65]*Hs[100] + Gsp[81]*Hs[101] + Gsp[97]*Hs[102] + Gsp[113]*Hs[103]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*(Gsp[1]*Hs[96] + Gsp[17]*Hs[97] + Gsp[33]*Hs[98] + Gsp[49]*Hs[99] + Gsp[65]*Hs[100] + Gsp[81]*Hs[101] + Gsp[97]*Hs[102] + Gsp[113]*Hs[103]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*(Gsp[1]*Hs[96] + Gsp[17]*Hs[97] + Gsp[33]*Hs[98] + Gsp[49]*Hs[99] + Gsp[65]*Hs[100] + Gsp[81]*Hs[101] + Gsp[97]*Hs[102] + Gsp[113]*Hs[103]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*(Gsp[2]*Hs[96] + Gsp[18]*Hs[97] + Gsp[34]*Hs[98] + Gsp[50]*Hs[99] + Gsp[66]*Hs[100] + Gsp[82]*Hs[101] + Gsp[98]*Hs[102] + Gsp[114]*Hs[103]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[66]*(Gsp[2]*Hs[96] + Gsp[18]*Hs[97] + Gsp[34]*Hs[98] + Gsp[50]*Hs[99] + Gsp[66]*Hs[100] + Gsp[82]*Hs[101] + Gsp[98]*Hs[102] + Gsp[114]*Hs[103]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[67]*(Gsp[2]*Hs[96] + Gsp[18]*Hs[97] + Gsp[34]*Hs[98] + Gsp[50]*Hs[99] + Gsp[66]*Hs[100] + Gsp[82]*Hs[101] + Gsp[98]*Hs[102] + Gsp[114]*Hs[103]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*(Gsp[2]*Hs[96] + Gsp[18]*Hs[97] + Gsp[34]*Hs[98] + Gsp[50]*Hs[99] + Gsp[66]*Hs[100] + Gsp[82]*Hs[101] + Gsp[98]*Hs[102] + Gsp[114]*Hs[103]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*(Gsp[2]*Hs[96] + Gsp[18]*Hs[97] + Gsp[34]*Hs[98] + Gsp[50]*Hs[99] + Gsp[66]*Hs[100] + Gsp[82]*Hs[101] + Gsp[98]*Hs[102] + Gsp[114]*Hs[103]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[64]*((-1 + Gsp[4])*Hs[96] + Gsp[20]*Hs[97] + Gsp[36]*Hs[98] + (rrhoz + Gsp[52])*Hs[99] + Gsp[68]*Hs[100] + Gsp[84]*Hs[101] + Gsp[100]*Hs[102] + Gsp[116]*Hs[103]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])*((-1 + Gsp[4])*Hs[96] + Gsp[20]*Hs[97] + Gsp[36]*Hs[98] + (rrhoz + Gsp[52])*Hs[99] + Gsp[68]*Hs[100] + Gsp[84]*Hs[101] + Gsp[100]*Hs[102] + Gsp[116]*Hs[103]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])*(Gsp[4]*Hs[96] + Gsp[20]*Hs[97] + Gsp[36]*Hs[98] + (rrhoz + Gsp[52])*Hs[99] + Gsp[68]*Hs[100] + Gsp[84]*Hs[101] + Gsp[100]*Hs[102] + Gsp[116]*Hs[103]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[67]*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[64] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71]))*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[67]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[96] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[98] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[99] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[96] + Gsp[17]*Hs[97] + Gsp[33]*Hs[98] + Gsp[49]*Hs[99] + Gsp[65]*Hs[100] + Gsp[81]*Hs[101] + Gsp[97]*Hs[102] + Gsp[113]*Hs[103]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[96] + Gsp[18]*Hs[97] + Gsp[34]*Hs[98] + Gsp[50]*Hs[99] + Gsp[66]*Hs[100] + Gsp[82]*Hs[101] + Gsp[98]*Hs[102] + Gsp[114]*Hs[103]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[96] + Gsp[20]*Hs[97] + Gsp[36]*Hs[98] + (rrhoz + Gsp[52])*Hs[99] + Gsp[68]*Hs[100] + Gsp[84]*Hs[101] + Gsp[100]*Hs[102] + Gsp[116]*Hs[103])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[96] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[98] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[99] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[96] + Gsp[17]*Hs[97] + Gsp[33]*Hs[98] + Gsp[49]*Hs[99] + Gsp[65]*Hs[100] + Gsp[81]*Hs[101] + Gsp[97]*Hs[102] + Gsp[113]*Hs[103]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[96] + Gsp[18]*Hs[97] + Gsp[34]*Hs[98] + Gsp[50]*Hs[99] + Gsp[66]*Hs[100] + Gsp[82]*Hs[101] + Gsp[98]*Hs[102] + Gsp[114]*Hs[103]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[96] + Gsp[20]*Hs[97] + Gsp[36]*Hs[98] + (rrhoz + Gsp[52])*Hs[99] + Gsp[68]*Hs[100] + Gsp[84]*Hs[101] + Gsp[100]*Hs[102] + Gsp[116]*Hs[103])))/pow(zbar,rrho) - kkappa*Pssp*Gs[134]*Gs[198]*yss[9] + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(pow(E,yss[8])*Gs[136] - kkappa*Gs[137] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[67])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[64] + Hs[67]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[64] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])))/pow(zbar,rrho) - kkappa*Gs[134]*yss[9]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(E,yss[8])*Gs[200] - kkappa*Gs[201] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[99])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[96] + Hs[99]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[96] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[98] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[99] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[96] + Gsp[17]*Hs[97] + Gsp[33]*Hs[98] + Gsp[49]*Hs[99] + Gsp[65]*Hs[100] + Gsp[81]*Hs[101] + Gsp[97]*Hs[102] + Gsp[113]*Hs[103]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[96] + Gsp[18]*Hs[97] + Gsp[34]*Hs[98] + Gsp[50]*Hs[99] + Gsp[66]*Hs[100] + Gsp[82]*Hs[101] + Gsp[98]*Hs[102] + Gsp[114]*Hs[103]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[96] + Gsp[20]*Hs[97] + Gsp[36]*Hs[98] + (rrhoz + Gsp[52])*Hs[99] + Gsp[68]*Hs[100] + Gsp[84]*Hs[101] + Gsp[100]*Hs[102] + Gsp[116]*Hs[103])))/pow(zbar,rrho) - kkappa*Gs[198]*yss[9]);
	Nee_sp_s[101]=-(Pssp*Gs[134]*Gs[198]) + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(-Gs[134] + iiota*zbar*(Hs[64] + Hs[67])) + iiota*Pssp*zbar*(Hs[64] + Hs[67])*(Hs[96] + Hs[99]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-Gs[198] + iiota*zbar*(Hs[96] + Hs[99]));
	Nee_sp_s[102]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[129]*Gs[193] - pow(E,yss[7])*Pssp*Gs[135]*Gs[199] + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[193] - pow(E,yss[7])*Gs[199]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[129] - pow(E,yss[7])*Gs[135])*(dP2ssp*Gs[201] + dP1ssp*Gs[202]);
	Nee_sp_s[103]=-(pow(E,yss[0])*Pssp*Gs[128]*Gs[192]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[193] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[193] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[194] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[194] - pow(E,yss[3])*Pssp*Gs[131]*Gs[195] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[193]*Hs[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[194]*Hs[66] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[193]*Hs[67] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[194]*Hs[67] - pphi*Pssp*Gs[197]*(pow(E,yss[1] + yss[7])*(Gs[129] + Gs[135]) + pow(E,yss[2])*pbar*(Gs[130] + Hs[68])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[98] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[98] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[98] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[99] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[99] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[99] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[99] - pow(E,yss[2])*pbar*Pssp*(Gs[130] + Hs[68])*(Gs[194] + Hs[100]) - pphi*Pssp*Gs[133]*(pow(E,yss[1] + yss[7])*(Gs[193] + Gs[199]) + pow(E,yss[2])*pbar*(Gs[194] + Hs[100])) - pow(E,yss[11])*ebar*Pssp*Hs[70]*Hs[102] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[129] + Gs[135])*(Gs[193] + Gs[199])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[130] + Hs[68])*(Gs[194] + Hs[100])*yss[5] - (2*Pssp*zbar*Gs[133]*Gs[197]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[197]*Hs[65])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[133]*Hs[97])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[197]*Hs[67]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[133]*Hs[99]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[67]*Hs[97])/(1 + yss[5]) - (Pssp*zbar*Hs[65]*Hs[99])/(1 + yss[5]) - (Pssp*zbar*Hs[67]*Hs[99]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(-(pow(E,yss[0])*Gs[128]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[129] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[130] - pow(E,yss[3])*Gs[131] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[133] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[67] - pow(E,yss[2])*pbar*(Gs[130] + Hs[68]) - pow(E,yss[11])*ebar*Hs[70] - pphi*(pow(E,yss[1] + yss[7])*(Gs[129] + Gs[135]) + pow(E,yss[2])*pbar*(Gs[130] + Hs[68]))*yss[5] + (zbar*Gs[133]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[65])/(1 + yss[5]) - (zbar*Hs[67]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(pow(E,yss[0])*Gs[192]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[193] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[194] - pow(E,yss[3])*Gs[195] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[197] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[98] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[99] - pow(E,yss[2])*pbar*(Gs[194] + Hs[100]) - pow(E,yss[11])*ebar*Hs[102] - pphi*(pow(E,yss[1] + yss[7])*(Gs[193] + Gs[199]) + pow(E,yss[2])*pbar*(Gs[194] + Hs[100]))*yss[5] + (zbar*Gs[197]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[97])/(1 + yss[5]) - (zbar*Hs[99]*xss[1])/(1 + yss[5]));
	Nee_sp_s[104]=pow(E,yss[3])*Pssp*Gs[131]*Gs[195] + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(pow(E,yss[3])*Gs[131] - pow(E,xss[0])*zbar*(Hs[64] + Hs[67])) - pow(E,xss[0])*Pssp*zbar*(Hs[64] + Hs[67])*(Hs[96] + Hs[99]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[64] + Hs[67])*(Hs[96] + Hs[99]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(E,yss[3])*Gs[195] - pow(E,xss[0])*zbar*(Hs[96] + Hs[99]));
	Nee_sp_s[105]=-(pphi*Pssp*Gs[197]*(pow(E,yss[1] + yss[7])*(Gs[129] + Gs[135]) + pow(E,yss[2])*pbar*(Gs[130] + Hs[68]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[134] + Hs[64] + Hs[67])*(Gs[198] + Hs[96] + Hs[99]) - pphi*Pssp*Gs[133]*(pow(E,yss[1] + yss[7])*(Gs[193] + Gs[199]) + pow(E,yss[2])*pbar*(Gs[194] + Hs[100])) + (2*Pssp*zbar*Gs[133]*Gs[197]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[197]*Hs[65])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[133]*Hs[97])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[197]*Hs[67]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[133]*Hs[99]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[67]*Hs[97])/(1 + yss[5]) + (Pssp*zbar*Hs[65]*Hs[99])/(1 + yss[5]) + (Pssp*zbar*Hs[67]*Hs[99]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[129] + Gs[135])*(Gs[193] + Gs[199])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[130] + Hs[68])*(Gs[194] + Hs[100])*(1 + yss[5]) + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[133]) - Gs[138] + pow(E,xss[0])*kkappa*zbar*(Gs[134] + Hs[64] + Hs[67]) - (zbar*Gs[133]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[65])/(1 + yss[5]) + (zbar*Hs[67]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[129] + Gs[135]) + pow(E,yss[2])*pbar*(Gs[130] + Hs[68]))*(1 + yss[5])) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[197]) - Gs[202] + pow(E,xss[0])*kkappa*zbar*(Gs[198] + Hs[96] + Hs[99]) - (zbar*Gs[197]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[97])/(1 + yss[5]) + (zbar*Hs[99]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[193] + Gs[199]) + pow(E,yss[2])*pbar*(Gs[194] + Hs[100]))*(1 + yss[5]));
	Nee_sp_s[106]=((-1 + nnus)*Gs[137] + nnus*Gs[138])*(dP2ssp*Gs[201] + dP1ssp*Gs[202]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*((-1 + nnus)*Gs[201] + nnus*Gs[202]);
	Nee_sp_s[107]=(dP2ssp*Gs[201] + dP1ssp*Gs[202])*(-Gs[133] - pow(E,bbar - xss[1])*ppsir*Hs[65] + Hs[69]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[65]*Hs[97] + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-Gs[197] - pow(E,bbar - xss[1])*ppsir*Hs[97] + Hs[101]);
	Nee_sp_s[108]=pow(E,xss[0])*(-(Pssp*Gs[132]*Gs[196]) - (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(Gs[132] - Hs[64]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(Gs[196] - Hs[96]) + Pssp*Hs[64]*Hs[96]);
	Nee_sp_s[109]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[193]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[193] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[194] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[194] + pow(E,yss[11])*Pssp*Gs[139]*Gs[203] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[193]*Hs[66] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[194]*Hs[66] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[193]*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[194]*Hs[67] + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[129]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[130] + pow(E,yss[11])*Gs[139] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[66] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[67] + pow(E,yss[2])*pbar*(Gs[130] + Hs[68])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[98] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[98] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[98] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[98] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[99] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[99] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[99] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[99] + pow(E,yss[2])*pbar*Pssp*(Gs[130] + Hs[68])*(Gs[194] + Hs[100]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[193]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[194] + pow(E,yss[11])*Gs[203] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[98] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[99] + pow(E,yss[2])*pbar*(Gs[194] + Hs[100]));
	Nee_sp_s[110]=(Pssp*zbar*(Gs[139] - Hs[67])*Hs[97] + Pssp*zbar*Hs[65]*(Gs[203] - Hs[99]) - Pssp*zbar*(Gs[139] - Hs[67])*(Gs[203] - Hs[99])*xss[1] + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(pow(E,yss[11])*Gs[140] - zbar*Hs[65] + zbar*(Gs[139] - Hs[67])*xss[1]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(E,yss[11])*Gs[204] - zbar*Hs[97] + zbar*(Gs[203] - Hs[99])*xss[1]))/pow(E,yss[11]);
	Nee_sp_s[111]=(-(Pssp*zbar*Hs[67]*Hs[97]) - Pssp*zbar*Hs[65]*Hs[99] - Pssp*(-1 + zbar)*Gs[139]*Gs[203]*xss[1] - Pssp*zbar*Hs[67]*Hs[99]*xss[1] + Pssp*zbar*Gs[203]*(Hs[65] + Hs[67]*xss[1]) - (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(-(pow(E,yss[11])*Gs[141]) + zbar*Hs[65] - (-1 + zbar)*Gs[139]*xss[1] + zbar*Hs[67]*xss[1]) + Pssp*zbar*Gs[139]*(Hs[97] + Hs[99]*xss[1]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(pow(E,yss[11])*Gs[205]) + zbar*Hs[97] - (-1 + zbar)*Gs[203]*xss[1] + zbar*Hs[99]*xss[1]))/pow(E,yss[11]);
	Nee_sp_s[112]=pow(E,yss[0] - yss[11])*Pssp*Gs[128]*Gs[192] + pow(E,yss[3] - yss[11])*Pssp*Gs[131]*Gs[195] - Pssp*Gs[139]*Gs[203] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[139]*Gs[203])/pow(E,yss[11]) - (Pssp*Gs[203]*(pow(E,yss[0])*Gs[128] + pow(E,yss[3])*Gs[131] - pow(E,yss[11])*Gs[139] + pow(E,yss[11])*ebar*Hs[70]))/pow(E,yss[11]) + ((dP2ssp*Gs[201] + dP1ssp*Gs[202])*(pow(E,yss[0])*Gs[128] + pow(E,yss[3])*Gs[131] - pow(E,yss[0])*Gs[139] - pow(E,yss[3])*Gs[139] - pow(E,yss[11])*ebar*Gs[139] + pow(E,yss[11])*Gs[142] + pow(E,yss[11])*ebar*Hs[70]))/pow(E,yss[11]) + ebar*Pssp*Hs[70]*Hs[102] - (Pssp*Gs[139]*(pow(E,yss[0])*Gs[192] + pow(E,yss[3])*Gs[195] - pow(E,yss[11])*Gs[203] + pow(E,yss[11])*ebar*Hs[102]))/pow(E,yss[11]) + ((dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(E,yss[0])*Gs[192] + pow(E,yss[3])*Gs[195] - pow(E,yss[0])*Gs[203] - pow(E,yss[3])*Gs[203] - pow(E,yss[11])*ebar*Gs[203] + pow(E,yss[11])*Gs[206] + pow(E,yss[11])*ebar*Hs[102]))/pow(E,yss[11]);
	Nee_sp_s[113]=(-(Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[201]*Hs[67]) + Pssp*pow(zbar,rrho)*Gs[201]*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71]) - Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[137]*Hs[99] + Pssp*pow(zbar,rrho)*Gs[137]*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103]) - Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[67]*Hs[99]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*Hs[99]*yss[9] + Pssp*pow(zbar,rrho)*Hs[64]*(G2sp[8]*Hs[96] + G2sp[24]*Hs[97] + G2sp[40]*Hs[98] + G2sp[56]*Hs[99] + G2sp[72]*Hs[100] + G2sp[88]*Hs[101] + G2sp[104]*Hs[102] + G2sp[120]*Hs[103])*yss[9] + Pssp*pow(zbar,rrho)*Hs[65]*(G2sp[24]*Hs[96] + G2sp[264]*Hs[97] + G2sp[280]*Hs[98] + G2sp[296]*Hs[99] + G2sp[312]*Hs[100] + G2sp[328]*Hs[101] + G2sp[344]*Hs[102] + G2sp[360]*Hs[103])*yss[9] + Pssp*pow(zbar,rrho)*Hs[66]*(G2sp[40]*Hs[96] + G2sp[280]*Hs[97] + G2sp[520]*Hs[98] + G2sp[536]*Hs[99] + G2sp[552]*Hs[100] + G2sp[568]*Hs[101] + G2sp[584]*Hs[102] + G2sp[600]*Hs[103])*yss[9] + Pssp*pow(zbar,rrho)*Hs[67]*(G2sp[56]*Hs[96] + G2sp[296]*Hs[97] + G2sp[536]*Hs[98] + G2sp[776]*Hs[99] + G2sp[792]*Hs[100] + G2sp[808]*Hs[101] + G2sp[824]*Hs[102] + G2sp[840]*Hs[103])*yss[9] + Pssp*pow(zbar,rrho)*Hs[68]*(G2sp[72]*Hs[96] + G2sp[312]*Hs[97] + G2sp[552]*Hs[98] + G2sp[792]*Hs[99] + G2sp[1032]*Hs[100] + G2sp[1048]*Hs[101] + G2sp[1064]*Hs[102] + G2sp[1080]*Hs[103])*yss[9] + Pssp*pow(zbar,rrho)*Hs[69]*(G2sp[88]*Hs[96] + G2sp[328]*Hs[97] + G2sp[568]*Hs[98] + G2sp[808]*Hs[99] + G2sp[1048]*Hs[100] + G2sp[1288]*Hs[101] + G2sp[1304]*Hs[102] + G2sp[1320]*Hs[103])*yss[9] + Pssp*pow(zbar,rrho)*Hs[70]*(G2sp[104]*Hs[96] + G2sp[344]*Hs[97] + G2sp[584]*Hs[98] + G2sp[824]*Hs[99] + G2sp[1064]*Hs[100] + G2sp[1304]*Hs[101] + G2sp[1544]*Hs[102] + G2sp[1560]*Hs[103])*yss[9] + Pssp*pow(zbar,rrho)*Hs[71]*(G2sp[120]*Hs[96] + G2sp[360]*Hs[97] + G2sp[600]*Hs[98] + G2sp[840]*Hs[99] + G2sp[1080]*Hs[100] + G2sp[1320]*Hs[101] + G2sp[1560]*Hs[102] + G2sp[1800]*Hs[103])*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[67]*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103])*yss[9] - Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103])*yss[9] + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(bbeta*pow(E,yss[8])*Gs[143] + pow(zbar,rrho)*(-Gs[137] + (-(rrho*rrhoz) + Gsp[56])*Hs[67]*yss[9] + (Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*yss[9])) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(bbeta*pow(E,yss[8])*Gs[207] + pow(zbar,rrho)*(-Gs[201] + (-(rrho*rrhoz) + Gsp[56])*Hs[99]*yss[9] + (Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103])*yss[9])))/(bbeta*pow(E,yss[8]));
	Nee_sp_s[114]=(dP2ssp*Gs[201] + dP1ssp*Gs[202])*(ssigmaas - Hs[66]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[98];
	Nee_sp_s[115]=-((dP2ssp*Gs[201] + dP1ssp*Gs[202])*Hs[67]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[99];
	Nee_sp_s[116]=-((dP2ssp*Gs[201] + dP1ssp*Gs[202])*Hs[68]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[100];
	Nee_sp_s[117]=-((dP2ssp*Gs[201] + dP1ssp*Gs[202])*Hs[71]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[103];
	Nee_sp_s[118]=-((dP2ssp*Gs[201] + dP1ssp*Gs[202])*Hs[70]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(ssigmaes - Hs[102]);
	Nee_sp_s[119]=-((dP2ssp*Gs[201] + dP1ssp*Gs[202])*Hs[69]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[101];
	Nee_sp_s[120]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[128]*Gs[208]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[129]*Gs[209] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[128] - pow(pow(E,yss[1]),oomega)*Gs[129])*(pow(E,yss[0])*Gs[208] - pow(pow(E,yss[1]),oomega)*Gs[209]) - pow(E,yss[8])*Pssp*Gs[136]*Gs[216] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[208] - pow(pow(E,yss[1]),oomega)*Gs[209])*Hs[71] + (dP2ssp*Gs[217] + dP1ssp*Gs[218])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[128] - pow(pow(E,yss[1]),oomega)*Gs[129])) - pow(E,yss[8])*Gs[136] + Hs[71]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[128] - pow(pow(E,yss[1]),oomega)*Gs[129])*Hs[111] + (Pssp*Hs[71]*Hs[111])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[208] - pow(pow(E,yss[1]),oomega)*Gs[209])) - pow(E,yss[8])*Gs[216] + Hs[111]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nee_sp_s[121]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[209]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[209] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[210] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[210] - (pbar*pphi*Pssp*Gs[137]*Gs[213])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[133]*Gs[217])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[209]*Hs[66] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[210]*Hs[66] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[209]*Hs[67] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[210]*Hs[67] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[106] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[106] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[106] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[106] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[107] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[107] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[107] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[107] + (pbar*pphi*Pssp*Gs[137]*Gs[216]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[136]*Gs[217]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[136]*Gs[213]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[133]*Gs[216]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[136]*Gs[216]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[68]*Hs[108]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[108]*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[68]*(Gs[213]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[217] - Gs[216]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[217] + dP1ssp*Gs[218])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[129]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[130] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[66] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[67] - pbar*Hs[68]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[209]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[210] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[106] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[107] - pbar*Hs[108]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[213]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[217] - Gs[216]*yss[9])))/pow(E,yss[8]));
	Nee_sp_s[122]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[129]*Gs[209]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[209] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[209] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[210] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[210] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[137]*Gs[213] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[133]*Gs[217] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[209]*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[210]*Hs[66] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[209]*Hs[67] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[210]*Hs[67] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[106] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[106] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[106] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[106] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[107] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[107] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[107] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[107] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[137]*Gs[216]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[136]*Gs[217]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[136]*Gs[213]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[133]*Gs[216]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[136]*Gs[216]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[135]*Gs[215]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[215]*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[135]*(Gs[213]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[217] - Gs[216]*yss[9])) + (dP2ssp*Gs[217] + dP1ssp*Gs[218])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[129]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[129] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[130] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[66] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[67] - pow(E,yss[7])*pphi*Gs[135]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9]))) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[209]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[209] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[210] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[106] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[107] - pow(E,yss[7])*pphi*Gs[215]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[213]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[217] - Gs[216]*yss[9])));
	Nee_sp_s[123]=-(pow(E,yss[8])*Pssp*Gs[136]*Gs[216]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[213]*Hs[67])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[213]*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[133]*Hs[107])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[133]*(Gsp[8]*Hs[104] + Gsp[24]*Hs[105] + Gsp[40]*Hs[106] + Gsp[56]*Hs[107] + Gsp[72]*Hs[108] + Gsp[88]*Hs[109] + Gsp[104]*Hs[110] + Gsp[120]*Hs[111]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[67]*Hs[107]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*Hs[107]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[64]*(G2sp[8]*Hs[104] + G2sp[24]*Hs[105] + G2sp[40]*Hs[106] + G2sp[56]*Hs[107] + G2sp[72]*Hs[108] + G2sp[88]*Hs[109] + G2sp[104]*Hs[110] + G2sp[120]*Hs[111])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[65]*(G2sp[24]*Hs[104] + G2sp[264]*Hs[105] + G2sp[280]*Hs[106] + G2sp[296]*Hs[107] + G2sp[312]*Hs[108] + G2sp[328]*Hs[109] + G2sp[344]*Hs[110] + G2sp[360]*Hs[111])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[66]*(G2sp[40]*Hs[104] + G2sp[280]*Hs[105] + G2sp[520]*Hs[106] + G2sp[536]*Hs[107] + G2sp[552]*Hs[108] + G2sp[568]*Hs[109] + G2sp[584]*Hs[110] + G2sp[600]*Hs[111])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[67]*(G2sp[56]*Hs[104] + G2sp[296]*Hs[105] + G2sp[536]*Hs[106] + G2sp[776]*Hs[107] + G2sp[792]*Hs[108] + G2sp[808]*Hs[109] + G2sp[824]*Hs[110] + G2sp[840]*Hs[111])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[68]*(G2sp[72]*Hs[104] + G2sp[312]*Hs[105] + G2sp[552]*Hs[106] + G2sp[792]*Hs[107] + G2sp[1032]*Hs[108] + G2sp[1048]*Hs[109] + G2sp[1064]*Hs[110] + G2sp[1080]*Hs[111])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[69]*(G2sp[88]*Hs[104] + G2sp[328]*Hs[105] + G2sp[568]*Hs[106] + G2sp[808]*Hs[107] + G2sp[1048]*Hs[108] + G2sp[1288]*Hs[109] + G2sp[1304]*Hs[110] + G2sp[1320]*Hs[111])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[70]*(G2sp[104]*Hs[104] + G2sp[344]*Hs[105] + G2sp[584]*Hs[106] + G2sp[824]*Hs[107] + G2sp[1064]*Hs[108] + G2sp[1304]*Hs[109] + G2sp[1544]*Hs[110] + G2sp[1560]*Hs[111])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[71]*(G2sp[120]*Hs[104] + G2sp[360]*Hs[105] + G2sp[600]*Hs[106] + G2sp[840]*Hs[107] + G2sp[1080]*Hs[108] + G2sp[1320]*Hs[109] + G2sp[1560]*Hs[110] + G2sp[1800]*Hs[111])*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[67]*(Gsp[8]*Hs[104] + Gsp[24]*Hs[105] + Gsp[40]*Hs[106] + Gsp[56]*Hs[107] + Gsp[72]*Hs[108] + Gsp[88]*Hs[109] + Gsp[104]*Hs[110] + Gsp[120]*Hs[111])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(Gsp[8]*Hs[104] + Gsp[24]*Hs[105] + Gsp[40]*Hs[106] + Gsp[56]*Hs[107] + Gsp[72]*Hs[108] + Gsp[88]*Hs[109] + Gsp[104]*Hs[110] + Gsp[120]*Hs[111])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[217] + dP1ssp*Gs[218])*((bbeta*pow(E,yss[8])*Gs[133])/pow(zbar,rrho) - pow(E,yss[8])*Gs[136] + Gs[137] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[67]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*((bbeta*pow(E,yss[8])*Gs[213])/pow(zbar,rrho) - pow(E,yss[8])*Gs[216] + Gs[217] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[107]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[104] + Gsp[24]*Hs[105] + Gsp[40]*Hs[106] + Gsp[56]*Hs[107] + Gsp[72]*Hs[108] + Gsp[88]*Hs[109] + Gsp[104]*Hs[110] + Gsp[120]*Hs[111])*(1 + yss[5]))/pow(zbar,rrho));
	Nee_sp_s[124]=-(kkappa*Pssp*Gs[137]*Gs[214]) + pow(E,yss[8])*Pssp*Gs[136]*Gs[216] - kkappa*Pssp*Gs[134]*Gs[217] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[64]*Hs[104] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*Hs[104] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[66]*Hs[104] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[67]*Hs[104] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*Hs[104] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*Hs[104] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])*Hs[104] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[64]*Hs[106] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[66]*Hs[106] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[67]*Hs[106] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*Hs[106] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*Hs[106] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[64]*Hs[107] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[66]*Hs[107] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[67]*Hs[107] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[67]*Hs[107])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*Hs[107] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*Hs[107] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*Hs[107])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[64] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71]))*Hs[107])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[136]*(Hs[104] + Hs[107]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[64] + Hs[67])*(Gs[216] + Hs[104] + Hs[107]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*(G2sp[1]*Hs[104] + G2sp[17]*Hs[105] + G2sp[33]*Hs[106] + G2sp[49]*Hs[107] + G2sp[65]*Hs[108] + G2sp[81]*Hs[109] + G2sp[97]*Hs[110] + G2sp[113]*Hs[111]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*(G2sp[2]*Hs[104] + G2sp[18]*Hs[105] + G2sp[34]*Hs[106] + G2sp[50]*Hs[107] + G2sp[66]*Hs[108] + G2sp[82]*Hs[109] + G2sp[98]*Hs[110] + G2sp[114]*Hs[111]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[64]*(G2sp[4]*Hs[104] + G2sp[20]*Hs[105] + G2sp[36]*Hs[106] + G2sp[52]*Hs[107] + G2sp[68]*Hs[108] + G2sp[84]*Hs[109] + G2sp[100]*Hs[110] + G2sp[116]*Hs[111]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[64]*(G2sp[8]*Hs[104] + G2sp[24]*Hs[105] + G2sp[40]*Hs[106] + G2sp[56]*Hs[107] + G2sp[72]*Hs[108] + G2sp[88]*Hs[109] + G2sp[104]*Hs[110] + G2sp[120]*Hs[111]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[65]*(G2sp[17]*Hs[104] + G2sp[257]*Hs[105] + G2sp[273]*Hs[106] + G2sp[289]*Hs[107] + G2sp[305]*Hs[108] + G2sp[321]*Hs[109] + G2sp[337]*Hs[110] + G2sp[353]*Hs[111]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[65]*(G2sp[18]*Hs[104] + G2sp[258]*Hs[105] + G2sp[274]*Hs[106] + G2sp[290]*Hs[107] + G2sp[306]*Hs[108] + G2sp[322]*Hs[109] + G2sp[338]*Hs[110] + G2sp[354]*Hs[111]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[65]*(G2sp[20]*Hs[104] + G2sp[260]*Hs[105] + G2sp[276]*Hs[106] + G2sp[292]*Hs[107] + G2sp[308]*Hs[108] + G2sp[324]*Hs[109] + G2sp[340]*Hs[110] + G2sp[356]*Hs[111]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[65]*(G2sp[24]*Hs[104] + G2sp[264]*Hs[105] + G2sp[280]*Hs[106] + G2sp[296]*Hs[107] + G2sp[312]*Hs[108] + G2sp[328]*Hs[109] + G2sp[344]*Hs[110] + G2sp[360]*Hs[111]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[66]*(G2sp[33]*Hs[104] + G2sp[273]*Hs[105] + G2sp[513]*Hs[106] + G2sp[529]*Hs[107] + G2sp[545]*Hs[108] + G2sp[561]*Hs[109] + G2sp[577]*Hs[110] + G2sp[593]*Hs[111]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[66]*(G2sp[34]*Hs[104] + G2sp[274]*Hs[105] + G2sp[514]*Hs[106] + G2sp[530]*Hs[107] + G2sp[546]*Hs[108] + G2sp[562]*Hs[109] + G2sp[578]*Hs[110] + G2sp[594]*Hs[111]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[66]*(G2sp[36]*Hs[104] + G2sp[276]*Hs[105] + G2sp[516]*Hs[106] + G2sp[532]*Hs[107] + G2sp[548]*Hs[108] + G2sp[564]*Hs[109] + G2sp[580]*Hs[110] + G2sp[596]*Hs[111]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[66]*(G2sp[40]*Hs[104] + G2sp[280]*Hs[105] + G2sp[520]*Hs[106] + G2sp[536]*Hs[107] + G2sp[552]*Hs[108] + G2sp[568]*Hs[109] + G2sp[584]*Hs[110] + G2sp[600]*Hs[111]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[67]*(G2sp[49]*Hs[104] + G2sp[289]*Hs[105] + G2sp[529]*Hs[106] + G2sp[769]*Hs[107] + G2sp[785]*Hs[108] + G2sp[801]*Hs[109] + G2sp[817]*Hs[110] + G2sp[833]*Hs[111]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[67]*(G2sp[50]*Hs[104] + G2sp[290]*Hs[105] + G2sp[530]*Hs[106] + G2sp[770]*Hs[107] + G2sp[786]*Hs[108] + G2sp[802]*Hs[109] + G2sp[818]*Hs[110] + G2sp[834]*Hs[111]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[67]*(G2sp[52]*Hs[104] + G2sp[292]*Hs[105] + G2sp[532]*Hs[106] + G2sp[772]*Hs[107] + G2sp[788]*Hs[108] + G2sp[804]*Hs[109] + G2sp[820]*Hs[110] + G2sp[836]*Hs[111]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[67]*(G2sp[56]*Hs[104] + G2sp[296]*Hs[105] + G2sp[536]*Hs[106] + G2sp[776]*Hs[107] + G2sp[792]*Hs[108] + G2sp[808]*Hs[109] + G2sp[824]*Hs[110] + G2sp[840]*Hs[111]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[68]*(G2sp[65]*Hs[104] + G2sp[305]*Hs[105] + G2sp[545]*Hs[106] + G2sp[785]*Hs[107] + G2sp[1025]*Hs[108] + G2sp[1041]*Hs[109] + G2sp[1057]*Hs[110] + G2sp[1073]*Hs[111]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[68]*(G2sp[66]*Hs[104] + G2sp[306]*Hs[105] + G2sp[546]*Hs[106] + G2sp[786]*Hs[107] + G2sp[1026]*Hs[108] + G2sp[1042]*Hs[109] + G2sp[1058]*Hs[110] + G2sp[1074]*Hs[111]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[68]*(G2sp[68]*Hs[104] + G2sp[308]*Hs[105] + G2sp[548]*Hs[106] + G2sp[788]*Hs[107] + G2sp[1028]*Hs[108] + G2sp[1044]*Hs[109] + G2sp[1060]*Hs[110] + G2sp[1076]*Hs[111]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[68]*(G2sp[72]*Hs[104] + G2sp[312]*Hs[105] + G2sp[552]*Hs[106] + G2sp[792]*Hs[107] + G2sp[1032]*Hs[108] + G2sp[1048]*Hs[109] + G2sp[1064]*Hs[110] + G2sp[1080]*Hs[111]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[69]*(G2sp[81]*Hs[104] + G2sp[321]*Hs[105] + G2sp[561]*Hs[106] + G2sp[801]*Hs[107] + G2sp[1041]*Hs[108] + G2sp[1281]*Hs[109] + G2sp[1297]*Hs[110] + G2sp[1313]*Hs[111]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[69]*(G2sp[82]*Hs[104] + G2sp[322]*Hs[105] + G2sp[562]*Hs[106] + G2sp[802]*Hs[107] + G2sp[1042]*Hs[108] + G2sp[1282]*Hs[109] + G2sp[1298]*Hs[110] + G2sp[1314]*Hs[111]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[69]*(G2sp[84]*Hs[104] + G2sp[324]*Hs[105] + G2sp[564]*Hs[106] + G2sp[804]*Hs[107] + G2sp[1044]*Hs[108] + G2sp[1284]*Hs[109] + G2sp[1300]*Hs[110] + G2sp[1316]*Hs[111]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[69]*(G2sp[88]*Hs[104] + G2sp[328]*Hs[105] + G2sp[568]*Hs[106] + G2sp[808]*Hs[107] + G2sp[1048]*Hs[108] + G2sp[1288]*Hs[109] + G2sp[1304]*Hs[110] + G2sp[1320]*Hs[111]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[70]*(G2sp[97]*Hs[104] + G2sp[337]*Hs[105] + G2sp[577]*Hs[106] + G2sp[817]*Hs[107] + G2sp[1057]*Hs[108] + G2sp[1297]*Hs[109] + G2sp[1537]*Hs[110] + G2sp[1553]*Hs[111]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[70]*(G2sp[98]*Hs[104] + G2sp[338]*Hs[105] + G2sp[578]*Hs[106] + G2sp[818]*Hs[107] + G2sp[1058]*Hs[108] + G2sp[1298]*Hs[109] + G2sp[1538]*Hs[110] + G2sp[1554]*Hs[111]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[70]*(G2sp[100]*Hs[104] + G2sp[340]*Hs[105] + G2sp[580]*Hs[106] + G2sp[820]*Hs[107] + G2sp[1060]*Hs[108] + G2sp[1300]*Hs[109] + G2sp[1540]*Hs[110] + G2sp[1556]*Hs[111]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[70]*(G2sp[104]*Hs[104] + G2sp[344]*Hs[105] + G2sp[584]*Hs[106] + G2sp[824]*Hs[107] + G2sp[1064]*Hs[108] + G2sp[1304]*Hs[109] + G2sp[1544]*Hs[110] + G2sp[1560]*Hs[111]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[71]*(G2sp[113]*Hs[104] + G2sp[353]*Hs[105] + G2sp[593]*Hs[106] + G2sp[833]*Hs[107] + G2sp[1073]*Hs[108] + G2sp[1313]*Hs[109] + G2sp[1553]*Hs[110] + G2sp[1793]*Hs[111]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[71]*(G2sp[114]*Hs[104] + G2sp[354]*Hs[105] + G2sp[594]*Hs[106] + G2sp[834]*Hs[107] + G2sp[1074]*Hs[108] + G2sp[1314]*Hs[109] + G2sp[1554]*Hs[110] + G2sp[1794]*Hs[111]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[71]*(G2sp[116]*Hs[104] + G2sp[356]*Hs[105] + G2sp[596]*Hs[106] + G2sp[836]*Hs[107] + G2sp[1076]*Hs[108] + G2sp[1316]*Hs[109] + G2sp[1556]*Hs[110] + G2sp[1796]*Hs[111]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[71]*(G2sp[120]*Hs[104] + G2sp[360]*Hs[105] + G2sp[600]*Hs[106] + G2sp[840]*Hs[107] + G2sp[1080]*Hs[108] + G2sp[1320]*Hs[109] + G2sp[1560]*Hs[110] + G2sp[1800]*Hs[111]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*(Gsp[1]*Hs[104] + Gsp[17]*Hs[105] + Gsp[33]*Hs[106] + Gsp[49]*Hs[107] + Gsp[65]*Hs[108] + Gsp[81]*Hs[109] + Gsp[97]*Hs[110] + Gsp[113]*Hs[111]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[66]*(Gsp[1]*Hs[104] + Gsp[17]*Hs[105] + Gsp[33]*Hs[106] + Gsp[49]*Hs[107] + Gsp[65]*Hs[108] + Gsp[81]*Hs[109] + Gsp[97]*Hs[110] + Gsp[113]*Hs[111]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[67]*(Gsp[1]*Hs[104] + Gsp[17]*Hs[105] + Gsp[33]*Hs[106] + Gsp[49]*Hs[107] + Gsp[65]*Hs[108] + Gsp[81]*Hs[109] + Gsp[97]*Hs[110] + Gsp[113]*Hs[111]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*(Gsp[1]*Hs[104] + Gsp[17]*Hs[105] + Gsp[33]*Hs[106] + Gsp[49]*Hs[107] + Gsp[65]*Hs[108] + Gsp[81]*Hs[109] + Gsp[97]*Hs[110] + Gsp[113]*Hs[111]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*(Gsp[1]*Hs[104] + Gsp[17]*Hs[105] + Gsp[33]*Hs[106] + Gsp[49]*Hs[107] + Gsp[65]*Hs[108] + Gsp[81]*Hs[109] + Gsp[97]*Hs[110] + Gsp[113]*Hs[111]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*(Gsp[2]*Hs[104] + Gsp[18]*Hs[105] + Gsp[34]*Hs[106] + Gsp[50]*Hs[107] + Gsp[66]*Hs[108] + Gsp[82]*Hs[109] + Gsp[98]*Hs[110] + Gsp[114]*Hs[111]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[66]*(Gsp[2]*Hs[104] + Gsp[18]*Hs[105] + Gsp[34]*Hs[106] + Gsp[50]*Hs[107] + Gsp[66]*Hs[108] + Gsp[82]*Hs[109] + Gsp[98]*Hs[110] + Gsp[114]*Hs[111]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[67]*(Gsp[2]*Hs[104] + Gsp[18]*Hs[105] + Gsp[34]*Hs[106] + Gsp[50]*Hs[107] + Gsp[66]*Hs[108] + Gsp[82]*Hs[109] + Gsp[98]*Hs[110] + Gsp[114]*Hs[111]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*(Gsp[2]*Hs[104] + Gsp[18]*Hs[105] + Gsp[34]*Hs[106] + Gsp[50]*Hs[107] + Gsp[66]*Hs[108] + Gsp[82]*Hs[109] + Gsp[98]*Hs[110] + Gsp[114]*Hs[111]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*(Gsp[2]*Hs[104] + Gsp[18]*Hs[105] + Gsp[34]*Hs[106] + Gsp[50]*Hs[107] + Gsp[66]*Hs[108] + Gsp[82]*Hs[109] + Gsp[98]*Hs[110] + Gsp[114]*Hs[111]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[64]*((-1 + Gsp[4])*Hs[104] + Gsp[20]*Hs[105] + Gsp[36]*Hs[106] + (rrhoz + Gsp[52])*Hs[107] + Gsp[68]*Hs[108] + Gsp[84]*Hs[109] + Gsp[100]*Hs[110] + Gsp[116]*Hs[111]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])*((-1 + Gsp[4])*Hs[104] + Gsp[20]*Hs[105] + Gsp[36]*Hs[106] + (rrhoz + Gsp[52])*Hs[107] + Gsp[68]*Hs[108] + Gsp[84]*Hs[109] + Gsp[100]*Hs[110] + Gsp[116]*Hs[111]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])*(Gsp[4]*Hs[104] + Gsp[20]*Hs[105] + Gsp[36]*Hs[106] + (rrhoz + Gsp[52])*Hs[107] + Gsp[68]*Hs[108] + Gsp[84]*Hs[109] + Gsp[100]*Hs[110] + Gsp[116]*Hs[111]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[67]*(Gsp[8]*Hs[104] + Gsp[24]*Hs[105] + Gsp[40]*Hs[106] + Gsp[56]*Hs[107] + Gsp[72]*Hs[108] + Gsp[88]*Hs[109] + Gsp[104]*Hs[110] + Gsp[120]*Hs[111]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(Gsp[8]*Hs[104] + Gsp[24]*Hs[105] + Gsp[40]*Hs[106] + Gsp[56]*Hs[107] + Gsp[72]*Hs[108] + Gsp[88]*Hs[109] + Gsp[104]*Hs[110] + Gsp[120]*Hs[111]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[64] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71]))*(Gsp[8]*Hs[104] + Gsp[24]*Hs[105] + Gsp[40]*Hs[106] + Gsp[56]*Hs[107] + Gsp[72]*Hs[108] + Gsp[88]*Hs[109] + Gsp[104]*Hs[110] + Gsp[120]*Hs[111]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[67]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[104] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[106] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[107] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[104] + Gsp[17]*Hs[105] + Gsp[33]*Hs[106] + Gsp[49]*Hs[107] + Gsp[65]*Hs[108] + Gsp[81]*Hs[109] + Gsp[97]*Hs[110] + Gsp[113]*Hs[111]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[104] + Gsp[18]*Hs[105] + Gsp[34]*Hs[106] + Gsp[50]*Hs[107] + Gsp[66]*Hs[108] + Gsp[82]*Hs[109] + Gsp[98]*Hs[110] + Gsp[114]*Hs[111]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[104] + Gsp[20]*Hs[105] + Gsp[36]*Hs[106] + (rrhoz + Gsp[52])*Hs[107] + Gsp[68]*Hs[108] + Gsp[84]*Hs[109] + Gsp[100]*Hs[110] + Gsp[116]*Hs[111])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[104] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[106] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[107] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[104] + Gsp[17]*Hs[105] + Gsp[33]*Hs[106] + Gsp[49]*Hs[107] + Gsp[65]*Hs[108] + Gsp[81]*Hs[109] + Gsp[97]*Hs[110] + Gsp[113]*Hs[111]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[104] + Gsp[18]*Hs[105] + Gsp[34]*Hs[106] + Gsp[50]*Hs[107] + Gsp[66]*Hs[108] + Gsp[82]*Hs[109] + Gsp[98]*Hs[110] + Gsp[114]*Hs[111]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[104] + Gsp[20]*Hs[105] + Gsp[36]*Hs[106] + (rrhoz + Gsp[52])*Hs[107] + Gsp[68]*Hs[108] + Gsp[84]*Hs[109] + Gsp[100]*Hs[110] + Gsp[116]*Hs[111])))/pow(zbar,rrho) - kkappa*Pssp*Gs[134]*Gs[214]*yss[9] + (dP2ssp*Gs[217] + dP1ssp*Gs[218])*(pow(E,yss[8])*Gs[136] - kkappa*Gs[137] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[67])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[64] + Hs[67]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[64] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])))/pow(zbar,rrho) - kkappa*Gs[134]*yss[9]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(E,yss[8])*Gs[216] - kkappa*Gs[217] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[107])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[104] + Hs[107]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[104] + Gsp[24]*Hs[105] + Gsp[40]*Hs[106] + Gsp[56]*Hs[107] + Gsp[72]*Hs[108] + Gsp[88]*Hs[109] + Gsp[104]*Hs[110] + Gsp[120]*Hs[111]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[104] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[106] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[107] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[104] + Gsp[17]*Hs[105] + Gsp[33]*Hs[106] + Gsp[49]*Hs[107] + Gsp[65]*Hs[108] + Gsp[81]*Hs[109] + Gsp[97]*Hs[110] + Gsp[113]*Hs[111]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[104] + Gsp[18]*Hs[105] + Gsp[34]*Hs[106] + Gsp[50]*Hs[107] + Gsp[66]*Hs[108] + Gsp[82]*Hs[109] + Gsp[98]*Hs[110] + Gsp[114]*Hs[111]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[104] + Gsp[20]*Hs[105] + Gsp[36]*Hs[106] + (rrhoz + Gsp[52])*Hs[107] + Gsp[68]*Hs[108] + Gsp[84]*Hs[109] + Gsp[100]*Hs[110] + Gsp[116]*Hs[111])))/pow(zbar,rrho) - kkappa*Gs[214]*yss[9]);
	Nee_sp_s[125]=-(Pssp*Gs[134]*Gs[214]) + (dP2ssp*Gs[217] + dP1ssp*Gs[218])*(-Gs[134] + iiota*zbar*(Hs[64] + Hs[67])) + iiota*Pssp*zbar*(Hs[64] + Hs[67])*(Hs[104] + Hs[107]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-Gs[214] + iiota*zbar*(Hs[104] + Hs[107]));
	Nee_sp_s[126]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[129]*Gs[209] - pow(E,yss[7])*Pssp*Gs[135]*Gs[215] + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[209] - pow(E,yss[7])*Gs[215]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[129] - pow(E,yss[7])*Gs[135])*(dP2ssp*Gs[217] + dP1ssp*Gs[218]);
	Nee_sp_s[127]=-(pow(E,yss[0])*Pssp*Gs[128]*Gs[208]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[209] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[209] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[210] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[210] - pow(E,yss[3])*Pssp*Gs[131]*Gs[211] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[209]*Hs[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[210]*Hs[66] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[209]*Hs[67] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[210]*Hs[67] - pphi*Pssp*Gs[213]*(pow(E,yss[1] + yss[7])*(Gs[129] + Gs[135]) + pow(E,yss[2])*pbar*(Gs[130] + Hs[68])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[106] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[106] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[106] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[106] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[107] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[107] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[107] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[107] - pow(E,yss[2])*pbar*Pssp*(Gs[130] + Hs[68])*(Gs[210] + Hs[108]) - pphi*Pssp*Gs[133]*(pow(E,yss[1] + yss[7])*(Gs[209] + Gs[215]) + pow(E,yss[2])*pbar*(Gs[210] + Hs[108])) - pow(E,yss[11])*ebar*Pssp*Hs[70]*Hs[110] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[129] + Gs[135])*(Gs[209] + Gs[215])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[130] + Hs[68])*(Gs[210] + Hs[108])*yss[5] - (2*Pssp*zbar*Gs[133]*Gs[213]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[213]*Hs[65])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[133]*Hs[105])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[213]*Hs[67]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[133]*Hs[107]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[67]*Hs[105])/(1 + yss[5]) - (Pssp*zbar*Hs[65]*Hs[107])/(1 + yss[5]) - (Pssp*zbar*Hs[67]*Hs[107]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[217] + dP1ssp*Gs[218])*(-(pow(E,yss[0])*Gs[128]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[129] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[130] - pow(E,yss[3])*Gs[131] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[133] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[67] - pow(E,yss[2])*pbar*(Gs[130] + Hs[68]) - pow(E,yss[11])*ebar*Hs[70] - pphi*(pow(E,yss[1] + yss[7])*(Gs[129] + Gs[135]) + pow(E,yss[2])*pbar*(Gs[130] + Hs[68]))*yss[5] + (zbar*Gs[133]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[65])/(1 + yss[5]) - (zbar*Hs[67]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(pow(E,yss[0])*Gs[208]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[209] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[210] - pow(E,yss[3])*Gs[211] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[213] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[106] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[107] - pow(E,yss[2])*pbar*(Gs[210] + Hs[108]) - pow(E,yss[11])*ebar*Hs[110] - pphi*(pow(E,yss[1] + yss[7])*(Gs[209] + Gs[215]) + pow(E,yss[2])*pbar*(Gs[210] + Hs[108]))*yss[5] + (zbar*Gs[213]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[105])/(1 + yss[5]) - (zbar*Hs[107]*xss[1])/(1 + yss[5]));
	Nee_sp_s[128]=pow(E,yss[3])*Pssp*Gs[131]*Gs[211] + (dP2ssp*Gs[217] + dP1ssp*Gs[218])*(pow(E,yss[3])*Gs[131] - pow(E,xss[0])*zbar*(Hs[64] + Hs[67])) - pow(E,xss[0])*Pssp*zbar*(Hs[64] + Hs[67])*(Hs[104] + Hs[107]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[64] + Hs[67])*(Hs[104] + Hs[107]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(E,yss[3])*Gs[211] - pow(E,xss[0])*zbar*(Hs[104] + Hs[107]));
	Nee_sp_s[129]=-(pphi*Pssp*Gs[213]*(pow(E,yss[1] + yss[7])*(Gs[129] + Gs[135]) + pow(E,yss[2])*pbar*(Gs[130] + Hs[68]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[134] + Hs[64] + Hs[67])*(Gs[214] + Hs[104] + Hs[107]) - pphi*Pssp*Gs[133]*(pow(E,yss[1] + yss[7])*(Gs[209] + Gs[215]) + pow(E,yss[2])*pbar*(Gs[210] + Hs[108])) + (2*Pssp*zbar*Gs[133]*Gs[213]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[213]*Hs[65])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[133]*Hs[105])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[213]*Hs[67]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[133]*Hs[107]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[67]*Hs[105])/(1 + yss[5]) + (Pssp*zbar*Hs[65]*Hs[107])/(1 + yss[5]) + (Pssp*zbar*Hs[67]*Hs[107]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[129] + Gs[135])*(Gs[209] + Gs[215])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[130] + Hs[68])*(Gs[210] + Hs[108])*(1 + yss[5]) + (dP2ssp*Gs[217] + dP1ssp*Gs[218])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[133]) - Gs[138] + pow(E,xss[0])*kkappa*zbar*(Gs[134] + Hs[64] + Hs[67]) - (zbar*Gs[133]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[65])/(1 + yss[5]) + (zbar*Hs[67]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[129] + Gs[135]) + pow(E,yss[2])*pbar*(Gs[130] + Hs[68]))*(1 + yss[5])) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[213]) - Gs[218] + pow(E,xss[0])*kkappa*zbar*(Gs[214] + Hs[104] + Hs[107]) - (zbar*Gs[213]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[105])/(1 + yss[5]) + (zbar*Hs[107]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[209] + Gs[215]) + pow(E,yss[2])*pbar*(Gs[210] + Hs[108]))*(1 + yss[5]));
	Nee_sp_s[130]=((-1 + nnus)*Gs[137] + nnus*Gs[138])*(dP2ssp*Gs[217] + dP1ssp*Gs[218]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*((-1 + nnus)*Gs[217] + nnus*Gs[218]);
	Nee_sp_s[131]=(dP2ssp*Gs[217] + dP1ssp*Gs[218])*(-Gs[133] - pow(E,bbar - xss[1])*ppsir*Hs[65] + Hs[69]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[65]*Hs[105] + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-Gs[213] - pow(E,bbar - xss[1])*ppsir*Hs[105] + Hs[109]);
	Nee_sp_s[132]=pow(E,xss[0])*(-(Pssp*Gs[132]*Gs[212]) - (dP2ssp*Gs[217] + dP1ssp*Gs[218])*(Gs[132] - Hs[64]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(Gs[212] - Hs[104]) + Pssp*Hs[64]*Hs[104]);
	Nee_sp_s[133]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[209]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[209] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[210] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[210] + pow(E,yss[11])*Pssp*Gs[139]*Gs[219] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[209]*Hs[66] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[210]*Hs[66] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[209]*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[210]*Hs[67] + (dP2ssp*Gs[217] + dP1ssp*Gs[218])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[129]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[130] + pow(E,yss[11])*Gs[139] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[66] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[67] + pow(E,yss[2])*pbar*(Gs[130] + Hs[68])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[106] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[106] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[106] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[106] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[107] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[107] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[107] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[107] + pow(E,yss[2])*pbar*Pssp*(Gs[130] + Hs[68])*(Gs[210] + Hs[108]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[209]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[210] + pow(E,yss[11])*Gs[219] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[106] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[107] + pow(E,yss[2])*pbar*(Gs[210] + Hs[108]));
	Nee_sp_s[134]=(Pssp*zbar*(Gs[139] - Hs[67])*Hs[105] + Pssp*zbar*Hs[65]*(Gs[219] - Hs[107]) - Pssp*zbar*(Gs[139] - Hs[67])*(Gs[219] - Hs[107])*xss[1] + (dP2ssp*Gs[217] + dP1ssp*Gs[218])*(pow(E,yss[11])*Gs[140] - zbar*Hs[65] + zbar*(Gs[139] - Hs[67])*xss[1]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(E,yss[11])*Gs[220] - zbar*Hs[105] + zbar*(Gs[219] - Hs[107])*xss[1]))/pow(E,yss[11]);
	Nee_sp_s[135]=(-(Pssp*zbar*Hs[67]*Hs[105]) - Pssp*zbar*Hs[65]*Hs[107] - Pssp*(-1 + zbar)*Gs[139]*Gs[219]*xss[1] - Pssp*zbar*Hs[67]*Hs[107]*xss[1] + Pssp*zbar*Gs[219]*(Hs[65] + Hs[67]*xss[1]) - (dP2ssp*Gs[217] + dP1ssp*Gs[218])*(-(pow(E,yss[11])*Gs[141]) + zbar*Hs[65] - (-1 + zbar)*Gs[139]*xss[1] + zbar*Hs[67]*xss[1]) + Pssp*zbar*Gs[139]*(Hs[105] + Hs[107]*xss[1]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(pow(E,yss[11])*Gs[221]) + zbar*Hs[105] - (-1 + zbar)*Gs[219]*xss[1] + zbar*Hs[107]*xss[1]))/pow(E,yss[11]);
	Nee_sp_s[136]=pow(E,yss[0] - yss[11])*Pssp*Gs[128]*Gs[208] + pow(E,yss[3] - yss[11])*Pssp*Gs[131]*Gs[211] - Pssp*Gs[139]*Gs[219] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[139]*Gs[219])/pow(E,yss[11]) - (Pssp*Gs[219]*(pow(E,yss[0])*Gs[128] + pow(E,yss[3])*Gs[131] - pow(E,yss[11])*Gs[139] + pow(E,yss[11])*ebar*Hs[70]))/pow(E,yss[11]) + ((dP2ssp*Gs[217] + dP1ssp*Gs[218])*(pow(E,yss[0])*Gs[128] + pow(E,yss[3])*Gs[131] - pow(E,yss[0])*Gs[139] - pow(E,yss[3])*Gs[139] - pow(E,yss[11])*ebar*Gs[139] + pow(E,yss[11])*Gs[142] + pow(E,yss[11])*ebar*Hs[70]))/pow(E,yss[11]) + ebar*Pssp*Hs[70]*Hs[110] - (Pssp*Gs[139]*(pow(E,yss[0])*Gs[208] + pow(E,yss[3])*Gs[211] - pow(E,yss[11])*Gs[219] + pow(E,yss[11])*ebar*Hs[110]))/pow(E,yss[11]) + ((dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(E,yss[0])*Gs[208] + pow(E,yss[3])*Gs[211] - pow(E,yss[0])*Gs[219] - pow(E,yss[3])*Gs[219] - pow(E,yss[11])*ebar*Gs[219] + pow(E,yss[11])*Gs[222] + pow(E,yss[11])*ebar*Hs[110]))/pow(E,yss[11]);
	Nee_sp_s[137]=(-(Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[217]*Hs[67]) + Pssp*pow(zbar,rrho)*Gs[217]*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71]) - Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[137]*Hs[107] + Pssp*pow(zbar,rrho)*Gs[137]*(Gsp[8]*Hs[104] + Gsp[24]*Hs[105] + Gsp[40]*Hs[106] + Gsp[56]*Hs[107] + Gsp[72]*Hs[108] + Gsp[88]*Hs[109] + Gsp[104]*Hs[110] + Gsp[120]*Hs[111]) - Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[67]*Hs[107]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*Hs[107]*yss[9] + Pssp*pow(zbar,rrho)*Hs[64]*(G2sp[8]*Hs[104] + G2sp[24]*Hs[105] + G2sp[40]*Hs[106] + G2sp[56]*Hs[107] + G2sp[72]*Hs[108] + G2sp[88]*Hs[109] + G2sp[104]*Hs[110] + G2sp[120]*Hs[111])*yss[9] + Pssp*pow(zbar,rrho)*Hs[65]*(G2sp[24]*Hs[104] + G2sp[264]*Hs[105] + G2sp[280]*Hs[106] + G2sp[296]*Hs[107] + G2sp[312]*Hs[108] + G2sp[328]*Hs[109] + G2sp[344]*Hs[110] + G2sp[360]*Hs[111])*yss[9] + Pssp*pow(zbar,rrho)*Hs[66]*(G2sp[40]*Hs[104] + G2sp[280]*Hs[105] + G2sp[520]*Hs[106] + G2sp[536]*Hs[107] + G2sp[552]*Hs[108] + G2sp[568]*Hs[109] + G2sp[584]*Hs[110] + G2sp[600]*Hs[111])*yss[9] + Pssp*pow(zbar,rrho)*Hs[67]*(G2sp[56]*Hs[104] + G2sp[296]*Hs[105] + G2sp[536]*Hs[106] + G2sp[776]*Hs[107] + G2sp[792]*Hs[108] + G2sp[808]*Hs[109] + G2sp[824]*Hs[110] + G2sp[840]*Hs[111])*yss[9] + Pssp*pow(zbar,rrho)*Hs[68]*(G2sp[72]*Hs[104] + G2sp[312]*Hs[105] + G2sp[552]*Hs[106] + G2sp[792]*Hs[107] + G2sp[1032]*Hs[108] + G2sp[1048]*Hs[109] + G2sp[1064]*Hs[110] + G2sp[1080]*Hs[111])*yss[9] + Pssp*pow(zbar,rrho)*Hs[69]*(G2sp[88]*Hs[104] + G2sp[328]*Hs[105] + G2sp[568]*Hs[106] + G2sp[808]*Hs[107] + G2sp[1048]*Hs[108] + G2sp[1288]*Hs[109] + G2sp[1304]*Hs[110] + G2sp[1320]*Hs[111])*yss[9] + Pssp*pow(zbar,rrho)*Hs[70]*(G2sp[104]*Hs[104] + G2sp[344]*Hs[105] + G2sp[584]*Hs[106] + G2sp[824]*Hs[107] + G2sp[1064]*Hs[108] + G2sp[1304]*Hs[109] + G2sp[1544]*Hs[110] + G2sp[1560]*Hs[111])*yss[9] + Pssp*pow(zbar,rrho)*Hs[71]*(G2sp[120]*Hs[104] + G2sp[360]*Hs[105] + G2sp[600]*Hs[106] + G2sp[840]*Hs[107] + G2sp[1080]*Hs[108] + G2sp[1320]*Hs[109] + G2sp[1560]*Hs[110] + G2sp[1800]*Hs[111])*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[67]*(Gsp[8]*Hs[104] + Gsp[24]*Hs[105] + Gsp[40]*Hs[106] + Gsp[56]*Hs[107] + Gsp[72]*Hs[108] + Gsp[88]*Hs[109] + Gsp[104]*Hs[110] + Gsp[120]*Hs[111])*yss[9] - Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(Gsp[8]*Hs[104] + Gsp[24]*Hs[105] + Gsp[40]*Hs[106] + Gsp[56]*Hs[107] + Gsp[72]*Hs[108] + Gsp[88]*Hs[109] + Gsp[104]*Hs[110] + Gsp[120]*Hs[111])*yss[9] + (dP2ssp*Gs[217] + dP1ssp*Gs[218])*(bbeta*pow(E,yss[8])*Gs[143] + pow(zbar,rrho)*(-Gs[137] + (-(rrho*rrhoz) + Gsp[56])*Hs[67]*yss[9] + (Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*yss[9])) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(bbeta*pow(E,yss[8])*Gs[223] + pow(zbar,rrho)*(-Gs[217] + (-(rrho*rrhoz) + Gsp[56])*Hs[107]*yss[9] + (Gsp[8]*Hs[104] + Gsp[24]*Hs[105] + Gsp[40]*Hs[106] + Gsp[72]*Hs[108] + Gsp[88]*Hs[109] + Gsp[104]*Hs[110] + Gsp[120]*Hs[111])*yss[9])))/(bbeta*pow(E,yss[8]));
	Nee_sp_s[138]=(dP2ssp*Gs[217] + dP1ssp*Gs[218])*(ssigmaas - Hs[66]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[106];
	Nee_sp_s[139]=-((dP2ssp*Gs[217] + dP1ssp*Gs[218])*Hs[67]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[107];
	Nee_sp_s[140]=-((dP2ssp*Gs[217] + dP1ssp*Gs[218])*Hs[68]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[108];
	Nee_sp_s[141]=-((dP2ssp*Gs[217] + dP1ssp*Gs[218])*Hs[71]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(ssigmads - Hs[111]);
	Nee_sp_s[142]=-((dP2ssp*Gs[217] + dP1ssp*Gs[218])*Hs[70]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[110];
	Nee_sp_s[143]=-((dP2ssp*Gs[217] + dP1ssp*Gs[218])*Hs[69]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[109];
	Nee_sp_s[168]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*pow(Gs[144],2)) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*pow(Gs[145],2) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*pow(pow(E,yss[0])*Gs[144] - pow(pow(E,yss[1]),oomega)*Gs[145],2) - pow(E,yss[8])*Pssp*pow(Gs[152],2) - 2*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[144] - pow(pow(E,yss[1]),oomega)*Gs[145])*Hs[79] + (Pssp*pow(Hs[79],2))/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + 2*(dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[144] - pow(pow(E,yss[1]),oomega)*Gs[145])) - pow(E,yss[8])*Gs[152] + Hs[79]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nee_sp_s[169]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*pow(Gs[145],2)) + 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[146] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*pow(Gs[146],2) - (2*pbar*pphi*Pssp*Gs[149]*Gs[153])/pow(E,yss[8]) - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[74] + 2*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[74] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[74],2) - 2*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[75] + 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[75] - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[75] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[75],2) + (2*pbar*pphi*Pssp*Gs[152]*Gs[153]*(1 + yss[5]))/pow(E,yss[8]) + (2*pbar*pphi*Pssp*Gs[149]*Gs[152]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*pow(Gs[152],2)*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*pow(Hs[76],2)*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (2*pbar*pphi*Pssp*Hs[76]*(Gs[149]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[153] - Gs[152]*yss[9])))/pow(E,yss[8]) + 2*(dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[145]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[146] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[74] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[75] - pbar*Hs[76]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[149]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[153] - Gs[152]*yss[9])))/pow(E,yss[8]));
	Nee_sp_s[170]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*pow(Gs[145],2)) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Gs[145],2) - 2*(-1 + aalpha)*aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[146] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*pow(Gs[146],2) - 2*pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[149]*Gs[153] + 2*(-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[74] - 2*aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[74],2) + 2*(-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[75] - 2*pow(aalpha,2)*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[75] + 2*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[75] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[75],2) + 2*pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[152]*Gs[153]*(1 + yss[5]) + 2*pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[149]*Gs[152]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*pow(Gs[152],2)*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*pow(Gs[151],2)*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - 2*pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[151]*(Gs[149]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[153] - Gs[152]*yss[9])) + 2*(dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[145]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[145] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[146] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[74] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[75] - pow(E,yss[7])*pphi*Gs[151]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[149]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[153] - Gs[152]*yss[9])));
	Nee_sp_s[171]=-(pow(E,yss[8])*Pssp*pow(Gs[152],2)) - (2*bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[149]*Hs[75])/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gs[149]*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(Hs[75],2)*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[72]*(G2sp[8]*Hs[72] + G2sp[24]*Hs[73] + G2sp[40]*Hs[74] + G2sp[56]*Hs[75] + G2sp[72]*Hs[76] + G2sp[88]*Hs[77] + G2sp[104]*Hs[78] + G2sp[120]*Hs[79])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[73]*(G2sp[24]*Hs[72] + G2sp[264]*Hs[73] + G2sp[280]*Hs[74] + G2sp[296]*Hs[75] + G2sp[312]*Hs[76] + G2sp[328]*Hs[77] + G2sp[344]*Hs[78] + G2sp[360]*Hs[79])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[74]*(G2sp[40]*Hs[72] + G2sp[280]*Hs[73] + G2sp[520]*Hs[74] + G2sp[536]*Hs[75] + G2sp[552]*Hs[76] + G2sp[568]*Hs[77] + G2sp[584]*Hs[78] + G2sp[600]*Hs[79])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[75]*(G2sp[56]*Hs[72] + G2sp[296]*Hs[73] + G2sp[536]*Hs[74] + G2sp[776]*Hs[75] + G2sp[792]*Hs[76] + G2sp[808]*Hs[77] + G2sp[824]*Hs[78] + G2sp[840]*Hs[79])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[76]*(G2sp[72]*Hs[72] + G2sp[312]*Hs[73] + G2sp[552]*Hs[74] + G2sp[792]*Hs[75] + G2sp[1032]*Hs[76] + G2sp[1048]*Hs[77] + G2sp[1064]*Hs[78] + G2sp[1080]*Hs[79])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[77]*(G2sp[88]*Hs[72] + G2sp[328]*Hs[73] + G2sp[568]*Hs[74] + G2sp[808]*Hs[75] + G2sp[1048]*Hs[76] + G2sp[1288]*Hs[77] + G2sp[1304]*Hs[78] + G2sp[1320]*Hs[79])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[78]*(G2sp[104]*Hs[72] + G2sp[344]*Hs[73] + G2sp[584]*Hs[74] + G2sp[824]*Hs[75] + G2sp[1064]*Hs[76] + G2sp[1304]*Hs[77] + G2sp[1544]*Hs[78] + G2sp[1560]*Hs[79])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[79]*(G2sp[120]*Hs[72] + G2sp[360]*Hs[73] + G2sp[600]*Hs[74] + G2sp[840]*Hs[75] + G2sp[1080]*Hs[76] + G2sp[1320]*Hs[77] + G2sp[1560]*Hs[78] + G2sp[1800]*Hs[79])*(1 + yss[5]))/pow(zbar,rrho) - (2*bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[75]*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79],2)*(1 + yss[5]))/pow(zbar,rrho) + 2*(dP2ssp*Gs[153] + dP1ssp*Gs[154])*((bbeta*pow(E,yss[8])*Gs[149])/pow(zbar,rrho) - pow(E,yss[8])*Gs[152] + Gs[153] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[75]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*(1 + yss[5]))/pow(zbar,rrho));
	Nee_sp_s[172]=pow(E,yss[8])*Pssp*pow(Gs[152],2) - 2*kkappa*Pssp*Gs[150]*Gs[153] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Hs[72],2) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[72],2) - 2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[72]*Hs[74] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*pow(Hs[74],2) - 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[72]*Hs[75] - 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[74]*Hs[75] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*pow(Hs[75],2) - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*pow(Hs[75],2))/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[152]*(Hs[72] + Hs[75]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[72] + Hs[75])*(Gs[152] + Hs[72] + Hs[75]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[72]*(G2sp[1]*Hs[72] + G2sp[17]*Hs[73] + G2sp[33]*Hs[74] + G2sp[49]*Hs[75] + G2sp[65]*Hs[76] + G2sp[81]*Hs[77] + G2sp[97]*Hs[78] + G2sp[113]*Hs[79]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[72]*(G2sp[2]*Hs[72] + G2sp[18]*Hs[73] + G2sp[34]*Hs[74] + G2sp[50]*Hs[75] + G2sp[66]*Hs[76] + G2sp[82]*Hs[77] + G2sp[98]*Hs[78] + G2sp[114]*Hs[79]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[72]*(G2sp[4]*Hs[72] + G2sp[20]*Hs[73] + G2sp[36]*Hs[74] + G2sp[52]*Hs[75] + G2sp[68]*Hs[76] + G2sp[84]*Hs[77] + G2sp[100]*Hs[78] + G2sp[116]*Hs[79]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[72]*(G2sp[8]*Hs[72] + G2sp[24]*Hs[73] + G2sp[40]*Hs[74] + G2sp[56]*Hs[75] + G2sp[72]*Hs[76] + G2sp[88]*Hs[77] + G2sp[104]*Hs[78] + G2sp[120]*Hs[79]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[73]*(G2sp[17]*Hs[72] + G2sp[257]*Hs[73] + G2sp[273]*Hs[74] + G2sp[289]*Hs[75] + G2sp[305]*Hs[76] + G2sp[321]*Hs[77] + G2sp[337]*Hs[78] + G2sp[353]*Hs[79]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[73]*(G2sp[18]*Hs[72] + G2sp[258]*Hs[73] + G2sp[274]*Hs[74] + G2sp[290]*Hs[75] + G2sp[306]*Hs[76] + G2sp[322]*Hs[77] + G2sp[338]*Hs[78] + G2sp[354]*Hs[79]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[73]*(G2sp[20]*Hs[72] + G2sp[260]*Hs[73] + G2sp[276]*Hs[74] + G2sp[292]*Hs[75] + G2sp[308]*Hs[76] + G2sp[324]*Hs[77] + G2sp[340]*Hs[78] + G2sp[356]*Hs[79]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[73]*(G2sp[24]*Hs[72] + G2sp[264]*Hs[73] + G2sp[280]*Hs[74] + G2sp[296]*Hs[75] + G2sp[312]*Hs[76] + G2sp[328]*Hs[77] + G2sp[344]*Hs[78] + G2sp[360]*Hs[79]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[74]*(G2sp[33]*Hs[72] + G2sp[273]*Hs[73] + G2sp[513]*Hs[74] + G2sp[529]*Hs[75] + G2sp[545]*Hs[76] + G2sp[561]*Hs[77] + G2sp[577]*Hs[78] + G2sp[593]*Hs[79]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[74]*(G2sp[34]*Hs[72] + G2sp[274]*Hs[73] + G2sp[514]*Hs[74] + G2sp[530]*Hs[75] + G2sp[546]*Hs[76] + G2sp[562]*Hs[77] + G2sp[578]*Hs[78] + G2sp[594]*Hs[79]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[74]*(G2sp[36]*Hs[72] + G2sp[276]*Hs[73] + G2sp[516]*Hs[74] + G2sp[532]*Hs[75] + G2sp[548]*Hs[76] + G2sp[564]*Hs[77] + G2sp[580]*Hs[78] + G2sp[596]*Hs[79]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[74]*(G2sp[40]*Hs[72] + G2sp[280]*Hs[73] + G2sp[520]*Hs[74] + G2sp[536]*Hs[75] + G2sp[552]*Hs[76] + G2sp[568]*Hs[77] + G2sp[584]*Hs[78] + G2sp[600]*Hs[79]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[75]*(G2sp[49]*Hs[72] + G2sp[289]*Hs[73] + G2sp[529]*Hs[74] + G2sp[769]*Hs[75] + G2sp[785]*Hs[76] + G2sp[801]*Hs[77] + G2sp[817]*Hs[78] + G2sp[833]*Hs[79]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[75]*(G2sp[50]*Hs[72] + G2sp[290]*Hs[73] + G2sp[530]*Hs[74] + G2sp[770]*Hs[75] + G2sp[786]*Hs[76] + G2sp[802]*Hs[77] + G2sp[818]*Hs[78] + G2sp[834]*Hs[79]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[75]*(G2sp[52]*Hs[72] + G2sp[292]*Hs[73] + G2sp[532]*Hs[74] + G2sp[772]*Hs[75] + G2sp[788]*Hs[76] + G2sp[804]*Hs[77] + G2sp[820]*Hs[78] + G2sp[836]*Hs[79]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[75]*(G2sp[56]*Hs[72] + G2sp[296]*Hs[73] + G2sp[536]*Hs[74] + G2sp[776]*Hs[75] + G2sp[792]*Hs[76] + G2sp[808]*Hs[77] + G2sp[824]*Hs[78] + G2sp[840]*Hs[79]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[76]*(G2sp[65]*Hs[72] + G2sp[305]*Hs[73] + G2sp[545]*Hs[74] + G2sp[785]*Hs[75] + G2sp[1025]*Hs[76] + G2sp[1041]*Hs[77] + G2sp[1057]*Hs[78] + G2sp[1073]*Hs[79]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[76]*(G2sp[66]*Hs[72] + G2sp[306]*Hs[73] + G2sp[546]*Hs[74] + G2sp[786]*Hs[75] + G2sp[1026]*Hs[76] + G2sp[1042]*Hs[77] + G2sp[1058]*Hs[78] + G2sp[1074]*Hs[79]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[76]*(G2sp[68]*Hs[72] + G2sp[308]*Hs[73] + G2sp[548]*Hs[74] + G2sp[788]*Hs[75] + G2sp[1028]*Hs[76] + G2sp[1044]*Hs[77] + G2sp[1060]*Hs[78] + G2sp[1076]*Hs[79]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[76]*(G2sp[72]*Hs[72] + G2sp[312]*Hs[73] + G2sp[552]*Hs[74] + G2sp[792]*Hs[75] + G2sp[1032]*Hs[76] + G2sp[1048]*Hs[77] + G2sp[1064]*Hs[78] + G2sp[1080]*Hs[79]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[77]*(G2sp[81]*Hs[72] + G2sp[321]*Hs[73] + G2sp[561]*Hs[74] + G2sp[801]*Hs[75] + G2sp[1041]*Hs[76] + G2sp[1281]*Hs[77] + G2sp[1297]*Hs[78] + G2sp[1313]*Hs[79]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[77]*(G2sp[82]*Hs[72] + G2sp[322]*Hs[73] + G2sp[562]*Hs[74] + G2sp[802]*Hs[75] + G2sp[1042]*Hs[76] + G2sp[1282]*Hs[77] + G2sp[1298]*Hs[78] + G2sp[1314]*Hs[79]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[77]*(G2sp[84]*Hs[72] + G2sp[324]*Hs[73] + G2sp[564]*Hs[74] + G2sp[804]*Hs[75] + G2sp[1044]*Hs[76] + G2sp[1284]*Hs[77] + G2sp[1300]*Hs[78] + G2sp[1316]*Hs[79]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[77]*(G2sp[88]*Hs[72] + G2sp[328]*Hs[73] + G2sp[568]*Hs[74] + G2sp[808]*Hs[75] + G2sp[1048]*Hs[76] + G2sp[1288]*Hs[77] + G2sp[1304]*Hs[78] + G2sp[1320]*Hs[79]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[78]*(G2sp[97]*Hs[72] + G2sp[337]*Hs[73] + G2sp[577]*Hs[74] + G2sp[817]*Hs[75] + G2sp[1057]*Hs[76] + G2sp[1297]*Hs[77] + G2sp[1537]*Hs[78] + G2sp[1553]*Hs[79]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[78]*(G2sp[98]*Hs[72] + G2sp[338]*Hs[73] + G2sp[578]*Hs[74] + G2sp[818]*Hs[75] + G2sp[1058]*Hs[76] + G2sp[1298]*Hs[77] + G2sp[1538]*Hs[78] + G2sp[1554]*Hs[79]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[78]*(G2sp[100]*Hs[72] + G2sp[340]*Hs[73] + G2sp[580]*Hs[74] + G2sp[820]*Hs[75] + G2sp[1060]*Hs[76] + G2sp[1300]*Hs[77] + G2sp[1540]*Hs[78] + G2sp[1556]*Hs[79]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[78]*(G2sp[104]*Hs[72] + G2sp[344]*Hs[73] + G2sp[584]*Hs[74] + G2sp[824]*Hs[75] + G2sp[1064]*Hs[76] + G2sp[1304]*Hs[77] + G2sp[1544]*Hs[78] + G2sp[1560]*Hs[79]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[79]*(G2sp[113]*Hs[72] + G2sp[353]*Hs[73] + G2sp[593]*Hs[74] + G2sp[833]*Hs[75] + G2sp[1073]*Hs[76] + G2sp[1313]*Hs[77] + G2sp[1553]*Hs[78] + G2sp[1793]*Hs[79]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[79]*(G2sp[114]*Hs[72] + G2sp[354]*Hs[73] + G2sp[594]*Hs[74] + G2sp[834]*Hs[75] + G2sp[1074]*Hs[76] + G2sp[1314]*Hs[77] + G2sp[1554]*Hs[78] + G2sp[1794]*Hs[79]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[79]*(G2sp[116]*Hs[72] + G2sp[356]*Hs[73] + G2sp[596]*Hs[74] + G2sp[836]*Hs[75] + G2sp[1076]*Hs[76] + G2sp[1316]*Hs[77] + G2sp[1556]*Hs[78] + G2sp[1796]*Hs[79]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[79]*(G2sp[120]*Hs[72] + G2sp[360]*Hs[73] + G2sp[600]*Hs[74] + G2sp[840]*Hs[75] + G2sp[1080]*Hs[76] + G2sp[1320]*Hs[77] + G2sp[1560]*Hs[78] + G2sp[1800]*Hs[79]))/pow(zbar,rrho) - 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[72]*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79]) - 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[74]*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79]) - 2*pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[75]*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79],2) + 2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[72]*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79]) + 2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[74]*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79]) + 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[75]*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79]) + 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79])*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*pow(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79],2) + 2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[72]*((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79],2) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Gsp[4]*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79],2) + (2*bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[75]*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*pow(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79],2))/pow(zbar,rrho) + (2*bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[75]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[72] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[75] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79])))/pow(zbar,rrho) - (2*bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[72] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[75] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79])))/pow(zbar,rrho) - kkappa*Pssp*pow(Gs[150],2)*yss[9] + 2*(dP2ssp*Gs[153] + dP1ssp*Gs[154])*(pow(E,yss[8])*Gs[152] - kkappa*Gs[153] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[75])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[72] + Hs[75]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[72] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[75] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79])))/pow(zbar,rrho) - kkappa*Gs[150]*yss[9]);
	Nee_sp_s[173]=-(Pssp*pow(Gs[150],2)) + iiota*Pssp*zbar*pow(Hs[72] + Hs[75],2) + 2*(dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-Gs[150] + iiota*zbar*(Hs[72] + Hs[75]));
	Nee_sp_s[174]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*pow(Gs[145],2) - pow(E,yss[7])*Pssp*pow(Gs[151],2) + 2*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[145] - pow(E,yss[7])*Gs[151])*(dP2ssp*Gs[153] + dP1ssp*Gs[154]);
	Nee_sp_s[175]=-(pow(E,yss[0])*Pssp*pow(Gs[144],2)) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Gs[145],2) - 2*aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[146] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*pow(Gs[146],2) - pow(E,yss[3])*Pssp*pow(Gs[147],2) + 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[74] - 2*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[74] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[74],2) + 2*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[75] - 2*aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[75] + 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[75] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[75],2) - pow(E,yss[2])*pbar*Pssp*pow(Gs[146] + Hs[76],2) - 2*pphi*Pssp*Gs[149]*(pow(E,yss[1] + yss[7])*(Gs[145] + Gs[151]) + pow(E,yss[2])*pbar*(Gs[146] + Hs[76])) - pow(E,yss[11])*ebar*Pssp*pow(Hs[78],2) - pow(E,yss[1] + yss[7])*pphi*Pssp*pow(Gs[145] + Gs[151],2)*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*pow(Gs[146] + Hs[76],2)*yss[5] - (2*Pssp*zbar*pow(Gs[149],2)*xss[1])/pow(1 + yss[5],3) + (2*Pssp*zbar*Gs[149]*Hs[73])/pow(1 + yss[5],2) + (2*Pssp*zbar*Gs[149]*Hs[75]*xss[1])/pow(1 + yss[5],2) - (2*Pssp*zbar*Hs[73]*Hs[75])/(1 + yss[5]) - (Pssp*zbar*pow(Hs[75],2)*xss[1])/(1 + yss[5]) + 2*(dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(pow(E,yss[0])*Gs[144]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[145] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[146] - pow(E,yss[3])*Gs[147] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[149] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[75] - pow(E,yss[2])*pbar*(Gs[146] + Hs[76]) - pow(E,yss[11])*ebar*Hs[78] - pphi*(pow(E,yss[1] + yss[7])*(Gs[145] + Gs[151]) + pow(E,yss[2])*pbar*(Gs[146] + Hs[76]))*yss[5] + (zbar*Gs[149]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[73])/(1 + yss[5]) - (zbar*Hs[75]*xss[1])/(1 + yss[5]));
	Nee_sp_s[176]=pow(E,yss[3])*Pssp*pow(Gs[147],2) - pow(E,xss[0])*Pssp*zbar*pow(Hs[72] + Hs[75],2) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*pow(Hs[72] + Hs[75],2) + 2*(dP2ssp*Gs[153] + dP1ssp*Gs[154])*(pow(E,yss[3])*Gs[147] - pow(E,xss[0])*zbar*(Hs[72] + Hs[75]));
	Nee_sp_s[177]=pow(E,xss[0])*kkappa*Pssp*zbar*pow(Gs[150] + Hs[72] + Hs[75],2) - 2*pphi*Pssp*Gs[149]*(pow(E,yss[1] + yss[7])*(Gs[145] + Gs[151]) + pow(E,yss[2])*pbar*(Gs[146] + Hs[76])) + (2*Pssp*zbar*pow(Gs[149],2)*xss[1])/pow(1 + yss[5],3) - (2*Pssp*zbar*Gs[149]*Hs[73])/pow(1 + yss[5],2) - (2*Pssp*zbar*Gs[149]*Hs[75]*xss[1])/pow(1 + yss[5],2) + (2*Pssp*zbar*Hs[73]*Hs[75])/(1 + yss[5]) + (Pssp*zbar*pow(Hs[75],2)*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*pow(Gs[145] + Gs[151],2)*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*pow(Gs[146] + Hs[76],2)*(1 + yss[5]) + 2*(dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[149]) - Gs[154] + pow(E,xss[0])*kkappa*zbar*(Gs[150] + Hs[72] + Hs[75]) - (zbar*Gs[149]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[73])/(1 + yss[5]) + (zbar*Hs[75]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[145] + Gs[151]) + pow(E,yss[2])*pbar*(Gs[146] + Hs[76]))*(1 + yss[5]));
	Nee_sp_s[178]=2*(dP2ssp*Gs[153] + dP1ssp*Gs[154])*((-1 + nnus)*Gs[153] + nnus*Gs[154]);
	Nee_sp_s[179]=pow(E,bbar - xss[1])*ppsir*Pssp*pow(Hs[73],2) + 2*(dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-Gs[149] - pow(E,bbar - xss[1])*ppsir*Hs[73] + Hs[77]);
	Nee_sp_s[180]=-(pow(E,xss[0])*(Gs[148] - Hs[72])*(2*dP2ssp*Gs[153] + 2*dP1ssp*Gs[154] + Pssp*(Gs[148] + Hs[72])));
	Nee_sp_s[181]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Gs[145],2)) + 2*aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[146] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*pow(Gs[146],2) + pow(E,yss[11])*Pssp*pow(Gs[155],2) - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[74] + 2*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[74] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[74],2) - 2*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[75] + 2*aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[75] - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[75] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[75],2) + pow(E,yss[2])*pbar*Pssp*pow(Gs[146] + Hs[76],2) + 2*(dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[145]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[146] + pow(E,yss[11])*Gs[155] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[74] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[75] + pow(E,yss[2])*pbar*(Gs[146] + Hs[76]));
	Nee_sp_s[182]=(2*Pssp*zbar*Hs[73]*(Gs[155] - Hs[75]) - Pssp*zbar*pow(Gs[155] - Hs[75],2)*xss[1] + 2*(dP2ssp*Gs[153] + dP1ssp*Gs[154])*(pow(E,yss[11])*Gs[156] - zbar*Hs[73] + zbar*(Gs[155] - Hs[75])*xss[1]))/pow(E,yss[11]);
	Nee_sp_s[183]=(-2*Pssp*zbar*Hs[73]*Hs[75] - Pssp*(-1 + zbar)*pow(Gs[155],2)*xss[1] - Pssp*zbar*pow(Hs[75],2)*xss[1] + 2*Pssp*zbar*Gs[155]*(Hs[73] + Hs[75]*xss[1]) - 2*(dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(pow(E,yss[11])*Gs[157]) + zbar*Hs[73] - (-1 + zbar)*Gs[155]*xss[1] + zbar*Hs[75]*xss[1]))/pow(E,yss[11]);
	Nee_sp_s[184]=pow(E,yss[0] - yss[11])*Pssp*pow(Gs[144],2) + pow(E,yss[3] - yss[11])*Pssp*pow(Gs[147],2) - Pssp*pow(Gs[155],2) + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*pow(Gs[155],2))/pow(E,yss[11]) + ebar*Pssp*pow(Hs[78],2) + (2*Pssp*Gs[155]*(-(pow(E,yss[0])*Gs[144]) - pow(E,yss[3])*Gs[147] + pow(E,yss[11])*Gs[155] - pow(E,yss[11])*ebar*Hs[78]))/pow(E,yss[11]) + (2*(dP2ssp*Gs[153] + dP1ssp*Gs[154])*(pow(E,yss[0])*Gs[144] + pow(E,yss[3])*Gs[147] - pow(E,yss[0])*Gs[155] - pow(E,yss[3])*Gs[155] - pow(E,yss[11])*ebar*Gs[155] + pow(E,yss[11])*Gs[158] + pow(E,yss[11])*ebar*Hs[78]))/pow(E,yss[11]);
	Nee_sp_s[185]=(-2*Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[153]*Hs[75] + 2*Pssp*pow(zbar,rrho)*Gs[153]*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79]) - Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*pow(Hs[75],2)*yss[9] + Pssp*pow(zbar,rrho)*Hs[72]*(G2sp[8]*Hs[72] + G2sp[24]*Hs[73] + G2sp[40]*Hs[74] + G2sp[56]*Hs[75] + G2sp[72]*Hs[76] + G2sp[88]*Hs[77] + G2sp[104]*Hs[78] + G2sp[120]*Hs[79])*yss[9] + Pssp*pow(zbar,rrho)*Hs[73]*(G2sp[24]*Hs[72] + G2sp[264]*Hs[73] + G2sp[280]*Hs[74] + G2sp[296]*Hs[75] + G2sp[312]*Hs[76] + G2sp[328]*Hs[77] + G2sp[344]*Hs[78] + G2sp[360]*Hs[79])*yss[9] + Pssp*pow(zbar,rrho)*Hs[74]*(G2sp[40]*Hs[72] + G2sp[280]*Hs[73] + G2sp[520]*Hs[74] + G2sp[536]*Hs[75] + G2sp[552]*Hs[76] + G2sp[568]*Hs[77] + G2sp[584]*Hs[78] + G2sp[600]*Hs[79])*yss[9] + Pssp*pow(zbar,rrho)*Hs[75]*(G2sp[56]*Hs[72] + G2sp[296]*Hs[73] + G2sp[536]*Hs[74] + G2sp[776]*Hs[75] + G2sp[792]*Hs[76] + G2sp[808]*Hs[77] + G2sp[824]*Hs[78] + G2sp[840]*Hs[79])*yss[9] + Pssp*pow(zbar,rrho)*Hs[76]*(G2sp[72]*Hs[72] + G2sp[312]*Hs[73] + G2sp[552]*Hs[74] + G2sp[792]*Hs[75] + G2sp[1032]*Hs[76] + G2sp[1048]*Hs[77] + G2sp[1064]*Hs[78] + G2sp[1080]*Hs[79])*yss[9] + Pssp*pow(zbar,rrho)*Hs[77]*(G2sp[88]*Hs[72] + G2sp[328]*Hs[73] + G2sp[568]*Hs[74] + G2sp[808]*Hs[75] + G2sp[1048]*Hs[76] + G2sp[1288]*Hs[77] + G2sp[1304]*Hs[78] + G2sp[1320]*Hs[79])*yss[9] + Pssp*pow(zbar,rrho)*Hs[78]*(G2sp[104]*Hs[72] + G2sp[344]*Hs[73] + G2sp[584]*Hs[74] + G2sp[824]*Hs[75] + G2sp[1064]*Hs[76] + G2sp[1304]*Hs[77] + G2sp[1544]*Hs[78] + G2sp[1560]*Hs[79])*yss[9] + Pssp*pow(zbar,rrho)*Hs[79]*(G2sp[120]*Hs[72] + G2sp[360]*Hs[73] + G2sp[600]*Hs[74] + G2sp[840]*Hs[75] + G2sp[1080]*Hs[76] + G2sp[1320]*Hs[77] + G2sp[1560]*Hs[78] + G2sp[1800]*Hs[79])*yss[9] + 2*Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[75]*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*yss[9] - Pssp*pow(zbar,rrho)*pow(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79],2)*yss[9] + 2*(dP2ssp*Gs[153] + dP1ssp*Gs[154])*(bbeta*pow(E,yss[8])*Gs[159] + pow(zbar,rrho)*(-Gs[153] + (-(rrho*rrhoz) + Gsp[56])*Hs[75]*yss[9] + (Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*yss[9])))/(bbeta*pow(E,yss[8]));
	Nee_sp_s[186]=-2*(dP2ssp*Gs[153] + dP1ssp*Gs[154])*Hs[74];
	Nee_sp_s[187]=2*(dP2ssp*Gs[153] + dP1ssp*Gs[154])*(ssigmazs - Hs[75]);
	Nee_sp_s[188]=-2*(dP2ssp*Gs[153] + dP1ssp*Gs[154])*Hs[76];
	Nee_sp_s[189]=-2*(dP2ssp*Gs[153] + dP1ssp*Gs[154])*Hs[79];
	Nee_sp_s[190]=-2*(dP2ssp*Gs[153] + dP1ssp*Gs[154])*Hs[78];
	Nee_sp_s[191]=-2*(dP2ssp*Gs[153] + dP1ssp*Gs[154])*Hs[77];
	Nee_sp_s[192]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[144]*Gs[160]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[145]*Gs[161] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[144] - pow(pow(E,yss[1]),oomega)*Gs[145])*(pow(E,yss[0])*Gs[160] - pow(pow(E,yss[1]),oomega)*Gs[161]) - pow(E,yss[8])*Pssp*Gs[152]*Gs[168] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[160] - pow(pow(E,yss[1]),oomega)*Gs[161])*Hs[79] + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[144] - pow(pow(E,yss[1]),oomega)*Gs[145])) - pow(E,yss[8])*Gs[152] + Hs[79]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[144] - pow(pow(E,yss[1]),oomega)*Gs[145])*Hs[87] + (Pssp*Hs[79]*Hs[87])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[160] - pow(pow(E,yss[1]),oomega)*Gs[161])) - pow(E,yss[8])*Gs[168] + Hs[87]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nee_sp_s[193]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[161]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Gs[161] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[162] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[146]*Gs[162] - (pbar*pphi*Pssp*Gs[153]*Gs[165])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[149]*Gs[169])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Hs[74] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[162]*Hs[74] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Hs[75] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[162]*Hs[75] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[82] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[82] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[82] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[75]*Hs[82] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[83] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[83] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[83] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[75]*Hs[83] + (pbar*pphi*Pssp*Gs[153]*Gs[168]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[152]*Gs[169]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[152]*Gs[165]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[149]*Gs[168]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[152]*Gs[168]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[76]*Hs[84]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[84]*(Gs[149]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[153] - Gs[152]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[76]*(Gs[165]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[169] - Gs[168]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[145]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[146] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[74] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[75] - pbar*Hs[76]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[149]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[153] - Gs[152]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[161]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[162] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[82] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[83] - pbar*Hs[84]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[165]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[169] - Gs[168]*yss[9])))/pow(E,yss[8]));
	Nee_sp_s[194]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[145]*Gs[161]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[161] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Gs[161] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[162] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[146]*Gs[162] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[153]*Gs[165] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[149]*Gs[169] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[162]*Hs[74] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Hs[75] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[162]*Hs[75] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[82] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[82] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[82] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[75]*Hs[82] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[83] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[83] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[83] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[75]*Hs[83] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[153]*Gs[168]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[152]*Gs[169]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[152]*Gs[165]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[149]*Gs[168]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[152]*Gs[168]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[151]*Gs[167]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[167]*(Gs[149]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[153] - Gs[152]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[151]*(Gs[165]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[169] - Gs[168]*yss[9])) + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[145]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[145] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[146] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[74] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[75] - pow(E,yss[7])*pphi*Gs[151]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[149]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[153] - Gs[152]*yss[9]))) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[161]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[161] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[162] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[82] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[83] - pow(E,yss[7])*pphi*Gs[167]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[165]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[169] - Gs[168]*yss[9])));
	Nee_sp_s[195]=-(pow(E,yss[8])*Pssp*Gs[152]*Gs[168]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[165]*Hs[75])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[165]*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[149]*Hs[83])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[149]*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[75]*Hs[83]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*Hs[83]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[72]*(G2sp[8]*Hs[80] + G2sp[24]*Hs[81] + G2sp[40]*Hs[82] + G2sp[56]*Hs[83] + G2sp[72]*Hs[84] + G2sp[88]*Hs[85] + G2sp[104]*Hs[86] + G2sp[120]*Hs[87])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[73]*(G2sp[24]*Hs[80] + G2sp[264]*Hs[81] + G2sp[280]*Hs[82] + G2sp[296]*Hs[83] + G2sp[312]*Hs[84] + G2sp[328]*Hs[85] + G2sp[344]*Hs[86] + G2sp[360]*Hs[87])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[74]*(G2sp[40]*Hs[80] + G2sp[280]*Hs[81] + G2sp[520]*Hs[82] + G2sp[536]*Hs[83] + G2sp[552]*Hs[84] + G2sp[568]*Hs[85] + G2sp[584]*Hs[86] + G2sp[600]*Hs[87])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[75]*(G2sp[56]*Hs[80] + G2sp[296]*Hs[81] + G2sp[536]*Hs[82] + G2sp[776]*Hs[83] + G2sp[792]*Hs[84] + G2sp[808]*Hs[85] + G2sp[824]*Hs[86] + G2sp[840]*Hs[87])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[76]*(G2sp[72]*Hs[80] + G2sp[312]*Hs[81] + G2sp[552]*Hs[82] + G2sp[792]*Hs[83] + G2sp[1032]*Hs[84] + G2sp[1048]*Hs[85] + G2sp[1064]*Hs[86] + G2sp[1080]*Hs[87])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[77]*(G2sp[88]*Hs[80] + G2sp[328]*Hs[81] + G2sp[568]*Hs[82] + G2sp[808]*Hs[83] + G2sp[1048]*Hs[84] + G2sp[1288]*Hs[85] + G2sp[1304]*Hs[86] + G2sp[1320]*Hs[87])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[78]*(G2sp[104]*Hs[80] + G2sp[344]*Hs[81] + G2sp[584]*Hs[82] + G2sp[824]*Hs[83] + G2sp[1064]*Hs[84] + G2sp[1304]*Hs[85] + G2sp[1544]*Hs[86] + G2sp[1560]*Hs[87])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[79]*(G2sp[120]*Hs[80] + G2sp[360]*Hs[81] + G2sp[600]*Hs[82] + G2sp[840]*Hs[83] + G2sp[1080]*Hs[84] + G2sp[1320]*Hs[85] + G2sp[1560]*Hs[86] + G2sp[1800]*Hs[87])*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[75]*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*((bbeta*pow(E,yss[8])*Gs[149])/pow(zbar,rrho) - pow(E,yss[8])*Gs[152] + Gs[153] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[75]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*((bbeta*pow(E,yss[8])*Gs[165])/pow(zbar,rrho) - pow(E,yss[8])*Gs[168] + Gs[169] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[83]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87])*(1 + yss[5]))/pow(zbar,rrho));
	Nee_sp_s[196]=-(kkappa*Pssp*Gs[153]*Gs[166]) + pow(E,yss[8])*Pssp*Gs[152]*Gs[168] - kkappa*Pssp*Gs[150]*Gs[169] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[72]*Hs[80] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[72]*Hs[80] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[74]*Hs[80] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[75]*Hs[80] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79])*Hs[80] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79])*Hs[80] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79])*Hs[80] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[72]*Hs[82] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[74]*Hs[82] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[75]*Hs[82] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79])*Hs[82] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79])*Hs[82] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[72]*Hs[83] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[74]*Hs[83] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[75]*Hs[83] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[75]*Hs[83])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79])*Hs[83] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79])*Hs[83] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*Hs[83])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[72] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[75] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79]))*Hs[83])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[152]*(Hs[80] + Hs[83]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[72] + Hs[75])*(Gs[168] + Hs[80] + Hs[83]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[72]*(G2sp[1]*Hs[80] + G2sp[17]*Hs[81] + G2sp[33]*Hs[82] + G2sp[49]*Hs[83] + G2sp[65]*Hs[84] + G2sp[81]*Hs[85] + G2sp[97]*Hs[86] + G2sp[113]*Hs[87]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[72]*(G2sp[2]*Hs[80] + G2sp[18]*Hs[81] + G2sp[34]*Hs[82] + G2sp[50]*Hs[83] + G2sp[66]*Hs[84] + G2sp[82]*Hs[85] + G2sp[98]*Hs[86] + G2sp[114]*Hs[87]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[72]*(G2sp[4]*Hs[80] + G2sp[20]*Hs[81] + G2sp[36]*Hs[82] + G2sp[52]*Hs[83] + G2sp[68]*Hs[84] + G2sp[84]*Hs[85] + G2sp[100]*Hs[86] + G2sp[116]*Hs[87]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[72]*(G2sp[8]*Hs[80] + G2sp[24]*Hs[81] + G2sp[40]*Hs[82] + G2sp[56]*Hs[83] + G2sp[72]*Hs[84] + G2sp[88]*Hs[85] + G2sp[104]*Hs[86] + G2sp[120]*Hs[87]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[73]*(G2sp[17]*Hs[80] + G2sp[257]*Hs[81] + G2sp[273]*Hs[82] + G2sp[289]*Hs[83] + G2sp[305]*Hs[84] + G2sp[321]*Hs[85] + G2sp[337]*Hs[86] + G2sp[353]*Hs[87]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[73]*(G2sp[18]*Hs[80] + G2sp[258]*Hs[81] + G2sp[274]*Hs[82] + G2sp[290]*Hs[83] + G2sp[306]*Hs[84] + G2sp[322]*Hs[85] + G2sp[338]*Hs[86] + G2sp[354]*Hs[87]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[73]*(G2sp[20]*Hs[80] + G2sp[260]*Hs[81] + G2sp[276]*Hs[82] + G2sp[292]*Hs[83] + G2sp[308]*Hs[84] + G2sp[324]*Hs[85] + G2sp[340]*Hs[86] + G2sp[356]*Hs[87]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[73]*(G2sp[24]*Hs[80] + G2sp[264]*Hs[81] + G2sp[280]*Hs[82] + G2sp[296]*Hs[83] + G2sp[312]*Hs[84] + G2sp[328]*Hs[85] + G2sp[344]*Hs[86] + G2sp[360]*Hs[87]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[74]*(G2sp[33]*Hs[80] + G2sp[273]*Hs[81] + G2sp[513]*Hs[82] + G2sp[529]*Hs[83] + G2sp[545]*Hs[84] + G2sp[561]*Hs[85] + G2sp[577]*Hs[86] + G2sp[593]*Hs[87]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[74]*(G2sp[34]*Hs[80] + G2sp[274]*Hs[81] + G2sp[514]*Hs[82] + G2sp[530]*Hs[83] + G2sp[546]*Hs[84] + G2sp[562]*Hs[85] + G2sp[578]*Hs[86] + G2sp[594]*Hs[87]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[74]*(G2sp[36]*Hs[80] + G2sp[276]*Hs[81] + G2sp[516]*Hs[82] + G2sp[532]*Hs[83] + G2sp[548]*Hs[84] + G2sp[564]*Hs[85] + G2sp[580]*Hs[86] + G2sp[596]*Hs[87]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[74]*(G2sp[40]*Hs[80] + G2sp[280]*Hs[81] + G2sp[520]*Hs[82] + G2sp[536]*Hs[83] + G2sp[552]*Hs[84] + G2sp[568]*Hs[85] + G2sp[584]*Hs[86] + G2sp[600]*Hs[87]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[75]*(G2sp[49]*Hs[80] + G2sp[289]*Hs[81] + G2sp[529]*Hs[82] + G2sp[769]*Hs[83] + G2sp[785]*Hs[84] + G2sp[801]*Hs[85] + G2sp[817]*Hs[86] + G2sp[833]*Hs[87]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[75]*(G2sp[50]*Hs[80] + G2sp[290]*Hs[81] + G2sp[530]*Hs[82] + G2sp[770]*Hs[83] + G2sp[786]*Hs[84] + G2sp[802]*Hs[85] + G2sp[818]*Hs[86] + G2sp[834]*Hs[87]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[75]*(G2sp[52]*Hs[80] + G2sp[292]*Hs[81] + G2sp[532]*Hs[82] + G2sp[772]*Hs[83] + G2sp[788]*Hs[84] + G2sp[804]*Hs[85] + G2sp[820]*Hs[86] + G2sp[836]*Hs[87]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[75]*(G2sp[56]*Hs[80] + G2sp[296]*Hs[81] + G2sp[536]*Hs[82] + G2sp[776]*Hs[83] + G2sp[792]*Hs[84] + G2sp[808]*Hs[85] + G2sp[824]*Hs[86] + G2sp[840]*Hs[87]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[76]*(G2sp[65]*Hs[80] + G2sp[305]*Hs[81] + G2sp[545]*Hs[82] + G2sp[785]*Hs[83] + G2sp[1025]*Hs[84] + G2sp[1041]*Hs[85] + G2sp[1057]*Hs[86] + G2sp[1073]*Hs[87]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[76]*(G2sp[66]*Hs[80] + G2sp[306]*Hs[81] + G2sp[546]*Hs[82] + G2sp[786]*Hs[83] + G2sp[1026]*Hs[84] + G2sp[1042]*Hs[85] + G2sp[1058]*Hs[86] + G2sp[1074]*Hs[87]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[76]*(G2sp[68]*Hs[80] + G2sp[308]*Hs[81] + G2sp[548]*Hs[82] + G2sp[788]*Hs[83] + G2sp[1028]*Hs[84] + G2sp[1044]*Hs[85] + G2sp[1060]*Hs[86] + G2sp[1076]*Hs[87]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[76]*(G2sp[72]*Hs[80] + G2sp[312]*Hs[81] + G2sp[552]*Hs[82] + G2sp[792]*Hs[83] + G2sp[1032]*Hs[84] + G2sp[1048]*Hs[85] + G2sp[1064]*Hs[86] + G2sp[1080]*Hs[87]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[77]*(G2sp[81]*Hs[80] + G2sp[321]*Hs[81] + G2sp[561]*Hs[82] + G2sp[801]*Hs[83] + G2sp[1041]*Hs[84] + G2sp[1281]*Hs[85] + G2sp[1297]*Hs[86] + G2sp[1313]*Hs[87]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[77]*(G2sp[82]*Hs[80] + G2sp[322]*Hs[81] + G2sp[562]*Hs[82] + G2sp[802]*Hs[83] + G2sp[1042]*Hs[84] + G2sp[1282]*Hs[85] + G2sp[1298]*Hs[86] + G2sp[1314]*Hs[87]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[77]*(G2sp[84]*Hs[80] + G2sp[324]*Hs[81] + G2sp[564]*Hs[82] + G2sp[804]*Hs[83] + G2sp[1044]*Hs[84] + G2sp[1284]*Hs[85] + G2sp[1300]*Hs[86] + G2sp[1316]*Hs[87]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[77]*(G2sp[88]*Hs[80] + G2sp[328]*Hs[81] + G2sp[568]*Hs[82] + G2sp[808]*Hs[83] + G2sp[1048]*Hs[84] + G2sp[1288]*Hs[85] + G2sp[1304]*Hs[86] + G2sp[1320]*Hs[87]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[78]*(G2sp[97]*Hs[80] + G2sp[337]*Hs[81] + G2sp[577]*Hs[82] + G2sp[817]*Hs[83] + G2sp[1057]*Hs[84] + G2sp[1297]*Hs[85] + G2sp[1537]*Hs[86] + G2sp[1553]*Hs[87]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[78]*(G2sp[98]*Hs[80] + G2sp[338]*Hs[81] + G2sp[578]*Hs[82] + G2sp[818]*Hs[83] + G2sp[1058]*Hs[84] + G2sp[1298]*Hs[85] + G2sp[1538]*Hs[86] + G2sp[1554]*Hs[87]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[78]*(G2sp[100]*Hs[80] + G2sp[340]*Hs[81] + G2sp[580]*Hs[82] + G2sp[820]*Hs[83] + G2sp[1060]*Hs[84] + G2sp[1300]*Hs[85] + G2sp[1540]*Hs[86] + G2sp[1556]*Hs[87]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[78]*(G2sp[104]*Hs[80] + G2sp[344]*Hs[81] + G2sp[584]*Hs[82] + G2sp[824]*Hs[83] + G2sp[1064]*Hs[84] + G2sp[1304]*Hs[85] + G2sp[1544]*Hs[86] + G2sp[1560]*Hs[87]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[79]*(G2sp[113]*Hs[80] + G2sp[353]*Hs[81] + G2sp[593]*Hs[82] + G2sp[833]*Hs[83] + G2sp[1073]*Hs[84] + G2sp[1313]*Hs[85] + G2sp[1553]*Hs[86] + G2sp[1793]*Hs[87]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[79]*(G2sp[114]*Hs[80] + G2sp[354]*Hs[81] + G2sp[594]*Hs[82] + G2sp[834]*Hs[83] + G2sp[1074]*Hs[84] + G2sp[1314]*Hs[85] + G2sp[1554]*Hs[86] + G2sp[1794]*Hs[87]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[79]*(G2sp[116]*Hs[80] + G2sp[356]*Hs[81] + G2sp[596]*Hs[82] + G2sp[836]*Hs[83] + G2sp[1076]*Hs[84] + G2sp[1316]*Hs[85] + G2sp[1556]*Hs[86] + G2sp[1796]*Hs[87]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[79]*(G2sp[120]*Hs[80] + G2sp[360]*Hs[81] + G2sp[600]*Hs[82] + G2sp[840]*Hs[83] + G2sp[1080]*Hs[84] + G2sp[1320]*Hs[85] + G2sp[1560]*Hs[86] + G2sp[1800]*Hs[87]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[72]*(Gsp[1]*Hs[80] + Gsp[17]*Hs[81] + Gsp[33]*Hs[82] + Gsp[49]*Hs[83] + Gsp[65]*Hs[84] + Gsp[81]*Hs[85] + Gsp[97]*Hs[86] + Gsp[113]*Hs[87]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[74]*(Gsp[1]*Hs[80] + Gsp[17]*Hs[81] + Gsp[33]*Hs[82] + Gsp[49]*Hs[83] + Gsp[65]*Hs[84] + Gsp[81]*Hs[85] + Gsp[97]*Hs[86] + Gsp[113]*Hs[87]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[75]*(Gsp[1]*Hs[80] + Gsp[17]*Hs[81] + Gsp[33]*Hs[82] + Gsp[49]*Hs[83] + Gsp[65]*Hs[84] + Gsp[81]*Hs[85] + Gsp[97]*Hs[86] + Gsp[113]*Hs[87]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79])*(Gsp[1]*Hs[80] + Gsp[17]*Hs[81] + Gsp[33]*Hs[82] + Gsp[49]*Hs[83] + Gsp[65]*Hs[84] + Gsp[81]*Hs[85] + Gsp[97]*Hs[86] + Gsp[113]*Hs[87]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79])*(Gsp[1]*Hs[80] + Gsp[17]*Hs[81] + Gsp[33]*Hs[82] + Gsp[49]*Hs[83] + Gsp[65]*Hs[84] + Gsp[81]*Hs[85] + Gsp[97]*Hs[86] + Gsp[113]*Hs[87]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[72]*(Gsp[2]*Hs[80] + Gsp[18]*Hs[81] + Gsp[34]*Hs[82] + Gsp[50]*Hs[83] + Gsp[66]*Hs[84] + Gsp[82]*Hs[85] + Gsp[98]*Hs[86] + Gsp[114]*Hs[87]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[74]*(Gsp[2]*Hs[80] + Gsp[18]*Hs[81] + Gsp[34]*Hs[82] + Gsp[50]*Hs[83] + Gsp[66]*Hs[84] + Gsp[82]*Hs[85] + Gsp[98]*Hs[86] + Gsp[114]*Hs[87]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[75]*(Gsp[2]*Hs[80] + Gsp[18]*Hs[81] + Gsp[34]*Hs[82] + Gsp[50]*Hs[83] + Gsp[66]*Hs[84] + Gsp[82]*Hs[85] + Gsp[98]*Hs[86] + Gsp[114]*Hs[87]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79])*(Gsp[2]*Hs[80] + Gsp[18]*Hs[81] + Gsp[34]*Hs[82] + Gsp[50]*Hs[83] + Gsp[66]*Hs[84] + Gsp[82]*Hs[85] + Gsp[98]*Hs[86] + Gsp[114]*Hs[87]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79])*(Gsp[2]*Hs[80] + Gsp[18]*Hs[81] + Gsp[34]*Hs[82] + Gsp[50]*Hs[83] + Gsp[66]*Hs[84] + Gsp[82]*Hs[85] + Gsp[98]*Hs[86] + Gsp[114]*Hs[87]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[72]*((-1 + Gsp[4])*Hs[80] + Gsp[20]*Hs[81] + Gsp[36]*Hs[82] + (rrhoz + Gsp[52])*Hs[83] + Gsp[68]*Hs[84] + Gsp[84]*Hs[85] + Gsp[100]*Hs[86] + Gsp[116]*Hs[87]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79])*((-1 + Gsp[4])*Hs[80] + Gsp[20]*Hs[81] + Gsp[36]*Hs[82] + (rrhoz + Gsp[52])*Hs[83] + Gsp[68]*Hs[84] + Gsp[84]*Hs[85] + Gsp[100]*Hs[86] + Gsp[116]*Hs[87]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79])*(Gsp[4]*Hs[80] + Gsp[20]*Hs[81] + Gsp[36]*Hs[82] + (rrhoz + Gsp[52])*Hs[83] + Gsp[68]*Hs[84] + Gsp[84]*Hs[85] + Gsp[100]*Hs[86] + Gsp[116]*Hs[87]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[75]*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[72] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[75] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79]))*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[75]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[80] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[82] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[83] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[80] + Gsp[17]*Hs[81] + Gsp[33]*Hs[82] + Gsp[49]*Hs[83] + Gsp[65]*Hs[84] + Gsp[81]*Hs[85] + Gsp[97]*Hs[86] + Gsp[113]*Hs[87]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[80] + Gsp[18]*Hs[81] + Gsp[34]*Hs[82] + Gsp[50]*Hs[83] + Gsp[66]*Hs[84] + Gsp[82]*Hs[85] + Gsp[98]*Hs[86] + Gsp[114]*Hs[87]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[80] + Gsp[20]*Hs[81] + Gsp[36]*Hs[82] + (rrhoz + Gsp[52])*Hs[83] + Gsp[68]*Hs[84] + Gsp[84]*Hs[85] + Gsp[100]*Hs[86] + Gsp[116]*Hs[87])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[80] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[82] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[83] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[80] + Gsp[17]*Hs[81] + Gsp[33]*Hs[82] + Gsp[49]*Hs[83] + Gsp[65]*Hs[84] + Gsp[81]*Hs[85] + Gsp[97]*Hs[86] + Gsp[113]*Hs[87]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[80] + Gsp[18]*Hs[81] + Gsp[34]*Hs[82] + Gsp[50]*Hs[83] + Gsp[66]*Hs[84] + Gsp[82]*Hs[85] + Gsp[98]*Hs[86] + Gsp[114]*Hs[87]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[80] + Gsp[20]*Hs[81] + Gsp[36]*Hs[82] + (rrhoz + Gsp[52])*Hs[83] + Gsp[68]*Hs[84] + Gsp[84]*Hs[85] + Gsp[100]*Hs[86] + Gsp[116]*Hs[87])))/pow(zbar,rrho) - kkappa*Pssp*Gs[150]*Gs[166]*yss[9] + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(pow(E,yss[8])*Gs[152] - kkappa*Gs[153] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[75])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[72] + Hs[75]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[72] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[75] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79])))/pow(zbar,rrho) - kkappa*Gs[150]*yss[9]) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(pow(E,yss[8])*Gs[168] - kkappa*Gs[169] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[83])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[80] + Hs[83]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[80] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[82] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[83] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[80] + Gsp[17]*Hs[81] + Gsp[33]*Hs[82] + Gsp[49]*Hs[83] + Gsp[65]*Hs[84] + Gsp[81]*Hs[85] + Gsp[97]*Hs[86] + Gsp[113]*Hs[87]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[80] + Gsp[18]*Hs[81] + Gsp[34]*Hs[82] + Gsp[50]*Hs[83] + Gsp[66]*Hs[84] + Gsp[82]*Hs[85] + Gsp[98]*Hs[86] + Gsp[114]*Hs[87]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[80] + Gsp[20]*Hs[81] + Gsp[36]*Hs[82] + (rrhoz + Gsp[52])*Hs[83] + Gsp[68]*Hs[84] + Gsp[84]*Hs[85] + Gsp[100]*Hs[86] + Gsp[116]*Hs[87])))/pow(zbar,rrho) - kkappa*Gs[166]*yss[9]);
	Nee_sp_s[197]=-(Pssp*Gs[150]*Gs[166]) + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(-Gs[150] + iiota*zbar*(Hs[72] + Hs[75])) + iiota*Pssp*zbar*(Hs[72] + Hs[75])*(Hs[80] + Hs[83]) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-Gs[166] + iiota*zbar*(Hs[80] + Hs[83]));
	Nee_sp_s[198]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[145]*Gs[161] - pow(E,yss[7])*Pssp*Gs[151]*Gs[167] + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[161] - pow(E,yss[7])*Gs[167]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[145] - pow(E,yss[7])*Gs[151])*(dP2ssp*Gs[169] + dP1ssp*Gs[170]);
	Nee_sp_s[199]=-(pow(E,yss[0])*Pssp*Gs[144]*Gs[160]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[161] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Gs[161] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[162] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[146]*Gs[162] - pow(E,yss[3])*Pssp*Gs[147]*Gs[163] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Hs[74] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[162]*Hs[74] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Hs[75] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[162]*Hs[75] - pphi*Pssp*Gs[165]*(pow(E,yss[1] + yss[7])*(Gs[145] + Gs[151]) + pow(E,yss[2])*pbar*(Gs[146] + Hs[76])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[82] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[82] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[75]*Hs[82] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[83] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[83] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[83] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[75]*Hs[83] - pow(E,yss[2])*pbar*Pssp*(Gs[146] + Hs[76])*(Gs[162] + Hs[84]) - pphi*Pssp*Gs[149]*(pow(E,yss[1] + yss[7])*(Gs[161] + Gs[167]) + pow(E,yss[2])*pbar*(Gs[162] + Hs[84])) - pow(E,yss[11])*ebar*Pssp*Hs[78]*Hs[86] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[145] + Gs[151])*(Gs[161] + Gs[167])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[146] + Hs[76])*(Gs[162] + Hs[84])*yss[5] - (2*Pssp*zbar*Gs[149]*Gs[165]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[165]*Hs[73])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[149]*Hs[81])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[165]*Hs[75]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[149]*Hs[83]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[75]*Hs[81])/(1 + yss[5]) - (Pssp*zbar*Hs[73]*Hs[83])/(1 + yss[5]) - (Pssp*zbar*Hs[75]*Hs[83]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(-(pow(E,yss[0])*Gs[144]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[145] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[146] - pow(E,yss[3])*Gs[147] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[149] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[75] - pow(E,yss[2])*pbar*(Gs[146] + Hs[76]) - pow(E,yss[11])*ebar*Hs[78] - pphi*(pow(E,yss[1] + yss[7])*(Gs[145] + Gs[151]) + pow(E,yss[2])*pbar*(Gs[146] + Hs[76]))*yss[5] + (zbar*Gs[149]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[73])/(1 + yss[5]) - (zbar*Hs[75]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(pow(E,yss[0])*Gs[160]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[161] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[162] - pow(E,yss[3])*Gs[163] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[165] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[82] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[83] - pow(E,yss[2])*pbar*(Gs[162] + Hs[84]) - pow(E,yss[11])*ebar*Hs[86] - pphi*(pow(E,yss[1] + yss[7])*(Gs[161] + Gs[167]) + pow(E,yss[2])*pbar*(Gs[162] + Hs[84]))*yss[5] + (zbar*Gs[165]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[81])/(1 + yss[5]) - (zbar*Hs[83]*xss[1])/(1 + yss[5]));
	Nee_sp_s[200]=pow(E,yss[3])*Pssp*Gs[147]*Gs[163] + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(pow(E,yss[3])*Gs[147] - pow(E,xss[0])*zbar*(Hs[72] + Hs[75])) - pow(E,xss[0])*Pssp*zbar*(Hs[72] + Hs[75])*(Hs[80] + Hs[83]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[72] + Hs[75])*(Hs[80] + Hs[83]) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(pow(E,yss[3])*Gs[163] - pow(E,xss[0])*zbar*(Hs[80] + Hs[83]));
	Nee_sp_s[201]=-(pphi*Pssp*Gs[165]*(pow(E,yss[1] + yss[7])*(Gs[145] + Gs[151]) + pow(E,yss[2])*pbar*(Gs[146] + Hs[76]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[150] + Hs[72] + Hs[75])*(Gs[166] + Hs[80] + Hs[83]) - pphi*Pssp*Gs[149]*(pow(E,yss[1] + yss[7])*(Gs[161] + Gs[167]) + pow(E,yss[2])*pbar*(Gs[162] + Hs[84])) + (2*Pssp*zbar*Gs[149]*Gs[165]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[165]*Hs[73])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[149]*Hs[81])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[165]*Hs[75]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[149]*Hs[83]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[75]*Hs[81])/(1 + yss[5]) + (Pssp*zbar*Hs[73]*Hs[83])/(1 + yss[5]) + (Pssp*zbar*Hs[75]*Hs[83]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[145] + Gs[151])*(Gs[161] + Gs[167])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[146] + Hs[76])*(Gs[162] + Hs[84])*(1 + yss[5]) + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[149]) - Gs[154] + pow(E,xss[0])*kkappa*zbar*(Gs[150] + Hs[72] + Hs[75]) - (zbar*Gs[149]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[73])/(1 + yss[5]) + (zbar*Hs[75]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[145] + Gs[151]) + pow(E,yss[2])*pbar*(Gs[146] + Hs[76]))*(1 + yss[5])) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[165]) - Gs[170] + pow(E,xss[0])*kkappa*zbar*(Gs[166] + Hs[80] + Hs[83]) - (zbar*Gs[165]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[81])/(1 + yss[5]) + (zbar*Hs[83]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[161] + Gs[167]) + pow(E,yss[2])*pbar*(Gs[162] + Hs[84]))*(1 + yss[5]));
	Nee_sp_s[202]=((-1 + nnus)*Gs[153] + nnus*Gs[154])*(dP2ssp*Gs[169] + dP1ssp*Gs[170]) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*((-1 + nnus)*Gs[169] + nnus*Gs[170]);
	Nee_sp_s[203]=(dP2ssp*Gs[169] + dP1ssp*Gs[170])*(-Gs[149] - pow(E,bbar - xss[1])*ppsir*Hs[73] + Hs[77]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[73]*Hs[81] + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-Gs[165] - pow(E,bbar - xss[1])*ppsir*Hs[81] + Hs[85]);
	Nee_sp_s[204]=pow(E,xss[0])*(-(Pssp*Gs[148]*Gs[164]) - (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(Gs[148] - Hs[72]) - (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(Gs[164] - Hs[80]) + Pssp*Hs[72]*Hs[80]);
	Nee_sp_s[205]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[161]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Gs[161] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[162] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[146]*Gs[162] + pow(E,yss[11])*Pssp*Gs[155]*Gs[171] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Hs[74] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[162]*Hs[74] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Hs[75] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[162]*Hs[75] + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[145]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[146] + pow(E,yss[11])*Gs[155] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[74] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[75] + pow(E,yss[2])*pbar*(Gs[146] + Hs[76])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[82] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[82] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[82] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[75]*Hs[82] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[83] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[83] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[83] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[75]*Hs[83] + pow(E,yss[2])*pbar*Pssp*(Gs[146] + Hs[76])*(Gs[162] + Hs[84]) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[161]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[162] + pow(E,yss[11])*Gs[171] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[82] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[83] + pow(E,yss[2])*pbar*(Gs[162] + Hs[84]));
	Nee_sp_s[206]=(Pssp*zbar*(Gs[155] - Hs[75])*Hs[81] + Pssp*zbar*Hs[73]*(Gs[171] - Hs[83]) - Pssp*zbar*(Gs[155] - Hs[75])*(Gs[171] - Hs[83])*xss[1] + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(pow(E,yss[11])*Gs[156] - zbar*Hs[73] + zbar*(Gs[155] - Hs[75])*xss[1]) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(pow(E,yss[11])*Gs[172] - zbar*Hs[81] + zbar*(Gs[171] - Hs[83])*xss[1]))/pow(E,yss[11]);
	Nee_sp_s[207]=(-(Pssp*zbar*Hs[75]*Hs[81]) - Pssp*zbar*Hs[73]*Hs[83] - Pssp*(-1 + zbar)*Gs[155]*Gs[171]*xss[1] - Pssp*zbar*Hs[75]*Hs[83]*xss[1] + Pssp*zbar*Gs[171]*(Hs[73] + Hs[75]*xss[1]) - (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(-(pow(E,yss[11])*Gs[157]) + zbar*Hs[73] - (-1 + zbar)*Gs[155]*xss[1] + zbar*Hs[75]*xss[1]) + Pssp*zbar*Gs[155]*(Hs[81] + Hs[83]*xss[1]) - (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(pow(E,yss[11])*Gs[173]) + zbar*Hs[81] - (-1 + zbar)*Gs[171]*xss[1] + zbar*Hs[83]*xss[1]))/pow(E,yss[11]);
	Nee_sp_s[208]=pow(E,yss[0] - yss[11])*Pssp*Gs[144]*Gs[160] + pow(E,yss[3] - yss[11])*Pssp*Gs[147]*Gs[163] - Pssp*Gs[155]*Gs[171] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[155]*Gs[171])/pow(E,yss[11]) - (Pssp*Gs[171]*(pow(E,yss[0])*Gs[144] + pow(E,yss[3])*Gs[147] - pow(E,yss[11])*Gs[155] + pow(E,yss[11])*ebar*Hs[78]))/pow(E,yss[11]) + ((dP2ssp*Gs[169] + dP1ssp*Gs[170])*(pow(E,yss[0])*Gs[144] + pow(E,yss[3])*Gs[147] - pow(E,yss[0])*Gs[155] - pow(E,yss[3])*Gs[155] - pow(E,yss[11])*ebar*Gs[155] + pow(E,yss[11])*Gs[158] + pow(E,yss[11])*ebar*Hs[78]))/pow(E,yss[11]) + ebar*Pssp*Hs[78]*Hs[86] - (Pssp*Gs[155]*(pow(E,yss[0])*Gs[160] + pow(E,yss[3])*Gs[163] - pow(E,yss[11])*Gs[171] + pow(E,yss[11])*ebar*Hs[86]))/pow(E,yss[11]) + ((dP2ssp*Gs[153] + dP1ssp*Gs[154])*(pow(E,yss[0])*Gs[160] + pow(E,yss[3])*Gs[163] - pow(E,yss[0])*Gs[171] - pow(E,yss[3])*Gs[171] - pow(E,yss[11])*ebar*Gs[171] + pow(E,yss[11])*Gs[174] + pow(E,yss[11])*ebar*Hs[86]))/pow(E,yss[11]);
	Nee_sp_s[209]=(-(Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[169]*Hs[75]) + Pssp*pow(zbar,rrho)*Gs[169]*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79]) - Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[153]*Hs[83] + Pssp*pow(zbar,rrho)*Gs[153]*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87]) - Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[75]*Hs[83]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*Hs[83]*yss[9] + Pssp*pow(zbar,rrho)*Hs[72]*(G2sp[8]*Hs[80] + G2sp[24]*Hs[81] + G2sp[40]*Hs[82] + G2sp[56]*Hs[83] + G2sp[72]*Hs[84] + G2sp[88]*Hs[85] + G2sp[104]*Hs[86] + G2sp[120]*Hs[87])*yss[9] + Pssp*pow(zbar,rrho)*Hs[73]*(G2sp[24]*Hs[80] + G2sp[264]*Hs[81] + G2sp[280]*Hs[82] + G2sp[296]*Hs[83] + G2sp[312]*Hs[84] + G2sp[328]*Hs[85] + G2sp[344]*Hs[86] + G2sp[360]*Hs[87])*yss[9] + Pssp*pow(zbar,rrho)*Hs[74]*(G2sp[40]*Hs[80] + G2sp[280]*Hs[81] + G2sp[520]*Hs[82] + G2sp[536]*Hs[83] + G2sp[552]*Hs[84] + G2sp[568]*Hs[85] + G2sp[584]*Hs[86] + G2sp[600]*Hs[87])*yss[9] + Pssp*pow(zbar,rrho)*Hs[75]*(G2sp[56]*Hs[80] + G2sp[296]*Hs[81] + G2sp[536]*Hs[82] + G2sp[776]*Hs[83] + G2sp[792]*Hs[84] + G2sp[808]*Hs[85] + G2sp[824]*Hs[86] + G2sp[840]*Hs[87])*yss[9] + Pssp*pow(zbar,rrho)*Hs[76]*(G2sp[72]*Hs[80] + G2sp[312]*Hs[81] + G2sp[552]*Hs[82] + G2sp[792]*Hs[83] + G2sp[1032]*Hs[84] + G2sp[1048]*Hs[85] + G2sp[1064]*Hs[86] + G2sp[1080]*Hs[87])*yss[9] + Pssp*pow(zbar,rrho)*Hs[77]*(G2sp[88]*Hs[80] + G2sp[328]*Hs[81] + G2sp[568]*Hs[82] + G2sp[808]*Hs[83] + G2sp[1048]*Hs[84] + G2sp[1288]*Hs[85] + G2sp[1304]*Hs[86] + G2sp[1320]*Hs[87])*yss[9] + Pssp*pow(zbar,rrho)*Hs[78]*(G2sp[104]*Hs[80] + G2sp[344]*Hs[81] + G2sp[584]*Hs[82] + G2sp[824]*Hs[83] + G2sp[1064]*Hs[84] + G2sp[1304]*Hs[85] + G2sp[1544]*Hs[86] + G2sp[1560]*Hs[87])*yss[9] + Pssp*pow(zbar,rrho)*Hs[79]*(G2sp[120]*Hs[80] + G2sp[360]*Hs[81] + G2sp[600]*Hs[82] + G2sp[840]*Hs[83] + G2sp[1080]*Hs[84] + G2sp[1320]*Hs[85] + G2sp[1560]*Hs[86] + G2sp[1800]*Hs[87])*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[75]*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87])*yss[9] - Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87])*yss[9] + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(bbeta*pow(E,yss[8])*Gs[159] + pow(zbar,rrho)*(-Gs[153] + (-(rrho*rrhoz) + Gsp[56])*Hs[75]*yss[9] + (Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*yss[9])) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(bbeta*pow(E,yss[8])*Gs[175] + pow(zbar,rrho)*(-Gs[169] + (-(rrho*rrhoz) + Gsp[56])*Hs[83]*yss[9] + (Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87])*yss[9])))/(bbeta*pow(E,yss[8]));
	Nee_sp_s[210]=-((dP2ssp*Gs[169] + dP1ssp*Gs[170])*Hs[74]) - (dP2ssp*Gs[153] + dP1ssp*Gs[154])*Hs[82];
	Nee_sp_s[211]=(dP2ssp*Gs[169] + dP1ssp*Gs[170])*(ssigmazs - Hs[75]) - (dP2ssp*Gs[153] + dP1ssp*Gs[154])*Hs[83];
	Nee_sp_s[212]=-((dP2ssp*Gs[169] + dP1ssp*Gs[170])*Hs[76]) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(ssigmaps - Hs[84]);
	Nee_sp_s[213]=-((dP2ssp*Gs[169] + dP1ssp*Gs[170])*Hs[79]) - (dP2ssp*Gs[153] + dP1ssp*Gs[154])*Hs[87];
	Nee_sp_s[214]=-((dP2ssp*Gs[169] + dP1ssp*Gs[170])*Hs[78]) - (dP2ssp*Gs[153] + dP1ssp*Gs[154])*Hs[86];
	Nee_sp_s[215]=-((dP2ssp*Gs[169] + dP1ssp*Gs[170])*Hs[77]) - (dP2ssp*Gs[153] + dP1ssp*Gs[154])*Hs[85];
	Nee_sp_s[216]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[144]*Gs[176]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[145]*Gs[177] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[144] - pow(pow(E,yss[1]),oomega)*Gs[145])*(pow(E,yss[0])*Gs[176] - pow(pow(E,yss[1]),oomega)*Gs[177]) - pow(E,yss[8])*Pssp*Gs[152]*Gs[184] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[176] - pow(pow(E,yss[1]),oomega)*Gs[177])*Hs[79] + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[144] - pow(pow(E,yss[1]),oomega)*Gs[145])) - pow(E,yss[8])*Gs[152] + Hs[79]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[144] - pow(pow(E,yss[1]),oomega)*Gs[145])*Hs[95] + (Pssp*Hs[79]*Hs[95])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[176] - pow(pow(E,yss[1]),oomega)*Gs[177])) - pow(E,yss[8])*Gs[184] + Hs[95]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nee_sp_s[217]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[177]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Gs[177] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[178] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[146]*Gs[178] - (pbar*pphi*Pssp*Gs[153]*Gs[181])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[149]*Gs[185])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Hs[74] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[178]*Hs[74] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Hs[75] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[178]*Hs[75] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[90] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[90] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[90] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[75]*Hs[90] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[91] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[91] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[91] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[75]*Hs[91] + (pbar*pphi*Pssp*Gs[153]*Gs[184]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[152]*Gs[185]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[152]*Gs[181]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[149]*Gs[184]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[152]*Gs[184]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[76]*Hs[92]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[92]*(Gs[149]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[153] - Gs[152]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[76]*(Gs[181]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[185] - Gs[184]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[145]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[146] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[74] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[75] - pbar*Hs[76]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[149]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[153] - Gs[152]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[177]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[178] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[90] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[91] - pbar*Hs[92]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[181]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[185] - Gs[184]*yss[9])))/pow(E,yss[8]));
	Nee_sp_s[218]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[145]*Gs[177]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[177] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Gs[177] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[178] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[146]*Gs[178] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[153]*Gs[181] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[149]*Gs[185] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[178]*Hs[74] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Hs[75] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[178]*Hs[75] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[90] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[90] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[90] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[75]*Hs[90] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[91] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[91] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[91] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[75]*Hs[91] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[153]*Gs[184]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[152]*Gs[185]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[152]*Gs[181]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[149]*Gs[184]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[152]*Gs[184]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[151]*Gs[183]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[183]*(Gs[149]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[153] - Gs[152]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[151]*(Gs[181]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[185] - Gs[184]*yss[9])) + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[145]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[145] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[146] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[74] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[75] - pow(E,yss[7])*pphi*Gs[151]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[149]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[153] - Gs[152]*yss[9]))) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[177]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[177] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[178] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[90] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[91] - pow(E,yss[7])*pphi*Gs[183]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[181]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[185] - Gs[184]*yss[9])));
	Nee_sp_s[219]=-(pow(E,yss[8])*Pssp*Gs[152]*Gs[184]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[181]*Hs[75])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[181]*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[149]*Hs[91])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[149]*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[75]*Hs[91]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*Hs[91]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[72]*(G2sp[8]*Hs[88] + G2sp[24]*Hs[89] + G2sp[40]*Hs[90] + G2sp[56]*Hs[91] + G2sp[72]*Hs[92] + G2sp[88]*Hs[93] + G2sp[104]*Hs[94] + G2sp[120]*Hs[95])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[73]*(G2sp[24]*Hs[88] + G2sp[264]*Hs[89] + G2sp[280]*Hs[90] + G2sp[296]*Hs[91] + G2sp[312]*Hs[92] + G2sp[328]*Hs[93] + G2sp[344]*Hs[94] + G2sp[360]*Hs[95])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[74]*(G2sp[40]*Hs[88] + G2sp[280]*Hs[89] + G2sp[520]*Hs[90] + G2sp[536]*Hs[91] + G2sp[552]*Hs[92] + G2sp[568]*Hs[93] + G2sp[584]*Hs[94] + G2sp[600]*Hs[95])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[75]*(G2sp[56]*Hs[88] + G2sp[296]*Hs[89] + G2sp[536]*Hs[90] + G2sp[776]*Hs[91] + G2sp[792]*Hs[92] + G2sp[808]*Hs[93] + G2sp[824]*Hs[94] + G2sp[840]*Hs[95])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[76]*(G2sp[72]*Hs[88] + G2sp[312]*Hs[89] + G2sp[552]*Hs[90] + G2sp[792]*Hs[91] + G2sp[1032]*Hs[92] + G2sp[1048]*Hs[93] + G2sp[1064]*Hs[94] + G2sp[1080]*Hs[95])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[77]*(G2sp[88]*Hs[88] + G2sp[328]*Hs[89] + G2sp[568]*Hs[90] + G2sp[808]*Hs[91] + G2sp[1048]*Hs[92] + G2sp[1288]*Hs[93] + G2sp[1304]*Hs[94] + G2sp[1320]*Hs[95])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[78]*(G2sp[104]*Hs[88] + G2sp[344]*Hs[89] + G2sp[584]*Hs[90] + G2sp[824]*Hs[91] + G2sp[1064]*Hs[92] + G2sp[1304]*Hs[93] + G2sp[1544]*Hs[94] + G2sp[1560]*Hs[95])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[79]*(G2sp[120]*Hs[88] + G2sp[360]*Hs[89] + G2sp[600]*Hs[90] + G2sp[840]*Hs[91] + G2sp[1080]*Hs[92] + G2sp[1320]*Hs[93] + G2sp[1560]*Hs[94] + G2sp[1800]*Hs[95])*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[75]*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*((bbeta*pow(E,yss[8])*Gs[149])/pow(zbar,rrho) - pow(E,yss[8])*Gs[152] + Gs[153] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[75]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*((bbeta*pow(E,yss[8])*Gs[181])/pow(zbar,rrho) - pow(E,yss[8])*Gs[184] + Gs[185] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[91]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95])*(1 + yss[5]))/pow(zbar,rrho));
	Nee_sp_s[220]=-(kkappa*Pssp*Gs[153]*Gs[182]) + pow(E,yss[8])*Pssp*Gs[152]*Gs[184] - kkappa*Pssp*Gs[150]*Gs[185] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[72]*Hs[88] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[72]*Hs[88] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[74]*Hs[88] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[75]*Hs[88] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79])*Hs[88] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79])*Hs[88] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79])*Hs[88] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[72]*Hs[90] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[74]*Hs[90] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[75]*Hs[90] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79])*Hs[90] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79])*Hs[90] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[72]*Hs[91] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[74]*Hs[91] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[75]*Hs[91] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[75]*Hs[91])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79])*Hs[91] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79])*Hs[91] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*Hs[91])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[72] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[75] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79]))*Hs[91])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[152]*(Hs[88] + Hs[91]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[72] + Hs[75])*(Gs[184] + Hs[88] + Hs[91]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[72]*(G2sp[1]*Hs[88] + G2sp[17]*Hs[89] + G2sp[33]*Hs[90] + G2sp[49]*Hs[91] + G2sp[65]*Hs[92] + G2sp[81]*Hs[93] + G2sp[97]*Hs[94] + G2sp[113]*Hs[95]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[72]*(G2sp[2]*Hs[88] + G2sp[18]*Hs[89] + G2sp[34]*Hs[90] + G2sp[50]*Hs[91] + G2sp[66]*Hs[92] + G2sp[82]*Hs[93] + G2sp[98]*Hs[94] + G2sp[114]*Hs[95]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[72]*(G2sp[4]*Hs[88] + G2sp[20]*Hs[89] + G2sp[36]*Hs[90] + G2sp[52]*Hs[91] + G2sp[68]*Hs[92] + G2sp[84]*Hs[93] + G2sp[100]*Hs[94] + G2sp[116]*Hs[95]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[72]*(G2sp[8]*Hs[88] + G2sp[24]*Hs[89] + G2sp[40]*Hs[90] + G2sp[56]*Hs[91] + G2sp[72]*Hs[92] + G2sp[88]*Hs[93] + G2sp[104]*Hs[94] + G2sp[120]*Hs[95]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[73]*(G2sp[17]*Hs[88] + G2sp[257]*Hs[89] + G2sp[273]*Hs[90] + G2sp[289]*Hs[91] + G2sp[305]*Hs[92] + G2sp[321]*Hs[93] + G2sp[337]*Hs[94] + G2sp[353]*Hs[95]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[73]*(G2sp[18]*Hs[88] + G2sp[258]*Hs[89] + G2sp[274]*Hs[90] + G2sp[290]*Hs[91] + G2sp[306]*Hs[92] + G2sp[322]*Hs[93] + G2sp[338]*Hs[94] + G2sp[354]*Hs[95]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[73]*(G2sp[20]*Hs[88] + G2sp[260]*Hs[89] + G2sp[276]*Hs[90] + G2sp[292]*Hs[91] + G2sp[308]*Hs[92] + G2sp[324]*Hs[93] + G2sp[340]*Hs[94] + G2sp[356]*Hs[95]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[73]*(G2sp[24]*Hs[88] + G2sp[264]*Hs[89] + G2sp[280]*Hs[90] + G2sp[296]*Hs[91] + G2sp[312]*Hs[92] + G2sp[328]*Hs[93] + G2sp[344]*Hs[94] + G2sp[360]*Hs[95]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[74]*(G2sp[33]*Hs[88] + G2sp[273]*Hs[89] + G2sp[513]*Hs[90] + G2sp[529]*Hs[91] + G2sp[545]*Hs[92] + G2sp[561]*Hs[93] + G2sp[577]*Hs[94] + G2sp[593]*Hs[95]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[74]*(G2sp[34]*Hs[88] + G2sp[274]*Hs[89] + G2sp[514]*Hs[90] + G2sp[530]*Hs[91] + G2sp[546]*Hs[92] + G2sp[562]*Hs[93] + G2sp[578]*Hs[94] + G2sp[594]*Hs[95]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[74]*(G2sp[36]*Hs[88] + G2sp[276]*Hs[89] + G2sp[516]*Hs[90] + G2sp[532]*Hs[91] + G2sp[548]*Hs[92] + G2sp[564]*Hs[93] + G2sp[580]*Hs[94] + G2sp[596]*Hs[95]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[74]*(G2sp[40]*Hs[88] + G2sp[280]*Hs[89] + G2sp[520]*Hs[90] + G2sp[536]*Hs[91] + G2sp[552]*Hs[92] + G2sp[568]*Hs[93] + G2sp[584]*Hs[94] + G2sp[600]*Hs[95]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[75]*(G2sp[49]*Hs[88] + G2sp[289]*Hs[89] + G2sp[529]*Hs[90] + G2sp[769]*Hs[91] + G2sp[785]*Hs[92] + G2sp[801]*Hs[93] + G2sp[817]*Hs[94] + G2sp[833]*Hs[95]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[75]*(G2sp[50]*Hs[88] + G2sp[290]*Hs[89] + G2sp[530]*Hs[90] + G2sp[770]*Hs[91] + G2sp[786]*Hs[92] + G2sp[802]*Hs[93] + G2sp[818]*Hs[94] + G2sp[834]*Hs[95]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[75]*(G2sp[52]*Hs[88] + G2sp[292]*Hs[89] + G2sp[532]*Hs[90] + G2sp[772]*Hs[91] + G2sp[788]*Hs[92] + G2sp[804]*Hs[93] + G2sp[820]*Hs[94] + G2sp[836]*Hs[95]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[75]*(G2sp[56]*Hs[88] + G2sp[296]*Hs[89] + G2sp[536]*Hs[90] + G2sp[776]*Hs[91] + G2sp[792]*Hs[92] + G2sp[808]*Hs[93] + G2sp[824]*Hs[94] + G2sp[840]*Hs[95]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[76]*(G2sp[65]*Hs[88] + G2sp[305]*Hs[89] + G2sp[545]*Hs[90] + G2sp[785]*Hs[91] + G2sp[1025]*Hs[92] + G2sp[1041]*Hs[93] + G2sp[1057]*Hs[94] + G2sp[1073]*Hs[95]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[76]*(G2sp[66]*Hs[88] + G2sp[306]*Hs[89] + G2sp[546]*Hs[90] + G2sp[786]*Hs[91] + G2sp[1026]*Hs[92] + G2sp[1042]*Hs[93] + G2sp[1058]*Hs[94] + G2sp[1074]*Hs[95]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[76]*(G2sp[68]*Hs[88] + G2sp[308]*Hs[89] + G2sp[548]*Hs[90] + G2sp[788]*Hs[91] + G2sp[1028]*Hs[92] + G2sp[1044]*Hs[93] + G2sp[1060]*Hs[94] + G2sp[1076]*Hs[95]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[76]*(G2sp[72]*Hs[88] + G2sp[312]*Hs[89] + G2sp[552]*Hs[90] + G2sp[792]*Hs[91] + G2sp[1032]*Hs[92] + G2sp[1048]*Hs[93] + G2sp[1064]*Hs[94] + G2sp[1080]*Hs[95]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[77]*(G2sp[81]*Hs[88] + G2sp[321]*Hs[89] + G2sp[561]*Hs[90] + G2sp[801]*Hs[91] + G2sp[1041]*Hs[92] + G2sp[1281]*Hs[93] + G2sp[1297]*Hs[94] + G2sp[1313]*Hs[95]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[77]*(G2sp[82]*Hs[88] + G2sp[322]*Hs[89] + G2sp[562]*Hs[90] + G2sp[802]*Hs[91] + G2sp[1042]*Hs[92] + G2sp[1282]*Hs[93] + G2sp[1298]*Hs[94] + G2sp[1314]*Hs[95]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[77]*(G2sp[84]*Hs[88] + G2sp[324]*Hs[89] + G2sp[564]*Hs[90] + G2sp[804]*Hs[91] + G2sp[1044]*Hs[92] + G2sp[1284]*Hs[93] + G2sp[1300]*Hs[94] + G2sp[1316]*Hs[95]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[77]*(G2sp[88]*Hs[88] + G2sp[328]*Hs[89] + G2sp[568]*Hs[90] + G2sp[808]*Hs[91] + G2sp[1048]*Hs[92] + G2sp[1288]*Hs[93] + G2sp[1304]*Hs[94] + G2sp[1320]*Hs[95]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[78]*(G2sp[97]*Hs[88] + G2sp[337]*Hs[89] + G2sp[577]*Hs[90] + G2sp[817]*Hs[91] + G2sp[1057]*Hs[92] + G2sp[1297]*Hs[93] + G2sp[1537]*Hs[94] + G2sp[1553]*Hs[95]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[78]*(G2sp[98]*Hs[88] + G2sp[338]*Hs[89] + G2sp[578]*Hs[90] + G2sp[818]*Hs[91] + G2sp[1058]*Hs[92] + G2sp[1298]*Hs[93] + G2sp[1538]*Hs[94] + G2sp[1554]*Hs[95]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[78]*(G2sp[100]*Hs[88] + G2sp[340]*Hs[89] + G2sp[580]*Hs[90] + G2sp[820]*Hs[91] + G2sp[1060]*Hs[92] + G2sp[1300]*Hs[93] + G2sp[1540]*Hs[94] + G2sp[1556]*Hs[95]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[78]*(G2sp[104]*Hs[88] + G2sp[344]*Hs[89] + G2sp[584]*Hs[90] + G2sp[824]*Hs[91] + G2sp[1064]*Hs[92] + G2sp[1304]*Hs[93] + G2sp[1544]*Hs[94] + G2sp[1560]*Hs[95]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[79]*(G2sp[113]*Hs[88] + G2sp[353]*Hs[89] + G2sp[593]*Hs[90] + G2sp[833]*Hs[91] + G2sp[1073]*Hs[92] + G2sp[1313]*Hs[93] + G2sp[1553]*Hs[94] + G2sp[1793]*Hs[95]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[79]*(G2sp[114]*Hs[88] + G2sp[354]*Hs[89] + G2sp[594]*Hs[90] + G2sp[834]*Hs[91] + G2sp[1074]*Hs[92] + G2sp[1314]*Hs[93] + G2sp[1554]*Hs[94] + G2sp[1794]*Hs[95]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[79]*(G2sp[116]*Hs[88] + G2sp[356]*Hs[89] + G2sp[596]*Hs[90] + G2sp[836]*Hs[91] + G2sp[1076]*Hs[92] + G2sp[1316]*Hs[93] + G2sp[1556]*Hs[94] + G2sp[1796]*Hs[95]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[79]*(G2sp[120]*Hs[88] + G2sp[360]*Hs[89] + G2sp[600]*Hs[90] + G2sp[840]*Hs[91] + G2sp[1080]*Hs[92] + G2sp[1320]*Hs[93] + G2sp[1560]*Hs[94] + G2sp[1800]*Hs[95]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[72]*(Gsp[1]*Hs[88] + Gsp[17]*Hs[89] + Gsp[33]*Hs[90] + Gsp[49]*Hs[91] + Gsp[65]*Hs[92] + Gsp[81]*Hs[93] + Gsp[97]*Hs[94] + Gsp[113]*Hs[95]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[74]*(Gsp[1]*Hs[88] + Gsp[17]*Hs[89] + Gsp[33]*Hs[90] + Gsp[49]*Hs[91] + Gsp[65]*Hs[92] + Gsp[81]*Hs[93] + Gsp[97]*Hs[94] + Gsp[113]*Hs[95]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[75]*(Gsp[1]*Hs[88] + Gsp[17]*Hs[89] + Gsp[33]*Hs[90] + Gsp[49]*Hs[91] + Gsp[65]*Hs[92] + Gsp[81]*Hs[93] + Gsp[97]*Hs[94] + Gsp[113]*Hs[95]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79])*(Gsp[1]*Hs[88] + Gsp[17]*Hs[89] + Gsp[33]*Hs[90] + Gsp[49]*Hs[91] + Gsp[65]*Hs[92] + Gsp[81]*Hs[93] + Gsp[97]*Hs[94] + Gsp[113]*Hs[95]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79])*(Gsp[1]*Hs[88] + Gsp[17]*Hs[89] + Gsp[33]*Hs[90] + Gsp[49]*Hs[91] + Gsp[65]*Hs[92] + Gsp[81]*Hs[93] + Gsp[97]*Hs[94] + Gsp[113]*Hs[95]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[72]*(Gsp[2]*Hs[88] + Gsp[18]*Hs[89] + Gsp[34]*Hs[90] + Gsp[50]*Hs[91] + Gsp[66]*Hs[92] + Gsp[82]*Hs[93] + Gsp[98]*Hs[94] + Gsp[114]*Hs[95]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[74]*(Gsp[2]*Hs[88] + Gsp[18]*Hs[89] + Gsp[34]*Hs[90] + Gsp[50]*Hs[91] + Gsp[66]*Hs[92] + Gsp[82]*Hs[93] + Gsp[98]*Hs[94] + Gsp[114]*Hs[95]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[75]*(Gsp[2]*Hs[88] + Gsp[18]*Hs[89] + Gsp[34]*Hs[90] + Gsp[50]*Hs[91] + Gsp[66]*Hs[92] + Gsp[82]*Hs[93] + Gsp[98]*Hs[94] + Gsp[114]*Hs[95]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79])*(Gsp[2]*Hs[88] + Gsp[18]*Hs[89] + Gsp[34]*Hs[90] + Gsp[50]*Hs[91] + Gsp[66]*Hs[92] + Gsp[82]*Hs[93] + Gsp[98]*Hs[94] + Gsp[114]*Hs[95]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79])*(Gsp[2]*Hs[88] + Gsp[18]*Hs[89] + Gsp[34]*Hs[90] + Gsp[50]*Hs[91] + Gsp[66]*Hs[92] + Gsp[82]*Hs[93] + Gsp[98]*Hs[94] + Gsp[114]*Hs[95]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[72]*((-1 + Gsp[4])*Hs[88] + Gsp[20]*Hs[89] + Gsp[36]*Hs[90] + (rrhoz + Gsp[52])*Hs[91] + Gsp[68]*Hs[92] + Gsp[84]*Hs[93] + Gsp[100]*Hs[94] + Gsp[116]*Hs[95]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79])*((-1 + Gsp[4])*Hs[88] + Gsp[20]*Hs[89] + Gsp[36]*Hs[90] + (rrhoz + Gsp[52])*Hs[91] + Gsp[68]*Hs[92] + Gsp[84]*Hs[93] + Gsp[100]*Hs[94] + Gsp[116]*Hs[95]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79])*(Gsp[4]*Hs[88] + Gsp[20]*Hs[89] + Gsp[36]*Hs[90] + (rrhoz + Gsp[52])*Hs[91] + Gsp[68]*Hs[92] + Gsp[84]*Hs[93] + Gsp[100]*Hs[94] + Gsp[116]*Hs[95]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[75]*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[72] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[75] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79]))*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[75]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[88] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[90] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[91] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[88] + Gsp[17]*Hs[89] + Gsp[33]*Hs[90] + Gsp[49]*Hs[91] + Gsp[65]*Hs[92] + Gsp[81]*Hs[93] + Gsp[97]*Hs[94] + Gsp[113]*Hs[95]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[88] + Gsp[18]*Hs[89] + Gsp[34]*Hs[90] + Gsp[50]*Hs[91] + Gsp[66]*Hs[92] + Gsp[82]*Hs[93] + Gsp[98]*Hs[94] + Gsp[114]*Hs[95]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[88] + Gsp[20]*Hs[89] + Gsp[36]*Hs[90] + (rrhoz + Gsp[52])*Hs[91] + Gsp[68]*Hs[92] + Gsp[84]*Hs[93] + Gsp[100]*Hs[94] + Gsp[116]*Hs[95])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[88] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[90] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[91] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[88] + Gsp[17]*Hs[89] + Gsp[33]*Hs[90] + Gsp[49]*Hs[91] + Gsp[65]*Hs[92] + Gsp[81]*Hs[93] + Gsp[97]*Hs[94] + Gsp[113]*Hs[95]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[88] + Gsp[18]*Hs[89] + Gsp[34]*Hs[90] + Gsp[50]*Hs[91] + Gsp[66]*Hs[92] + Gsp[82]*Hs[93] + Gsp[98]*Hs[94] + Gsp[114]*Hs[95]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[88] + Gsp[20]*Hs[89] + Gsp[36]*Hs[90] + (rrhoz + Gsp[52])*Hs[91] + Gsp[68]*Hs[92] + Gsp[84]*Hs[93] + Gsp[100]*Hs[94] + Gsp[116]*Hs[95])))/pow(zbar,rrho) - kkappa*Pssp*Gs[150]*Gs[182]*yss[9] + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(pow(E,yss[8])*Gs[152] - kkappa*Gs[153] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[75])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[72] + Hs[75]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[72] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[75] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79])))/pow(zbar,rrho) - kkappa*Gs[150]*yss[9]) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(pow(E,yss[8])*Gs[184] - kkappa*Gs[185] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[91])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[88] + Hs[91]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[88] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[90] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[91] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[88] + Gsp[17]*Hs[89] + Gsp[33]*Hs[90] + Gsp[49]*Hs[91] + Gsp[65]*Hs[92] + Gsp[81]*Hs[93] + Gsp[97]*Hs[94] + Gsp[113]*Hs[95]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[88] + Gsp[18]*Hs[89] + Gsp[34]*Hs[90] + Gsp[50]*Hs[91] + Gsp[66]*Hs[92] + Gsp[82]*Hs[93] + Gsp[98]*Hs[94] + Gsp[114]*Hs[95]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[88] + Gsp[20]*Hs[89] + Gsp[36]*Hs[90] + (rrhoz + Gsp[52])*Hs[91] + Gsp[68]*Hs[92] + Gsp[84]*Hs[93] + Gsp[100]*Hs[94] + Gsp[116]*Hs[95])))/pow(zbar,rrho) - kkappa*Gs[182]*yss[9]);
	Nee_sp_s[221]=-(Pssp*Gs[150]*Gs[182]) + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(-Gs[150] + iiota*zbar*(Hs[72] + Hs[75])) + iiota*Pssp*zbar*(Hs[72] + Hs[75])*(Hs[88] + Hs[91]) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-Gs[182] + iiota*zbar*(Hs[88] + Hs[91]));
	Nee_sp_s[222]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[145]*Gs[177] - pow(E,yss[7])*Pssp*Gs[151]*Gs[183] + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[177] - pow(E,yss[7])*Gs[183]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[145] - pow(E,yss[7])*Gs[151])*(dP2ssp*Gs[185] + dP1ssp*Gs[186]);
	Nee_sp_s[223]=-(pow(E,yss[0])*Pssp*Gs[144]*Gs[176]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[177] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Gs[177] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[178] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[146]*Gs[178] - pow(E,yss[3])*Pssp*Gs[147]*Gs[179] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Hs[74] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[178]*Hs[74] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Hs[75] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[178]*Hs[75] - pphi*Pssp*Gs[181]*(pow(E,yss[1] + yss[7])*(Gs[145] + Gs[151]) + pow(E,yss[2])*pbar*(Gs[146] + Hs[76])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[90] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[90] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[90] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[75]*Hs[90] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[91] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[91] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[91] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[75]*Hs[91] - pow(E,yss[2])*pbar*Pssp*(Gs[146] + Hs[76])*(Gs[178] + Hs[92]) - pphi*Pssp*Gs[149]*(pow(E,yss[1] + yss[7])*(Gs[177] + Gs[183]) + pow(E,yss[2])*pbar*(Gs[178] + Hs[92])) - pow(E,yss[11])*ebar*Pssp*Hs[78]*Hs[94] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[145] + Gs[151])*(Gs[177] + Gs[183])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[146] + Hs[76])*(Gs[178] + Hs[92])*yss[5] - (2*Pssp*zbar*Gs[149]*Gs[181]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[181]*Hs[73])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[149]*Hs[89])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[181]*Hs[75]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[149]*Hs[91]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[75]*Hs[89])/(1 + yss[5]) - (Pssp*zbar*Hs[73]*Hs[91])/(1 + yss[5]) - (Pssp*zbar*Hs[75]*Hs[91]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(-(pow(E,yss[0])*Gs[144]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[145] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[146] - pow(E,yss[3])*Gs[147] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[149] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[75] - pow(E,yss[2])*pbar*(Gs[146] + Hs[76]) - pow(E,yss[11])*ebar*Hs[78] - pphi*(pow(E,yss[1] + yss[7])*(Gs[145] + Gs[151]) + pow(E,yss[2])*pbar*(Gs[146] + Hs[76]))*yss[5] + (zbar*Gs[149]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[73])/(1 + yss[5]) - (zbar*Hs[75]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(pow(E,yss[0])*Gs[176]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[177] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[178] - pow(E,yss[3])*Gs[179] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[181] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[90] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[91] - pow(E,yss[2])*pbar*(Gs[178] + Hs[92]) - pow(E,yss[11])*ebar*Hs[94] - pphi*(pow(E,yss[1] + yss[7])*(Gs[177] + Gs[183]) + pow(E,yss[2])*pbar*(Gs[178] + Hs[92]))*yss[5] + (zbar*Gs[181]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[89])/(1 + yss[5]) - (zbar*Hs[91]*xss[1])/(1 + yss[5]));
	Nee_sp_s[224]=pow(E,yss[3])*Pssp*Gs[147]*Gs[179] + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(pow(E,yss[3])*Gs[147] - pow(E,xss[0])*zbar*(Hs[72] + Hs[75])) - pow(E,xss[0])*Pssp*zbar*(Hs[72] + Hs[75])*(Hs[88] + Hs[91]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[72] + Hs[75])*(Hs[88] + Hs[91]) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(pow(E,yss[3])*Gs[179] - pow(E,xss[0])*zbar*(Hs[88] + Hs[91]));
	Nee_sp_s[225]=-(pphi*Pssp*Gs[181]*(pow(E,yss[1] + yss[7])*(Gs[145] + Gs[151]) + pow(E,yss[2])*pbar*(Gs[146] + Hs[76]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[150] + Hs[72] + Hs[75])*(Gs[182] + Hs[88] + Hs[91]) - pphi*Pssp*Gs[149]*(pow(E,yss[1] + yss[7])*(Gs[177] + Gs[183]) + pow(E,yss[2])*pbar*(Gs[178] + Hs[92])) + (2*Pssp*zbar*Gs[149]*Gs[181]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[181]*Hs[73])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[149]*Hs[89])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[181]*Hs[75]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[149]*Hs[91]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[75]*Hs[89])/(1 + yss[5]) + (Pssp*zbar*Hs[73]*Hs[91])/(1 + yss[5]) + (Pssp*zbar*Hs[75]*Hs[91]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[145] + Gs[151])*(Gs[177] + Gs[183])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[146] + Hs[76])*(Gs[178] + Hs[92])*(1 + yss[5]) + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[149]) - Gs[154] + pow(E,xss[0])*kkappa*zbar*(Gs[150] + Hs[72] + Hs[75]) - (zbar*Gs[149]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[73])/(1 + yss[5]) + (zbar*Hs[75]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[145] + Gs[151]) + pow(E,yss[2])*pbar*(Gs[146] + Hs[76]))*(1 + yss[5])) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[181]) - Gs[186] + pow(E,xss[0])*kkappa*zbar*(Gs[182] + Hs[88] + Hs[91]) - (zbar*Gs[181]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[89])/(1 + yss[5]) + (zbar*Hs[91]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[177] + Gs[183]) + pow(E,yss[2])*pbar*(Gs[178] + Hs[92]))*(1 + yss[5]));
	Nee_sp_s[226]=((-1 + nnus)*Gs[153] + nnus*Gs[154])*(dP2ssp*Gs[185] + dP1ssp*Gs[186]) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*((-1 + nnus)*Gs[185] + nnus*Gs[186]);
	Nee_sp_s[227]=(dP2ssp*Gs[185] + dP1ssp*Gs[186])*(-Gs[149] - pow(E,bbar - xss[1])*ppsir*Hs[73] + Hs[77]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[73]*Hs[89] + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-Gs[181] - pow(E,bbar - xss[1])*ppsir*Hs[89] + Hs[93]);
	Nee_sp_s[228]=pow(E,xss[0])*(-(Pssp*Gs[148]*Gs[180]) - (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(Gs[148] - Hs[72]) - (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(Gs[180] - Hs[88]) + Pssp*Hs[72]*Hs[88]);
	Nee_sp_s[229]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[177]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Gs[177] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[178] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[146]*Gs[178] + pow(E,yss[11])*Pssp*Gs[155]*Gs[187] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Hs[74] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[178]*Hs[74] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Hs[75] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[178]*Hs[75] + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[145]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[146] + pow(E,yss[11])*Gs[155] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[74] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[75] + pow(E,yss[2])*pbar*(Gs[146] + Hs[76])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[90] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[90] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[90] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[75]*Hs[90] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[91] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[91] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[91] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[75]*Hs[91] + pow(E,yss[2])*pbar*Pssp*(Gs[146] + Hs[76])*(Gs[178] + Hs[92]) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[177]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[178] + pow(E,yss[11])*Gs[187] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[90] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[91] + pow(E,yss[2])*pbar*(Gs[178] + Hs[92]));
	Nee_sp_s[230]=(Pssp*zbar*(Gs[155] - Hs[75])*Hs[89] + Pssp*zbar*Hs[73]*(Gs[187] - Hs[91]) - Pssp*zbar*(Gs[155] - Hs[75])*(Gs[187] - Hs[91])*xss[1] + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(pow(E,yss[11])*Gs[156] - zbar*Hs[73] + zbar*(Gs[155] - Hs[75])*xss[1]) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(pow(E,yss[11])*Gs[188] - zbar*Hs[89] + zbar*(Gs[187] - Hs[91])*xss[1]))/pow(E,yss[11]);
	Nee_sp_s[231]=(-(Pssp*zbar*Hs[75]*Hs[89]) - Pssp*zbar*Hs[73]*Hs[91] - Pssp*(-1 + zbar)*Gs[155]*Gs[187]*xss[1] - Pssp*zbar*Hs[75]*Hs[91]*xss[1] + Pssp*zbar*Gs[187]*(Hs[73] + Hs[75]*xss[1]) - (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(-(pow(E,yss[11])*Gs[157]) + zbar*Hs[73] - (-1 + zbar)*Gs[155]*xss[1] + zbar*Hs[75]*xss[1]) + Pssp*zbar*Gs[155]*(Hs[89] + Hs[91]*xss[1]) - (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(pow(E,yss[11])*Gs[189]) + zbar*Hs[89] - (-1 + zbar)*Gs[187]*xss[1] + zbar*Hs[91]*xss[1]))/pow(E,yss[11]);
	Nee_sp_s[232]=pow(E,yss[0] - yss[11])*Pssp*Gs[144]*Gs[176] + pow(E,yss[3] - yss[11])*Pssp*Gs[147]*Gs[179] - Pssp*Gs[155]*Gs[187] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[155]*Gs[187])/pow(E,yss[11]) - (Pssp*Gs[187]*(pow(E,yss[0])*Gs[144] + pow(E,yss[3])*Gs[147] - pow(E,yss[11])*Gs[155] + pow(E,yss[11])*ebar*Hs[78]))/pow(E,yss[11]) + ((dP2ssp*Gs[185] + dP1ssp*Gs[186])*(pow(E,yss[0])*Gs[144] + pow(E,yss[3])*Gs[147] - pow(E,yss[0])*Gs[155] - pow(E,yss[3])*Gs[155] - pow(E,yss[11])*ebar*Gs[155] + pow(E,yss[11])*Gs[158] + pow(E,yss[11])*ebar*Hs[78]))/pow(E,yss[11]) + ebar*Pssp*Hs[78]*Hs[94] - (Pssp*Gs[155]*(pow(E,yss[0])*Gs[176] + pow(E,yss[3])*Gs[179] - pow(E,yss[11])*Gs[187] + pow(E,yss[11])*ebar*Hs[94]))/pow(E,yss[11]) + ((dP2ssp*Gs[153] + dP1ssp*Gs[154])*(pow(E,yss[0])*Gs[176] + pow(E,yss[3])*Gs[179] - pow(E,yss[0])*Gs[187] - pow(E,yss[3])*Gs[187] - pow(E,yss[11])*ebar*Gs[187] + pow(E,yss[11])*Gs[190] + pow(E,yss[11])*ebar*Hs[94]))/pow(E,yss[11]);
	Nee_sp_s[233]=(-(Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[185]*Hs[75]) + Pssp*pow(zbar,rrho)*Gs[185]*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79]) - Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[153]*Hs[91] + Pssp*pow(zbar,rrho)*Gs[153]*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95]) - Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[75]*Hs[91]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*Hs[91]*yss[9] + Pssp*pow(zbar,rrho)*Hs[72]*(G2sp[8]*Hs[88] + G2sp[24]*Hs[89] + G2sp[40]*Hs[90] + G2sp[56]*Hs[91] + G2sp[72]*Hs[92] + G2sp[88]*Hs[93] + G2sp[104]*Hs[94] + G2sp[120]*Hs[95])*yss[9] + Pssp*pow(zbar,rrho)*Hs[73]*(G2sp[24]*Hs[88] + G2sp[264]*Hs[89] + G2sp[280]*Hs[90] + G2sp[296]*Hs[91] + G2sp[312]*Hs[92] + G2sp[328]*Hs[93] + G2sp[344]*Hs[94] + G2sp[360]*Hs[95])*yss[9] + Pssp*pow(zbar,rrho)*Hs[74]*(G2sp[40]*Hs[88] + G2sp[280]*Hs[89] + G2sp[520]*Hs[90] + G2sp[536]*Hs[91] + G2sp[552]*Hs[92] + G2sp[568]*Hs[93] + G2sp[584]*Hs[94] + G2sp[600]*Hs[95])*yss[9] + Pssp*pow(zbar,rrho)*Hs[75]*(G2sp[56]*Hs[88] + G2sp[296]*Hs[89] + G2sp[536]*Hs[90] + G2sp[776]*Hs[91] + G2sp[792]*Hs[92] + G2sp[808]*Hs[93] + G2sp[824]*Hs[94] + G2sp[840]*Hs[95])*yss[9] + Pssp*pow(zbar,rrho)*Hs[76]*(G2sp[72]*Hs[88] + G2sp[312]*Hs[89] + G2sp[552]*Hs[90] + G2sp[792]*Hs[91] + G2sp[1032]*Hs[92] + G2sp[1048]*Hs[93] + G2sp[1064]*Hs[94] + G2sp[1080]*Hs[95])*yss[9] + Pssp*pow(zbar,rrho)*Hs[77]*(G2sp[88]*Hs[88] + G2sp[328]*Hs[89] + G2sp[568]*Hs[90] + G2sp[808]*Hs[91] + G2sp[1048]*Hs[92] + G2sp[1288]*Hs[93] + G2sp[1304]*Hs[94] + G2sp[1320]*Hs[95])*yss[9] + Pssp*pow(zbar,rrho)*Hs[78]*(G2sp[104]*Hs[88] + G2sp[344]*Hs[89] + G2sp[584]*Hs[90] + G2sp[824]*Hs[91] + G2sp[1064]*Hs[92] + G2sp[1304]*Hs[93] + G2sp[1544]*Hs[94] + G2sp[1560]*Hs[95])*yss[9] + Pssp*pow(zbar,rrho)*Hs[79]*(G2sp[120]*Hs[88] + G2sp[360]*Hs[89] + G2sp[600]*Hs[90] + G2sp[840]*Hs[91] + G2sp[1080]*Hs[92] + G2sp[1320]*Hs[93] + G2sp[1560]*Hs[94] + G2sp[1800]*Hs[95])*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[75]*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95])*yss[9] - Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95])*yss[9] + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(bbeta*pow(E,yss[8])*Gs[159] + pow(zbar,rrho)*(-Gs[153] + (-(rrho*rrhoz) + Gsp[56])*Hs[75]*yss[9] + (Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*yss[9])) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(bbeta*pow(E,yss[8])*Gs[191] + pow(zbar,rrho)*(-Gs[185] + (-(rrho*rrhoz) + Gsp[56])*Hs[91]*yss[9] + (Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95])*yss[9])))/(bbeta*pow(E,yss[8]));
	Nee_sp_s[234]=-((dP2ssp*Gs[185] + dP1ssp*Gs[186])*Hs[74]) - (dP2ssp*Gs[153] + dP1ssp*Gs[154])*Hs[90];
	Nee_sp_s[235]=(dP2ssp*Gs[185] + dP1ssp*Gs[186])*(ssigmazs - Hs[75]) - (dP2ssp*Gs[153] + dP1ssp*Gs[154])*Hs[91];
	Nee_sp_s[236]=-((dP2ssp*Gs[185] + dP1ssp*Gs[186])*Hs[76]) - (dP2ssp*Gs[153] + dP1ssp*Gs[154])*Hs[92];
	Nee_sp_s[237]=-((dP2ssp*Gs[185] + dP1ssp*Gs[186])*Hs[79]) - (dP2ssp*Gs[153] + dP1ssp*Gs[154])*Hs[95];
	Nee_sp_s[238]=-((dP2ssp*Gs[185] + dP1ssp*Gs[186])*Hs[78]) - (dP2ssp*Gs[153] + dP1ssp*Gs[154])*Hs[94];
	Nee_sp_s[239]=-((dP2ssp*Gs[185] + dP1ssp*Gs[186])*Hs[77]) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(ssigmars - Hs[93]);
	Nee_sp_s[240]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[144]*Gs[192]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[145]*Gs[193] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[144] - pow(pow(E,yss[1]),oomega)*Gs[145])*(pow(E,yss[0])*Gs[192] - pow(pow(E,yss[1]),oomega)*Gs[193]) - pow(E,yss[8])*Pssp*Gs[152]*Gs[200] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[192] - pow(pow(E,yss[1]),oomega)*Gs[193])*Hs[79] + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[144] - pow(pow(E,yss[1]),oomega)*Gs[145])) - pow(E,yss[8])*Gs[152] + Hs[79]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[144] - pow(pow(E,yss[1]),oomega)*Gs[145])*Hs[103] + (Pssp*Hs[79]*Hs[103])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[192] - pow(pow(E,yss[1]),oomega)*Gs[193])) - pow(E,yss[8])*Gs[200] + Hs[103]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nee_sp_s[241]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[193]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Gs[193] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[194] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[146]*Gs[194] - (pbar*pphi*Pssp*Gs[153]*Gs[197])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[149]*Gs[201])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[193]*Hs[74] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[194]*Hs[74] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[193]*Hs[75] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[194]*Hs[75] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[98] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[98] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[98] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[75]*Hs[98] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[99] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[99] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[99] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[75]*Hs[99] + (pbar*pphi*Pssp*Gs[153]*Gs[200]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[152]*Gs[201]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[152]*Gs[197]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[149]*Gs[200]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[152]*Gs[200]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[76]*Hs[100]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[100]*(Gs[149]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[153] - Gs[152]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[76]*(Gs[197]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[201] - Gs[200]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[145]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[146] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[74] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[75] - pbar*Hs[76]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[149]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[153] - Gs[152]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[193]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[194] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[98] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[99] - pbar*Hs[100]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[197]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[201] - Gs[200]*yss[9])))/pow(E,yss[8]));
	Nee_sp_s[242]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[145]*Gs[193]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[193] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Gs[193] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[194] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[146]*Gs[194] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[153]*Gs[197] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[149]*Gs[201] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[193]*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[194]*Hs[74] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[193]*Hs[75] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[194]*Hs[75] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[98] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[98] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[98] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[75]*Hs[98] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[99] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[99] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[99] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[75]*Hs[99] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[153]*Gs[200]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[152]*Gs[201]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[152]*Gs[197]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[149]*Gs[200]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[152]*Gs[200]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[151]*Gs[199]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[199]*(Gs[149]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[153] - Gs[152]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[151]*(Gs[197]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[201] - Gs[200]*yss[9])) + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[145]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[145] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[146] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[74] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[75] - pow(E,yss[7])*pphi*Gs[151]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[149]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[153] - Gs[152]*yss[9]))) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[193]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[193] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[194] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[98] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[99] - pow(E,yss[7])*pphi*Gs[199]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[197]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[201] - Gs[200]*yss[9])));
	Nee_sp_s[243]=-(pow(E,yss[8])*Pssp*Gs[152]*Gs[200]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[197]*Hs[75])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[197]*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[149]*Hs[99])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[149]*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[75]*Hs[99]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*Hs[99]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[72]*(G2sp[8]*Hs[96] + G2sp[24]*Hs[97] + G2sp[40]*Hs[98] + G2sp[56]*Hs[99] + G2sp[72]*Hs[100] + G2sp[88]*Hs[101] + G2sp[104]*Hs[102] + G2sp[120]*Hs[103])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[73]*(G2sp[24]*Hs[96] + G2sp[264]*Hs[97] + G2sp[280]*Hs[98] + G2sp[296]*Hs[99] + G2sp[312]*Hs[100] + G2sp[328]*Hs[101] + G2sp[344]*Hs[102] + G2sp[360]*Hs[103])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[74]*(G2sp[40]*Hs[96] + G2sp[280]*Hs[97] + G2sp[520]*Hs[98] + G2sp[536]*Hs[99] + G2sp[552]*Hs[100] + G2sp[568]*Hs[101] + G2sp[584]*Hs[102] + G2sp[600]*Hs[103])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[75]*(G2sp[56]*Hs[96] + G2sp[296]*Hs[97] + G2sp[536]*Hs[98] + G2sp[776]*Hs[99] + G2sp[792]*Hs[100] + G2sp[808]*Hs[101] + G2sp[824]*Hs[102] + G2sp[840]*Hs[103])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[76]*(G2sp[72]*Hs[96] + G2sp[312]*Hs[97] + G2sp[552]*Hs[98] + G2sp[792]*Hs[99] + G2sp[1032]*Hs[100] + G2sp[1048]*Hs[101] + G2sp[1064]*Hs[102] + G2sp[1080]*Hs[103])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[77]*(G2sp[88]*Hs[96] + G2sp[328]*Hs[97] + G2sp[568]*Hs[98] + G2sp[808]*Hs[99] + G2sp[1048]*Hs[100] + G2sp[1288]*Hs[101] + G2sp[1304]*Hs[102] + G2sp[1320]*Hs[103])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[78]*(G2sp[104]*Hs[96] + G2sp[344]*Hs[97] + G2sp[584]*Hs[98] + G2sp[824]*Hs[99] + G2sp[1064]*Hs[100] + G2sp[1304]*Hs[101] + G2sp[1544]*Hs[102] + G2sp[1560]*Hs[103])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[79]*(G2sp[120]*Hs[96] + G2sp[360]*Hs[97] + G2sp[600]*Hs[98] + G2sp[840]*Hs[99] + G2sp[1080]*Hs[100] + G2sp[1320]*Hs[101] + G2sp[1560]*Hs[102] + G2sp[1800]*Hs[103])*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[75]*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*((bbeta*pow(E,yss[8])*Gs[149])/pow(zbar,rrho) - pow(E,yss[8])*Gs[152] + Gs[153] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[75]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*((bbeta*pow(E,yss[8])*Gs[197])/pow(zbar,rrho) - pow(E,yss[8])*Gs[200] + Gs[201] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[99]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103])*(1 + yss[5]))/pow(zbar,rrho));
	Nee_sp_s[244]=-(kkappa*Pssp*Gs[153]*Gs[198]) + pow(E,yss[8])*Pssp*Gs[152]*Gs[200] - kkappa*Pssp*Gs[150]*Gs[201] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[72]*Hs[96] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[72]*Hs[96] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[74]*Hs[96] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[75]*Hs[96] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79])*Hs[96] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79])*Hs[96] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79])*Hs[96] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[72]*Hs[98] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[74]*Hs[98] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[75]*Hs[98] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79])*Hs[98] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79])*Hs[98] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[72]*Hs[99] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[74]*Hs[99] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[75]*Hs[99] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[75]*Hs[99])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79])*Hs[99] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79])*Hs[99] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*Hs[99])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[72] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[75] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79]))*Hs[99])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[152]*(Hs[96] + Hs[99]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[72] + Hs[75])*(Gs[200] + Hs[96] + Hs[99]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[72]*(G2sp[1]*Hs[96] + G2sp[17]*Hs[97] + G2sp[33]*Hs[98] + G2sp[49]*Hs[99] + G2sp[65]*Hs[100] + G2sp[81]*Hs[101] + G2sp[97]*Hs[102] + G2sp[113]*Hs[103]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[72]*(G2sp[2]*Hs[96] + G2sp[18]*Hs[97] + G2sp[34]*Hs[98] + G2sp[50]*Hs[99] + G2sp[66]*Hs[100] + G2sp[82]*Hs[101] + G2sp[98]*Hs[102] + G2sp[114]*Hs[103]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[72]*(G2sp[4]*Hs[96] + G2sp[20]*Hs[97] + G2sp[36]*Hs[98] + G2sp[52]*Hs[99] + G2sp[68]*Hs[100] + G2sp[84]*Hs[101] + G2sp[100]*Hs[102] + G2sp[116]*Hs[103]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[72]*(G2sp[8]*Hs[96] + G2sp[24]*Hs[97] + G2sp[40]*Hs[98] + G2sp[56]*Hs[99] + G2sp[72]*Hs[100] + G2sp[88]*Hs[101] + G2sp[104]*Hs[102] + G2sp[120]*Hs[103]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[73]*(G2sp[17]*Hs[96] + G2sp[257]*Hs[97] + G2sp[273]*Hs[98] + G2sp[289]*Hs[99] + G2sp[305]*Hs[100] + G2sp[321]*Hs[101] + G2sp[337]*Hs[102] + G2sp[353]*Hs[103]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[73]*(G2sp[18]*Hs[96] + G2sp[258]*Hs[97] + G2sp[274]*Hs[98] + G2sp[290]*Hs[99] + G2sp[306]*Hs[100] + G2sp[322]*Hs[101] + G2sp[338]*Hs[102] + G2sp[354]*Hs[103]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[73]*(G2sp[20]*Hs[96] + G2sp[260]*Hs[97] + G2sp[276]*Hs[98] + G2sp[292]*Hs[99] + G2sp[308]*Hs[100] + G2sp[324]*Hs[101] + G2sp[340]*Hs[102] + G2sp[356]*Hs[103]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[73]*(G2sp[24]*Hs[96] + G2sp[264]*Hs[97] + G2sp[280]*Hs[98] + G2sp[296]*Hs[99] + G2sp[312]*Hs[100] + G2sp[328]*Hs[101] + G2sp[344]*Hs[102] + G2sp[360]*Hs[103]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[74]*(G2sp[33]*Hs[96] + G2sp[273]*Hs[97] + G2sp[513]*Hs[98] + G2sp[529]*Hs[99] + G2sp[545]*Hs[100] + G2sp[561]*Hs[101] + G2sp[577]*Hs[102] + G2sp[593]*Hs[103]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[74]*(G2sp[34]*Hs[96] + G2sp[274]*Hs[97] + G2sp[514]*Hs[98] + G2sp[530]*Hs[99] + G2sp[546]*Hs[100] + G2sp[562]*Hs[101] + G2sp[578]*Hs[102] + G2sp[594]*Hs[103]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[74]*(G2sp[36]*Hs[96] + G2sp[276]*Hs[97] + G2sp[516]*Hs[98] + G2sp[532]*Hs[99] + G2sp[548]*Hs[100] + G2sp[564]*Hs[101] + G2sp[580]*Hs[102] + G2sp[596]*Hs[103]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[74]*(G2sp[40]*Hs[96] + G2sp[280]*Hs[97] + G2sp[520]*Hs[98] + G2sp[536]*Hs[99] + G2sp[552]*Hs[100] + G2sp[568]*Hs[101] + G2sp[584]*Hs[102] + G2sp[600]*Hs[103]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[75]*(G2sp[49]*Hs[96] + G2sp[289]*Hs[97] + G2sp[529]*Hs[98] + G2sp[769]*Hs[99] + G2sp[785]*Hs[100] + G2sp[801]*Hs[101] + G2sp[817]*Hs[102] + G2sp[833]*Hs[103]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[75]*(G2sp[50]*Hs[96] + G2sp[290]*Hs[97] + G2sp[530]*Hs[98] + G2sp[770]*Hs[99] + G2sp[786]*Hs[100] + G2sp[802]*Hs[101] + G2sp[818]*Hs[102] + G2sp[834]*Hs[103]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[75]*(G2sp[52]*Hs[96] + G2sp[292]*Hs[97] + G2sp[532]*Hs[98] + G2sp[772]*Hs[99] + G2sp[788]*Hs[100] + G2sp[804]*Hs[101] + G2sp[820]*Hs[102] + G2sp[836]*Hs[103]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[75]*(G2sp[56]*Hs[96] + G2sp[296]*Hs[97] + G2sp[536]*Hs[98] + G2sp[776]*Hs[99] + G2sp[792]*Hs[100] + G2sp[808]*Hs[101] + G2sp[824]*Hs[102] + G2sp[840]*Hs[103]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[76]*(G2sp[65]*Hs[96] + G2sp[305]*Hs[97] + G2sp[545]*Hs[98] + G2sp[785]*Hs[99] + G2sp[1025]*Hs[100] + G2sp[1041]*Hs[101] + G2sp[1057]*Hs[102] + G2sp[1073]*Hs[103]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[76]*(G2sp[66]*Hs[96] + G2sp[306]*Hs[97] + G2sp[546]*Hs[98] + G2sp[786]*Hs[99] + G2sp[1026]*Hs[100] + G2sp[1042]*Hs[101] + G2sp[1058]*Hs[102] + G2sp[1074]*Hs[103]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[76]*(G2sp[68]*Hs[96] + G2sp[308]*Hs[97] + G2sp[548]*Hs[98] + G2sp[788]*Hs[99] + G2sp[1028]*Hs[100] + G2sp[1044]*Hs[101] + G2sp[1060]*Hs[102] + G2sp[1076]*Hs[103]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[76]*(G2sp[72]*Hs[96] + G2sp[312]*Hs[97] + G2sp[552]*Hs[98] + G2sp[792]*Hs[99] + G2sp[1032]*Hs[100] + G2sp[1048]*Hs[101] + G2sp[1064]*Hs[102] + G2sp[1080]*Hs[103]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[77]*(G2sp[81]*Hs[96] + G2sp[321]*Hs[97] + G2sp[561]*Hs[98] + G2sp[801]*Hs[99] + G2sp[1041]*Hs[100] + G2sp[1281]*Hs[101] + G2sp[1297]*Hs[102] + G2sp[1313]*Hs[103]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[77]*(G2sp[82]*Hs[96] + G2sp[322]*Hs[97] + G2sp[562]*Hs[98] + G2sp[802]*Hs[99] + G2sp[1042]*Hs[100] + G2sp[1282]*Hs[101] + G2sp[1298]*Hs[102] + G2sp[1314]*Hs[103]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[77]*(G2sp[84]*Hs[96] + G2sp[324]*Hs[97] + G2sp[564]*Hs[98] + G2sp[804]*Hs[99] + G2sp[1044]*Hs[100] + G2sp[1284]*Hs[101] + G2sp[1300]*Hs[102] + G2sp[1316]*Hs[103]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[77]*(G2sp[88]*Hs[96] + G2sp[328]*Hs[97] + G2sp[568]*Hs[98] + G2sp[808]*Hs[99] + G2sp[1048]*Hs[100] + G2sp[1288]*Hs[101] + G2sp[1304]*Hs[102] + G2sp[1320]*Hs[103]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[78]*(G2sp[97]*Hs[96] + G2sp[337]*Hs[97] + G2sp[577]*Hs[98] + G2sp[817]*Hs[99] + G2sp[1057]*Hs[100] + G2sp[1297]*Hs[101] + G2sp[1537]*Hs[102] + G2sp[1553]*Hs[103]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[78]*(G2sp[98]*Hs[96] + G2sp[338]*Hs[97] + G2sp[578]*Hs[98] + G2sp[818]*Hs[99] + G2sp[1058]*Hs[100] + G2sp[1298]*Hs[101] + G2sp[1538]*Hs[102] + G2sp[1554]*Hs[103]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[78]*(G2sp[100]*Hs[96] + G2sp[340]*Hs[97] + G2sp[580]*Hs[98] + G2sp[820]*Hs[99] + G2sp[1060]*Hs[100] + G2sp[1300]*Hs[101] + G2sp[1540]*Hs[102] + G2sp[1556]*Hs[103]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[78]*(G2sp[104]*Hs[96] + G2sp[344]*Hs[97] + G2sp[584]*Hs[98] + G2sp[824]*Hs[99] + G2sp[1064]*Hs[100] + G2sp[1304]*Hs[101] + G2sp[1544]*Hs[102] + G2sp[1560]*Hs[103]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[79]*(G2sp[113]*Hs[96] + G2sp[353]*Hs[97] + G2sp[593]*Hs[98] + G2sp[833]*Hs[99] + G2sp[1073]*Hs[100] + G2sp[1313]*Hs[101] + G2sp[1553]*Hs[102] + G2sp[1793]*Hs[103]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[79]*(G2sp[114]*Hs[96] + G2sp[354]*Hs[97] + G2sp[594]*Hs[98] + G2sp[834]*Hs[99] + G2sp[1074]*Hs[100] + G2sp[1314]*Hs[101] + G2sp[1554]*Hs[102] + G2sp[1794]*Hs[103]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[79]*(G2sp[116]*Hs[96] + G2sp[356]*Hs[97] + G2sp[596]*Hs[98] + G2sp[836]*Hs[99] + G2sp[1076]*Hs[100] + G2sp[1316]*Hs[101] + G2sp[1556]*Hs[102] + G2sp[1796]*Hs[103]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[79]*(G2sp[120]*Hs[96] + G2sp[360]*Hs[97] + G2sp[600]*Hs[98] + G2sp[840]*Hs[99] + G2sp[1080]*Hs[100] + G2sp[1320]*Hs[101] + G2sp[1560]*Hs[102] + G2sp[1800]*Hs[103]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[72]*(Gsp[1]*Hs[96] + Gsp[17]*Hs[97] + Gsp[33]*Hs[98] + Gsp[49]*Hs[99] + Gsp[65]*Hs[100] + Gsp[81]*Hs[101] + Gsp[97]*Hs[102] + Gsp[113]*Hs[103]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[74]*(Gsp[1]*Hs[96] + Gsp[17]*Hs[97] + Gsp[33]*Hs[98] + Gsp[49]*Hs[99] + Gsp[65]*Hs[100] + Gsp[81]*Hs[101] + Gsp[97]*Hs[102] + Gsp[113]*Hs[103]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[75]*(Gsp[1]*Hs[96] + Gsp[17]*Hs[97] + Gsp[33]*Hs[98] + Gsp[49]*Hs[99] + Gsp[65]*Hs[100] + Gsp[81]*Hs[101] + Gsp[97]*Hs[102] + Gsp[113]*Hs[103]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79])*(Gsp[1]*Hs[96] + Gsp[17]*Hs[97] + Gsp[33]*Hs[98] + Gsp[49]*Hs[99] + Gsp[65]*Hs[100] + Gsp[81]*Hs[101] + Gsp[97]*Hs[102] + Gsp[113]*Hs[103]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79])*(Gsp[1]*Hs[96] + Gsp[17]*Hs[97] + Gsp[33]*Hs[98] + Gsp[49]*Hs[99] + Gsp[65]*Hs[100] + Gsp[81]*Hs[101] + Gsp[97]*Hs[102] + Gsp[113]*Hs[103]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[72]*(Gsp[2]*Hs[96] + Gsp[18]*Hs[97] + Gsp[34]*Hs[98] + Gsp[50]*Hs[99] + Gsp[66]*Hs[100] + Gsp[82]*Hs[101] + Gsp[98]*Hs[102] + Gsp[114]*Hs[103]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[74]*(Gsp[2]*Hs[96] + Gsp[18]*Hs[97] + Gsp[34]*Hs[98] + Gsp[50]*Hs[99] + Gsp[66]*Hs[100] + Gsp[82]*Hs[101] + Gsp[98]*Hs[102] + Gsp[114]*Hs[103]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[75]*(Gsp[2]*Hs[96] + Gsp[18]*Hs[97] + Gsp[34]*Hs[98] + Gsp[50]*Hs[99] + Gsp[66]*Hs[100] + Gsp[82]*Hs[101] + Gsp[98]*Hs[102] + Gsp[114]*Hs[103]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79])*(Gsp[2]*Hs[96] + Gsp[18]*Hs[97] + Gsp[34]*Hs[98] + Gsp[50]*Hs[99] + Gsp[66]*Hs[100] + Gsp[82]*Hs[101] + Gsp[98]*Hs[102] + Gsp[114]*Hs[103]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79])*(Gsp[2]*Hs[96] + Gsp[18]*Hs[97] + Gsp[34]*Hs[98] + Gsp[50]*Hs[99] + Gsp[66]*Hs[100] + Gsp[82]*Hs[101] + Gsp[98]*Hs[102] + Gsp[114]*Hs[103]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[72]*((-1 + Gsp[4])*Hs[96] + Gsp[20]*Hs[97] + Gsp[36]*Hs[98] + (rrhoz + Gsp[52])*Hs[99] + Gsp[68]*Hs[100] + Gsp[84]*Hs[101] + Gsp[100]*Hs[102] + Gsp[116]*Hs[103]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79])*((-1 + Gsp[4])*Hs[96] + Gsp[20]*Hs[97] + Gsp[36]*Hs[98] + (rrhoz + Gsp[52])*Hs[99] + Gsp[68]*Hs[100] + Gsp[84]*Hs[101] + Gsp[100]*Hs[102] + Gsp[116]*Hs[103]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79])*(Gsp[4]*Hs[96] + Gsp[20]*Hs[97] + Gsp[36]*Hs[98] + (rrhoz + Gsp[52])*Hs[99] + Gsp[68]*Hs[100] + Gsp[84]*Hs[101] + Gsp[100]*Hs[102] + Gsp[116]*Hs[103]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[75]*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[72] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[75] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79]))*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[75]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[96] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[98] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[99] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[96] + Gsp[17]*Hs[97] + Gsp[33]*Hs[98] + Gsp[49]*Hs[99] + Gsp[65]*Hs[100] + Gsp[81]*Hs[101] + Gsp[97]*Hs[102] + Gsp[113]*Hs[103]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[96] + Gsp[18]*Hs[97] + Gsp[34]*Hs[98] + Gsp[50]*Hs[99] + Gsp[66]*Hs[100] + Gsp[82]*Hs[101] + Gsp[98]*Hs[102] + Gsp[114]*Hs[103]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[96] + Gsp[20]*Hs[97] + Gsp[36]*Hs[98] + (rrhoz + Gsp[52])*Hs[99] + Gsp[68]*Hs[100] + Gsp[84]*Hs[101] + Gsp[100]*Hs[102] + Gsp[116]*Hs[103])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[96] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[98] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[99] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[96] + Gsp[17]*Hs[97] + Gsp[33]*Hs[98] + Gsp[49]*Hs[99] + Gsp[65]*Hs[100] + Gsp[81]*Hs[101] + Gsp[97]*Hs[102] + Gsp[113]*Hs[103]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[96] + Gsp[18]*Hs[97] + Gsp[34]*Hs[98] + Gsp[50]*Hs[99] + Gsp[66]*Hs[100] + Gsp[82]*Hs[101] + Gsp[98]*Hs[102] + Gsp[114]*Hs[103]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[96] + Gsp[20]*Hs[97] + Gsp[36]*Hs[98] + (rrhoz + Gsp[52])*Hs[99] + Gsp[68]*Hs[100] + Gsp[84]*Hs[101] + Gsp[100]*Hs[102] + Gsp[116]*Hs[103])))/pow(zbar,rrho) - kkappa*Pssp*Gs[150]*Gs[198]*yss[9] + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(pow(E,yss[8])*Gs[152] - kkappa*Gs[153] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[75])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[72] + Hs[75]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[72] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[75] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79])))/pow(zbar,rrho) - kkappa*Gs[150]*yss[9]) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(pow(E,yss[8])*Gs[200] - kkappa*Gs[201] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[99])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[96] + Hs[99]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp